/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.EventItems;
import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import au.com.glenix.trn.PEE0003BusinessEventMessage;
import au.com.glenix.trn.PEE0003Int;
import au.com.glenix.trn.PEE0003OverallEventMessage;
import au.com.glenix.trn.PEE0003Payroll;
import au.com.glenix.trn.PEE0003Rp;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import javafx.beans.property.SimpleStringProperty;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Batch
extends GlenixAbstractBranchElement {
    private DocumentBuilderFactory docFactory;
    private DocumentBuilder docBuilder;

    public Batch() throws Exception {
        this.name = "batch";
        this.namespace = "http://www.glenix.com.au/";
        this.sbrName = "PAYEVNT";
        this.sbrNamespace = "http://www.sbr.gov.au/ato/payevnt";
        this.sbrContext = "RP";
        this.docFactory = DocumentBuilderFactory.newInstance();
        this.docFactory.setNamespaceAware(true);
        this.docBuilder = this.docFactory.newDocumentBuilder();
        this.childrenAndMeta.put("batchIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "batchIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("batchComment", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "batchComment", null, null, null, 1, true));
        this.childrenAndMeta.put("batchAuthorisedByContainer", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "batchAuthorisedByContainer", null, null, null, 1, true));
        this.childrenAndMeta.put("batchAuthorisedByOwner", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "batchAuthorisedByOwner", null, null, null, 1, true));
        this.childrenAndMeta.put("batchAuthorisedByViewer", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "batchAuthorisedByViewer", null, null, null, 1, true));
        this.childrenAndMeta.put("batchAuthorisedTime", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "batchAuthorisedTime", null, null, null, 1, true));
        this.childrenAndMeta.put("batchPeriodStart", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "batchPeriodStart", null, null, null, 1, true));
        this.childrenAndMeta.put("batchPeriodEnd", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "batchPeriodEnd", null, null, null, 1, true));
        this.childrenAndMeta.put("batchPaymentDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "batchPaymentDate", null, null, null, 1, true));
        this.childrenAndMeta.put("batchStatus", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "batchStatus", null, null, null, 1, true));
        this.childrenAndMeta.put("batchMessageIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "batchMessageIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("batchLodgeTimestamp", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "batchLodgeTimestamp", null, null, null, 1, true));
        this.childrenAndMeta.put("batchPullMessagesTimestamp", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "batchPullMessagesTimestamp", null, null, null, 1, true));
        this.childrenAndMeta.put("batchPullMessageIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "batchPullMessageIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("batchATOLodgeMessageIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "batchATOLodgeMessageIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("batchATOLodgeTimestamp", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "batchATOLodgeTimestamp", null, null, null, 1, true));
        this.childrenAndMeta.put("batchATOPullMessagesMessageIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "batchATOPullMessagesMessageIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("batchATOPullMessagesTimestamp", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "batchATOPullMessagesTimestamp", null, null, null, 1, true));
        this.childrenAndMeta.put("PEE0003OverallEventMessage", new GlenixElementChildList(PEE0003OverallEventMessage.class, "http://www.glenix.com.au/", "PEE0003OverallEventMessage", null, null, null, 1, false));
        this.childrenAndMeta.put("PEE0003BusinessEventMessage", new GlenixElementChildList(PEE0003BusinessEventMessage.class, "http://www.glenix.com.au/", "PEE0003BusinessEventMessage", null, null, null, 1, false));
        this.childrenAndMeta.put("PEE0003Rp", new GlenixElementChildList(PEE0003Rp.class, "http://www.glenix.com.au/", "PEE0003Rp", "http://www.sbr.gov.au/ato/payevnt", "Rp", null, 1, false));
        this.childrenAndMeta.put("PEE0003Int", new GlenixElementChildList(PEE0003Int.class, "http://www.glenix.com.au/", "PEE0003Int", "http://www.sbr.gov.au/ato/payevnt", "Int", null, 1, false));
        this.childrenAndMeta.put("certAlias", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "certAlias", null, null, null, 1, true));
    }

    private GlenixElement getChild(String childName) {
        if (childName == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return glenixElementChildList.getChild(0);
        }
        return null;
    }

    private String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    private SimpleStringProperty getChildProperty(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementProperty();
        }
        return null;
    }

    public String getBatchIdentifier() {
        return this.getChildValue("batchIdentifier");
    }

    public void setBatchIdentifier(String identifier) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("batchIdentifier");
        if (gse != null) {
            gse.setGlenixElementValue(identifier);
        }
    }

    public String getBatchComment() {
        return this.getChildValue("batchComment");
    }

    public String getBatchAuthorisedByContainer() {
        return this.getChildValue("batchAuthorisedByContainer");
    }

    public String getBatchAuthorisedByOwner() {
        return this.getChildValue("batchAuthorisedByOwner");
    }

    public String getBatchAuthorisedByViewer() {
        return this.getChildValue("batchAuthorisedByViewer");
    }

    public String getBatchAuthorisedTime() {
        return this.getChildValue("batchAuthorisedTime");
    }

    public String getBatchPeriodStart() {
        return this.getChildValue("batchPeriodStart");
    }

    public LocalDate getBatchPeriodStartAsDate() {
        String date = this.getChildValue("batchPeriodStart");
        if (date == null || date.equals("")) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getBatchPeriodEnd() {
        return this.getChildValue("batchPeriodEnd");
    }

    public LocalDate getBatchPeriodEndAsDate() {
        String date = this.getChildValue("batchPeriodEnd");
        if (date == null || date.equals("")) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getBatchPaymentDate() {
        return this.getChildValue("batchPaymentDate");
    }

    public LocalDate getBatchPaymentDateAsDate() {
        String date = this.getChildValue("batchPaymentDate");
        if (date == null || date.equals("")) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getBatchStatus() {
        return this.getChildValue("batchStatus");
    }

    public void setBatchStatus(String status) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("batchStatus");
        if (gse != null) {
            gse.setGlenixElementValue(status);
        }
    }

    public String getBatchMessageIdentifier() {
        return this.getChildValue("batchMessageIdentifier");
    }

    public String getBatchPullMessageIdentifier() {
        return this.getChildValue("batchPullMessageIdentifier");
    }

    public SimpleStringProperty getBatchIdentifierProperty() {
        return this.getChildProperty("batchIdentifier");
    }

    public SimpleStringProperty getBatchCommentProperty() {
        return this.getChildProperty("batchComment");
    }

    public SimpleStringProperty getBatchAuthorisedByContainerProperty() {
        return this.getChildProperty("batchAuthorisedByContainer");
    }

    public SimpleStringProperty getBatchAuthorisedByOwnerProperty() {
        return this.getChildProperty("batchAuthorisedByOwner");
    }

    public SimpleStringProperty getBatchAuthorisedByViewerProperty() {
        return this.getChildProperty("batchAuthorisedByViewer");
    }

    public SimpleStringProperty getBatchAuthorisedTimeProperty() {
        return this.getChildProperty("batchAuthorisedTime");
    }

    public SimpleStringProperty getBatchPeriodStartProperty() {
        return this.getChildProperty("batchPeriodStart");
    }

    public SimpleStringProperty getBatchPeriodEndProperty() {
        return this.getChildProperty("batchPeriodEnd");
    }

    public SimpleStringProperty getBatchPaymentDateProperty() {
        return this.getChildProperty("batchPaymentDate");
    }

    public SimpleStringProperty getBatchStatusProperty() {
        return this.getChildProperty("batchStatus");
    }

    public SimpleStringProperty getBatchMessageIdentifierProperty() {
        return this.getChildProperty("batchMessageIdentifier");
    }

    public SimpleStringProperty getBatchPullMessageIdentifierProperty() {
        return this.getChildProperty("batchPullMessageIdentifier");
    }

    public SimpleStringProperty getBatchATOLodgeMessageIdentifierProperty() {
        return this.getChildProperty("batchATOLodgeMessageIdentifier");
    }

    public String getBatchATOLodgeMessageIdentifier() {
        return this.getChildValue("batchATOLodgeMessageIdentifier");
    }

    public void setBatchATOLodgeMessageIdentifier(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("batchATOLodgeMessageIdentifier");
        if (gse != null) {
            gse.setGlenixElementValue(value);
        }
    }

    public SimpleStringProperty getBatchATOLodgeTimestampProperty() {
        return this.getChildProperty("batchATOLodgeTimestamp");
    }

    public String getBatchATOLodgeTimestamp() {
        return this.getChildValue("batchATOLodgeTimestamp");
    }

    public void setBatchATOLodgeTimestamp(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("batchATOLodgeTimestamp");
        if (gse != null) {
            gse.setGlenixElementValue(value);
        }
    }

    public SimpleStringProperty getBatchATOPullMessagesMessageIdentifierProperty() {
        return this.getChildProperty("batchATOPullMessagesMessageIdentifier");
    }

    public String getBatchATOPullMessagesMessageIdentifier() {
        return this.getChildValue("batchATOPullMessagesMessageIdentifier");
    }

    public void setBatchATOPullMessagesMessageIdentifier(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("batchATOPullMessagesMessageIdentifier");
        if (gse != null) {
            gse.setGlenixElementValue(value);
        }
    }

    public SimpleStringProperty getBatchATOPullMessagesTimestampProperty() {
        return this.getChildProperty("batchATOPullMessagesTimestamp");
    }

    public String getBatchATOPullMessagesTimestamp() {
        return this.getChildValue("batchATOPullMessagesTimestamp");
    }

    public void setBatchATOPullMessagesTimestamp(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("batchATOPullMessagesTimestamp");
        if (gse != null) {
            gse.setGlenixElementValue(value);
        }
    }

    public SimpleStringProperty getBatchLodgeTimestampProperty() {
        return this.getChildProperty("batchLodgeTimestamp");
    }

    public String getBatchLodgeTimestamp() {
        return this.getChildValue("batchLodgeTimestamp");
    }

    public void setBatchLodgeTimestamp() throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("batchLodgeTimestamp");
        if (gse != null) {
            String timestamp = this.generateTimestamp();
            gse.setGlenixElementValue(timestamp);
        }
    }

    public SimpleStringProperty getBatchPullMessagesTimestampProperty() {
        return this.getChildProperty("batchPullMessagesTimestamp");
    }

    public String getBatchPullMessagesTimestamp() {
        return this.getChildValue("batchPullMessagesTimestamp");
    }

    public void setBatchPullMessagesTimestamp() throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("batchPullMessagesTimestamp");
        if (gse != null) {
            String timestamp = this.generateTimestamp();
            gse.setGlenixElementValue(timestamp);
        }
    }

    public EventItems getOverallEventItems() {
        return (EventItems)this.getChild("PEE0003OverallEventMessage");
    }

    public EventItems getBusinessEventItems() {
        return (EventItems)this.getChild("PEE0003BusinessEventMessage");
    }

    public PEE0003Rp getPEE0003Rp() {
        return (PEE0003Rp)this.getChild("PEE0003Rp");
    }

    public PEE0003Int getPEE0003Int() {
        return (PEE0003Int)this.getChild("PEE0003Int");
    }

    public String getCertAlias() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("certAlias");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public void setCertAlias(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("certAlias");
        if (gse == null) {
            return;
        }
        gse.setGlenixElementValue(value);
    }

    public String getIntAustralianBusinessNumberId() {
        PEE0003Int pee0003Int = (PEE0003Int)this.getChild("PEE0003Int");
        if (pee0003Int == null) {
            return null;
        }
        return pee0003Int.getAustralianBusinessNumberId();
    }

    public SimpleStringProperty getIntAustralianBusinessNumberIdProperty() {
        PEE0003Int pee0003Int = (PEE0003Int)this.getChild("PEE0003Int");
        if (pee0003Int == null) {
            return null;
        }
        return pee0003Int.getAustralianBusinessNumberIdProperty();
    }

    public PEE0003Payroll getPEE0003Payroll() {
        PEE0003Rp rp = this.getPEE0003Rp();
        if (rp == null) {
            return null;
        }
        return rp.getPEE0003Payroll();
    }

    public String getAmendmentI() {
        PEE0003Payroll payroll = this.getPEE0003Payroll();
        if (payroll == null) {
            return null;
        }
        return payroll.getAmendmentI();
    }

    public SimpleStringProperty getAmendmentIProperty() {
        PEE0003Payroll payroll = this.getPEE0003Payroll();
        if (payroll == null) {
            return null;
        }
        return payroll.getAmendmentIProperty();
    }

    public void setAmendmentI(String value) throws Exception {
        PEE0003Payroll payroll = this.getPEE0003Payroll();
        if (payroll == null) {
            return;
        }
        payroll.setAmendmentI(value);
    }

    public Document buildDocument() throws Exception {
        Document document = this.docBuilder.newDocument();
        Element xbrlEl = document.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        xbrlEl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        document.appendChild(xbrlEl);
        Element businessEl = document.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = document.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        this.appendToElement(document, transactionEl);
        return document;
    }

    private void assignUUIDToBatchIdentifier() throws Exception {
        String batchIdentifier = this.getBatchIdentifier();
        if (batchIdentifier == null || batchIdentifier.isEmpty()) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("batchIdentifier");
            UUID uuid = UUID.randomUUID();
            String uuidString = uuid.toString();
            if (glenixElementChildList != null && glenixElementChildList.getChildCount() > 0) {
                GlenixStringElement gse = (GlenixStringElement)glenixElementChildList.getChild(0);
                gse.setGlenixElementValue(uuidString);
            } else {
                glenixElementChildList.addChild(uuidString);
            }
        }
    }

    public void generateBatchMessageIdentifier() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("batchMessageIdentifier");
        String uuidString = this.generateMessageIdentifier();
        if (glenixElementChildList != null && glenixElementChildList.getChildCount() > 0) {
            GlenixStringElement gse = (GlenixStringElement)glenixElementChildList.getChild(0);
            gse.setGlenixElementValue(uuidString);
        } else {
            glenixElementChildList.addChild(uuidString);
        }
    }

    public void generateBatchPullMessageIdentifier() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("batchPullMessageIdentifier");
        String uuidString = this.generateMessageIdentifier();
        if (glenixElementChildList != null && glenixElementChildList.getChildCount() > 0) {
            GlenixStringElement gse = (GlenixStringElement)glenixElementChildList.getChild(0);
            gse.setGlenixElementValue(uuidString);
        } else {
            glenixElementChildList.addChild(uuidString);
        }
    }

    @Override
    public void loadDocumentElement(Document doc, Element element) throws Exception {
        super.loadDocumentElement(doc, element);
        this.assignUUIDToBatchIdentifier();
    }

    @Override
    public void loadDocumentElementOverwrite(Document doc, Element element) throws Exception {
        super.loadDocumentElementOverwrite(doc, element);
        this.assignUUIDToBatchIdentifier();
    }

    @Override
    public String getGlenixElementKeyId() {
        return this.getBatchIdentifier();
    }

    public Document buildPEE0003Document() {
        Document doc = this.docBuilder.newDocument();
        doc.setXmlStandalone(true);
        this.buildSBRElement(doc, null);
        return doc;
    }

    public void loadSBROverallEventMessageDocument(Document doc, Element root) throws Exception {
        this.childrenAndMeta.put("PEE0003OverallEventMessage", new GlenixElementChildList(PEE0003OverallEventMessage.class, "http://www.glenix.com.au/", "PEE0003OverallEventMessage", null, null, null, 1, false));
        EventItems overallEventItems = (EventItems)this.getOrAddChild("PEE0003OverallEventMessage");
        overallEventItems.loadSBRDocumentRoot(doc, root);
    }

    public void loadSBRBusinessEventMessageDocument(Document doc, Element root) throws Exception {
        this.childrenAndMeta.put("PEE0003BusinessEventMessage", new GlenixElementChildList(PEE0003BusinessEventMessage.class, "http://www.glenix.com.au/", "PEE0003BusinessEventMessage", null, null, null, 1, false));
        EventItems businessEventItems = (EventItems)this.getOrAddChild("PEE0003BusinessEventMessage");
        businessEventItems.loadSBRDocumentRoot(doc, root);
    }

    public void removeAllEventMessages() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("PEE0003OverallEventMessage");
        if (glenixElementChildList != null) {
            glenixElementChildList.clearChildren();
        }
        if ((glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("PEE0003BusinessEventMessage")) != null) {
            glenixElementChildList.clearChildren();
        }
    }

    public void loadFasV2Transactions(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.socialaccounts.com/gl/soc/2011-03-31") && element.getLocalName() != null && element.getLocalName().equals("batch")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("batchNumber")) continue;
                GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("batchIdentifier");
                gse.setGlenixElementValue(el.getTextContent());
            }
            return;
        }
    }

    public void loadFasV2Batches(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.socialaccounts.com/gl/soc/2011-03-31") && element.getLocalName() != null && element.getLocalName().equals("batch")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                GlenixStringElement gse;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                if (el.getLocalName().equals("batchNumber")) {
                    gse = (GlenixStringElement)this.getOrAddChild("batchIdentifier");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("batchComment")) {
                    gse = (GlenixStringElement)this.getOrAddChild("batchComment");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("batchAuthorisedByContainer")) {
                    gse = (GlenixStringElement)this.getOrAddChild("batchAuthorisedByContainer");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("batchAuthorisedByOwner")) {
                    gse = (GlenixStringElement)this.getOrAddChild("batchAuthorisedByOwner");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("batchAuthorisedByViewer")) {
                    gse = (GlenixStringElement)this.getOrAddChild("batchAuthorisedByViewer");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("batchAuthorisedTime")) {
                    gse = (GlenixStringElement)this.getOrAddChild("batchAuthorisedTime");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("batchPeriodStart")) {
                    gse = (GlenixStringElement)this.getOrAddChild("batchPeriodStart");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("batchPeriodEnd")) {
                    gse = (GlenixStringElement)this.getOrAddChild("batchPeriodEnd");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("batchPaymentDate")) {
                    gse = (GlenixStringElement)this.getOrAddChild("batchPaymentDate");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (!el.getLocalName().equals("batchStatus")) continue;
                gse = (GlenixStringElement)this.getOrAddChild("batchStatus");
                String status = el.getTextContent();
                if (status != null && status.equals("authorized")) {
                    status = "authorised";
                } else if (status != null && status.equals("cancelled")) {
                    status = "created";
                }
                gse.setGlenixElementValue(status);
            }
            return;
        }
    }

    public void loadFasV2AddPaySlipBatches(String postingDate) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("batchIdentifier");
        gse.setGlenixElementValue("payslip_date_" + postingDate);
        gse = (GlenixStringElement)this.getOrAddChild("batchComment");
        gse.setGlenixElementValue("Pay slip(s) paid on " + postingDate);
        gse = (GlenixStringElement)this.getOrAddChild("batchPeriodStart");
        gse.setGlenixElementValue(postingDate);
        gse = (GlenixStringElement)this.getOrAddChild("batchPeriodEnd");
        gse.setGlenixElementValue(postingDate);
        gse = (GlenixStringElement)this.getOrAddChild("batchPaymentDate");
        gse.setGlenixElementValue(postingDate);
        gse = (GlenixStringElement)this.getOrAddChild("batchStatus");
        gse.setGlenixElementValue("authorised");
    }

    public void removeMasterFileInformation() {
        for (String key : this.childrenAndMeta.keySet()) {
            if (key.equals("batchIdentifier")) continue;
            ((GlenixElementChildList)this.childrenAndMeta.get(key)).clearChildren();
        }
    }

    public String getOrganisationDetailsOrganisationBranchC() {
        PEE0003Rp rp = this.getPEE0003Rp();
        if (rp == null) {
            return null;
        }
        return rp.getOrganisationDetailsOrganisationBranchC();
    }

    public String getSoftwareInformationBusinessManagementSystemId() {
        PEE0003Rp rp = this.getPEE0003Rp();
        if (rp == null) {
            return null;
        }
        return rp.getSoftwareInformationBusinessManagementSystemId();
    }

    public String getAustralianBusinessNumberId() {
        PEE0003Rp rp = this.getPEE0003Rp();
        if (rp == null) {
            return null;
        }
        return rp.getAustralianBusinessNumberId();
    }

    public String getWithholdingPayerNumberId() {
        PEE0003Rp rp = this.getPEE0003Rp();
        if (rp == null) {
            return null;
        }
        return rp.getWithholdingPayerNumberId();
    }
}

