/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.ASBusinessEventItems;
import au.com.glenix.trn.ASIntermediary;
import au.com.glenix.trn.ASOverallEventItems;
import au.com.glenix.trn.AddressDetails;
import au.com.glenix.trn.Declaration;
import au.com.glenix.trn.ElectronicContactElectronicMail;
import au.com.glenix.trn.ElectronicContactTelephone;
import au.com.glenix.trn.EventItems;
import au.com.glenix.trn.FBTObligation;
import au.com.glenix.trn.GSTObligation;
import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixAmountElement;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixPureElementNoProcLodge;
import au.com.glenix.trn.GlenixStringElement;
import au.com.glenix.trn.GlenixStringElementNoProcLodge;
import au.com.glenix.trn.OrganisationNameDetails;
import au.com.glenix.trn.PAYGIObligation;
import au.com.glenix.trn.PAYGWObligation;
import au.com.glenix.trn.PaymentMechanism;
import au.com.glenix.trn.SBRContexts;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javafx.beans.property.SimpleStringProperty;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ActivityStatement
extends GlenixAbstractBranchElement {
    private DocumentBuilderFactory docFactory;
    private DocumentBuilder docBuilder;

    public ActivityStatement() throws ParserConfigurationException, Exception {
        this.name = "activityStatement";
        this.namespace = "http://www.glenix.com.au/";
        this.docFactory = DocumentBuilderFactory.newInstance();
        this.docFactory.setNamespaceAware(true);
        this.docBuilder = this.docFactory.newDocumentBuilder();
        this.childrenAndMeta.put("ActivityStatementNumber", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "ActivityStatementNumber", null, null, null, 1, true));
        this.childrenAndMeta.put("originalActivityStatementNumber", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "originalActivityStatementNumber", null, null, null, 1, true));
        this.childrenAndMeta.put("SBRStartDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "SBRStartDate", null, null, null, 1, true));
        this.childrenAndMeta.put("SBREndDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "SBREndDate", null, null, null, 1, true));
        this.childrenAndMeta.put("ASOverallEventItems", new GlenixElementChildList(ASOverallEventItems.class, "http://www.glenix.com.au/", "ASOverallEventItems", null, null, null, 1, false));
        this.childrenAndMeta.put("ASBusinessEventItems", new GlenixElementChildList(ASBusinessEventItems.class, "http://www.glenix.com.au/", "ASBusinessEventItems", null, null, null, 1, false));
        this.childrenAndMeta.put("SBRDocumentStatus", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "SBRDocumentStatus", null, null, null, 1, true));
        this.childrenAndMeta.put("SBRDocumentDateTime", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "SBRDocumentDateTime", null, null, null, 1, true));
        this.childrenAndMeta.put("asMessageIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "asMessageIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("Identifiers.AustralianBusinessNumber.Identifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Identifiers.AustralianBusinessNumber.Identifier", null, null, "RP", 1, true));
        this.childrenAndMeta.put("ASCertAlias", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "ASCertAlias", null, null, null, 1, true));
        this.childrenAndMeta.put("OrganisationDetails.OrganisationBranch.Code", new GlenixElementChildList(GlenixStringElementNoProcLodge.class, "http://www.glenix.com.au/", "OrganisationDetails.OrganisationBranch.Code", "http://sbr.gov.au/icls/py/pyde/pyde.02.00.data", "OrganisationDetails.OrganisationBranch.Code", "RP", 1, true));
        this.childrenAndMeta.put("Identifiers.TaxFileNumber.Identifier", new GlenixElementChildList(GlenixStringElementNoProcLodge.class, "http://www.glenix.com.au/", "Identifiers.TaxFileNumber.Identifier", "http://sbr.gov.au/icls/py/pyid/pyid.02.00.data", "Identifiers.TaxFileNumber.Identifier", "RP", 1, true));
        GlenixElementChildList gecl = new GlenixElementChildList(OrganisationNameDetails.class, "http://www.glenix.com.au/", "ASOrganisationNameDetails", "http://sbr.gov.au/comnmdle/comnmdle.organisationname1.02.00.module", "OrganisationNameDetails", "RP", 1, false);
        this.childrenAndMeta.put("ASOrganisationNameDetails", gecl);
        gecl = new GlenixElementChildList(AddressDetails.class, "http://www.glenix.com.au/", "ASOrganisationAddressDetails", "http://sbr.gov.au/comnmdle/comnmdle.addressdetails1.02.00.module", "AddressDetails", "RP", 1, false);
        this.childrenAndMeta.put("ASOrganisationAddressDetails", gecl);
        gecl = new GlenixElementChildList(ElectronicContactTelephone.class, "http://www.glenix.com.au/", "ASOrganisationContactTelephone", "http://sbr.gov.au/comnmdle/comnmdle.electroniccontacttelephone1.02.00.module", "ElectronicContactTelephone", "RP", 1, false);
        this.childrenAndMeta.put("ASOrganisationContactTelephone", gecl);
        gecl = new GlenixElementChildList(ElectronicContactElectronicMail.class, "http://www.glenix.com.au/", "ASOrganisationContactEmail", "http://sbr.gov.au/comnmdle/comnmdle.electroniccontactelectronicmail1.02.00.module", "ElectronicContactElectronicMail", "RP", 1, false);
        this.childrenAndMeta.put("ASOrganisationContactEmail", gecl);
        this.childrenAndMeta.put("Report.CompletionHours.Number", new GlenixElementChildList(GlenixPureElementNoProcLodge.class, "http://www.glenix.com.au/", "Report.CompletionHours.Number", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "Report.CompletionHours.Number", "RP", 1, true));
        this.childrenAndMeta.put("Report.CompletionMinutes.Number", new GlenixElementChildList(GlenixPureElementNoProcLodge.class, "http://www.glenix.com.au/", "Report.CompletionMinutes.Number", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "Report.CompletionMinutes.Number", "RP", 1, true));
        this.childrenAndMeta.put("Lodgment.Receipt.Datetime", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Lodgment.Receipt.Datetime", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "Lodgment.Receipt.Datetime", "RP", 1, true));
        this.childrenAndMeta.put("BusinessDocument.GovernmentGeneratedIdentifier.Text", new GlenixElementChildList(GlenixStringElementNoProcLodge.class, "http://www.glenix.com.au/", "BusinessDocument.GovernmentGeneratedIdentifier.Text", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "BusinessDocument.GovernmentGeneratedIdentifier.Text", "RP", 1, true));
        this.childrenAndMeta.put("Report.Name.Text", new GlenixElementChildList(GlenixStringElementNoProcLodge.class, "http://www.glenix.com.au/", "Report.Name.Text", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "Report.Name.Text", "RP", 1, true));
        this.childrenAndMeta.put("Report.TypeVariation.Code", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Report.TypeVariation.Code", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "Report.TypeVariation.Code", "RP", 1, true));
        this.childrenAndMeta.put("Lodgment.Due.Date", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Lodgment.Due.Date", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "Lodgment.Due.Date", "RP", 1, true));
        this.childrenAndMeta.put("PaymentRecord.Due.Date", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "PaymentRecord.Due.Date", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "PaymentRecord.Due.Date", "RP", 1, true));
        this.childrenAndMeta.put("Report.Statement.Revision.Indicator", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Report.Statement.Revision.Indicator", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "Report.Statement.Revision.Indicator", "RP", 1, true));
        this.childrenAndMeta.put("Report.Statement.PeriodSequence.Number", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Report.Statement.PeriodSequence.Number", null, null, "RP", 1, true));
        this.childrenAndMeta.put("Report.ProcessStatus.Code", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Report.ProcessStatus.Code", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "Report.ProcessStatus.Code", "RP", 1, true));
        this.childrenAndMeta.put("AccountingPolicies.CashAccountingMethodUsed.Indicator", new GlenixElementChildList(GlenixStringElementNoProcLodge.class, "http://www.glenix.com.au/", "AccountingPolicies.CashAccountingMethodUsed.Indicator", "http://sbr.gov.au/icls/baf/bafot/bafot.02.00.data", "AccountingPolicies.CashAccountingMethodUsed.Indicator", "RP", 1, true));
        this.childrenAndMeta.put("Report.Statement.Summary.Payable.Amount", new GlenixElementChildList(GlenixAmountElement.class, "http://www.glenix.com.au/", "Report.Statement.Summary.Payable.Amount", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "Report.Statement.Summary.Payable.Amount", "RP", 1, true));
        this.childrenAndMeta.put("Report.Statement.Summary.Refundable.Amount", new GlenixElementChildList(GlenixAmountElement.class, "http://www.glenix.com.au/", "Report.Statement.Summary.Refundable.Amount", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "Report.Statement.Summary.Refundable.Amount", "RP", 1, true));
        this.childrenAndMeta.put("Report.Statement.Summary.Net.Amount", new GlenixElementChildList(GlenixAmountElement.class, "http://www.glenix.com.au/", "Report.Statement.Summary.Net.Amount", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "Report.Statement.Summary.Net.Amount", "RP", 1, true));
        this.childrenAndMeta.put("GSTObligation", new GlenixElementChildList(GSTObligation.class, "http://www.glenix.com.au/", "GSTObligation", null, null, "RP_GST", 1, false));
        this.childrenAndMeta.put("FBTObligation", new GlenixElementChildList(FBTObligation.class, "http://www.glenix.com.au/", "FBTObligation", null, null, "RP_FBT", 1, false));
        this.childrenAndMeta.put("PAYGWObligation", new GlenixElementChildList(PAYGWObligation.class, "http://www.glenix.com.au/", "PAYGWObligation", null, null, "RP_PAYGW", 1, false));
        this.childrenAndMeta.put("PAYGIObligation", new GlenixElementChildList(PAYGIObligation.class, "http://www.glenix.com.au/", "PAYGIObligation", null, null, "RP_PAYGI", 1, false));
        this.childrenAndMeta.put("ASPaymentMechanism", new GlenixElementChildList(PaymentMechanism.class, "http://www.glenix.com.au/", "ASPaymentMechanism", null, null, "GovernmentAgency", 1, false));
        gecl = new GlenixElementChildList(Declaration.class, "http://www.glenix.com.au/", "ASDeclaration", "http://sbr.gov.au/comnmdle/comnmdle.declaration1.02.00.module", "Declaration", "RP", 1, false);
        this.childrenAndMeta.put("ASDeclaration", gecl);
        gecl = new GlenixElementChildList(ASIntermediary.class, "http://www.glenix.com.au/", "ASIntermediary", null, null, "INT", 1, false);
        this.childrenAndMeta.put("ASIntermediary", gecl);
        this.childrenAndMeta.put("SBRMessageTypeText", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "SBRMessageTypeText", null, null, "RP", 1, true));
        this.childrenAndMeta.put("SBRMessageTimestamp", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "SBRMessageTimestamp", null, null, "RP", 1, true));
        this.childrenAndMeta.put("IdentificationDetails.IdentifierDesignation.Text", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "IdentificationDetails.IdentifierDesignation.Text", null, null, "RP", 1, true));
        this.childrenAndMeta.put("IdentificationDetails.IdentifierName.Text", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "IdentificationDetails.IdentifierName.Text", null, null, "RP", 1, true));
    }

    private GlenixElement getChild(String childName) {
        if (childName == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return glenixElementChildList.getChild(0);
        }
        return null;
    }

    private String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    public void setAustralianBusinessNumber(String abn) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("Identifiers.AustralianBusinessNumber.Identifier");
        if (gse == null) {
            throw new Exception("Error, unable to set ABN number");
        }
        gse.setGlenixElementValue(abn);
    }

    public void setOrganisationBranchCode(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("OrganisationDetails.OrganisationBranch.Code");
        if (gse == null) {
            throw new Exception("Error, unable to set ABN branch code number");
        }
        gse.setGlenixElementValue(value);
    }

    public void setTaxFileNumberIdentifier(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("Identifiers.TaxFileNumber.Identifier");
        if (gse == null) {
            throw new Exception("Error, unable to set TFN");
        }
        gse.setGlenixElementValue(value);
    }

    public String getTaxFileNumberIdentifier() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("Identifiers.TaxFileNumber.Identifier");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public String getReportStatementRevisionIndicator() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("Report.Statement.Revision.Indicator");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public void setReportStatementRevisionIndicator(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("Report.Statement.Revision.Indicator");
        if (gse == null) {
            throw new Exception("Error, unable to set revision indicator");
        }
        gse.setGlenixElementValue(value);
    }

    public String getReportProcessStatusCode() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("Report.ProcessStatus.Code");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public String getReportNameText() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("Report.Name.Text");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public String getPaymentRecordDueDate() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("PaymentRecord.Due.Date");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public String getLodgmentDueDate() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("Lodgment.Due.Date");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public String getAustralianBusinessNumberIdentifier() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("Identifiers.AustralianBusinessNumber.Identifier");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public ASIntermediary getASIntermediary() {
        return (ASIntermediary)this.getChild("ASIntermediary");
    }

    public String getBusinessDocumentGovernmentGeneratedIdentifierText() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("BusinessDocument.GovernmentGeneratedIdentifier.Text");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public Declaration getDeclaration() {
        return (Declaration)this.getChild("ASDeclaration");
    }

    private void buildContext(Document doc, Element node_xbrl, String contextId, String abn, String tfn, String startDate, String endDate, String rpDimension, String estimationDimension, String taxObligationDimension) {
        Element node_explicitMember;
        Element node_context = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:context");
        node_xbrl.appendChild(node_context);
        node_context.setAttribute("id", contextId);
        Element node_entity = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:entity");
        node_context.appendChild(node_entity);
        Element node_identifier = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:identifier");
        node_entity.appendChild(node_identifier);
        if (abn != null && !abn.equals("")) {
            node_identifier.setAttribute("scheme", "http://www.ato.gov.au/abn");
            node_identifier.setTextContent(abn);
        } else {
            node_identifier.setAttribute("scheme", "http://www.ato.gov.au/tfn");
            node_identifier.setTextContent(tfn);
        }
        Element node_segment = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:segment");
        node_entity.appendChild(node_segment);
        if (estimationDimension != null) {
            node_explicitMember = doc.createElementNS("http://xbrl.org/2006/xbrldi", "xbrldi:explicitMember");
            node_segment.appendChild(node_explicitMember);
            node_explicitMember.setAttribute("dimension", "h03.02.00:LiabilityEstimationMethodDimension");
            node_explicitMember.setTextContent("h03.02.00:" + estimationDimension);
        }
        if (rpDimension != null) {
            node_explicitMember = doc.createElementNS("http://xbrl.org/2006/xbrldi", "xbrldi:explicitMember");
            node_segment.appendChild(node_explicitMember);
            node_explicitMember.setAttribute("dimension", "h04.02.00:ReportPartyTypeDimension");
            node_explicitMember.setTextContent("h04.02.00:" + rpDimension);
        }
        if (taxObligationDimension != null) {
            node_explicitMember = doc.createElementNS("http://xbrl.org/2006/xbrldi", "xbrldi:explicitMember");
            node_segment.appendChild(node_explicitMember);
            node_explicitMember.setAttribute("dimension", "h05.02.00:TaxObligationTypeDimension");
            node_explicitMember.setTextContent("h05.02.00:" + taxObligationDimension);
        }
        Element node_period = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:period");
        node_context.appendChild(node_period);
        Element node_startDate = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:startDate");
        node_period.appendChild(node_startDate);
        node_startDate.setTextContent(startDate);
        Element node_endDate = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:endDate");
        node_period.appendChild(node_endDate);
        node_endDate.setTextContent(endDate);
    }

    public Document buildActivityStatementDocument(String action) {
        PAYGWObligation paygwO;
        PAYGIObligation paygiO;
        FBTObligation fbtO;
        GSTObligation gstO;
        Document doc = this.docBuilder.newDocument();
        doc.setXmlStandalone(true);
        Element node_xbrl = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:xbrl");
        doc.appendChild(node_xbrl);
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xbrli", "http://www.xbrl.org/2003/instance");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:link", "http://www.xbrl.org/2003/linkbase");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xlink", "http://www.w3.org/1999/xlink");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xbrldi", "http://xbrl.org/2006/xbrldi");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:iso4217", "http://www.xbrl.org/2003/iso4217");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xbrldt", "http://xbrl.org/2005/xbrldt");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:as.0001.prv", "http://sbr.gov.au/rprt/ato/as/as.0001.private.02.00.module");
        if (action != null && action.equals("prelodge")) {
            node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:as.0001", "http://sbr.gov.au/rprt/ato/as/as.0001.prelodge.request.02.00.report");
        } else {
            node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:as.0001", "http://sbr.gov.au/rprt/ato/as/as.0001.lodge.request.02.00.report");
        }
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:h03.02.00", "http://sbr.gov.au/dims/LiabEstMethod.02.00.dims");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:h04.02.00", "http://sbr.gov.au/dims/RprtPyType.02.00.dims");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:h05.02.00", "http://sbr.gov.au/dims/TaxOblgtn.02.00.dims");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:address1.02.00", "http://sbr.gov.au/comnmdle/comnmdle.addressdetails1.02.00.module");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:bafpr1.02.00", "http://sbr.gov.au/icls/baf/bafpr/bafpr1.02.00.data");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:bafpr2.02.00", "http://sbr.gov.au/icls/baf/bafpr/bafpr2.02.00.data");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:bafot.02.00", "http://sbr.gov.au/icls/baf/bafot/bafot.02.00.data");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:email1.02.00", "http://sbr.gov.au/comnmdle/comnmdle.electroniccontactelectronicmail1.02.00.module");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:phone1.02.00", "http://sbr.gov.au/comnmdle/comnmdle.electroniccontacttelephone1.02.00.module");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:orgname1.02.00", "http://sbr.gov.au/comnmdle/comnmdle.organisationname1.02.00.module");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:lrla.02.00", "http://sbr.gov.au/icls/lr/lrla/lrla.02.00.data");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:pyde.02.00", "http://sbr.gov.au/icls/py/pyde/pyde.02.00.data");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:pyid.02.00", "http://sbr.gov.au/icls/py/pyid/pyid.02.00.data");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:pyin.02.00", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:rvctc1.02.00", "http://sbr.gov.au/icls/rvc/rvctc/rvctc1.02.00.data");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:rvctc2.02.00", "http://sbr.gov.au/icls/rvc/rvctc/rvctc2.02.00.data");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:rvctc3.02.00", "http://sbr.gov.au/icls/rvc/rvctc/rvctc3.02.00.data");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:tech.01.02", "http://sbr.gov.au/fdtn/sbr.01.02.tech");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:taxrate.02.00", "http://sbr.gov.au/comnmdle/comnmdle.taxrate1.02.00.module");
        node_xbrl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:declaration.02.00", "http://sbr.gov.au/comnmdle/comnmdle.declaration1.02.00.module");
        Element node_schemaRef = doc.createElementNS("http://www.xbrl.org/2003/linkbase", "link:schemaRef");
        node_xbrl.appendChild(node_schemaRef);
        if (action != null && action.equals("prelodge")) {
            node_schemaRef.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "http://sbr.gov.au/taxonomy/sbr_au_reports/ato/as/as_0001/as.0001.prelodge.request.02.00.report.xsd");
        } else {
            node_schemaRef.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:href", "http://sbr.gov.au/taxonomy/sbr_au_reports/ato/as/as_0001/as.0001.lodge.request.02.00.report.xsd");
        }
        node_schemaRef.setAttributeNS("http://www.w3.org/1999/xlink", "xlink:type", "simple");
        String abn = this.getAustralianBusinessNumberIdentifier();
        String tfn = this.getTaxFileNumberIdentifier();
        String startDate = this.getStartDate();
        String endDate = this.getEndDate();
        this.buildContext(doc, node_xbrl, "RP", abn, tfn, startDate, endDate, "ReportingParty", null, null);
        String agentABN = null;
        ASIntermediary asIntermediary = this.getASIntermediary();
        if (asIntermediary != null && (agentABN = asIntermediary.getAustralianBusinessNumberIdentifier()) != null && !agentABN.equals("")) {
            this.buildContext(doc, node_xbrl, "INT", agentABN, null, startDate, endDate, "Intermediary", null, null);
        }
        if ((gstO = this.getGSTObligation()) != null) {
            this.buildContext(doc, node_xbrl, "RP_GST", abn, tfn, startDate, endDate, "ReportingParty", null, "GST");
            this.buildContext(doc, node_xbrl, "RP_GST_CC", abn, tfn, startDate, endDate, "ReportingParty", "CommissionerChosen", "GST");
            this.buildContext(doc, node_xbrl, "RP_GST_BV", abn, tfn, startDate, endDate, "ReportingParty", "BusinessVariation", "GST");
            this.buildContext(doc, node_xbrl, "RP_GST_BE", abn, tfn, startDate, endDate, "ReportingParty", "BusinessEstimation", "GST");
            this.buildContext(doc, node_xbrl, "RP_GST_CAL", abn, tfn, startDate, endDate, "ReportingParty", "Calculation", "GST");
        }
        if ((fbtO = this.getFBTObligation()) != null) {
            this.buildContext(doc, node_xbrl, "RP_FBT", abn, tfn, startDate, endDate, "ReportingParty", null, "FBT");
            this.buildContext(doc, node_xbrl, "RP_FBT_CC", abn, tfn, startDate, endDate, "ReportingParty", "CommissionerChosen", "FBT");
            this.buildContext(doc, node_xbrl, "RP_FBT_BV", abn, tfn, startDate, endDate, "ReportingParty", "BusinessVariation", "FBT");
            this.buildContext(doc, node_xbrl, "RP_FBT_BE", abn, tfn, startDate, endDate, "ReportingParty", "BusinessEstimation", "FBT");
        }
        if ((paygiO = this.getPAYGIObligation()) != null) {
            this.buildContext(doc, node_xbrl, "RP_PAYGI", abn, tfn, startDate, endDate, "ReportingParty", null, "PAYGI");
            this.buildContext(doc, node_xbrl, "RP_PAYGI_CC", abn, tfn, startDate, endDate, "ReportingParty", "CommissionerChosen", "PAYGI");
            this.buildContext(doc, node_xbrl, "RP_PAYGI_BV", abn, tfn, startDate, endDate, "ReportingParty", "BusinessVariation", "PAYGI");
            this.buildContext(doc, node_xbrl, "RP_PAYGI_BE", abn, tfn, startDate, endDate, "ReportingParty", "BusinessEstimation", "PAYGI");
            this.buildContext(doc, node_xbrl, "RP_PAYGI_CAL", abn, tfn, startDate, endDate, "ReportingParty", "Calculation", "PAYGI");
        }
        if ((paygwO = this.getPAYGWObligation()) != null) {
            this.buildContext(doc, node_xbrl, "RP_PAYGW", abn, tfn, startDate, endDate, "ReportingParty", null, "PAYGW");
        }
        Element node_unit = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:unit");
        node_xbrl.appendChild(node_unit);
        node_unit.setAttribute("id", "U1");
        Element node_measure = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:measure");
        node_unit.appendChild(node_measure);
        node_measure.setTextContent("iso4217:AUD");
        node_unit = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:unit");
        node_xbrl.appendChild(node_unit);
        node_unit.setAttribute("id", "U2");
        node_measure = doc.createElementNS("http://www.xbrl.org/2003/instance", "xbrli:measure");
        node_unit.appendChild(node_measure);
        node_measure.setTextContent("xbrli:pure");
        Set<String> childNames = this.getChildElementNameSet();
        for (String childName : childNames) {
            List<GlenixElement> childGEs = this.getChildElementSet(childName);
            if (childGEs == null || childGEs.size() <= 0) continue;
            if (childName.equals("ASDeclaration")) {
                if (agentABN != null && !agentABN.equals("")) continue;
                for (GlenixElement ge_child : childGEs) {
                    ge_child.buildActivityStatementElement(doc, node_xbrl, this.getChildIsLeaf(childName));
                }
                continue;
            }
            if (childName.equals("ASIntermediary")) {
                if (agentABN == null || agentABN.equals("")) continue;
                for (GlenixElement ge_child : childGEs) {
                    ge_child.buildActivityStatementElement(doc, node_xbrl, this.getChildIsLeaf(childName));
                }
                continue;
            }
            for (GlenixElement ge_child : childGEs) {
                ge_child.buildActivityStatementElement(doc, node_xbrl, this.getChildIsLeaf(childName));
            }
        }
        return doc;
    }

    @Override
    public boolean loadSBRDocumentElement(Document doc, Element element, SBRContexts contexts, boolean lodgeOK) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/2003/instance") && element.getLocalName() != null && element.getLocalName().equals("xbrl")) {
            PAYGWObligation paygwO;
            PAYGIObligation paygiO;
            FBTObligation fbtO;
            GSTObligation gstO;
            GlenixStringElement gse;
            String endDateStr;
            GlenixStringElement gse2;
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                GlenixElementChildList cl;
                GlenixElement ge;
                Element element_child;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || "http://www.xbrl.org/2003/instance".equals((element_child = (Element)node).getNamespaceURI()) && "context".equals(element_child.getLocalName()) || "http://www.xbrl.org/2003/linkbase".equals(element_child.getNamespaceURI()) && "schemaRef".equals(element_child.getLocalName()) || "http://www.xbrl.org/2003/instance".equals(element_child.getNamespaceURI()) && "unit".equals(element_child.getLocalName())) continue;
                if ("http://sbr.gov.au/icls/py/pyin/pyin.02.00.data".equals(element_child.getNamespaceURI()) && "PaymentMechanism.CustomerReference.Number".equals(element_child.getLocalName())) {
                    GlenixElement ge2 = this.getOrAddChild("ASPaymentMechanism");
                    ge2.loadSBRDocumentElement(doc, element, contexts, lodgeOK);
                    continue;
                }
                if ("http://sbr.gov.au/comnmdle/comnmdle.bpay1.02.00.module".equals(element_child.getNamespaceURI()) && "Bpay".equals(element_child.getLocalName())) {
                    GlenixElement ge3 = this.getOrAddChild("ASPaymentMechanism");
                    ge3.loadSBRDocumentElement(doc, element, contexts, lodgeOK);
                    continue;
                }
                if ("http://sbr.gov.au/comnmdle/comnmdle.directcredit1.02.00.module".equals(element_child.getNamespaceURI()) && "DirectCredit".equals(element_child.getLocalName())) {
                    GlenixElement ge4 = this.getOrAddChild("ASPaymentMechanism");
                    ge4.loadSBRDocumentElement(doc, element, contexts, lodgeOK);
                    continue;
                }
                if ("http://sbr.gov.au/comnmdle/comnmdle.cheque1.02.00.module".equals(element_child.getNamespaceURI()) && "Cheque".equals(element_child.getLocalName())) {
                    GlenixElement ge5 = this.getOrAddChild("ASPaymentMechanism");
                    ge5.loadSBRDocumentElement(doc, element, contexts, lodgeOK);
                    continue;
                }
                boolean subresult = false;
                Iterator iterator = this.childrenAndMeta.values().iterator();
                while (iterator.hasNext() && !(subresult = (ge = this.getOrAddChild(cl = (GlenixElementChildList)iterator.next())).loadSBRDocumentElement(doc, element_child, contexts, lodgeOK))) {
                }
                if (subresult) continue;
                throw new Exception("Error ActivityStatment cannot process element, " + element_child.getLocalName());
            }
            String startDateStr = contexts.getGlenixContextStartDate("RP_GST");
            if (startDateStr != null && (gse2 = (GlenixStringElement)this.getOrAddChild("SBRStartDate")) != null) {
                gse2.setGlenixElementValue(startDateStr);
            }
            if ((endDateStr = contexts.getGlenixContextEndDate("RP_GST")) != null && (gse = (GlenixStringElement)this.getOrAddChild("SBREndDate")) != null) {
                gse.setGlenixElementValue(endDateStr);
            }
            if ((gstO = (GSTObligation)this.getOrAddChild("GSTObligation")) != null) {
                gstO.setContextFields(contexts);
            }
            if ((fbtO = (FBTObligation)this.getOrAddChild("FBTObligation")) != null) {
                fbtO.setContextFields(contexts);
            }
            if ((paygiO = (PAYGIObligation)this.getOrAddChild("PAYGIObligation")) != null) {
                paygiO.setContextFields(contexts);
            }
            if ((paygwO = (PAYGWObligation)this.getOrAddChild("PAYGWObligation")) != null) {
                paygwO.setContextFields(contexts);
            }
            return true;
        }
        return false;
    }

    public void loadSBRDocumentRoot(Document doc, Element root, boolean lodgeOK) throws Exception {
        SBRContexts contexts = new SBRContexts();
        if (root.getNamespaceURI() != null && root.getNamespaceURI().equals("http://www.xbrl.org/2003/instance") && root.getLocalName() != null && root.getLocalName().equals("xbrl")) {
            GlenixElementChildList glenixElementChildList;
            boolean hasGST = false;
            boolean hasFBT = false;
            boolean hasPAYGI = false;
            boolean hasPAYGW = false;
            NodeList nodeList = root.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element root_child;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !"http://www.xbrl.org/2003/instance".equals((root_child = (Element)node).getNamespaceURI()) || !"context".equals(root_child.getLocalName())) continue;
                String contextIdentifier = null;
                String startDate = null;
                String endDate = null;
                String identifierScheme = null;
                String identifier = null;
                String reportingPartyDimension = null;
                String taxObligationTypeDimension = null;
                String liabilityEstimationMethodDimension = null;
                contextIdentifier = root_child.getAttribute("id");
                contexts.addContext(contextIdentifier);
                NodeList context_childList = root_child.getChildNodes();
                for (int j = 0; j < context_childList.getLength(); ++j) {
                    int k;
                    Node context_child = context_childList.item(j);
                    if (context_child.getNodeType() != 1) continue;
                    Element context_childElement = (Element)context_child;
                    if ("http://www.xbrl.org/2003/instance".equals(context_child.getNamespaceURI()) && "entity".equals(context_child.getLocalName())) {
                        NodeList entity_childList = context_child.getChildNodes();
                        for (k = 0; k < entity_childList.getLength(); ++k) {
                            Node entity_child = entity_childList.item(k);
                            if (entity_child.getNodeType() != 1) continue;
                            Element entity_childElement = (Element)entity_child;
                            if ("http://www.xbrl.org/2003/instance".equals(entity_childElement.getNamespaceURI()) && "identifier".equals(entity_childElement.getLocalName())) {
                                identifierScheme = entity_childElement.getAttribute("scheme");
                                identifier = entity_childElement.getTextContent();
                                contexts.setIdentifierScheme(contextIdentifier, identifierScheme);
                                contexts.setIdentifier(contextIdentifier, identifier);
                                continue;
                            }
                            if (!"http://www.xbrl.org/2003/instance".equals(entity_childElement.getNamespaceURI()) || !"segment".equals(entity_childElement.getLocalName())) continue;
                            NodeList segment_childList = entity_child.getChildNodes();
                            for (int m = 0; m < segment_childList.getLength(); ++m) {
                                String dnamespace;
                                String[] ddparts;
                                String dimension;
                                String[] dparts;
                                Element segment_childElement;
                                Node segment_child = segment_childList.item(m);
                                if (segment_child.getNodeType() != 1 || !"http://xbrl.org/2006/xbrldi".equals((segment_childElement = (Element)segment_child).getNamespaceURI()) || !"explicitMember".equals(segment_childElement.getLocalName()) || (dparts = (dimension = segment_childElement.getAttribute("dimension")).split(":", 2)).length != 2) continue;
                                String namespace = doc.lookupNamespaceURI(dparts[0]);
                                if ("http://sbr.gov.au/dims/RprtPyType.02.00.dims".equals(namespace) && "ReportPartyTypeDimension".equals(dparts[1])) {
                                    String reportingPartyType = segment_childElement.getTextContent();
                                    ddparts = reportingPartyType.split(":", 2);
                                    if (ddparts.length != 2) continue;
                                    dnamespace = doc.lookupNamespaceURI(ddparts[0]);
                                    if ("http://sbr.gov.au/dims/RprtPyType.02.00.dims".equals(dnamespace) && "ReportingParty".equals(ddparts[1])) {
                                        reportingPartyDimension = "ReportingParty";
                                    } else if ("http://sbr.gov.au/dims/RprtPyType.02.00.dims".equals(dnamespace) && "GovernmentAgency".equals(ddparts[1])) {
                                        reportingPartyDimension = "GovernmentAgency";
                                    } else {
                                        throw new Exception("Error unexpected reporting party type, " + reportingPartyType);
                                    }
                                    contexts.setContextDimension(contextIdentifier, "ReportPartyTypeDimension", reportingPartyDimension);
                                    continue;
                                }
                                if ("http://sbr.gov.au/dims/TaxOblgtn.02.00.dims".equals(namespace) && "TaxObligationTypeDimension".equals(dparts[1])) {
                                    String taxObligationType = segment_childElement.getTextContent();
                                    ddparts = taxObligationType.split(":", 2);
                                    if (ddparts.length != 2) continue;
                                    dnamespace = doc.lookupNamespaceURI(ddparts[0]);
                                    if ("http://sbr.gov.au/dims/TaxOblgtn.02.00.dims".equals(dnamespace) && "GST".equals(ddparts[1])) {
                                        taxObligationTypeDimension = "GST";
                                        hasGST = true;
                                    } else if ("http://sbr.gov.au/dims/TaxOblgtn.02.00.dims".equals(dnamespace) && "PAYGI".equals(ddparts[1])) {
                                        taxObligationTypeDimension = "PAYGI";
                                        hasPAYGI = true;
                                    } else if ("http://sbr.gov.au/dims/TaxOblgtn.02.00.dims".equals(dnamespace) && "PAYGW".equals(ddparts[1])) {
                                        taxObligationTypeDimension = "PAYGW";
                                        hasPAYGW = true;
                                    } else if ("http://sbr.gov.au/dims/TaxOblgtn.02.00.dims".equals(dnamespace) && "FBT".equals(ddparts[1])) {
                                        taxObligationTypeDimension = "FBT";
                                        hasFBT = true;
                                    } else {
                                        throw new Exception("Error unexpected tax obligation type, " + taxObligationType);
                                    }
                                    contexts.setContextDimension(contextIdentifier, "TaxObligationTypeDimension", taxObligationTypeDimension);
                                    continue;
                                }
                                if ("http://sbr.gov.au/dims/LiabEstMethod.02.00.dims".equals(namespace) && "LiabilityEstimationMethodDimension".equals(dparts[1])) {
                                    String liabilityEstimationMethod = segment_childElement.getTextContent();
                                    ddparts = liabilityEstimationMethod.split(":", 2);
                                    if (ddparts.length != 2) continue;
                                    dnamespace = doc.lookupNamespaceURI(ddparts[0]);
                                    if ("http://sbr.gov.au/dims/LiabEstMethod.02.00.dims".equals(dnamespace) && "BusinessVariation".equals(ddparts[1])) {
                                        liabilityEstimationMethodDimension = "BusinessVariation";
                                    } else if ("http://sbr.gov.au/dims/LiabEstMethod.02.00.dims".equals(dnamespace) && "BusinessEstimation".equals(ddparts[1])) {
                                        liabilityEstimationMethodDimension = "BusinessEstimation";
                                    } else if ("http://sbr.gov.au/dims/LiabEstMethod.02.00.dims".equals(dnamespace) && "CommissionerChosen".equals(ddparts[1])) {
                                        liabilityEstimationMethodDimension = "CommissionerChosen";
                                    } else if ("http://sbr.gov.au/dims/LiabEstMethod.02.00.dims".equals(dnamespace) && "Calculation".equals(ddparts[1])) {
                                        liabilityEstimationMethodDimension = "Calculation";
                                    } else {
                                        throw new Exception("Error unexpected liability estimation method, " + liabilityEstimationMethod);
                                    }
                                    contexts.setContextDimension(contextIdentifier, "LiabilityEstimationMethodDimension", liabilityEstimationMethodDimension);
                                    continue;
                                }
                                throw new Exception("Error unexpected dimension, " + dimension);
                            }
                        }
                        continue;
                    }
                    if (!"http://www.xbrl.org/2003/instance".equals(context_child.getNamespaceURI()) || !"period".equals(context_child.getLocalName())) continue;
                    NodeList period_childList = context_child.getChildNodes();
                    for (k = 0; k < period_childList.getLength(); ++k) {
                        Node period_child = period_childList.item(k);
                        if (period_child.getNodeType() != 1) continue;
                        Element period_childElement = (Element)period_child;
                        if ("http://www.xbrl.org/2003/instance".equals(period_childElement.getNamespaceURI()) && "startDate".equals(period_childElement.getLocalName())) {
                            startDate = period_childElement.getTextContent();
                            contexts.setContextStartDate(contextIdentifier, startDate);
                            continue;
                        }
                        if (!"http://www.xbrl.org/2003/instance".equals(period_childElement.getNamespaceURI()) || !"endDate".equals(period_childElement.getLocalName())) continue;
                        endDate = period_childElement.getTextContent();
                        contexts.setContextEndDate(contextIdentifier, endDate);
                    }
                }
            }
            this.loadSBRDocumentElement(doc, root, contexts, lodgeOK);
            if (!hasGST && (glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("GSTObligation")) != null) {
                glenixElementChildList.clearChildren();
            }
            if (!hasFBT && (glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("FBTObligation")) != null) {
                glenixElementChildList.clearChildren();
            }
            if (!hasPAYGW && (glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("PAYGWObligation")) != null) {
                glenixElementChildList.clearChildren();
            }
            if (!hasPAYGI && (glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("PAYGIObligation")) != null) {
                glenixElementChildList.clearChildren();
            }
            return;
        }
        throw new Exception("Error: attempt to SBR load " + root.getLocalName() + " into ActivityStatement.");
    }

    public void loadSBROverallEventMessageDocument(Document doc, Element root) throws Exception {
        this.childrenAndMeta.put("ASOverallEventItems", new GlenixElementChildList(ASOverallEventItems.class, "http://www.glenix.com.au/", "ASOverallEventItems", null, null, null, 1, false));
        EventItems overallEventItems = (EventItems)this.getOrAddChild("ASOverallEventItems");
        overallEventItems.loadSBRDocumentRoot(doc, root);
    }

    public void loadSBRBusinessEventMessageDocument(Document doc, Element root) throws Exception {
        this.childrenAndMeta.put("ASBusinessEventItems", new GlenixElementChildList(ASBusinessEventItems.class, "http://www.glenix.com.au/", "ASBusinessEventItems", null, null, null, 1, false));
        EventItems businessEventItems = (EventItems)this.getOrAddChild("ASBusinessEventItems");
        businessEventItems.loadSBRDocumentRoot(doc, root);
    }

    public GSTObligation getGSTObligation() {
        return (GSTObligation)this.getChild("GSTObligation");
    }

    public FBTObligation getFBTObligation() {
        return (FBTObligation)this.getChild("FBTObligation");
    }

    public PAYGIObligation getPAYGIObligation() {
        return (PAYGIObligation)this.getChild("PAYGIObligation");
    }

    public PAYGWObligation getPAYGWObligation() {
        return (PAYGWObligation)this.getChild("PAYGWObligation");
    }

    public EventItems getOverallEventItems() {
        return (EventItems)this.getChild("ASOverallEventItems");
    }

    public EventItems getBusinessEventItems() {
        return (EventItems)this.getChild("ASBusinessEventItems");
    }

    public String getStartDate() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("SBRStartDate");
        if (gse != null) {
            return gse.getGlenixElementValue();
        }
        return null;
    }

    public LocalDate getStartDateAsDate() {
        String date = this.getChildValue("SBRStartDate");
        if (date == null || date.isEmpty()) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getEndDate() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("SBREndDate");
        if (gse != null) {
            return gse.getGlenixElementValue();
        }
        return null;
    }

    public LocalDate getEndDateAsDate() {
        String date = this.getChildValue("SBREndDate");
        if (date == null || date.isEmpty()) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getActivityStatementNumber() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("ActivityStatementNumber");
        if (gse != null) {
            return gse.getGlenixElementValue();
        }
        return null;
    }

    public SimpleStringProperty getActivityStatementNumberProperty() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("ActivityStatementNumber");
        if (gse != null) {
            return gse.getGlenixElementProperty();
        }
        return null;
    }

    public void setActivityStatementNumber(String activityStatementNumber) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("ActivityStatementNumber");
        if (gse != null) {
            gse.setGlenixElementValue(activityStatementNumber);
        }
    }

    public String getOriginalActivityStatementNumber() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("originalActivityStatementNumber");
        if (gse != null) {
            return gse.getGlenixElementValue();
        }
        return null;
    }

    public void setOriginalActivityStatementNumber(String originalActivityStatementNumber) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("originalActivityStatementNumber");
        if (gse != null) {
            gse.setGlenixElementValue(originalActivityStatementNumber);
        }
    }

    public String getSBRDocumentStatus() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("SBRDocumentStatus");
        if (gse != null) {
            return gse.getGlenixElementValue();
        }
        return null;
    }

    public void setSBRDocumentStatus(String status) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("SBRDocumentStatus");
        if (gse != null) {
            gse.setGlenixElementValue(status);
        }
    }

    public String getSBRDocumentDateTime() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("SBRDocumentDateTime");
        if (gse != null) {
            return gse.getGlenixElementValue();
        }
        return null;
    }

    public void setSBRDocumentDateTime() throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("SBRDocumentDateTime");
        if (gse != null) {
            String timestamp = this.generateTimestamp();
            gse.setGlenixElementValue(timestamp);
        }
    }

    public void setLodgmentReceiptDatetime(String timestamp) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("Lodgment.Receipt.Datetime");
        if (gse != null) {
            gse.setGlenixElementValue(timestamp);
        }
    }

    private void assignUUIDToActivityStatementNumber() throws Exception {
        String activityStatementNumber = this.getActivityStatementNumber();
        if (activityStatementNumber == null || activityStatementNumber.isEmpty()) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("ActivityStatementNumber");
            UUID uuid = UUID.randomUUID();
            String uuidString = uuid.toString();
            if (glenixElementChildList != null && glenixElementChildList.getChildCount() > 0) {
                GlenixStringElement gse = (GlenixStringElement)glenixElementChildList.getChild(0);
                gse.setGlenixElementValue(uuidString);
            } else {
                glenixElementChildList.addChild(uuidString);
            }
        }
    }

    @Override
    public void loadDocumentElement(Document doc, Element element) throws Exception {
        super.loadDocumentElement(doc, element);
        this.assignUUIDToActivityStatementNumber();
    }

    @Override
    public void loadDocumentElementOverwrite(Document doc, Element element) throws Exception {
        super.loadDocumentElementOverwrite(doc, element);
        this.assignUUIDToActivityStatementNumber();
    }

    public void removeEventMessages() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("ASOverallEventItems");
        if (glenixElementChildList != null) {
            glenixElementChildList.clearChildren();
        }
        if ((glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("ASBusinessEventItems")) != null) {
            glenixElementChildList.clearChildren();
        }
    }

    public String getASCertAlias() {
        return this.getChildValue("ASCertAlias");
    }

    public void setASCertAlias(String value) throws Exception {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getOrAddChild("ASCertAlias");
        if (glenixStringElement == null) {
            return;
        }
        glenixStringElement.setGlenixElementValue(value);
    }

    public String getASMessageIdentifier() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("asMessageIdentifier");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public void generateASMessageIdentifier() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("asMessageIdentifier");
        String uuidString = this.generateMessageIdentifier();
        if (glenixElementChildList != null && glenixElementChildList.getChildCount() > 0) {
            GlenixStringElement gse = (GlenixStringElement)glenixElementChildList.getChild(0);
            gse.setGlenixElementValue(uuidString);
        } else {
            glenixElementChildList.addChild(uuidString);
        }
    }

    public void setRpDeclarationStatementTypeCode(String value) throws Exception {
        Declaration d = this.getDeclaration();
        if (d == null) {
            if (value == null) {
                return;
            }
            throw new Exception("Error, cannot set declaration type code as there is no declaration element.");
        }
        d.setDeclarationStatementTypeCode(value);
    }

    public void setIntDeclarationStatementTypeCode(String value) throws Exception {
        ASIntermediary asi = this.getASIntermediary();
        if (asi == null) {
            if (value == null) {
                return;
            }
            throw new Exception("Error, cannot set intermediary declaration type code as there is no intermediary element.");
        }
        asi.setDeclarationStatementTypeCode(value);
    }

    public void loadFasV2ActivityStatement(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.socialaccounts.com/gl/soc/2011-03-31") && element.getLocalName() != null && element.getLocalName().equals("SBRDocumentAS")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                GlenixStringElement gse;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                if (el.getLocalName().equals("SBRDocumentASNumber")) {
                    gse = (GlenixStringElement)this.getOrAddChild("ActivityStatementNumber");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("SBRStartDate")) {
                    gse = (GlenixStringElement)this.getOrAddChild("SBRStartDate");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("SBREndDate")) {
                    gse = (GlenixStringElement)this.getOrAddChild("SBREndDate");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("SBRDocumentDateTime")) {
                    gse = (GlenixStringElement)this.getOrAddChild("SBRDocumentDateTime");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("SBRDocumentStatus")) {
                    gse = (GlenixStringElement)this.getOrAddChild("SBRDocumentStatus");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("Identifiers.AustralianBusinessNumber.Identifier")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Identifiers.AustralianBusinessNumber.Identifier");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("OrganisationDetails.OrganisationBranch.Code")) {
                    gse = (GlenixStringElement)this.getOrAddChild("OrganisationDetails.OrganisationBranch.Code");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("Identifiers.TaxFileNumber.Identifier")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Identifiers.TaxFileNumber.Identifier");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("ASOrganisationDetails")) {
                    OrganisationNameDetails name = (OrganisationNameDetails)this.getOrAddChild("ASOrganisationNameDetails");
                    name.loadFasV2ActivityStatement(doc, el);
                    continue;
                }
                if (el.getLocalName().equals("ASOrganisationAddressDetails")) {
                    AddressDetails addr = (AddressDetails)this.getOrAddChild("ASOrganisationAddressDetails");
                    addr.loadFasV2ActivityStatement(doc, el);
                    continue;
                }
                if (el.getLocalName().equals("ASOrganisationContactTelephone")) {
                    ElectronicContactTelephone tel = (ElectronicContactTelephone)this.getOrAddChild("ASOrganisationContactTelephone");
                    tel.loadFasV2ActivityStatement(doc, el);
                    continue;
                }
                if (el.getLocalName().equals("ASOrganisationContactEmail")) {
                    ElectronicContactElectronicMail em = (ElectronicContactElectronicMail)this.getOrAddChild("ASOrganisationContactEmail");
                    em.loadFasV2ActivityStatement(doc, el);
                    continue;
                }
                if (el.getLocalName().equals("Report.CompletionHours.Number")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Report.CompletionHours.Number");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("Report.CompletionMinutes.Number")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Report.CompletionMinutes.Number");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("Lodgment.Receipt.Datetime")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Lodgment.Receipt.Datetime");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("BusinessDocument.GovernmentGeneratedIdentifier.Text")) {
                    gse = (GlenixStringElement)this.getOrAddChild("BusinessDocument.GovernmentGeneratedIdentifier.Text");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("Report.Name.Text")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Report.Name.Text");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("Report.TypeVariation.Code")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Report.TypeVariation.Code");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("Lodgment.Due.Date")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Lodgment.Due.Date");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("PaymentRecord.Due.Date")) {
                    gse = (GlenixStringElement)this.getOrAddChild("PaymentRecord.Due.Date");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("Report.Statement.Revision.Indicator")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Report.Statement.Revision.Indicator");
                    String val = el.getTextContent();
                    if (val != null && val.equals("f")) {
                        gse.setGlenixElementValue("false");
                        continue;
                    }
                    gse.setGlenixElementValue("true");
                    continue;
                }
                if (el.getLocalName().equals("Report.Statement.PeriodSequence.Number")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Report.Statement.PeriodSequence.Number");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("Report.ProcessStatus.Code")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Report.ProcessStatus.Code");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("AccountingPolicies.CashAccountingMethodUsed.Indicator")) {
                    gse = (GlenixStringElement)this.getOrAddChild("AccountingPolicies.CashAccountingMethodUsed.Indicator");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("Report.Statement.Summary.Payable.Amount")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Report.Statement.Summary.Payable.Amount");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("Report.Statement.Summary.Refundable.Amount")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Report.Statement.Summary.Refundable.Amount");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("Report.Statement.Summary.Net.Amount")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Report.Statement.Summary.Net.Amount");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("")) {
                    gse = (GlenixStringElement)this.getOrAddChild("");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("GSTObligation")) {
                    GSTObligation gst = (GSTObligation)this.getOrAddChild("GSTObligation");
                    gst.loadFasV2ActivityStatement(doc, el);
                    continue;
                }
                if (el.getLocalName().equals("SBRMessageTypeText")) {
                    gse = (GlenixStringElement)this.getOrAddChild("SBRMessageTypeText");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("SBRMessageTimestamp")) {
                    gse = (GlenixStringElement)this.getOrAddChild("SBRMessageTimestamp");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("IdentificationDetails.IdentifierDesignation.Text")) {
                    gse = (GlenixStringElement)this.getOrAddChild("IdentificationDetails.IdentifierDesignation.Text");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (!el.getLocalName().equals("IdentificationDetails.IdentifierName.Text")) continue;
                gse = (GlenixStringElement)this.getOrAddChild("IdentificationDetails.IdentifierName.Text");
                gse.setGlenixElementValue(el.getTextContent());
            }
            return;
        }
    }

    public void removeMasterFileInformation() {
        for (String key : this.childrenAndMeta.keySet()) {
            if (key.equals("ActivityStatementNumber")) continue;
            ((GlenixElementChildList)this.childrenAndMeta.get(key)).clearChildren();
        }
    }
}

