/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.Business;
import au.com.glenix.trn.CalculationRule;
import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import au.com.glenix.trn.Transaction;
import java.util.UUID;
import javafx.beans.property.SimpleStringProperty;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Account
extends GlenixAbstractBranchElement {
    private DocumentBuilderFactory docFactory;
    private DocumentBuilder docBuilder;

    public Account() throws Exception {
        this.name = "account";
        this.namespace = "http://www.glenix.com.au/";
        this.docFactory = DocumentBuilderFactory.newInstance();
        this.docFactory.setNamespaceAware(true);
        this.docBuilder = this.docFactory.newDocumentBuilder();
        this.childrenAndMeta.put("accountIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "accountIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("accountName", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "accountName", null, null, null, 1, true));
        this.childrenAndMeta.put("accountDescription", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "accountDescription", null, null, null, 1, true));
        this.childrenAndMeta.put("accountClassificationReference", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "accountClassificationReference", null, null, null, 1, true));
        this.childrenAndMeta.put("accountActive", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "accountActive", null, null, null, 1, true));
        this.childrenAndMeta.put("defaultProvisionIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "defaultProvisionIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("rate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "rate", null, null, null, 1, true));
        this.childrenAndMeta.put("normalRateMultiplier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "normalRateMultiplier", null, null, null, 1, true));
        this.childrenAndMeta.put("paymentDeductionType", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "paymentDeductionType", null, null, null, 1, true));
        this.childrenAndMeta.put("applySuper", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "applySuper", null, null, null, 1, true));
        this.childrenAndMeta.put("applyLeave", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "applyLeave", null, null, null, 1, true));
        this.childrenAndMeta.put("calculationRule", new GlenixElementChildList(CalculationRule.class, "http://www.glenix.com.au/", "calculationRule", null, null, null, -1, false));
        this.childrenAndMeta.put("calculationRuleMethod", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "calculationRuleMethod", null, null, null, 1, true));
        this.childrenAndMeta.put("calculationProvisionIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "calculationProvisionIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("calculationStage", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "calculationStage", null, null, null, 1, true));
    }

    private GlenixElement getChild(String childName) {
        if (childName == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return glenixElementChildList.getChild(0);
        }
        return null;
    }

    private String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    private SimpleStringProperty getChildProperty(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementProperty();
        }
        return null;
    }

    public String getAccountIdentifier() {
        return this.getChildValue("accountIdentifier");
    }

    public SimpleStringProperty getAccountIdentifierProperty() {
        return this.getChildProperty("accountIdentifier");
    }

    public void setAccountIdentifier(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("accountIdentifier");
        gse.setGlenixElementValue(value);
    }

    public String getAccountName() {
        return this.getChildValue("accountName");
    }

    public void setAccountName(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("accountName");
        gse.setGlenixElementValue(value);
    }

    public SimpleStringProperty getAccountNameProperty() {
        return this.getChildProperty("accountName");
    }

    public String getAccountDescription() {
        return this.getChildValue("accountDescription");
    }

    public SimpleStringProperty getAccountDescriptionProperty() {
        return this.getChildProperty("accountDescription");
    }

    public String getAccountClassificationReference() {
        return this.getChildValue("accountClassificationReference");
    }

    public SimpleStringProperty getAccountClassificationReferenceProperty() {
        return this.getChildProperty("accountClassificationReference");
    }

    public void setAccountClassificationReference(String value) throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("accountClassificationReference");
        gse.setGlenixElementValue(value);
    }

    public String getAccountActive() {
        return this.getChildValue("accountActive");
    }

    public SimpleStringProperty getAccountActiveProperty() {
        return this.getChildProperty("accountActive");
    }

    public String getDefaultProvisionIdentifier() {
        return this.getChildValue("defaultProvisionIdentifier");
    }

    public SimpleStringProperty getDefaultProvisionIdentifierProperty() {
        return this.getChildProperty("defaultProvisionIdentifier");
    }

    public String getRate() {
        return this.getChildValue("rate");
    }

    public SimpleStringProperty getRateProperty() {
        return this.getChildProperty("rate");
    }

    public String getNormalRateMultiplier() {
        return this.getChildValue("normalRateMultiplier");
    }

    public SimpleStringProperty getNormalRateMultiplierProperty() {
        return this.getChildProperty("normalRateMultiplier");
    }

    public String getPaymentDeductionType() {
        return this.getChildValue("paymentDeductionType");
    }

    public SimpleStringProperty getPaymentDeductionTypeProperty() {
        return this.getChildProperty("paymentDeductionType");
    }

    public String getApplySuper() {
        return this.getChildValue("applySuper");
    }

    public SimpleStringProperty getApplySuperProperty() {
        return this.getChildProperty("applySuper");
    }

    public String getApplyLeave() {
        return this.getChildValue("applyLeave");
    }

    public SimpleStringProperty getApplyLeaveProperty() {
        return this.getChildProperty("applyLeave");
    }

    public String getCalculationRule() {
        return this.getChildValue("calculationRule");
    }

    public SimpleStringProperty getCalculationRuleProperty() {
        return this.getChildProperty("calculationRule");
    }

    public String getCalculationRuleMethod() {
        return this.getChildValue("calculationRuleMethod");
    }

    public SimpleStringProperty getCalculationRuleMethodProperty() {
        return this.getChildProperty("calculationRuleMethod");
    }

    public String getCalculationProvisionIdentifier() {
        return this.getChildValue("calculationProvisionIdentifier");
    }

    public SimpleStringProperty getCalculationProvisionIdentifierProperty() {
        return this.getChildProperty("calculationProvisionIdentifier");
    }

    public String getCalculationStage() {
        return this.getChildValue("calculationStage");
    }

    public SimpleStringProperty getCalculationStageProperty() {
        return this.getChildProperty("calculationStage");
    }

    public CalculationRule addCalculationRule() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("calculationRule");
        if (glenixElementChildList != null) {
            return (CalculationRule)glenixElementChildList.addChild();
        }
        return null;
    }

    public Document buildDocument() throws Exception {
        Document document = this.docBuilder.newDocument();
        Element xbrlEl = document.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        xbrlEl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        document.appendChild(xbrlEl);
        Element businessEl = document.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = document.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        Element transactionLineEl = document.createElementNS("http://www.glenix.com.au/", "gx:transactionLine");
        transactionEl.appendChild(transactionLineEl);
        this.appendToElement(document, transactionLineEl);
        return document;
    }

    public Document buildDocument(CalculationRule calculationRule) throws Exception {
        if (calculationRule == null) {
            throw new Exception("Error, calc rule is null");
        }
        Document document = this.docBuilder.newDocument();
        Element xbrlEl = document.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        xbrlEl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        document.appendChild(xbrlEl);
        Element businessEl = document.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element transactionEl = document.createElementNS("http://www.glenix.com.au/", "gx:transaction");
        businessEl.appendChild(transactionEl);
        Element transactionLineEl = document.createElementNS("http://www.glenix.com.au/", "gx:transactionLine");
        transactionEl.appendChild(transactionLineEl);
        Element accountEl = document.createElementNS("http://www.glenix.com.au/", "gx:account");
        transactionLineEl.appendChild(accountEl);
        Element accountIdentifierEl = document.createElementNS("http://www.glenix.com.au/", "gx:accountIdentifier");
        accountIdentifierEl.setTextContent(this.getAccountIdentifier());
        accountEl.appendChild(accountIdentifierEl);
        calculationRule.appendToElement(document, accountEl);
        return document;
    }

    public void assignUUIDToAccountIdentifier() throws Exception {
        String accountIdentifier = this.getAccountIdentifier();
        if (accountIdentifier == null || accountIdentifier.isEmpty()) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("accountIdentifier");
            UUID uuid = UUID.randomUUID();
            String uuidString = uuid.toString();
            if (glenixElementChildList != null && glenixElementChildList.getChildCount() > 0) {
                GlenixStringElement gse = (GlenixStringElement)glenixElementChildList.getChild(0);
                gse.setGlenixElementValue(uuidString);
            } else {
                glenixElementChildList.addChild(uuidString);
            }
        }
    }

    @Override
    public void loadDocumentElement(Document doc, Element element) throws Exception {
        super.loadDocumentElement(doc, element);
    }

    @Override
    public void loadDocumentElementOverwrite(Document doc, Element element) throws Exception {
        super.loadDocumentElementOverwrite(doc, element);
    }

    @Override
    public String getGlenixElementKeyId() {
        return this.getAccountIdentifier();
    }

    public void loadFasV2AccountListMeasurable(Document doc, Element element, Business business) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.socialaccounts.com/gl/soc/2011-03-31") && element.getLocalName() != null && element.getLocalName().equals("measurableMaster")) {
            this.setAccountClassificationReference("expense");
            NodeList nodeList2 = element.getChildNodes();
            for (int j = 0; j < nodeList2.getLength(); ++j) {
                GlenixStringElement gse;
                Node node2 = nodeList2.item(j);
                if (node2.getNodeType() != 1) continue;
                Element el2 = (Element)node2;
                if (el2.getLocalName().equals("measurableID")) {
                    gse = (GlenixStringElement)this.getOrAddChild("accountIdentifier");
                    gse.setGlenixElementValue("meas_" + el2.getTextContent());
                    continue;
                }
                if (el2.getLocalName().equals("measurableDescription")) {
                    gse = (GlenixStringElement)this.getOrAddChild("accountName");
                    gse.setGlenixElementValue(el2.getTextContent());
                    continue;
                }
                if (el2.getLocalName().equals("measurableAccountMainID")) {
                    String aC;
                    Transaction acTr;
                    String acId = el2.getTextContent();
                    if (acId == null || acId.isEmpty() || (acTr = business.getAccountTransaction(acId)) == null || (aC = acTr.getAccountClassificationReference()) == null || aC.isEmpty()) continue;
                    GlenixStringElement gse2 = (GlenixStringElement)this.getOrAddChild("accountClassificationReference");
                    gse2.setGlenixElementValue(aC);
                    continue;
                }
                if (el2.getLocalName().equals("measurableActive")) {
                    gse = (GlenixStringElement)this.getOrAddChild("accountActive");
                    if (el2.getTextContent() == null || el2.getTextContent().equals("t")) {
                        gse.setGlenixElementValue("true");
                        continue;
                    }
                    gse.setGlenixElementValue("false");
                    continue;
                }
                if (el2.getLocalName().equals("measurableTaxCode")) {
                    gse = (GlenixStringElement)this.getOrAddChild("defaultProvisionIdentifier");
                    gse.setGlenixElementValue(el2.getTextContent());
                    continue;
                }
                if (el2.getLocalName().equals("measurableCostPerUnit")) {
                    gse = (GlenixStringElement)this.getOrAddChild("rate");
                    gse.setGlenixElementValue(el2.getTextContent());
                    continue;
                }
                if (el2.getLocalName().equals("measurableRateMultiplier")) {
                    gse = (GlenixStringElement)this.getOrAddChild("normalRateMultiplier");
                    gse.setGlenixElementValue(el2.getTextContent());
                    continue;
                }
                if (el2.getLocalName().equals("measurablePaymentType")) {
                    gse = (GlenixStringElement)this.getOrAddChild("paymentDeductionType");
                    gse.setGlenixElementValue(el2.getTextContent());
                    continue;
                }
                if (el2.getLocalName().equals("measurableApplySuper")) {
                    gse = (GlenixStringElement)this.getOrAddChild("applySuper");
                    if (el2.getTextContent() == null || el2.getTextContent().equals("t")) {
                        gse.setGlenixElementValue("true");
                        continue;
                    }
                    gse.setGlenixElementValue("false");
                    continue;
                }
                if (!el2.getLocalName().equals("measurableApplyLeave")) continue;
                gse = (GlenixStringElement)this.getOrAddChild("applyLeave");
                if (el2.getTextContent() == null || el2.getTextContent().equals("t")) {
                    gse.setGlenixElementValue("true");
                    continue;
                }
                gse.setGlenixElementValue("false");
            }
            return;
        }
    }

    public void loadFasV2AccountList(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("account")) {
            NodeList nodeList = element.getChildNodes();
            String accountMainID = null;
            for (int i = 0; i < nodeList.getLength(); ++i) {
                GlenixStringElement gse;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                if (el.getLocalName().equals("accountMainID")) {
                    gse = (GlenixStringElement)this.getOrAddChild("accountIdentifier");
                    accountMainID = el.getTextContent();
                    gse.setGlenixElementValue(accountMainID);
                    continue;
                }
                if (el.getLocalName().equals("accountMainDescription")) {
                    gse = (GlenixStringElement)this.getOrAddChild("accountName");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("mainAccountType")) {
                    gse = (GlenixStringElement)this.getOrAddChild("accountClassificationReference");
                    String value = el.getTextContent();
                    if (value != null && !value.isEmpty()) {
                        if (value.equals("cost-of-goods-sold")) {
                            value = "expense";
                        } else if (value.equals("gain")) {
                            value = "income";
                        } else if (value.equals("loss")) {
                            value = "expense";
                        } else if (value.equals("contr-to-equity")) {
                            value = "distribution";
                        } else if (value.equals("distr-from-equity")) {
                            value = "distribution";
                        } else if (value.equals("comprehensive-income")) {
                            value = "distribution";
                        } else if (value.equals("other")) {
                            value = "distribution";
                        }
                    }
                    gse.setGlenixElementValue(value);
                    continue;
                }
                if (!el.getLocalName().equals("accountActive")) continue;
                if (el.getTextContent() == null || el.getTextContent().equals("t")) {
                    gse = (GlenixStringElement)this.getOrAddChild("accountActive");
                    gse.setGlenixElementValue("true");
                    continue;
                }
                gse = (GlenixStringElement)this.getOrAddChild("accountActive");
                gse.setGlenixElementValue("false");
            }
            if (accountMainID != null && accountMainID.equals("xglsup")) {
                GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("accountClassificationReference");
                gse.setGlenixElementValue("expense");
                gse = (GlenixStringElement)this.getOrAddChild("defaultProvisionIdentifier");
                gse.setGlenixElementValue("xglsup");
            }
            return;
        }
    }

    public void loadFasV2Transactions(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.xbrl.org/int/gl/cor/2010-04-12") && element.getLocalName() != null && element.getLocalName().equals("account")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("accountMainID")) continue;
                GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("accountIdentifier");
                gse.setGlenixElementValue(el.getTextContent());
            }
            return;
        }
    }

    public void loadFasV2TransactionsMeasurable(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.socialaccounts.com/gl/soc/2011-03-31") && element.getLocalName() != null && element.getLocalName().equals("measurableMaster")) {
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Element el;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1 || !(el = (Element)node).getLocalName().equals("measurableID")) continue;
                GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("accountIdentifier");
                gse.setGlenixElementValue("meas_" + el.getTextContent());
            }
            return;
        }
    }

    public void removeMasterFileInformation() {
        for (String key : this.childrenAndMeta.keySet()) {
            if (key.equals("accountIdentifier")) continue;
            ((GlenixElementChildList)this.childrenAndMeta.get(key)).clearChildren();
        }
    }

    public int getCalculationRuleCount() {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("calculationRule");
        if (glenixElementChildList != null) {
            return glenixElementChildList.getChildCount();
        }
        return 0;
    }

    public CalculationRule getCalculationRule(int index) {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("calculationRule");
        if (glenixElementChildList != null) {
            return (CalculationRule)glenixElementChildList.getChild(index);
        }
        return null;
    }

    public AccountCalculationRule getAccountCalculationRule(int index) {
        return new AccountCalculationRule(index);
    }

    public class AccountCalculationRule {
        int index;

        public AccountCalculationRule(int index) {
            this.index = index;
        }

        public Account getAccount() {
            return Account.this;
        }

        public String getAccountName() {
            return Account.this.getAccountName();
        }

        public String getAccountIdentifier() {
            return Account.this.getAccountIdentifier();
        }

        public int getCalculationIndex() {
            return this.index;
        }

        public CalculationRule getCalculationRule() {
            return Account.this.getCalculationRule(this.index);
        }

        public String getCalculationRuleIdentifier() {
            CalculationRule cr = this.getCalculationRule();
            if (cr == null) {
                return null;
            }
            return cr.getCalculationRuleIdentifier();
        }

        public String getCalculationRuleName() {
            CalculationRule cr = this.getCalculationRule();
            if (cr == null) {
                return null;
            }
            return cr.getCalculationRuleName();
        }
    }
}

