/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.GlenixAbstractBranchElementLoadOk;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.TemporalAccessor;
import javafx.beans.property.SimpleStringProperty;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AUSKeyCredential
extends GlenixAbstractBranchElementLoadOk {
    private SimpleStringProperty id = new SimpleStringProperty();
    private SimpleStringProperty credentialType = new SimpleStringProperty();
    private SimpleStringProperty credentialSalt = new SimpleStringProperty();
    private SimpleStringProperty integrityValue = new SimpleStringProperty();
    protected DateTimeFormatter prettyDateFormatter = DateTimeFormatter.ofPattern("dd MMM yyyy");
    private String cachedNotAfterFormatted = null;
    private boolean cachedNotAfterIsValid = false;

    public AUSKeyCredential() throws ParserConfigurationException {
        this.name = "credential";
        this.namespace = "http://auth.abr.gov.au/credential/xsd/SBRCredentialStore";
        this.childrenAndMeta.put("name1", new GlenixElementChildList(GlenixStringElement.class, "http://auth.abr.gov.au/credential/xsd/SBRCredentialStore", "name1", null, null, null, 1, true));
        this.childrenAndMeta.put("name2", new GlenixElementChildList(GlenixStringElement.class, "http://auth.abr.gov.au/credential/xsd/SBRCredentialStore", "name2", null, null, null, 1, true));
        this.childrenAndMeta.put("abn", new GlenixElementChildList(GlenixStringElement.class, "http://auth.abr.gov.au/credential/xsd/SBRCredentialStore", "abn", null, null, null, 1, true));
        this.childrenAndMeta.put("legalName", new GlenixElementChildList(GlenixStringElement.class, "http://auth.abr.gov.au/credential/xsd/SBRCredentialStore", "legalName", null, null, null, 1, true));
        this.childrenAndMeta.put("personId", new GlenixElementChildList(GlenixStringElement.class, "http://auth.abr.gov.au/credential/xsd/SBRCredentialStore", "personId", null, null, null, 1, true));
        this.childrenAndMeta.put("serialNumber", new GlenixElementChildList(GlenixStringElement.class, "http://auth.abr.gov.au/credential/xsd/SBRCredentialStore", "serialNumber", null, null, null, 1, true));
        this.childrenAndMeta.put("creationDate", new GlenixElementChildList(GlenixStringElement.class, "http://auth.abr.gov.au/credential/xsd/SBRCredentialStore", "creationDate", null, null, null, 1, true));
        this.childrenAndMeta.put("notBefore", new GlenixElementChildList(GlenixStringElement.class, "http://auth.abr.gov.au/credential/xsd/SBRCredentialStore", "notBefore", null, null, null, 1, true));
        this.childrenAndMeta.put("notAfter", new GlenixElementChildList(GlenixStringElement.class, "http://auth.abr.gov.au/credential/xsd/SBRCredentialStore", "notAfter", null, null, null, 1, true));
        this.childrenAndMeta.put("sha1fingerprint", new GlenixElementChildList(GlenixStringElement.class, "http://auth.abr.gov.au/credential/xsd/SBRCredentialStore", "sha1fingerprint", null, null, null, 1, true));
        this.childrenAndMeta.put("publicCertificate", new GlenixElementChildList(GlenixStringElement.class, "http://auth.abr.gov.au/credential/xsd/SBRCredentialStore", "publicCertificate", null, null, null, 1, true));
        this.childrenAndMeta.put("protectedPrivateKey", new GlenixElementChildList(GlenixStringElement.class, "http://auth.abr.gov.au/credential/xsd/SBRCredentialStore", "protectedPrivateKey", null, null, null, 1, true));
    }

    private GlenixElement getChild(String childName) {
        if (childName == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return glenixElementChildList.getChild(0);
        }
        return null;
    }

    private String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    public void setChildValue(String childName, String value) throws Exception {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(childName);
        if (glenixStringElement == null) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
            glenixStringElement = (GlenixStringElement)glenixElementChildList.addChild();
        }
        glenixStringElement.setGlenixElementValue(value);
    }

    private boolean notAfterIsValid() {
        if (this.cachedNotAfterFormatted != null) {
            return this.cachedNotAfterIsValid;
        }
        String notAfterStr = this.getChildValue("notAfter");
        if (notAfterStr == null || notAfterStr.isEmpty()) {
            this.cachedNotAfterIsValid = false;
            this.cachedNotAfterFormatted = null;
            return false;
        }
        TemporalAccessor notAfterT = DateTimeFormatter.ISO_DATE_TIME.parse(notAfterStr);
        if (notAfterT == null) {
            this.cachedNotAfterIsValid = false;
            this.cachedNotAfterFormatted = null;
            return false;
        }
        LocalDate notAfter = LocalDate.from(notAfterT);
        LocalDate today = LocalDate.now();
        if (notAfter == null || today == null) {
            this.cachedNotAfterIsValid = false;
            this.cachedNotAfterFormatted = null;
            return false;
        }
        if (notAfter.isBefore(today)) {
            this.cachedNotAfterIsValid = false;
            this.cachedNotAfterFormatted = this.prettyDateFormatter.format(notAfter);
            return false;
        }
        this.cachedNotAfterIsValid = true;
        this.cachedNotAfterFormatted = this.prettyDateFormatter.format(notAfter);
        return true;
    }

    @Override
    public void loadDocumentElement(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals(this.getGlenixElementNamespace()) && element.getLocalName() != null && element.getLocalName().equals(this.getGlenixElementName())) {
            this.id.setValue(element.getAttribute("id"));
            this.credentialType.setValue(element.getAttribute("credentialType"));
            this.credentialSalt.setValue(element.getAttribute("credentialSalt"));
            this.integrityValue.setValue(element.getAttribute("integrityValue"));
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                this.addChildElement(doc, (Element)node);
            }
            this.notAfterIsValid();
            return;
        }
        throw new Exception("Error: attempt to load " + element.getLocalName() + " into " + this.getGlenixElementName());
    }

    public String getId() {
        return this.id.getValue();
    }

    public SimpleStringProperty getCredentialType() {
        return this.credentialType;
    }

    public SimpleStringProperty getCredentialSalt() {
        return this.credentialSalt;
    }

    public SimpleStringProperty getIntegrityValue() {
        return this.integrityValue;
    }

    public String getProtectedPrivateKey() {
        return this.getChildValue("protectedPrivateKey");
    }

    public String getPublicCertificate() {
        return this.getChildValue("publicCertificate");
    }

    public String toString() {
        if (this.notAfterIsValid()) {
            String name = this.getChildValue("name1") + " " + this.getChildValue("name2");
            name = name.trim();
            String abn = this.getChildValue("abn");
            String legalName = this.getChildValue("legalName");
            return name + ", ABN: " + abn + ", legal name: " + legalName + " (id: " + this.id.getValue() + ")";
        }
        String name = this.getChildValue("name1") + " " + this.getChildValue("name2");
        name = name.trim();
        String abn = this.getChildValue("abn");
        String legalName = this.getChildValue("legalName");
        return "Expired: " + this.cachedNotAfterFormatted + ", " + name + ", ABN: " + abn + ", legal name: " + legalName + " (id: " + this.id.getValue() + ")";
    }

    @Override
    public String getGlenixElementKeyId() {
        return this.getId();
    }

    @Override
    public String getGlenixElementKeyValue() {
        return this.getId();
    }
}

