/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.trn;

import au.com.glenix.trn.ASLSBusinessEventItems;
import au.com.glenix.trn.ASLSOverallEventItems;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.EventItems;
import au.com.glenix.trn.GlenixAbstractBranchElement;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.GlenixElementChildList;
import au.com.glenix.trn.GlenixStringElement;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.UUID;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ASLStatement
extends GlenixAbstractBranchElement {
    private DocumentBuilderFactory docFactory;
    private DocumentBuilder docBuilder;

    public ASLStatement() throws ParserConfigurationException {
        this.name = "aslStatement";
        this.namespace = "http://www.glenix.com.au/";
        this.docFactory = DocumentBuilderFactory.newInstance();
        this.docFactory.setNamespaceAware(true);
        this.docBuilder = this.docFactory.newDocumentBuilder();
        this.childrenAndMeta.put("aslStatementIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "aslStatementIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("startDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "startDate", null, null, null, 1, true));
        this.childrenAndMeta.put("endDate", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "endDate", null, null, null, 1, true));
        this.childrenAndMeta.put("SBRDocumentDateTime", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "SBRDocumentDateTime", null, null, null, 1, true));
        this.childrenAndMeta.put("aslsMessageIdentifier", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "aslsMessageIdentifier", null, null, null, 1, true));
        this.childrenAndMeta.put("ASLSOverallEventItems", new GlenixElementChildList(ASLSOverallEventItems.class, "http://www.glenix.com.au/", "ASLSOverallEventItems", null, null, null, 1, false));
        this.childrenAndMeta.put("ASLSBusinessEventItems", new GlenixElementChildList(ASLSBusinessEventItems.class, "http://www.glenix.com.au/", "ASLSBusinessEventItems", null, null, null, 1, false));
        this.childrenAndMeta.put("ActivityStatementNumber", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "ActivityStatementNumber", null, null, null, 1, true));
        this.childrenAndMeta.put("originalActivityStatementNumber", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "originalActivityStatementNumber", null, null, null, 1, true));
        this.childrenAndMeta.put("BusinessDocument.GovernmentGeneratedIdentifier.Text", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "BusinessDocument.GovernmentGeneratedIdentifier.Text", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "BusinessDocument.GovernmentGeneratedIdentifier.Text", "RP", 1, true));
        this.childrenAndMeta.put("Report.Name.Text", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Report.Name.Text", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "Report.Name.Text", "RP", 1, true));
        this.childrenAndMeta.put("Report.TypeVariation.Code", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Report.TypeVariation.Code", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "Report.TypeVariation.Code", "RP", 1, true));
        this.childrenAndMeta.put("PaymentRecord.Due.Date", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "PaymentRecord.Due.Date", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "PaymentRecord.Due.Date", "RP", 1, true));
        this.childrenAndMeta.put("Report.Statement.Revision.Indicator", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Report.Statement.Revision.Indicator", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "Report.Statement.Revision.Indicator", "RP", 1, true));
        this.childrenAndMeta.put("Report.Statement.PeriodSequence.Number", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Report.Statement.PeriodSequence.Number", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "Report.Statement.PeriodSequence.Number", "RP", 1, true));
        this.childrenAndMeta.put("Report.ProcessStatus.Code", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Report.ProcessStatus.Code", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "Report.ProcessStatus.Code", "RP", 1, true));
        this.childrenAndMeta.put("Lodgment.Due.Date", new GlenixElementChildList(GlenixStringElement.class, "http://www.glenix.com.au/", "Lodgment.Due.Date", "http://sbr.gov.au/icls/py/pyin/pyin.02.00.data", "Lodgment.Due.Date", "RP", 1, true));
    }

    private GlenixElement getChild(String childName) {
        if (childName == null) {
            return null;
        }
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get(childName);
        if (glenixElementChildList != null) {
            if (glenixElementChildList.getChildCount() == 0) {
                return null;
            }
            return glenixElementChildList.getChild(0);
        }
        return null;
    }

    private String getChildValue(String fieldName) {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild(fieldName);
        if (glenixStringElement != null) {
            return glenixStringElement.getGlenixElementValue();
        }
        return null;
    }

    @Override
    public String getGlenixElementKeyId() {
        return this.getChildValue("ActivityStatementNumber");
    }

    @Override
    public String getGlenixElementKeyValue() {
        return this.getChildValue("ActivityStatementNumber");
    }

    public void setBusinessDocument_GovernmentGeneratedIdentifier_Text(String value, String isEditable, String isVisible) throws Exception {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild("BusinessDocument.GovernmentGeneratedIdentifier.Text");
        if (glenixStringElement == null) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("BusinessDocument.GovernmentGeneratedIdentifier.Text");
            glenixStringElement = (GlenixStringElement)glenixElementChildList.addChild();
        }
        glenixStringElement.setGlenixElementValue(value);
        glenixStringElement.setGlenixElementIsEditable(isEditable);
        glenixStringElement.setGlenixElementIsVisible(isVisible);
    }

    public void setBusinessDocument_GovernmentGeneratedIdentifier_Text(String value) throws Exception {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild("BusinessDocument.GovernmentGeneratedIdentifier.Text");
        if (glenixStringElement == null) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("BusinessDocument.GovernmentGeneratedIdentifier.Text");
            glenixStringElement = (GlenixStringElement)glenixElementChildList.addChild();
        }
        glenixStringElement.setGlenixElementValue(value);
    }

    public void setReport_Name_Text(String value, String isEditable, String isVisible) throws Exception {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild("Report.Name.Text");
        if (glenixStringElement == null) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("Report.Name.Text");
            glenixStringElement = (GlenixStringElement)glenixElementChildList.addChild();
        }
        glenixStringElement.setGlenixElementValue(value);
        glenixStringElement.setGlenixElementIsEditable(isEditable);
        glenixStringElement.setGlenixElementIsVisible(isVisible);
    }

    public void setReport_TypeVariation_Code(String value, String isEditable, String isVisible) throws Exception {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild("Report.TypeVariation.Code");
        if (glenixStringElement == null) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("Report.TypeVariation.Code");
            glenixStringElement = (GlenixStringElement)glenixElementChildList.addChild();
        }
        glenixStringElement.setGlenixElementValue(value);
        glenixStringElement.setGlenixElementIsEditable(isEditable);
        glenixStringElement.setGlenixElementIsVisible(isVisible);
    }

    public void setPaymentRecord_Due_Date(String value, String isEditable, String isVisible) throws Exception {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild("PaymentRecord.Due.Date");
        if (glenixStringElement == null) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("PaymentRecord.Due.Date");
            glenixStringElement = (GlenixStringElement)glenixElementChildList.addChild();
        }
        glenixStringElement.setGlenixElementValue(value);
        glenixStringElement.setGlenixElementIsEditable(isEditable);
        glenixStringElement.setGlenixElementIsVisible(isVisible);
    }

    public void setPaymentRecord_Due_Date(String value) throws Exception {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild("PaymentRecord.Due.Date");
        if (glenixStringElement == null) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("PaymentRecord.Due.Date");
            glenixStringElement = (GlenixStringElement)glenixElementChildList.addChild();
        }
        glenixStringElement.setGlenixElementValue(value);
    }

    public void setReport_Statement_Revision_Indicator(String value, String isEditable, String isVisible) throws Exception {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild("Report.Statement.Revision.Indicator");
        if (glenixStringElement == null) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("Report.Statement.Revision.Indicator");
            glenixStringElement = (GlenixStringElement)glenixElementChildList.addChild();
        }
        glenixStringElement.setGlenixElementValue(value);
        glenixStringElement.setGlenixElementIsEditable(isEditable);
        glenixStringElement.setGlenixElementIsVisible(isVisible);
    }

    public void setReport_Statement_PeriodSequence_Number(String value, String isEditable, String isVisible) throws Exception {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild("Report.Statement.PeriodSequence.Number");
        if (glenixStringElement == null) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("Report.Statement.PeriodSequence.Number");
            glenixStringElement = (GlenixStringElement)glenixElementChildList.addChild();
        }
        glenixStringElement.setGlenixElementValue(value);
        glenixStringElement.setGlenixElementIsEditable(isEditable);
        glenixStringElement.setGlenixElementIsVisible(isVisible);
    }

    public void setReport_ProcessStatus_Code(String value, String isEditable, String isVisible) throws Exception {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild("Report.ProcessStatus.Code");
        if (glenixStringElement == null) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("Report.ProcessStatus.Code");
            glenixStringElement = (GlenixStringElement)glenixElementChildList.addChild();
        }
        glenixStringElement.setGlenixElementValue(value);
        glenixStringElement.setGlenixElementIsEditable(isEditable);
        glenixStringElement.setGlenixElementIsVisible(isVisible);
    }

    public void setReport_ProcessStatus_Code(String value) throws Exception {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild("Report.ProcessStatus.Code");
        if (glenixStringElement == null) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("Report.ProcessStatus.Code");
            glenixStringElement = (GlenixStringElement)glenixElementChildList.addChild();
        }
        glenixStringElement.setGlenixElementValue(value);
    }

    public void setLodgment_Due_Date(String value, String isEditable, String isVisible) throws Exception {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild("Lodgment.Due.Date");
        if (glenixStringElement == null) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("Lodgment.Due.Date");
            glenixStringElement = (GlenixStringElement)glenixElementChildList.addChild();
        }
        glenixStringElement.setGlenixElementValue(value);
        glenixStringElement.setGlenixElementIsEditable(isEditable);
        glenixStringElement.setGlenixElementIsVisible(isVisible);
    }

    public void setLodgment_Due_Date(String value) throws Exception {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild("Lodgment.Due.Date");
        if (glenixStringElement == null) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("Lodgment.Due.Date");
            glenixStringElement = (GlenixStringElement)glenixElementChildList.addChild();
        }
        glenixStringElement.setGlenixElementValue(value);
    }

    public void setStartDate(String value) throws Exception {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild("startDate");
        if (glenixStringElement == null) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("startDate");
            glenixStringElement = (GlenixStringElement)glenixElementChildList.addChild();
        }
        glenixStringElement.setGlenixElementValue(value);
    }

    public void setEndDate(String value) throws Exception {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getChild("endDate");
        if (glenixStringElement == null) {
            GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("endDate");
            glenixStringElement = (GlenixStringElement)glenixElementChildList.addChild();
        }
        glenixStringElement.setGlenixElementValue(value);
    }

    public String getActivityStatementNumber() {
        return this.getChildValue("ActivityStatementNumber");
    }

    public void setActivityStatementNumber(String value) throws Exception {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getOrAddChild("ActivityStatementNumber");
        if (glenixStringElement == null) {
            throw new Exception("Error, unable to set ActivityStatementNumber");
        }
        glenixStringElement.setGlenixElementValue(value);
    }

    public String getOriginalActivityStatementNumber() {
        return this.getChildValue("originalActivityStatementNumber");
    }

    public void setOriginalActivityStatementNumber(String value) throws Exception {
        GlenixStringElement glenixStringElement = (GlenixStringElement)this.getOrAddChild("originalActivityStatementNumber");
        if (glenixStringElement == null) {
            throw new Exception("Error, unable to set originalActivityStatementNumber");
        }
        glenixStringElement.setGlenixElementValue(value);
    }

    public String getBusinessDocument_GovernmentGeneratedIdentifier_Text() {
        return this.getChildValue("BusinessDocument.GovernmentGeneratedIdentifier.Text");
    }

    public String getReport_Name_Text() {
        return this.getChildValue("Report.Name.Text");
    }

    public String getReport_TypeVariation_Code() {
        return this.getChildValue("Report.TypeVariation.Code");
    }

    public String getPaymentRecord_Due_Date() {
        return this.getChildValue("PaymentRecord.Due.Date");
    }

    public String getReport_Statement_Revision_Indicator() {
        return this.getChildValue("Report.Statement.Revision.Indicator");
    }

    public String getReport_Statement_PeriodSequence_Number() {
        return this.getChildValue("Report.Statement.PeriodSequence.Number");
    }

    public String getReport_ProcessStatus_Code() {
        return this.getChildValue("Report.ProcessStatus.Code");
    }

    public String getLodgment_Due_Date() {
        return this.getChildValue("Lodgment.Due.Date");
    }

    public String getStartDate() {
        return this.getChildValue("startDate");
    }

    public String getEndDate() {
        return this.getChildValue("endDate");
    }

    public LocalDate getStartDateAsDate() {
        String date = this.getChildValue("startDate");
        if (date == null || date.isEmpty()) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public LocalDate getEndDateAsDate() {
        String date = this.getChildValue("endDate");
        if (date == null || date.isEmpty()) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public LocalDate getLodgment_Due_Date_As_Date() {
        String date = this.getChildValue("Lodgment.Due.Date");
        if (date == null || date.isEmpty()) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public LocalDate getPaymentRecord_Due_Date_As_Date() {
        String date = this.getChildValue("PaymentRecord.Due.Date");
        if (date == null || date.isEmpty()) {
            return null;
        }
        try {
            return LocalDate.parse(date, DateTimeFormatter.ISO_LOCAL_DATE);
        }
        catch (Exception e) {
            return null;
        }
    }

    public ActivityStatement buildSkeletonActivityStatement() throws Exception {
        ActivityStatement as = new ActivityStatement();
        return as;
    }

    public void assignNewUUIDToASLStatementIdentifier() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("aslStatementIdentifier");
        UUID uuid = UUID.randomUUID();
        String uuidString = uuid.toString();
        if (glenixElementChildList != null && glenixElementChildList.getChildCount() > 0) {
            GlenixStringElement gse = (GlenixStringElement)glenixElementChildList.getChild(0);
            gse.setGlenixElementValue(uuidString);
        } else {
            glenixElementChildList.addChild(uuidString);
        }
    }

    public void assignUUIDToASLStatementIdentifier() throws Exception {
        String activityStatementNumber = this.getActivityStatementNumber();
        if (activityStatementNumber == null || activityStatementNumber.isEmpty()) {
            this.assignNewUUIDToASLStatementIdentifier();
        }
    }

    @Override
    public void loadDocumentElement(Document doc, Element element) throws Exception {
        super.loadDocumentElement(doc, element);
        this.assignUUIDToASLStatementIdentifier();
    }

    @Override
    public void loadDocumentElementOverwrite(Document doc, Element element) throws Exception {
        super.loadDocumentElementOverwrite(doc, element);
        this.assignUUIDToASLStatementIdentifier();
    }

    public String getSBRDocumentDateTime() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("SBRDocumentDateTime");
        if (gse != null) {
            return gse.getGlenixElementValue();
        }
        return null;
    }

    public void setSBRDocumentDateTime() throws Exception {
        GlenixStringElement gse = (GlenixStringElement)this.getOrAddChild("SBRDocumentDateTime");
        if (gse != null) {
            String timestamp = this.generateTimestamp();
            gse.setGlenixElementValue(timestamp);
        }
    }

    public String getASLSMessageIdentifier() {
        GlenixStringElement gse = (GlenixStringElement)this.getChild("aslsMessageIdentifier");
        if (gse == null) {
            return null;
        }
        return gse.getGlenixElementValue();
    }

    public void generateASLSMessageIdentifier() throws Exception {
        GlenixElementChildList glenixElementChildList = (GlenixElementChildList)this.childrenAndMeta.get("aslsMessageIdentifier");
        String uuidString = this.generateMessageIdentifier();
        if (glenixElementChildList != null && glenixElementChildList.getChildCount() > 0) {
            GlenixStringElement gse = (GlenixStringElement)glenixElementChildList.getChild(0);
            gse.setGlenixElementValue(uuidString);
        } else {
            glenixElementChildList.addChild(uuidString);
        }
    }

    public void loadSBROverallEventMessageDocument(Document doc, Element root) throws Exception {
        this.childrenAndMeta.put("ASLSOverallEventItems", new GlenixElementChildList(ASLSOverallEventItems.class, "http://www.glenix.com.au/", "ASLSOverallEventItems", null, null, null, 1, false));
        EventItems overallEventItems = (EventItems)this.getOrAddChild("ASLSOverallEventItems");
        overallEventItems.loadSBRDocumentRoot(doc, root);
    }

    public void loadSBRBusinessEventMessageDocument(Document doc, Element root) throws Exception {
        this.childrenAndMeta.put("ASLSBusinessEventItems", new GlenixElementChildList(ASLSBusinessEventItems.class, "http://www.glenix.com.au/", "ASLSBusinessEventItems", null, null, null, 1, false));
        EventItems businessEventItems = (EventItems)this.getOrAddChild("ASLSBusinessEventItems");
        businessEventItems.loadSBRDocumentRoot(doc, root);
    }

    public EventItems getOverallEventItems() {
        return (EventItems)this.getChild("ASLSOverallEventItems");
    }

    public EventItems getBusinessEventItems() {
        return (EventItems)this.getChild("ASLSBusinessEventItems");
    }

    public void loadFasV2ActivityStatementList(Document doc, Element element) throws Exception {
        if (element.getNamespaceURI() != null && element.getNamespaceURI().equals("http://www.socialaccounts.com/gl/soc/2011-03-31") && element.getLocalName() != null && element.getLocalName().equals("SBRDocumentAS")) {
            Object asNumber = null;
            NodeList nodeList = element.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                GlenixStringElement gse;
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                if (el.getLocalName().equals("SBRStartDate")) {
                    gse = (GlenixStringElement)this.getOrAddChild("startDate");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("SBREndDate")) {
                    gse = (GlenixStringElement)this.getOrAddChild("endDate");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("SBRDocumentDateTime")) {
                    gse = (GlenixStringElement)this.getOrAddChild("SBRDocumentDateTime");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("SBRDocumentASNumber")) {
                    gse = (GlenixStringElement)this.getOrAddChild("ActivityStatementNumber");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("BusinessDocument.GovernmentGeneratedIdentifier.Text")) {
                    gse = (GlenixStringElement)this.getOrAddChild("BusinessDocument.GovernmentGeneratedIdentifier.Text");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("Report.Name.Text")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Report.Name.Text");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("Report.TypeVariation.Code")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Report.TypeVariation.Code");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("PaymentRecord.Due.Date")) {
                    gse = (GlenixStringElement)this.getOrAddChild("PaymentRecord.Due.Date");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("Report.Statement.Revision.Indicator")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Report.Statement.Revision.Indicator");
                    String val = el.getTextContent();
                    if (val != null && val.equals("f")) {
                        gse.setGlenixElementValue("false");
                        continue;
                    }
                    gse.setGlenixElementValue("true");
                    continue;
                }
                if (el.getLocalName().equals("Report.Statement.PeriodSequence.Number")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Report.Statement.PeriodSequence.Number");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (el.getLocalName().equals("Report.ProcessStatus.Code")) {
                    gse = (GlenixStringElement)this.getOrAddChild("Report.ProcessStatus.Code");
                    gse.setGlenixElementValue(el.getTextContent());
                    continue;
                }
                if (!el.getLocalName().equals("Lodgment.Due.Date")) continue;
                gse = (GlenixStringElement)this.getOrAddChild("Lodgment.Due.Date");
                gse.setGlenixElementValue(el.getTextContent());
            }
            return;
        }
    }

    public Document buildDocument() throws Exception {
        Document document = this.docBuilder.newDocument();
        Element xbrlEl = document.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        xbrlEl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        document.appendChild(xbrlEl);
        Element businessEl = document.createElementNS("http://www.glenix.com.au/", "gx:business");
        xbrlEl.appendChild(businessEl);
        Element activityStatementListEl = document.createElementNS("http://www.glenix.com.au/", "gx:activityStatementList");
        businessEl.appendChild(activityStatementListEl);
        Element activityStatementListResponseEl = document.createElementNS("http://www.glenix.com.au/", "gx:activityStatementListResponse");
        activityStatementListEl.appendChild(activityStatementListResponseEl);
        this.appendToElement(document, activityStatementListResponseEl);
        return document;
    }

    public Document buildDocumentBusiness() throws Exception {
        Document document = this.docBuilder.newDocument();
        Element businessEl = document.createElementNS("http://www.glenix.com.au/", "gx:business");
        businessEl.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        document.appendChild(businessEl);
        Element activityStatementListEl = document.createElementNS("http://www.glenix.com.au/", "gx:activityStatementList");
        businessEl.appendChild(activityStatementListEl);
        Element activityStatementListResponseEl = document.createElementNS("http://www.glenix.com.au/", "gx:activityStatementListResponse");
        activityStatementListEl.appendChild(activityStatementListResponseEl);
        this.appendToElement(document, activityStatementListResponseEl);
        return document;
    }
}

