/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.tr2019;

import au.com.glenix.tr2018.GlenixLabelCarCalculationMethodCodeCombo;
import au.com.glenix.widget.GlenixLabelTwoDecimalPositiveAmountTR;
import au.com.glenix.widget.GlenixLabelTwoDecimalPositiveNumber;
import au.com.glenix.widget.GlenixLabelZeroDecimalPositiveNumber;
import au.com.glenix.widget.GlenixTitledPaneController;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.util.Pair;

public class TaxReturnDDCTNS0001EducationController
extends GlenixTitledPaneController {
    @FXML
    private Button deleteButton;
    protected ChangeListener<String> changeListener = null;
    protected EventHandler<ActionEvent> deleteListener = null;
    private NumberFormat format2dp = new DecimalFormat("#0.00");
    @FXML
    protected GlenixLabelCarCalculationMethodCodeCombo IncomeTax_Deduction_CarCalculationMethod_Code;
    @FXML
    protected GlenixLabelZeroDecimalPositiveNumber IncomeTax_Deduction_CarBusinessKilometres_Number;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_Deduction_CarCentsPerKmClaimable_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveNumber IncomeTax_Deduction_CarLogBookMethodBusinessUseRecorded_Percent;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_Deduction_CarLogBookMethod_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_Deduction_CarLogBookMethodDepreciation_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_Deduction_CarLogBookMethodClaimable_Amount;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        if (this.IncomeTax_Deduction_CarCalculationMethod_Code != null) {
            this.IncomeTax_Deduction_CarCalculationMethod_Code.setSingleComboChangeListener(new ChangeListener<Pair<String, String>>(){

                public void changed(ObservableValue<? extends Pair<String, String>> observable, Pair<String, String> oldValue, Pair<String, String> newValue) {
                    TaxReturnDDCTNS0001EducationController.this.setMethod();
                }
            });
        }
        if (this.IncomeTax_Deduction_CarBusinessKilometres_Number != null) {
            this.IncomeTax_Deduction_CarBusinessKilometres_Number.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    TaxReturnDDCTNS0001EducationController.this.calculateCentsPerKmAmount();
                }
            });
        }
        if (this.IncomeTax_Deduction_CarLogBookMethodBusinessUseRecorded_Percent != null) {
            this.IncomeTax_Deduction_CarLogBookMethodBusinessUseRecorded_Percent.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    TaxReturnDDCTNS0001EducationController.this.calculateLogBookAmount();
                }
            });
        }
        if (this.IncomeTax_Deduction_CarLogBookMethod_Amount != null) {
            this.IncomeTax_Deduction_CarLogBookMethod_Amount.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    TaxReturnDDCTNS0001EducationController.this.calculateLogBookAmount();
                }
            });
        }
        if (this.IncomeTax_Deduction_CarLogBookMethodDepreciation_Amount != null) {
            this.IncomeTax_Deduction_CarLogBookMethodDepreciation_Amount.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    TaxReturnDDCTNS0001EducationController.this.calculateLogBookAmount();
                }
            });
        }
    }

    public void setSingleChangeListener(ChangeListener<String> changeListener) {
        this.changeListener = changeListener;
    }

    public void addDeleteListener(EventHandler<ActionEvent> deleteListener) {
        this.deleteButton.addEventHandler(ActionEvent.ACTION, deleteListener);
    }

    public Double addDouble(Double d1, Double d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return d1 + d2;
    }

    protected void calculateCentsPerKmAmount() {
        Double d = this.IncomeTax_Deduction_CarBusinessKilometres_Number.getDouble();
        if (d != null) {
            this.IncomeTax_Deduction_CarCentsPerKmClaimable_Amount.setGlenixElementValue(this.format2dp.format(d * 0.68));
        } else {
            this.IncomeTax_Deduction_CarCentsPerKmClaimable_Amount.setGlenixElementValue(null);
        }
    }

    protected void calculateLogBookAmount() {
        Double d = this.IncomeTax_Deduction_CarLogBookMethodBusinessUseRecorded_Percent.getDouble();
        if (d != null) {
            Double total = this.IncomeTax_Deduction_CarLogBookMethod_Amount.getDouble();
            if ((total = this.addDouble(total, this.IncomeTax_Deduction_CarLogBookMethodDepreciation_Amount.getDouble())) == null) {
                this.IncomeTax_Deduction_CarLogBookMethodClaimable_Amount.setGlenixElementValue(null);
            } else {
                this.IncomeTax_Deduction_CarLogBookMethodClaimable_Amount.setGlenixElementValue(this.format2dp.format(d * total / 100.0));
            }
        } else {
            this.IncomeTax_Deduction_CarLogBookMethodClaimable_Amount.setGlenixElementValue(null);
        }
    }

    protected void setMethod() {
        String method = this.IncomeTax_Deduction_CarCalculationMethod_Code.getGlenixElementValue();
        if (method != null && !method.isEmpty()) {
            if (method.equals("Cents per kilometre")) {
                this.IncomeTax_Deduction_CarLogBookMethodBusinessUseRecorded_Percent.setGlenixElementValue(null);
                this.IncomeTax_Deduction_CarLogBookMethod_Amount.setGlenixElementValue(null);
                this.IncomeTax_Deduction_CarLogBookMethodDepreciation_Amount.setGlenixElementValue(null);
                this.IncomeTax_Deduction_CarLogBookMethodClaimable_Amount.setGlenixElementValue(null);
                this.calculateCentsPerKmAmount();
            } else if (method.equals("Logbook")) {
                this.IncomeTax_Deduction_CarBusinessKilometres_Number.setGlenixElementValue(null);
                this.IncomeTax_Deduction_CarCentsPerKmClaimable_Amount.setGlenixElementValue(null);
                this.calculateLogBookAmount();
            }
        }
    }
}

