/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.tr2018;

import au.com.glenix.tr2018.TaxReturnWRE0003CarVBox;
import au.com.glenix.tr2018.TaxReturnWRE0003ClothingVBox;
import au.com.glenix.tr2018.TaxReturnWRE0003EducationVBox;
import au.com.glenix.tr2018.TaxReturnWRE0003OtherVBox;
import au.com.glenix.tr2018.TaxReturnWRE0003TravelVBox;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.Profile;
import au.com.glenix.trn.WRE0003;
import au.com.glenix.widget.ErrorDisplay;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixLabelZeroDecimalPositiveNumber;
import au.com.glenix.widget.GlenixNCVBox;
import au.com.glenix.widget.GlenixVBox;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TaxReturnWRE0003Controller
extends GlenixBranchController {
    private DocumentBuilder dBuilder;
    private WRE0003 wre0003;
    private NumberFormat format2dp = new DecimalFormat("#0.00");
    @FXML
    private GlenixVBox wre0003VBox;
    @FXML
    private VBox wre0003carvbox;
    @FXML
    private VBox wre0003travelvbox;
    @FXML
    private VBox wre0003clothingvbox;
    @FXML
    private VBox wre0003educationvbox;
    @FXML
    private VBox wre0003othervbox;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber IncomeTax_Deduction_EducationReduction_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber IncomeTax_Deduction_EducationNet_Amount;
    @FXML
    private GlenixLabelLabel Identifiers_TaxFileNumber_Identifier;
    private ErrorDisplay errorDisplay;

    public TaxReturnWRE0003Controller(ErrorDisplay errorDisplay) {
        this.errorDisplay = errorDisplay;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
        }
        this.updateNetEducationInit();
    }

    public void setModel(WRE0003 wre0003) throws Exception {
        Document doc;
        GlenixNCVBox sw;
        List<GlenixElement> ges;
        Document doc2;
        this.wre0003 = wre0003;
        this.clearGlenixXBRL();
        if (wre0003 != null && (doc2 = wre0003.buildDocument()) != null) {
            this.loadGlenixXBRL(doc2, doc2.getDocumentElement());
        }
        this.wre0003carvbox.getChildren().clear();
        if (wre0003 != null) {
            ges = wre0003.getChildElementSet("wre0003Car");
            for (GlenixElement ge : ges) {
                sw = this.addCar();
                doc = this.dBuilder.newDocument();
                ge.appendToElement(doc);
                sw.getGlenixController().loadGlenixXBRL(doc, doc.getDocumentElement());
            }
        }
        this.wre0003travelvbox.getChildren().clear();
        if (wre0003 != null) {
            ges = wre0003.getChildElementSet("wre0003Travel");
            for (GlenixElement ge : ges) {
                sw = this.addTravel();
                doc = this.dBuilder.newDocument();
                ge.appendToElement(doc);
                sw.getGlenixController().loadGlenixXBRL(doc, doc.getDocumentElement());
            }
        }
        this.wre0003clothingvbox.getChildren().clear();
        if (wre0003 != null) {
            ges = wre0003.getChildElementSet("wre0003Clothing");
            for (GlenixElement ge : ges) {
                sw = this.addClothing();
                doc = this.dBuilder.newDocument();
                ge.appendToElement(doc);
                sw.getGlenixController().loadGlenixXBRL(doc, doc.getDocumentElement());
            }
        }
        this.wre0003educationvbox.getChildren().clear();
        if (wre0003 != null) {
            ges = wre0003.getChildElementSet("wre0003Education");
            for (GlenixElement ge : ges) {
                sw = this.addEducation();
                doc = this.dBuilder.newDocument();
                ge.appendToElement(doc);
                ((TaxReturnWRE0003EducationVBox)sw).getGlenixController().loadGlenixXBRL(doc, doc.getDocumentElement());
            }
        }
        this.wre0003othervbox.getChildren().clear();
        if (wre0003 != null) {
            ges = wre0003.getChildElementSet("wre0003Other");
            for (GlenixElement ge : ges) {
                sw = this.addOther();
                doc = this.dBuilder.newDocument();
                ge.appendToElement(doc);
                sw.getGlenixController().loadGlenixXBRL(doc, doc.getDocumentElement());
            }
        }
    }

    private Double getDouble(GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    private Double addDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return result;
        }
        return d + result;
    }

    private Double subtractDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return -result.doubleValue();
        }
        return d - result;
    }

    private Double addDouble(Double d, Double dd) {
        if (dd == null) {
            return d;
        }
        if (d == null) {
            return dd;
        }
        return d + dd;
    }

    @FXML
    private TaxReturnWRE0003CarVBox addCar() {
        try {
            final TaxReturnWRE0003CarVBox sw = new TaxReturnWRE0003CarVBox();
            sw.getGlenixController().initialize(null, null);
            this.wre0003carvbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete car expense");
            this.wre0003carvbox.getChildren().add((Object)b);
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnWRE0003Controller.this.wre0003carvbox.getChildren().remove((Object)sw);
                    TaxReturnWRE0003Controller.this.wre0003carvbox.getChildren().remove((Object)b);
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    private TaxReturnWRE0003TravelVBox addTravel() {
        try {
            final TaxReturnWRE0003TravelVBox sw = new TaxReturnWRE0003TravelVBox();
            sw.getGlenixController().initialize(null, null);
            this.wre0003travelvbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete travel expense");
            this.wre0003travelvbox.getChildren().add((Object)b);
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnWRE0003Controller.this.wre0003travelvbox.getChildren().remove((Object)sw);
                    TaxReturnWRE0003Controller.this.wre0003travelvbox.getChildren().remove((Object)b);
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    private TaxReturnWRE0003ClothingVBox addClothing() {
        try {
            final TaxReturnWRE0003ClothingVBox sw = new TaxReturnWRE0003ClothingVBox();
            sw.getGlenixController().initialize(null, null);
            this.wre0003clothingvbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete uniform expense");
            this.wre0003clothingvbox.getChildren().add((Object)b);
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnWRE0003Controller.this.wre0003clothingvbox.getChildren().remove((Object)sw);
                    TaxReturnWRE0003Controller.this.wre0003clothingvbox.getChildren().remove((Object)b);
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    private TaxReturnWRE0003EducationVBox addEducation() {
        try {
            final TaxReturnWRE0003EducationVBox sw = new TaxReturnWRE0003EducationVBox();
            sw.getGlenixController().initialize(null, null);
            this.wre0003educationvbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete education expense");
            this.wre0003educationvbox.getChildren().add((Object)b);
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnWRE0003Controller.this.wre0003educationvbox.getChildren().remove((Object)sw);
                    TaxReturnWRE0003Controller.this.wre0003educationvbox.getChildren().remove((Object)b);
                    TaxReturnWRE0003Controller.this.updateNetEducation();
                }
            });
            sw.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    TaxReturnWRE0003Controller.this.updateNetEducation();
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    private TaxReturnWRE0003OtherVBox addOther() {
        try {
            final TaxReturnWRE0003OtherVBox sw = new TaxReturnWRE0003OtherVBox();
            sw.getGlenixController().initialize(null, null);
            this.wre0003othervbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete other expense");
            this.wre0003othervbox.getChildren().add((Object)b);
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnWRE0003Controller.this.wre0003othervbox.getChildren().remove((Object)sw);
                    TaxReturnWRE0003Controller.this.wre0003othervbox.getChildren().remove((Object)b);
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    public void setBusinessDetails(BusinessMasterFile businessMasterFile) {
        if (businessMasterFile != null) {
            this.Identifiers_TaxFileNumber_Identifier.setGlenixElementValue(businessMasterFile.getBusinessTFN());
        }
    }

    public void setProfileDetails(Profile profileXBRL) {
    }

    public void updateNetEducationInit() {
        this.IncomeTax_Deduction_EducationReduction_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNetEducation()));
    }

    public void updateNetEducation() {
        Double total = null;
        for (Node n : this.wre0003educationvbox.getChildren()) {
            if (!(n instanceof TaxReturnWRE0003EducationVBox)) continue;
            total = this.addDouble(total, ((TaxReturnWRE0003EducationVBox)n).getGross());
        }
        if ((total = this.subtractDouble(total, this.IncomeTax_Deduction_EducationReduction_Amount)) == null) {
            this.IncomeTax_Deduction_EducationNet_Amount.setGlenixElementValue(null);
        } else {
            this.IncomeTax_Deduction_EducationNet_Amount.setGlenixElementValue("" + total.intValue());
        }
    }
}

