/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.tr2018;

import au.com.glenix.tr2018.GlenixLabelCGTCodeCombo;
import au.com.glenix.tr2018.GlenixLabelCountryLabel;
import au.com.glenix.tr2018.GlenixLabelServiceLineCodeCombo;
import au.com.glenix.tr2018.TaxReturnTRT0007INBWithholdingPaymentDetailsVBox;
import au.com.glenix.tr2018.TaxReturnTRT0007OtherDeductionVBox;
import au.com.glenix.tr2018.TaxReturnTRT0007OtherIncomeVBox;
import au.com.glenix.tr2018.TaxReturnTRT0007SISWithholdingPaymentDetailsVBox;
import au.com.glenix.tr2018.TaxReturnTRT0007StatementOfDistributionVBox;
import au.com.glenix.trn.AgentDetails;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.Profile;
import au.com.glenix.trn.ProfileElectronicContact;
import au.com.glenix.trn.TFND0004AddressDetailsBusiness;
import au.com.glenix.trn.TRT0007;
import au.com.glenix.widget.ErrorDisplay;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixFlowPane;
import au.com.glenix.widget.GlenixLabelAbstractPane;
import au.com.glenix.widget.GlenixLabelCheckbox;
import au.com.glenix.widget.GlenixLabelDate;
import au.com.glenix.widget.GlenixLabelDateTimeLabel;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelOnly;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixLabelZeroDecimalAmountTR;
import au.com.glenix.widget.GlenixLabelZeroDecimalPositiveAmountTR;
import au.com.glenix.widget.GlenixNCVBox;
import au.com.glenix.widget.GlenixPane;
import au.com.glenix.widget.GlenixVBox;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TitledPane;
import javafx.scene.layout.VBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TaxReturnTRT0007Controller
extends GlenixBranchController {
    private DocumentBuilder dBuilder;
    private TRT0007 trt0007;
    private NumberFormat format2dp = new DecimalFormat("#0.00");
    @FXML
    private GlenixLabelDateTimeLabel SBRDocumentDateTime;
    @FXML
    private GlenixVBox trt0007VBox;
    @FXML
    private GlenixLabelLabel Identifiers_TaxAgentNumber_Identifier;
    @FXML
    private GlenixLabelLabel Identifiers_AustralianBusinessNumber_Identifier_INT;
    @FXML
    private GlenixLabelLabel Identifiers_TaxFileNumber_Identifier;
    private ErrorDisplay errorDisplay;
    @FXML
    private TitledPane capall;
    @FXML
    private TitledPane capalltwo;
    @FXML
    private TitledPane nra;
    @FXML
    private TitledPane orto;
    @FXML
    private TitledPane onrto;
    @FXML
    private TitledPane medi;
    @FXML
    private GlenixLabelLabel Identifiers_AustralianBusinessNumber_Identifier;
    @FXML
    private GlenixLabelLabel OrganisationNameDetails_OrganisationalName_Text;
    @FXML
    private GlenixLabelLabel AddressDetails_Line1_Text_BUS;
    @FXML
    private GlenixLabelLabel AddressDetails_Line2_Text_BUS;
    @FXML
    private GlenixLabelLabel AddressDetails_LocalityName_Text_BUS;
    @FXML
    private GlenixLabelLabel AddressDetails_StateOrTerritory_Code_BUS;
    @FXML
    private GlenixLabelLabel AddressDetails_Postcode_Text_BUS;
    @FXML
    private GlenixLabelCountryLabel AddressDetails_Country_Code_BUS;
    @FXML
    private GlenixLabelLabel AddressDetails_Line1_Text;
    @FXML
    private GlenixLabelLabel AddressDetails_Line2_Text;
    @FXML
    private GlenixLabelLabel AddressDetails_LocalityName_Text;
    @FXML
    private GlenixLabelLabel AddressDetails_StateOrTerritory_Code;
    @FXML
    private GlenixLabelLabel AddressDetails_Postcode_Text;
    @FXML
    private GlenixLabelCountryLabel AddressDetails_Country_Code;
    @FXML
    private GlenixLabelLabel agentIntPersonUnstructuredName_FullName_Text;
    @FXML
    private GlenixLabelServiceLineCodeCombo agentElectronicContact_Telephone_ServiceLine_Code;
    @FXML
    private GlenixLabelLabel agentElectronicContact_Telephone_Area_Code;
    @FXML
    private GlenixLabelLabel agentElectronicContact_Telephone_Minimal_Number;
    @FXML
    private GlenixFlowPane intermediarysection;
    @FXML
    private GlenixLabelCheckbox agentDeclaration_StatementAccepted_Indicator;
    @FXML
    private GlenixLabelText agentDeclaration_SignatoryIdentifier_Text;
    @FXML
    private GlenixLabelDate agentDeclaration_Signature_Date;
    @FXML
    private GlenixLabelOnly Declaration_Statement_Text;
    @FXML
    private GlenixLabelCheckbox Declaration_StatementAccepted_Indicator;
    @FXML
    private GlenixLabelDate Declaration_Signature_Date;
    @FXML
    private GlenixLabelText Declaration_SignatoryIdentifier_Text;
    @FXML
    private VBox statementofdistributionvbox;
    @FXML
    private VBox exemptionorrollovervbox;
    @FXML
    private VBox otherdeductionsvbox;
    @FXML
    private GlenixFlowPane mainsectionflowpane;
    @FXML
    private VBox otherincomevbox;
    private int inbwithholdingcount = 0;
    @FXML
    private VBox inbwithholdingvbox;
    private int siswithholdingcount = 0;
    @FXML
    private VBox siswithholdingvbox;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Remuneration_ABNNotQuotedPaymentGross_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Remuneration_PaymentToForeignResidentGross_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR GovernmentFunding_GovernmentIndustryPaymentsAssessable_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalAmountTR Income_Other_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalAmountTR TotalBusinessIncome_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Remuneration_ABNNotQuotedPaymentGross_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR GovernmentFunding_GovernmentIndustryPaymentsAssessable_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalAmountTR Income_Other_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalAmountTR TotalBusinessIncome_Prim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_ForeignResidentWithholding_Amount_JAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Remuneration_WagesAndSalaries_PaymentsContractorAndConsultant_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR SuperannuationContribution_EmployerContributions_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_Operating_BadDebts_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_Operating_LeaseTotal_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_Operating_Rent_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_Operating_Interest_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_Royalties_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_DepreciationandAmortisation_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_Operating_MotorVehicle_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_Operating_RepairsAndMaintenance_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_DeductibleOtherTotal_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalAmountTR Expense_Operating_CostOfSales_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalAmountTR TotalBusinessExpenses_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Remuneration_WagesAndSalaries_PaymentsContractorAndConsultant_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR SuperannuationContribution_EmployerContributions_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_Operating_BadDebts_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_Operating_LeaseTotal_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_Operating_Rent_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_Operating_Interest_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_Royalties_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_DepreciationandAmortisation_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_Operating_MotorVehicle_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_Operating_RepairsAndMaintenance_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_DeductibleOtherTotal_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalAmountTR Expense_Operating_CostOfSales_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalAmountTR TotalBusinessExpenses_Prim;
    @FXML
    private GlenixLabelZeroDecimalAmountTR Income_ReconciliationAdjustmentTotal_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalAmountTR Expense_ReconciliationAdjustmentTotal_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalAmountTR Income_Net_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalAmountTR Income_ReconciliationAdjustmentTotal_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalAmountTR Expense_ReconciliationAdjustmentTotal_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalAmountTR Income_Net_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalAmountTR Income_PartnershipDistributionGross_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Income_TrustShareNet_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_DistributionDeductionsOther_Amount_JAUS_Prim;
    @FXML
    private GlenixLabelZeroDecimalAmountTR NetPrimaryProductionAmount;
    @FXML
    private GlenixLabelZeroDecimalAmountTR Income_PartnershipDistributionLessForeignIncome_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Income_TrustShareNetExcludeNetCapitalGainsAndForeignIncomeAndDistributionFranked_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_DistributionDeductionsOther_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Income_TrustDistributionFranked_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR IncomeTax_Deduction_TrustDistributionFranked_Amount_JAUS_NonPrim;
    @FXML
    private GlenixLabelZeroDecimalAmountTR NetNonPrimaryProductionAmount;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Income_Operating_RentalIncomeGross_Amount_JAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_Interest_Amount_JAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_CapitalWorksDeduction_Amount_JAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR IncomeTax_Deduction_RentalIncomeDeductionsOtherThanInterestAndCapitalWorks_Amount_JAUS;
    @FXML
    private GlenixLabelZeroDecimalAmountTR NetRent;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Income_ForestryManagedInvestmentScheme_Amount_JAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Income_Interest_Gross_Amount_JAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Income_DividendsUnfranked_Amount_JAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Income_DividendsFranked_Amount_JAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR IncomeTax_FrankingCredits_Amount_JAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR SuperannuationBenefit_DeathBenefitLumpSumPaymentTaxedElement_Amount_ND;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR SuperannuationBenefit_DeathBenefitLumpSumPaymentUntaxedElement_Amount_ND;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR SuperannuationBenefit_DeathBenefitEmploymentTerminationPaymentTaxableComponent_Amount_ETPD;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR SuperannuationBenefit_DeathBenefitEmploymentTerminationPaymentTaxableComponent_Amount_ETPND;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Remuneration_BonusesAndAllowances_Amount_JAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Pension_Total_Amount_JAUS;
    @FXML
    private GlenixLabelZeroDecimalAmountTR TotalAustralianIncome;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_AustralianInvestmentAllowableDeduction_Amount_JAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR IncomeTax_Deduction_DistributionFranked_Amount_JAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Expense_ForestryManagedInvestmentSchemeDeduction_Amount_JAUS;
    @FXML
    private GlenixLabelZeroDecimalAmountTR Income_Net_Amount_JAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Income_CapitalGainsNet_Amount_RP;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR Income_InternationalDealings_Attributed_Amount_JFOREIGN_CFCLC;
    @FXML
    private GlenixLabelZeroDecimalAmountTR Income_Net_Amount_JFOREIGN;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR IncomeTax_FrankingCredits_ReceivedFromNewZealandCompanies_Amount_JFOREIGN;
    @FXML
    private GlenixLabelZeroDecimalPositiveAmountTR IncomeTax_Deduction_TaxLossesDeducted_Amount_RP;
    @FXML
    private GlenixLabelZeroDecimalAmountTR TotalNetIncome;
    @FXML
    private GlenixLabelLabel Report_TargetFinancial_Year;
    private String type;
    private String status;
    private String year;
    private LocalDate startDate;
    private LocalDate endDate;

    public TaxReturnTRT0007Controller(ErrorDisplay errorDisplay) {
        this.errorDisplay = errorDisplay;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
        }
        this.updateBusinessIncomeNonPrimInit();
        this.updateBusinessIncomePrimInit();
        this.updateBusinessExpensesNonPrimInit();
        this.updateBusinessExpensesPrimInit();
        this.updateBusinessNetIncomeNonPrimInit();
        this.updateBusinessNetIncomePrimInit();
        this.updateNetPrimaryProductionAmountInit();
        this.updateNetNonPrimaryProductionAmountInit();
        this.updateNetRentInit();
        this.updateTotalAustralianIncomeInit();
        this.updateNetAustralianIncomeExCGInit();
        this.updateTotalNetIncomeInit();
        this.agentDeclaration_StatementAccepted_Indicator.setSingleChangeListener(new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null && !newValue.isEmpty()) {
                    TaxReturnTRT0007Controller.this.agentDeclaration_Signature_Date.setLocalDate(LocalDate.now());
                }
            }
        });
        this.Declaration_StatementAccepted_Indicator.setSingleChangeListener(new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null && !newValue.isEmpty()) {
                    TaxReturnTRT0007Controller.this.Declaration_Signature_Date.setLocalDate(LocalDate.now());
                }
            }
        });
    }

    public void setModel(TRT0007 trt0007) throws Exception {
        String taabn;
        Document doc;
        this.trt0007 = trt0007;
        this.clearGlenixXBRL();
        if (trt0007 != null && (doc = trt0007.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
        this.inbwithholdingcount = 0;
        this.siswithholdingcount = 0;
        ArrayList<Node> remove = new ArrayList<Node>();
        for (Node n : this.mainsectionflowpane.getChildren()) {
            if (n instanceof TaxReturnTRT0007OtherIncomeVBox) {
                remove.add(n);
            }
            if (n instanceof TaxReturnTRT0007INBWithholdingPaymentDetailsVBox) {
                remove.add(n);
            }
            if (n instanceof TaxReturnTRT0007SISWithholdingPaymentDetailsVBox) {
                remove.add(n);
            }
            if (!(n instanceof TaxReturnTRT0007OtherDeductionVBox)) continue;
            remove.add(n);
        }
        this.mainsectionflowpane.getChildren().removeAll(remove);
        this.exemptionorrollovervbox.getChildren().clear();
        this.statementofdistributionvbox.getChildren().clear();
        if (trt0007 != null) {
            Document doc2;
            GlenixPane sw;
            List<GlenixElement> ges = trt0007.getChildElementSet("OtherAustralianIncome");
            for (GlenixElement ge : ges) {
                sw = this.addOtherIncome();
                doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                ((TaxReturnTRT0007OtherIncomeVBox)sw).getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
            ges = trt0007.getChildElementSet("IndividualNonBusinessWithholdingPaymentDetails");
            for (GlenixElement ge : ges) {
                sw = this.addINBWithholding();
                doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                ((TaxReturnTRT0007INBWithholdingPaymentDetailsVBox)sw).getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
            ges = trt0007.getChildElementSet("SuperannuationIncomeStreamWithholdingPaymentDetails");
            for (GlenixElement ge : ges) {
                sw = this.addSISWithholding();
                doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                ((TaxReturnTRT0007SISWithholdingPaymentDetailsVBox)sw).getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
            ges = trt0007.getChildElementSet("OtherDeductions");
            for (GlenixElement ge : ges) {
                sw = this.addOtherDeduction();
                doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                ((TaxReturnTRT0007OtherDeductionVBox)sw).getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
            ges = trt0007.getChildElementSet("CapitalGainsTax.ExemptionOrRolloverApplied.Code");
            for (GlenixElement ge : ges) {
                sw = this.addExemptionOrRollover();
                doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                ((GlenixLabelAbstractPane)sw).getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
            ges = trt0007.getChildElementSet("StatementOfDistributionToBeneficiary");
            for (GlenixElement ge : ges) {
                sw = this.addStatementOfDistribution();
                doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                ((GlenixNCVBox)sw).getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
        }
        if ((taabn = this.Identifiers_AustralianBusinessNumber_Identifier_INT.getGlenixElementValue()) != null && !taabn.isEmpty()) {
            this.intermediarysection.setVisible(true);
            this.intermediarysection.setManaged(true);
        } else {
            this.intermediarysection.setVisible(false);
            this.intermediarysection.setManaged(false);
        }
        this.capall.expandedProperty().setValue(Boolean.valueOf(false));
        this.capalltwo.expandedProperty().setValue(Boolean.valueOf(false));
        this.nra.expandedProperty().setValue(Boolean.valueOf(false));
        this.orto.expandedProperty().setValue(Boolean.valueOf(false));
        this.onrto.expandedProperty().setValue(Boolean.valueOf(false));
        this.medi.expandedProperty().setValue(Boolean.valueOf(false));
        this.expandTitlePanes();
    }

    private Double getDouble(GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    private Double addDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return result;
        }
        return d + result;
    }

    private Double subtractDouble(Double d, Double d2) {
        Double result = d2;
        if (result == null) {
            return d;
        }
        if (d == null) {
            return -d2.doubleValue();
        }
        return d - d2;
    }

    private Double addDouble(GlenixLabelText glt1, GlenixLabelText glt2) {
        Double glt1d = glt1.getDouble();
        if (glt1d == null) {
            return glt2.getDouble();
        }
        Double glt2d = glt2.getDouble();
        if (glt2d == null) {
            return glt1d;
        }
        return glt1d + glt2d;
    }

    private Double subtractDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return -result.doubleValue();
        }
        return d - result;
    }

    private Double addDouble(Double d, Double dd) {
        if (dd == null) {
            return d;
        }
        if (d == null) {
            return dd;
        }
        return d + dd;
    }

    public void setBusinessDetails(BusinessMasterFile businessMasterFile) {
        if (businessMasterFile == null) {
            this.Identifiers_AustralianBusinessNumber_Identifier.setText(null);
            this.Identifiers_TaxFileNumber_Identifier.setText(null);
            this.OrganisationNameDetails_OrganisationalName_Text.setText(null);
            this.AddressDetails_Line1_Text_BUS.setText(null);
            this.AddressDetails_Line2_Text_BUS.setText(null);
            this.AddressDetails_LocalityName_Text_BUS.setText(null);
            this.AddressDetails_StateOrTerritory_Code_BUS.setText(null);
            this.AddressDetails_Postcode_Text_BUS.setText(null);
            this.AddressDetails_Country_Code_BUS.setGlenixElementValue(null);
            this.AddressDetails_Line1_Text.setText(null);
            this.AddressDetails_Line2_Text.setText(null);
            this.AddressDetails_LocalityName_Text.setText(null);
            this.AddressDetails_StateOrTerritory_Code.setText(null);
            this.AddressDetails_Postcode_Text.setText(null);
            this.AddressDetails_Country_Code.setGlenixElementValue(null);
        } else {
            this.Identifiers_AustralianBusinessNumber_Identifier.setText(businessMasterFile.getBusinessABN());
            this.Identifiers_TaxFileNumber_Identifier.setText(businessMasterFile.getBusinessTFN());
            this.OrganisationNameDetails_OrganisationalName_Text.setText(businessMasterFile.getBusinessLegalName());
            TFND0004AddressDetailsBusiness addr = businessMasterFile.getBusinessBusinessAddress();
            if (addr != null) {
                this.AddressDetails_Line1_Text_BUS.setText(addr.getLine1T());
                this.AddressDetails_Line2_Text_BUS.setText(addr.getLine2T());
                this.AddressDetails_LocalityName_Text_BUS.setText(addr.getLocalityNameT());
                this.AddressDetails_StateOrTerritory_Code_BUS.setText(addr.getStateOrTerritoryC());
                this.AddressDetails_Postcode_Text_BUS.setText(addr.getPostcodeT());
                this.AddressDetails_Country_Code_BUS.setGlenixElementValue(addr.getCountryC());
            } else {
                this.AddressDetails_Line1_Text_BUS.setText(null);
                this.AddressDetails_Line2_Text_BUS.setText(null);
                this.AddressDetails_LocalityName_Text_BUS.setText(null);
                this.AddressDetails_StateOrTerritory_Code_BUS.setText(null);
                this.AddressDetails_Postcode_Text_BUS.setText(null);
                this.AddressDetails_Country_Code_BUS.setGlenixElementValue(null);
            }
            addr = businessMasterFile.getBusinessPostalAddress();
            if (addr != null) {
                this.AddressDetails_Line1_Text.setText(addr.getLine1T());
                this.AddressDetails_Line2_Text.setText(addr.getLine2T());
                this.AddressDetails_LocalityName_Text.setText(addr.getLocalityNameT());
                this.AddressDetails_StateOrTerritory_Code.setText(addr.getStateOrTerritoryC());
                this.AddressDetails_Postcode_Text.setText(addr.getPostcodeT());
                this.AddressDetails_Country_Code.setGlenixElementValue(addr.getCountryC());
            } else {
                this.AddressDetails_Line1_Text.setText(null);
                this.AddressDetails_Line2_Text.setText(null);
                this.AddressDetails_LocalityName_Text.setText(null);
                this.AddressDetails_StateOrTerritory_Code.setText(null);
                this.AddressDetails_Postcode_Text.setText(null);
                this.AddressDetails_Country_Code.setGlenixElementValue(null);
            }
        }
    }

    public void setProfileDetails(Profile profileXBRL) {
        AgentDetails agentDetails = null;
        if (profileXBRL != null) {
            agentDetails = profileXBRL.getAgentDetails();
        }
        String agentABN = null;
        if (agentDetails != null) {
            agentABN = agentDetails.getAgentABN();
        }
        if (agentABN == null || agentABN.isEmpty()) {
            this.Identifiers_AustralianBusinessNumber_Identifier_INT.setText(null);
            this.Identifiers_TaxAgentNumber_Identifier.setText(null);
            this.agentIntPersonUnstructuredName_FullName_Text.setText(null);
            this.agentElectronicContact_Telephone_ServiceLine_Code.setGlenixElementValue(null);
            this.agentElectronicContact_Telephone_Area_Code.setText(null);
            this.agentElectronicContact_Telephone_Minimal_Number.setText(null);
            this.agentDeclaration_SignatoryIdentifier_Text.setText(null);
            this.agentDeclaration_Signature_Date.setGlenixElementValue(null);
            this.agentDeclaration_StatementAccepted_Indicator.setGlenixElementValue(null);
            this.intermediarysection.setVisible(false);
            this.intermediarysection.setManaged(false);
            this.Declaration_StatementAccepted_Indicator.setGlenixElementValue(null);
            this.Declaration_StatementAccepted_Indicator.getGlenixController().enableGlenixXBRL();
            this.Declaration_Signature_Date.getGlenixController().enableGlenixXBRL();
            this.Declaration_SignatoryIdentifier_Text.getGlenixController().enableGlenixXBRL();
            String declarationText = "I declare that:\n* All of the information I have provided to the agent for the preparation of this Trust tax return and attached schedules is true and correct\n* I authorise the agent to give this document to the Commissioner of Taxation.";
            this.Declaration_Statement_Text.setGlenixElementValue(declarationText);
        } else {
            this.agentDeclaration_StatementAccepted_Indicator.setGlenixElementValue(null);
            this.Identifiers_AustralianBusinessNumber_Identifier_INT.setText(agentABN);
            this.Identifiers_TaxAgentNumber_Identifier.setText(agentDetails.getAgentNumber());
            ProfileElectronicContact ec = agentDetails.getAgentElectronicContact();
            if (ec != null) {
                this.agentIntPersonUnstructuredName_FullName_Text.setText(ec.getPersonUnstructuredNameFullNameT());
                this.agentElectronicContact_Telephone_ServiceLine_Code.setGlenixElementValue(ec.getElectronicContactTelephoneServiceLineCode());
                this.agentElectronicContact_Telephone_Area_Code.setText(ec.getTelephoneAreaC());
                this.agentElectronicContact_Telephone_Minimal_Number.setText(ec.getTelephoneMinimalN());
            } else {
                this.agentIntPersonUnstructuredName_FullName_Text.setText(null);
                this.agentElectronicContact_Telephone_ServiceLine_Code.setGlenixElementValue(null);
                this.agentElectronicContact_Telephone_Area_Code.setText(null);
                this.agentElectronicContact_Telephone_Minimal_Number.setText(null);
            }
            this.intermediarysection.setVisible(true);
            this.intermediarysection.setManaged(true);
            this.Declaration_StatementAccepted_Indicator.getGlenixController().disableGlenixXBRL();
            this.Declaration_Signature_Date.getGlenixController().disableGlenixXBRL();
            this.Declaration_SignatoryIdentifier_Text.getGlenixController().disableGlenixXBRL();
            this.Declaration_StatementAccepted_Indicator.setGlenixElementValue(null);
            this.Declaration_Signature_Date.setGlenixElementValue(null);
            this.Declaration_SignatoryIdentifier_Text.setGlenixElementValue(null);
            String declarationText = "I declare that the information transmitted in this Trust tax return is true and correct and that I am authorised to make this declaration.";
            this.Declaration_Statement_Text.setGlenixElementValue(declarationText);
        }
    }

    private String formatTwoDp(Double amount) {
        if (amount == null) {
            return null;
        }
        return this.format2dp.format(amount);
    }

    @FXML
    private TaxReturnTRT0007StatementOfDistributionVBox addStatementOfDistribution() {
        try {
            final TaxReturnTRT0007StatementOfDistributionVBox sw = new TaxReturnTRT0007StatementOfDistributionVBox();
            sw.getGlenixController().initialize(null, null);
            this.statementofdistributionvbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete statement of distribution");
            this.statementofdistributionvbox.getChildren().add((Object)b);
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnTRT0007Controller.this.statementofdistributionvbox.getChildren().remove((Object)sw);
                    TaxReturnTRT0007Controller.this.statementofdistributionvbox.getChildren().remove((Object)b);
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    private GlenixLabelCGTCodeCombo addExemptionOrRollover() {
        try {
            final GlenixLabelCGTCodeCombo sw = new GlenixLabelCGTCodeCombo();
            sw.getGlenixController().initialize(null, null);
            this.exemptionorrollovervbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete exemption or rollover");
            this.exemptionorrollovervbox.getChildren().add((Object)b);
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnTRT0007Controller.this.exemptionorrollovervbox.getChildren().remove((Object)sw);
                    TaxReturnTRT0007Controller.this.exemptionorrollovervbox.getChildren().remove((Object)b);
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    private TaxReturnTRT0007OtherDeductionVBox addOtherDeduction() {
        try {
            final TaxReturnTRT0007OtherDeductionVBox sw = new TaxReturnTRT0007OtherDeductionVBox();
            sw.getGlenixController().initialize(null, null);
            ObservableList children = this.mainsectionflowpane.getChildren();
            int index = children.indexOf((Object)this.otherdeductionsvbox);
            this.mainsectionflowpane.getChildren().add(index, (Object)sw);
            sw.addDeleteListener(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnTRT0007Controller.this.mainsectionflowpane.getChildren().remove((Object)sw);
                    TaxReturnTRT0007Controller.this.updateNetAustralianIncomeExCG();
                }
            });
            sw.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    TaxReturnTRT0007Controller.this.updateNetAustralianIncomeExCG();
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    private TaxReturnTRT0007OtherIncomeVBox addOtherIncome() {
        try {
            final TaxReturnTRT0007OtherIncomeVBox sw = new TaxReturnTRT0007OtherIncomeVBox();
            sw.getGlenixController().initialize(null, null);
            ObservableList children = this.mainsectionflowpane.getChildren();
            int index = children.indexOf((Object)this.otherincomevbox);
            this.mainsectionflowpane.getChildren().add(index, (Object)sw);
            sw.addDeleteListener(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnTRT0007Controller.this.mainsectionflowpane.getChildren().remove((Object)sw);
                    TaxReturnTRT0007Controller.this.updateTotalAustralianIncome();
                }
            });
            sw.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    TaxReturnTRT0007Controller.this.updateTotalAustralianIncome();
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    private TaxReturnTRT0007INBWithholdingPaymentDetailsVBox addINBWithholding() {
        if (this.inbwithholdingcount > 0) {
            return null;
        }
        try {
            final TaxReturnTRT0007INBWithholdingPaymentDetailsVBox sw = new TaxReturnTRT0007INBWithholdingPaymentDetailsVBox();
            sw.getGlenixController().initialize(null, null);
            ObservableList children = this.mainsectionflowpane.getChildren();
            int index = children.indexOf((Object)this.inbwithholdingvbox);
            this.mainsectionflowpane.getChildren().add(index, (Object)sw);
            ++this.inbwithholdingcount;
            sw.addDeleteListener(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnTRT0007Controller.this.mainsectionflowpane.getChildren().remove((Object)sw);
                    TaxReturnTRT0007Controller.this.updateTotalAustralianIncome();
                }
            });
            sw.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    TaxReturnTRT0007Controller.this.updateTotalAustralianIncome();
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    private TaxReturnTRT0007SISWithholdingPaymentDetailsVBox addSISWithholding() {
        if (this.siswithholdingcount > 0) {
            return null;
        }
        try {
            final TaxReturnTRT0007SISWithholdingPaymentDetailsVBox sw = new TaxReturnTRT0007SISWithholdingPaymentDetailsVBox();
            sw.getGlenixController().initialize(null, null);
            ObservableList children = this.mainsectionflowpane.getChildren();
            int index = children.indexOf((Object)this.siswithholdingvbox);
            this.mainsectionflowpane.getChildren().add(index, (Object)sw);
            ++this.siswithholdingcount;
            sw.addDeleteListener(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnTRT0007Controller.this.mainsectionflowpane.getChildren().remove((Object)sw);
                    TaxReturnTRT0007Controller.this.updateTotalAustralianIncome();
                }
            });
            sw.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    TaxReturnTRT0007Controller.this.updateTotalAustralianIncome();
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    public void updateBusinessIncomeNonPrimInit() {
        this.Remuneration_ABNNotQuotedPaymentGross_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessIncomeNonPrim()));
        this.Remuneration_PaymentToForeignResidentGross_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessIncomeNonPrim()));
        this.GovernmentFunding_GovernmentIndustryPaymentsAssessable_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessIncomeNonPrim()));
        this.Income_Other_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessIncomeNonPrim()));
    }

    public void updateBusinessIncomeNonPrim() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Remuneration_ABNNotQuotedPaymentGross_Amount_JAUS_NonPrim);
        total = this.addDouble(total, (GlenixLabelText)this.Remuneration_PaymentToForeignResidentGross_Amount_JAUS_NonPrim);
        total = this.addDouble(total, (GlenixLabelText)this.GovernmentFunding_GovernmentIndustryPaymentsAssessable_Amount_JAUS_NonPrim);
        if ((total = this.addDouble(total, (GlenixLabelText)this.Income_Other_Amount_JAUS_NonPrim)) == null) {
            this.TotalBusinessIncome_NonPrim.setGlenixElementValue(null);
        } else {
            this.TotalBusinessIncome_NonPrim.setGlenixElementValue("" + total.intValue());
        }
    }

    public void updateBusinessIncomePrimInit() {
        this.Remuneration_ABNNotQuotedPaymentGross_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessIncomePrim()));
        this.GovernmentFunding_GovernmentIndustryPaymentsAssessable_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessIncomePrim()));
        this.Income_Other_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessIncomePrim()));
    }

    public void updateBusinessIncomePrim() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Remuneration_ABNNotQuotedPaymentGross_Amount_JAUS_Prim);
        total = this.addDouble(total, (GlenixLabelText)this.GovernmentFunding_GovernmentIndustryPaymentsAssessable_Amount_JAUS_Prim);
        if ((total = this.addDouble(total, (GlenixLabelText)this.Income_Other_Amount_JAUS_Prim)) == null) {
            this.TotalBusinessIncome_Prim.setGlenixElementValue(null);
        } else {
            this.TotalBusinessIncome_Prim.setGlenixElementValue("" + total.intValue());
        }
    }

    private void updateTRT0007FieldSum(String fieldname, Double d, GlenixLabelText glt2) throws Exception {
        Double total = this.addDouble(d, glt2);
        if (total == null) {
            this.trt0007.setChildValue(fieldname, null);
        } else {
            this.trt0007.setChildValue(fieldname, "" + total.intValue());
        }
    }

    private void updateTRT0007FieldSum(String fieldname, GlenixLabelText glt1, GlenixLabelText glt2) throws Exception {
        Double total = this.addDouble(glt1, glt2);
        if (total == null) {
            this.trt0007.setChildValue(fieldname, null);
        } else {
            this.trt0007.setChildValue(fieldname, "" + total.intValue());
        }
    }

    public void updateBusinessExpensesNonPrimInit() {
        this.Expense_ForeignResidentWithholding_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesNonPrim()));
        this.Remuneration_WagesAndSalaries_PaymentsContractorAndConsultant_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesNonPrim()));
        this.SuperannuationContribution_EmployerContributions_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesNonPrim()));
        this.Expense_Operating_BadDebts_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesNonPrim()));
        this.Expense_Operating_LeaseTotal_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesNonPrim()));
        this.Expense_Operating_Rent_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesNonPrim()));
        this.Expense_Operating_Interest_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesNonPrim()));
        this.Expense_Royalties_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesNonPrim()));
        this.Expense_DepreciationandAmortisation_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesNonPrim()));
        this.Expense_Operating_MotorVehicle_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesNonPrim()));
        this.Expense_Operating_RepairsAndMaintenance_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesNonPrim()));
        this.Expense_DeductibleOtherTotal_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesNonPrim()));
        this.Expense_Operating_CostOfSales_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesNonPrim()));
    }

    public void updateBusinessExpensesNonPrim() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Expense_ForeignResidentWithholding_Amount_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.Remuneration_WagesAndSalaries_PaymentsContractorAndConsultant_Amount_JAUS_NonPrim);
        total = this.addDouble(total, (GlenixLabelText)this.SuperannuationContribution_EmployerContributions_Amount_JAUS_NonPrim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Operating_BadDebts_Amount_JAUS_NonPrim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Operating_LeaseTotal_Amount_JAUS_NonPrim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Operating_Rent_Amount_JAUS_NonPrim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Operating_Interest_Amount_JAUS_NonPrim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Royalties_Amount_JAUS_NonPrim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_DepreciationandAmortisation_Amount_JAUS_NonPrim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Operating_MotorVehicle_Amount_JAUS_NonPrim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Operating_RepairsAndMaintenance_Amount_JAUS_NonPrim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_DeductibleOtherTotal_Amount_JAUS_NonPrim);
        if ((total = this.addDouble(total, (GlenixLabelText)this.Expense_Operating_CostOfSales_Amount_JAUS_NonPrim)) == null) {
            this.TotalBusinessExpenses_NonPrim.setGlenixElementValue(null);
        } else {
            this.TotalBusinessExpenses_NonPrim.setGlenixElementValue("" + total.intValue());
        }
        try {
            this.updateTRT0007FieldSum("Remuneration.WagesAndSalaries.PaymentsContractorAndConsultant.Amount.JAUS", this.Remuneration_WagesAndSalaries_PaymentsContractorAndConsultant_Amount_JAUS_Prim, (GlenixLabelText)this.Remuneration_WagesAndSalaries_PaymentsContractorAndConsultant_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("SuperannuationContribution.EmployerContributions.Amount.JAUS", this.SuperannuationContribution_EmployerContributions_Amount_JAUS_Prim, (GlenixLabelText)this.SuperannuationContribution_EmployerContributions_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.Operating.CostOfSales.Amount.JAUS", this.Expense_Operating_CostOfSales_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_Operating_CostOfSales_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.Operating.BadDebts.Amount.JAUS", this.Expense_Operating_BadDebts_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_Operating_BadDebts_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.Operating.LeaseTotal.Amount.JAUS", this.Expense_Operating_LeaseTotal_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_Operating_LeaseTotal_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.Operating.Rent.Amount.JAUS", this.Expense_Operating_Rent_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_Operating_Rent_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.Operating.Interest.Amount.JAUS", this.Expense_Operating_Interest_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_Operating_Interest_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.Royalties.Amount.JAUS", this.Expense_Royalties_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_Royalties_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.DepreciationandAmortisation.Amount.JAUS", this.Expense_DepreciationandAmortisation_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_DepreciationandAmortisation_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.Operating.MotorVehicle.Amount.JAUS", this.Expense_Operating_MotorVehicle_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_Operating_MotorVehicle_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.Operating.RepairsAndMaintenance.Amount.JAUS", this.Expense_Operating_RepairsAndMaintenance_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_Operating_RepairsAndMaintenance_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.DeductibleOtherTotal.Amount.JAUS", this.Expense_DeductibleOtherTotal_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_DeductibleOtherTotal_Amount_JAUS_NonPrim);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
        }
    }

    public void updateBusinessExpensesPrimInit() {
        this.Remuneration_WagesAndSalaries_PaymentsContractorAndConsultant_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesPrim()));
        this.SuperannuationContribution_EmployerContributions_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesPrim()));
        this.Expense_Operating_BadDebts_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesPrim()));
        this.Expense_Operating_LeaseTotal_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesPrim()));
        this.Expense_Operating_Rent_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesPrim()));
        this.Expense_Operating_Interest_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesPrim()));
        this.Expense_Royalties_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesPrim()));
        this.Expense_DepreciationandAmortisation_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesPrim()));
        this.Expense_Operating_MotorVehicle_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesPrim()));
        this.Expense_Operating_RepairsAndMaintenance_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesPrim()));
        this.Expense_DeductibleOtherTotal_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesPrim()));
        this.Expense_Operating_CostOfSales_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessExpensesPrim()));
    }

    public void updateBusinessExpensesPrim() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Remuneration_WagesAndSalaries_PaymentsContractorAndConsultant_Amount_JAUS_Prim);
        total = this.addDouble(total, (GlenixLabelText)this.SuperannuationContribution_EmployerContributions_Amount_JAUS_Prim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Operating_BadDebts_Amount_JAUS_Prim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Operating_LeaseTotal_Amount_JAUS_Prim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Operating_Rent_Amount_JAUS_Prim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Operating_Interest_Amount_JAUS_Prim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Royalties_Amount_JAUS_Prim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_DepreciationandAmortisation_Amount_JAUS_Prim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Operating_MotorVehicle_Amount_JAUS_Prim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Operating_RepairsAndMaintenance_Amount_JAUS_Prim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_DeductibleOtherTotal_Amount_JAUS_Prim);
        if ((total = this.addDouble(total, (GlenixLabelText)this.Expense_Operating_CostOfSales_Amount_JAUS_Prim)) == null) {
            this.TotalBusinessExpenses_Prim.setGlenixElementValue(null);
        } else {
            this.TotalBusinessExpenses_Prim.setGlenixElementValue("" + total.intValue());
        }
        try {
            this.updateTRT0007FieldSum("Remuneration.WagesAndSalaries.PaymentsContractorAndConsultant.Amount.JAUS", this.Remuneration_WagesAndSalaries_PaymentsContractorAndConsultant_Amount_JAUS_Prim, (GlenixLabelText)this.Remuneration_WagesAndSalaries_PaymentsContractorAndConsultant_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("SuperannuationContribution.EmployerContributions.Amount.JAUS", this.SuperannuationContribution_EmployerContributions_Amount_JAUS_Prim, (GlenixLabelText)this.SuperannuationContribution_EmployerContributions_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.Operating.CostOfSales.Amount.JAUS", this.Expense_Operating_CostOfSales_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_Operating_CostOfSales_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.Operating.BadDebts.Amount.JAUS", this.Expense_Operating_BadDebts_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_Operating_BadDebts_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.Operating.LeaseTotal.Amount.JAUS", this.Expense_Operating_LeaseTotal_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_Operating_LeaseTotal_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.Operating.Rent.Amount.JAUS", this.Expense_Operating_Rent_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_Operating_Rent_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.Operating.Interest.Amount.JAUS", this.Expense_Operating_Interest_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_Operating_Interest_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.Royalties.Amount.JAUS", this.Expense_Royalties_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_Royalties_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.DepreciationandAmortisation.Amount.JAUS", this.Expense_DepreciationandAmortisation_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_DepreciationandAmortisation_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.Operating.MotorVehicle.Amount.JAUS", this.Expense_Operating_MotorVehicle_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_Operating_MotorVehicle_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.Operating.RepairsAndMaintenance.Amount.JAUS", this.Expense_Operating_RepairsAndMaintenance_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_Operating_RepairsAndMaintenance_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.DeductibleOtherTotal.Amount.JAUS", this.Expense_DeductibleOtherTotal_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_DeductibleOtherTotal_Amount_JAUS_NonPrim);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
        }
    }

    public void updateBusinessNetIncomeNonPrimInit() {
        this.Income_ReconciliationAdjustmentTotal_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessNetIncomeNonPrim()));
        this.Expense_ReconciliationAdjustmentTotal_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessNetIncomeNonPrim()));
        this.TotalBusinessExpenses_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessNetIncomeNonPrim()));
        this.TotalBusinessIncome_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessNetIncomeNonPrim()));
    }

    public void updateBusinessNetIncomeNonPrim() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Income_ReconciliationAdjustmentTotal_Amount_JAUS_NonPrim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_ReconciliationAdjustmentTotal_Amount_JAUS_NonPrim);
        total = this.addDouble(total, (GlenixLabelText)this.TotalBusinessIncome_NonPrim);
        if ((total = this.subtractDouble(total, this.TotalBusinessExpenses_NonPrim)) == null) {
            this.Income_Net_Amount_JAUS_NonPrim.setGlenixElementValue(null);
        } else {
            this.Income_Net_Amount_JAUS_NonPrim.setGlenixElementValue("" + total.intValue());
        }
        try {
            this.updateTRT0007FieldSum("Income.ReconciliationAdjustmentTotal.Amount.JAUS", this.Income_ReconciliationAdjustmentTotal_Amount_JAUS_Prim, (GlenixLabelText)this.Income_ReconciliationAdjustmentTotal_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.ReconciliationAdjustmentTotal.Amount.JAUS", this.Expense_ReconciliationAdjustmentTotal_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_ReconciliationAdjustmentTotal_Amount_JAUS_NonPrim);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
        }
    }

    public void updateBusinessNetIncomePrimInit() {
        this.Income_ReconciliationAdjustmentTotal_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessNetIncomePrim()));
        this.Expense_ReconciliationAdjustmentTotal_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessNetIncomePrim()));
        this.TotalBusinessExpenses_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessNetIncomePrim()));
        this.TotalBusinessIncome_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateBusinessNetIncomePrim()));
    }

    public void updateBusinessNetIncomePrim() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Income_ReconciliationAdjustmentTotal_Amount_JAUS_Prim);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_ReconciliationAdjustmentTotal_Amount_JAUS_Prim);
        total = this.addDouble(total, (GlenixLabelText)this.TotalBusinessIncome_Prim);
        if ((total = this.subtractDouble(total, this.TotalBusinessExpenses_Prim)) == null) {
            this.Income_Net_Amount_JAUS_Prim.setGlenixElementValue(null);
        } else {
            this.Income_Net_Amount_JAUS_Prim.setGlenixElementValue("" + total.intValue());
        }
        try {
            this.updateTRT0007FieldSum("Income.ReconciliationAdjustmentTotal.Amount.JAUS", this.Income_ReconciliationAdjustmentTotal_Amount_JAUS_Prim, (GlenixLabelText)this.Income_ReconciliationAdjustmentTotal_Amount_JAUS_NonPrim);
            this.updateTRT0007FieldSum("Expense.ReconciliationAdjustmentTotal.Amount.JAUS", this.Expense_ReconciliationAdjustmentTotal_Amount_JAUS_Prim, (GlenixLabelText)this.Expense_ReconciliationAdjustmentTotal_Amount_JAUS_NonPrim);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
        }
    }

    public void updateNetPrimaryProductionAmountInit() {
        this.Income_PartnershipDistributionGross_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNetPrimaryProductionAmount()));
        this.Income_TrustShareNet_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNetPrimaryProductionAmount()));
        this.Expense_DistributionDeductionsOther_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNetPrimaryProductionAmount()));
    }

    public void updateNetPrimaryProductionAmount() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Income_PartnershipDistributionGross_Amount_JAUS_Prim);
        total = this.addDouble(total, (GlenixLabelText)this.Income_TrustShareNet_Amount_JAUS_Prim);
        if ((total = this.subtractDouble(total, this.Expense_DistributionDeductionsOther_Amount_JAUS_Prim)) == null) {
            this.NetPrimaryProductionAmount.setGlenixElementValue(null);
        } else {
            this.NetPrimaryProductionAmount.setGlenixElementValue("" + total.intValue());
        }
    }

    public void updateNetNonPrimaryProductionAmountInit() {
        this.Income_PartnershipDistributionLessForeignIncome_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNetNonPrimaryProductionAmount()));
        this.Income_TrustShareNetExcludeNetCapitalGainsAndForeignIncomeAndDistributionFranked_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNetNonPrimaryProductionAmount()));
        this.Expense_DistributionDeductionsOther_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNetNonPrimaryProductionAmount()));
        this.Income_TrustDistributionFranked_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNetNonPrimaryProductionAmount()));
        this.IncomeTax_Deduction_TrustDistributionFranked_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNetNonPrimaryProductionAmount()));
    }

    public void updateNetNonPrimaryProductionAmount() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Income_PartnershipDistributionLessForeignIncome_Amount_JAUS_NonPrim);
        total = this.addDouble(total, (GlenixLabelText)this.Income_TrustShareNetExcludeNetCapitalGainsAndForeignIncomeAndDistributionFranked_Amount_JAUS_NonPrim);
        total = this.subtractDouble(total, this.Expense_DistributionDeductionsOther_Amount_JAUS_NonPrim);
        total = this.addDouble(total, (GlenixLabelText)this.Income_TrustDistributionFranked_Amount_JAUS_NonPrim);
        if ((total = this.subtractDouble(total, this.IncomeTax_Deduction_TrustDistributionFranked_Amount_JAUS_NonPrim)) == null) {
            this.NetNonPrimaryProductionAmount.setGlenixElementValue(null);
        } else {
            this.NetNonPrimaryProductionAmount.setGlenixElementValue("" + total.intValue());
        }
    }

    public void updateNetRentInit() {
        this.Income_Operating_RentalIncomeGross_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNetRent()));
        this.Expense_Interest_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNetRent()));
        this.Expense_CapitalWorksDeduction_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNetRent()));
        this.IncomeTax_Deduction_RentalIncomeDeductionsOtherThanInterestAndCapitalWorks_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNetRent()));
    }

    public void updateNetRent() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Income_Operating_RentalIncomeGross_Amount_JAUS);
        total = this.subtractDouble(total, this.Expense_Interest_Amount_JAUS);
        total = this.subtractDouble(total, this.Expense_CapitalWorksDeduction_Amount_JAUS);
        if ((total = this.subtractDouble(total, this.IncomeTax_Deduction_RentalIncomeDeductionsOtherThanInterestAndCapitalWorks_Amount_JAUS)) == null) {
            this.NetRent.setGlenixElementValue(null);
        } else {
            this.NetRent.setGlenixElementValue("" + total.intValue());
        }
    }

    public void updateTotalAustralianIncomeInit() {
        this.Income_Net_Amount_JAUS_Prim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAustralianIncome()));
        this.Income_Net_Amount_JAUS_NonPrim.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAustralianIncome()));
        this.NetNonPrimaryProductionAmount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAustralianIncome()));
        this.NetPrimaryProductionAmount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAustralianIncome()));
        this.NetRent.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAustralianIncome()));
        this.Income_ForestryManagedInvestmentScheme_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAustralianIncome()));
        this.Income_Interest_Gross_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAustralianIncome()));
        this.Income_DividendsUnfranked_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAustralianIncome()));
        this.Income_DividendsFranked_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAustralianIncome()));
        this.IncomeTax_FrankingCredits_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAustralianIncome()));
        this.SuperannuationBenefit_DeathBenefitLumpSumPaymentTaxedElement_Amount_ND.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAustralianIncome()));
        this.SuperannuationBenefit_DeathBenefitLumpSumPaymentUntaxedElement_Amount_ND.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAustralianIncome()));
        this.SuperannuationBenefit_DeathBenefitEmploymentTerminationPaymentTaxableComponent_Amount_ETPD.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAustralianIncome()));
        this.SuperannuationBenefit_DeathBenefitEmploymentTerminationPaymentTaxableComponent_Amount_ETPND.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAustralianIncome()));
        this.Remuneration_BonusesAndAllowances_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAustralianIncome()));
        this.Pension_Total_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAustralianIncome()));
    }

    public void updateTotalAustralianIncome() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Income_Net_Amount_JAUS_Prim);
        total = this.addDouble(total, (GlenixLabelText)this.Income_Net_Amount_JAUS_NonPrim);
        total = this.addDouble(total, (GlenixLabelText)this.NetNonPrimaryProductionAmount);
        total = this.addDouble(total, (GlenixLabelText)this.NetPrimaryProductionAmount);
        total = this.addDouble(total, (GlenixLabelText)this.NetRent);
        total = this.addDouble(total, (GlenixLabelText)this.Income_ForestryManagedInvestmentScheme_Amount_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.Income_Interest_Gross_Amount_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.Income_DividendsUnfranked_Amount_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.Income_DividendsFranked_Amount_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_FrankingCredits_Amount_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.SuperannuationBenefit_DeathBenefitLumpSumPaymentTaxedElement_Amount_ND);
        total = this.addDouble(total, (GlenixLabelText)this.SuperannuationBenefit_DeathBenefitLumpSumPaymentUntaxedElement_Amount_ND);
        total = this.addDouble(total, (GlenixLabelText)this.SuperannuationBenefit_DeathBenefitEmploymentTerminationPaymentTaxableComponent_Amount_ETPD);
        total = this.addDouble(total, (GlenixLabelText)this.SuperannuationBenefit_DeathBenefitEmploymentTerminationPaymentTaxableComponent_Amount_ETPND);
        total = this.addDouble(total, (GlenixLabelText)this.Remuneration_BonusesAndAllowances_Amount_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.Pension_Total_Amount_JAUS);
        for (Node n : this.mainsectionflowpane.getChildren()) {
            if (n instanceof TaxReturnTRT0007OtherIncomeVBox) {
                total = this.addDouble(total, ((TaxReturnTRT0007OtherIncomeVBox)n).getGross());
            }
            if (n instanceof TaxReturnTRT0007INBWithholdingPaymentDetailsVBox) {
                total = this.addDouble(total, ((TaxReturnTRT0007INBWithholdingPaymentDetailsVBox)n).getGross());
            }
            if (!(n instanceof TaxReturnTRT0007SISWithholdingPaymentDetailsVBox)) continue;
            total = this.addDouble(total, ((TaxReturnTRT0007SISWithholdingPaymentDetailsVBox)n).getGross());
        }
        if (total == null) {
            this.TotalAustralianIncome.setGlenixElementValue(null);
        } else {
            this.TotalAustralianIncome.setGlenixElementValue("" + total.intValue());
        }
    }

    public void updateNetAustralianIncomeExCGInit() {
        this.Expense_AustralianInvestmentAllowableDeduction_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNetAustralianIncomeExCG()));
        this.IncomeTax_Deduction_DistributionFranked_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNetAustralianIncomeExCG()));
        this.Expense_ForestryManagedInvestmentSchemeDeduction_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNetAustralianIncomeExCG()));
        this.TotalAustralianIncome.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNetAustralianIncomeExCG()));
    }

    public void updateNetAustralianIncomeExCG() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.TotalAustralianIncome);
        total = this.subtractDouble(total, this.Expense_AustralianInvestmentAllowableDeduction_Amount_JAUS);
        total = this.subtractDouble(total, this.IncomeTax_Deduction_DistributionFranked_Amount_JAUS);
        total = this.subtractDouble(total, this.Expense_ForestryManagedInvestmentSchemeDeduction_Amount_JAUS);
        for (Node n : this.mainsectionflowpane.getChildren()) {
            if (!(n instanceof TaxReturnTRT0007OtherDeductionVBox)) continue;
            total = this.subtractDouble(total, ((TaxReturnTRT0007OtherDeductionVBox)n).getGross());
        }
        if (total == null) {
            this.Income_Net_Amount_JAUS.setGlenixElementValue(null);
        } else {
            this.Income_Net_Amount_JAUS.setGlenixElementValue("" + total.intValue());
        }
    }

    public void updateTotalNetIncomeInit() {
        this.Income_CapitalGainsNet_Amount_RP.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalNetIncome()));
        this.Income_InternationalDealings_Attributed_Amount_JFOREIGN_CFCLC.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalNetIncome()));
        this.Income_Net_Amount_JFOREIGN.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalNetIncome()));
        this.IncomeTax_FrankingCredits_ReceivedFromNewZealandCompanies_Amount_JFOREIGN.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalNetIncome()));
        this.IncomeTax_Deduction_TaxLossesDeducted_Amount_RP.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalNetIncome()));
        this.Income_Net_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalNetIncome()));
    }

    public void updateTotalNetIncome() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Income_Net_Amount_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.Income_CapitalGainsNet_Amount_RP);
        total = this.addDouble(total, (GlenixLabelText)this.Income_InternationalDealings_Attributed_Amount_JFOREIGN_CFCLC);
        total = this.addDouble(total, (GlenixLabelText)this.Income_Net_Amount_JFOREIGN);
        total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_FrankingCredits_ReceivedFromNewZealandCompanies_Amount_JFOREIGN);
        if ((total = this.subtractDouble(total, this.IncomeTax_Deduction_TaxLossesDeducted_Amount_RP)) == null) {
            this.TotalNetIncome.setGlenixElementValue(null);
        } else {
            this.TotalNetIncome.setGlenixElementValue("" + total.intValue());
        }
    }

    public void setTaxReturnDetails(String type, String status, String year, LocalDate startDate, LocalDate endDate) {
        this.type = type;
        this.status = status;
        this.year = year;
        this.startDate = startDate;
        this.endDate = endDate;
        this.Report_TargetFinancial_Year.setGlenixElementValue(year);
    }
}

