/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.tr2018;

import au.com.glenix.tr2018.GlenixLabelCGTCodeSMSF0008Combo;
import au.com.glenix.tr2018.GlenixLabelCountryLabel;
import au.com.glenix.tr2018.GlenixLabelServiceLineCodeCombo;
import au.com.glenix.tr2018.TaxReturnSMSF0008MemberInformationVBox;
import au.com.glenix.trn.AgentDetails;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.Profile;
import au.com.glenix.trn.ProfileElectronicContact;
import au.com.glenix.trn.SMSF0008;
import au.com.glenix.trn.TFND0004AddressDetailsBusiness;
import au.com.glenix.widget.ErrorDisplay;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixFlowPane;
import au.com.glenix.widget.GlenixLabelBlankNoYesCombo;
import au.com.glenix.widget.GlenixLabelCheckbox;
import au.com.glenix.widget.GlenixLabelDate;
import au.com.glenix.widget.GlenixLabelDateTimeLabel;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelOnly;
import au.com.glenix.widget.GlenixLabelSignatoryIdentifier;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixLabelTwoDecimalAmountTR;
import au.com.glenix.widget.GlenixLabelTwoDecimalPositiveAmountTR;
import au.com.glenix.widget.GlenixLabelZeroDecimalAmountTR;
import au.com.glenix.widget.GlenixLabelZeroDecimalPositiveAmountTR;
import au.com.glenix.widget.GlenixPane;
import au.com.glenix.widget.GlenixVBox;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import javafx.util.Pair;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TaxReturnSMSF0008Controller
extends GlenixBranchController {
    protected DocumentBuilder dBuilder;
    protected SMSF0008 smsf0008;
    protected NumberFormat format2dp = new DecimalFormat("#0.00");
    @FXML
    protected GlenixLabelDateTimeLabel SBRDocumentDateTime;
    @FXML
    protected GlenixVBox smsf0008VBox;
    @FXML
    protected GlenixLabelLabel Identifiers_TaxAgentNumber_Identifier;
    @FXML
    protected GlenixLabelLabel Identifiers_AustralianBusinessNumber_Identifier_INT;
    @FXML
    protected GlenixLabelLabel Identifiers_TaxFileNumber_Identifier;
    protected ErrorDisplay errorDisplay;
    @FXML
    protected GlenixLabelLabel Identifiers_AustralianBusinessNumber_Identifier;
    @FXML
    protected GlenixLabelLabel OrganisationNameDetails_OrganisationalName_Text;
    @FXML
    protected GlenixLabelLabel AddressDetails_Line1_Text;
    @FXML
    protected GlenixLabelLabel AddressDetails_Line2_Text;
    @FXML
    protected GlenixLabelLabel AddressDetails_LocalityName_Text;
    @FXML
    protected GlenixLabelLabel AddressDetails_StateOrTerritory_Code;
    @FXML
    protected GlenixLabelLabel AddressDetails_Postcode_Text;
    @FXML
    protected GlenixLabelCountryLabel AddressDetails_Country_Code;
    @FXML
    protected GlenixLabelServiceLineCodeCombo ElectronicContact_Telephone_ServiceLine_Code_INT;
    @FXML
    protected GlenixLabelLabel ElectronicContact_Telephone_Area_Code_INT;
    @FXML
    protected GlenixLabelLabel ElectronicContact_Telephone_Minimal_Number_INT;
    @FXML
    protected GlenixLabelLabel OrganisationNameDetails_OrganisationalName_Text_INT;
    @FXML
    protected GlenixFlowPane intermediarysection;
    @FXML
    protected GlenixLabelCheckbox agentDeclaration_StatementAccepted_Indicator;
    @FXML
    protected GlenixLabelText agentDeclaration_SignatoryIdentifier_Text;
    @FXML
    protected GlenixLabelDate agentDeclaration_Signature_Date;
    @FXML
    protected GlenixLabelOnly agentDeclaration_Statement_Text;
    @FXML
    protected GlenixLabelOnly Declaration_Statement_Text;
    @FXML
    protected GlenixLabelCheckbox Declaration_StatementAccepted_Indicator;
    @FXML
    protected GlenixLabelDate Declaration_Signature_Date;
    @FXML
    protected GlenixLabelSignatoryIdentifier Declaration_SignatoryIdentifier_Text;
    @FXML
    protected GlenixLabelLabel PersonUnstructuredName_FullName_Text;
    protected int memberinformationcount = 0;
    @FXML
    protected VBox memberinformationvbox;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Equity_MemberAccountBalance_Amount_Closing;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_LimitedRecourseBorrowing_Amount_JAUS_AustResidentialRealProperty;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_LimitedRecourseBorrowing_Amount_JAUS_AustNonResidentialRealProperty;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_LimitedRecourseBorrowing_Amount_JAUS_OverseasRealProperty;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_LimitedRecourseBorrowing_Amount_JAUS_AustralianShares;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_LimitedRecourseBorrowing_Amount_JAUS_OtherShares;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_LimitedRecourseBorrowing_Amount_JAUS_Other;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_LimitedRecourseBorrowing_Amount_JAUS;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_Investment_UnitTrustsListed_Amount_JAUS;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_Investment_UnitTrustsUnlisted_Amount_JAUS;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_Investment_SecuritiesAndOrInsurancePoliciesHeldInLifeCompanies_Amount_Closing_JAUS_Instant;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_ManagedInvestments_Amount_Closing_JAUS_Instant;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_CashAndLiquidAssets_Total_Amount_Closing_JAUS_Instant;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_DebtSecurities_Amount_JAUS;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_LoansAndReceivables_Held_Amount_Closing_JAUS_Instant;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_Investment_EquitySecuritiesListed_Amount_JAUS;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_Investment_EquitySecuritiesUnlisted_Amount_JAUS;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_Investment_PropertyNonResidential_Amount_JAUS;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_Investment_PropertyResidential_Amount_JAUS;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_Investment_Collectables_Amount_JAUS;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_Other_Amount_Closing_JAUS_Instant;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_Investment_EquitySecurities_Amount_Closing_JFOREIGN_Instant;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_Investment_PropertyNonResidential_Amount_JFOREIGN;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_Investment_PropertyResidential_Amount_JFOREIGN;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_ManagedInvestments_Amount_Closing_JFOREIGN_Instant;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Assets_Other_Amount_Closing_JFOREIGN_Instant;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR TotalAssets;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Liabilities_BorrowingsLimited_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Liabilities_BorrowingsTemporary_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Liabilities_BorrowingsOther_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Liabilities_Borrowings_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Equity_NetAssetsNotAllocatedToMembers_Amount_Closing_Instant;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Liabilities_Other_Amount_RP_Instant;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR TotalLiabilities;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR SuperannuationContribution_EmployerAssessable_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR SuperannuationContribution_PersonalAssessable_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR SuperannuationContribution_EmployerContributionsTaxFileNumberNotQuoted_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR SuperannuationContribution_LiabilityTransferToLifeInsuranceCompanyOrPooledSuperannuationTrustAssessable_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR AssessableContributions;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Income_NonArmsLengthPrivateCompanyDividendsNet_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Income_NonArmsLengthTrustDistributionsNet_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Income_NonArmsLengthOtherNet_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR NonArmsLengthNetAmount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Income_CapitalGainsNet_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Income_RentLeasingHiringGross_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Income_Interest_Gross_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Income_ForestryManagedInvestmentScheme_Amount;
    @FXML
    protected GlenixLabelZeroDecimalAmountTR Income_Net_Amount_JFOREIGN;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR IncomeTax_FrankingCredits_ReceivedFromNewZealandCompanies_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Equity_InternationalDealings_ForeignFundTransfers_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Remuneration_ABNNotQuotedPaymentGross_Amount;
    @FXML
    protected GlenixLabelZeroDecimalAmountTR Income_PartnershipDistributionGross_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Income_DividendsUnfranked_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Income_DividendsFranked_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR IncomeTax_FrankingCredits_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Income_TrustDistributionGross_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Income_Other_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Income_AssessableIncomeDueToFundTaxStatusChange_Amount;
    @FXML
    protected GlenixLabelZeroDecimalAmountTR GrossIncome;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR TaxConcession_PensionIncomeExemptDeduction_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR TaxConcession_PensionIncomeExemptDeduction_Amount_Restated;
    @FXML
    protected GlenixLabelZeroDecimalAmountTR TotalAssessableIncome;
    @FXML
    protected GlenixLabelBlankNoYesCombo Income_AssessableOther_Indicator;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_Interest_Amount_Deductible_JAUS;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_Interest_Amount_Deductible_JFOREIGN;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_CapitalWorks_Amount_Deductible;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_DepreciationandAmortisation_Amount_Deductible;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_PremiumsDeathOrDisability_Amount_Deductible;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_DeathBenefitLumpSumIncrease_Amount_Deductible;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_Operating_ApprovedAuditorFee_Amount_Deductible;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_Investment_Amount_Deductible;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_Operating_GeneralManagementAndAdministrationFees_Amount_Deductible;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_ForestryManagedInvestmentScheme_Amount_Deductible;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_Other_Amount_Deductible;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR IncomeTax_Deduction_TaxLossesDeducted_Amount_Deductible;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR TotalDeductibleExpenses;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_Interest_Amount_NonDeductible_JAUS;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_Interest_Amount_NonDeductible_JFOREIGN;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_CapitalWorks_Amount_NonDeductible;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_DepreciationandAmortisation_Amount_NonDeductible;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_PremiumsDeathOrDisability_Amount_NonDeductible;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_Operating_ApprovedAuditorFee_Amount_NonDeductible;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_Investment_Amount_NonDeductible;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_Operating_GeneralManagementAndAdministrationFees_Amount_NonDeductible;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_ForestryManagedInvestmentScheme_Amount_NonDeductible;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_Other_Amount_NonDeductible;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR TotalNonDeductibleExpenses;
    @FXML
    protected GlenixLabelZeroDecimalAmountTR Income_Taxable_Amount;
    @FXML
    protected GlenixLabelZeroDecimalPositiveAmountTR Expense_Total_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR Income_InternationalDealings_TaxOffset_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_TaxOffsetsAndRebatesTotal_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_TaxOffsetNonRefundableNonCarryForward_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR TaxOffsetClaim_NonRefundableOther_Amount_LimitedPartners;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR TaxOffsetClaim_NonRefundableOther_Amount_LimitedPartners_YPrevious;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR TaxOffsetClaim_NonRefundableOther_Amount_Investor;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR TaxOffsetClaim_NonRefundableOther_Amount_Investor_YPrevious;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_TaxOffsetNonRefundableCarryForward_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_FrankingCredits_Refundable_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_TaxOffsetTFNNotQuoted_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_TaxOffsetEntitlementForNationalRentalAffordabilityScheme_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_TaxOffsetExplorationCredits_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_TotalRefundableTaxOffsets_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR Income_Interest_EarlyPaymentCredit_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_PayAsYouGoWithholding_CreditForAmountsWithheldFromForeignResidents_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_PayAsYouGoWithholding_CreditForAmountsWithheldTFNNotQuotedAndABNNotQuoted_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_PayAsYouGoWithholding_CreditForTaxWithheldFromCloselyHeldTrust_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_TaxOffsetCalculatedInterestTFNNotQuoted_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_PayAsYouGoWithholding_CreditForCapitalGainsWithheldFromForeignResidents_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_Deduction_CreditsEligibleTotal_Amount;
    @FXML
    protected GlenixLabelBlankNoYesCombo SuperannuationFundDetails_AustralianSuperannuationFundStatus_Indicator;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_TotalTaxOnTaxableIncome_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_TFNNotQuotedContributionsTax_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_TaxableGross_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_SubtotalTaxPayable_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_TaxOffsetCarriedForwardSubTotal_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_TotalRemainderOfRefundableTaxOffsets_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_Payable_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR InternationalDealings_AAMInterestSection102_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_LiabilityInstalmentsTotal_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_SupervisoryLevy_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_SupervisoryLevyWoundupAdjustment_Amount;
    @FXML
    protected GlenixLabelTwoDecimalPositiveAmountTR IncomeTax_SupervisoryLevyNewlyRegisteredAdjustment_Amount;
    @FXML
    protected GlenixLabelTwoDecimalAmountTR IncomeTax_PayableOrRefundableTotal_Amount;
    @FXML
    protected GlenixLabelBlankNoYesCombo OrganisationDetails_OperationCease_Indicator;
    @FXML
    protected GlenixLabelBlankNoYesCombo Lodgment_FirstReturn_Indicator;
    @FXML
    protected VBox cgtexemptionvbox;
    @FXML
    protected GlenixLabelLabel Report_TargetFinancial_Year;
    protected String type;
    protected String status;
    protected String year;
    protected LocalDate startDate;
    protected LocalDate endDate;

    public TaxReturnSMSF0008Controller(ErrorDisplay errorDisplay) {
        this.errorDisplay = errorDisplay;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
        }
        this.updateLimitedRecourseInit();
        this.updateTotalAssetsInit();
        this.updateTotalBorrowingsInit();
        this.updateTotalLiabilitiesInit();
        this.updateAssessableContributionsInit();
        this.updateNonArmsLengthIncomeInit();
        this.updateGrossIncomeInit();
        this.updateTotalAssessableIncomeInit();
        this.updateTotalDeductibleExpensesInit();
        this.updateTotalNonDeductibleExpensesInit();
        this.updateTaxableIncomeInit();
        this.updateTotalExpensesInit();
        this.updateNonRefundableNonCarryForwardInit();
        this.updateNonRefundableCarryForwardInit();
        this.updateRefundableInit();
        this.updateCreditsEligibleTotalInit();
        this.calculateTaxOnTaxableIncomeInit();
        this.updateGrossTaxInit();
        this.updateSubtotalTaxPayableInit();
        this.updateCarriedFwdSubtotalTaxPayableInit();
        this.updateTaxPayableInit();
        this.updateDueOrRefundableInit();
        this.agentDeclaration_StatementAccepted_Indicator.setSingleChangeListener(new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null && !newValue.isEmpty()) {
                    TaxReturnSMSF0008Controller.this.agentDeclaration_Signature_Date.setLocalDate(LocalDate.now());
                }
            }
        });
        this.Declaration_StatementAccepted_Indicator.setSingleChangeListener(new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null && !newValue.isEmpty()) {
                    TaxReturnSMSF0008Controller.this.Declaration_Signature_Date.setLocalDate(LocalDate.now());
                }
            }
        });
    }

    public void setModel(SMSF0008 smsf0008) throws Exception {
        String taabn;
        Document doc;
        this.smsf0008 = smsf0008;
        this.clearGlenixXBRL();
        if (smsf0008 != null && (doc = smsf0008.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
        this.memberinformationcount = 0;
        this.memberinformationvbox.getChildren().clear();
        this.cgtexemptionvbox.getChildren().clear();
        if (smsf0008 != null) {
            GlenixPane sw;
            List<GlenixElement> ges = smsf0008.getChildElementSet("MemberInformation");
            for (GlenixElement ge : ges) {
                sw = this.addMemberInformation();
                Document doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                ((TaxReturnSMSF0008MemberInformationVBox)sw).getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
            ges = smsf0008.getChildElementSet("CapitalGainsTax.ExemptionOrRolloverApplied.Code");
            for (GlenixElement ge : ges) {
                sw = this.addGlenixLabelCGTCodeCombo();
                ((GlenixLabelBlankNoYesCombo)sw).setGlenixElementValue(ge.getGlenixElementValue());
            }
        }
        if ((taabn = this.Identifiers_AustralianBusinessNumber_Identifier_INT.getGlenixElementValue()) != null && !taabn.isEmpty()) {
            this.intermediarysection.setVisible(true);
            this.intermediarysection.setManaged(true);
        } else {
            this.intermediarysection.setVisible(false);
            this.intermediarysection.setManaged(false);
        }
        this.expandTitlePanes();
    }

    protected Double getDouble(GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    protected Double addDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return result;
        }
        return d + result;
    }

    protected Double subtractDouble(Double d, Double d2) {
        Double result = d2;
        if (result == null) {
            return d;
        }
        if (d == null) {
            return -d2.doubleValue();
        }
        return d - d2;
    }

    protected Double addDouble(GlenixLabelText glt1, GlenixLabelText glt2) {
        Double glt1d = glt1.getDouble();
        if (glt1d == null) {
            return glt2.getDouble();
        }
        Double glt2d = glt2.getDouble();
        if (glt2d == null) {
            return glt1d;
        }
        return glt1d + glt2d;
    }

    protected Double subtractDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return -result.doubleValue();
        }
        return d - result;
    }

    protected Double addDouble(Double d, Double dd) {
        if (dd == null) {
            return d;
        }
        if (d == null) {
            return dd;
        }
        return d + dd;
    }

    public void setBusinessDetails(BusinessMasterFile businessMasterFile) {
        if (businessMasterFile == null) {
            this.Identifiers_AustralianBusinessNumber_Identifier.setText(null);
            this.Identifiers_TaxFileNumber_Identifier.setText(null);
            this.OrganisationNameDetails_OrganisationalName_Text.setText(null);
            this.AddressDetails_Line1_Text.setText(null);
            this.AddressDetails_Line2_Text.setText(null);
            this.AddressDetails_LocalityName_Text.setText(null);
            this.AddressDetails_StateOrTerritory_Code.setText(null);
            this.AddressDetails_Postcode_Text.setText(null);
            this.AddressDetails_Country_Code.setGlenixElementValue(null);
        } else {
            this.Identifiers_AustralianBusinessNumber_Identifier.setText(businessMasterFile.getBusinessABN());
            this.Identifiers_TaxFileNumber_Identifier.setText(businessMasterFile.getBusinessTFN());
            this.OrganisationNameDetails_OrganisationalName_Text.setText(businessMasterFile.getBusinessLegalName());
            TFND0004AddressDetailsBusiness addr = businessMasterFile.getBusinessPostalAddress();
            if (addr != null) {
                this.AddressDetails_Line1_Text.setText(addr.getLine1T());
                this.AddressDetails_Line2_Text.setText(addr.getLine2T());
                this.AddressDetails_LocalityName_Text.setText(addr.getLocalityNameT());
                this.AddressDetails_StateOrTerritory_Code.setText(addr.getStateOrTerritoryC());
                this.AddressDetails_Postcode_Text.setText(addr.getPostcodeT());
                this.AddressDetails_Country_Code.setGlenixElementValue(addr.getCountryC());
            } else {
                this.AddressDetails_Line1_Text.setText(null);
                this.AddressDetails_Line2_Text.setText(null);
                this.AddressDetails_LocalityName_Text.setText(null);
                this.AddressDetails_StateOrTerritory_Code.setText(null);
                this.AddressDetails_Postcode_Text.setText(null);
                this.AddressDetails_Country_Code.setGlenixElementValue(null);
            }
        }
    }

    public void setProfileDetails(Profile profileXBRL) {
        AgentDetails agentDetails = null;
        if (profileXBRL != null) {
            agentDetails = profileXBRL.getAgentDetails();
        }
        String agentABN = null;
        if (agentDetails != null) {
            agentABN = agentDetails.getAgentABN();
        }
        if (agentABN == null || agentABN.isEmpty()) {
            this.Identifiers_AustralianBusinessNumber_Identifier_INT.setText(null);
            this.Identifiers_TaxAgentNumber_Identifier.setText(null);
            this.ElectronicContact_Telephone_ServiceLine_Code_INT.setGlenixElementValue(null);
            this.ElectronicContact_Telephone_Area_Code_INT.setText(null);
            this.ElectronicContact_Telephone_Minimal_Number_INT.setText(null);
            this.agentDeclaration_SignatoryIdentifier_Text.setText(null);
            this.agentDeclaration_Signature_Date.setGlenixElementValue(null);
            this.agentDeclaration_StatementAccepted_Indicator.setGlenixElementValue(null);
            this.OrganisationNameDetails_OrganisationalName_Text_INT.setText(null);
            this.intermediarysection.setVisible(false);
            this.intermediarysection.setManaged(false);
            this.Declaration_StatementAccepted_Indicator.setGlenixElementValue(null);
            this.Declaration_StatementAccepted_Indicator.getGlenixController().enableGlenixXBRL();
            this.Declaration_Signature_Date.getGlenixController().enableGlenixXBRL();
            this.Declaration_SignatoryIdentifier_Text.getGlenixController().enableGlenixXBRL();
            this.PersonUnstructuredName_FullName_Text.setText(this.Declaration_SignatoryIdentifier_Text.getText());
            this.Declaration_SignatoryIdentifier_Text.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.PersonUnstructuredName_FullName_Text.setText(this.Declaration_SignatoryIdentifier_Text.getText())));
            String declarationText = "I declare that current trustees and directors have authorised this annual return and it is documented as such in the SMSF's records. I have received the audit report and I am aware of any matters raised. I declare that the information on this annual return, including any attached schedules and additional documentation is true and correct. I also authorise the ATO to make any tax refunds to the nominated bank account (if applicable).";
            this.Declaration_Statement_Text.setGlenixElementValue(declarationText);
        } else {
            this.agentDeclaration_StatementAccepted_Indicator.setGlenixElementValue(null);
            this.Identifiers_AustralianBusinessNumber_Identifier_INT.setText(agentABN);
            this.Identifiers_TaxAgentNumber_Identifier.setText(agentDetails.getAgentNumber());
            this.OrganisationNameDetails_OrganisationalName_Text_INT.setText(agentDetails.getAgentLegalName());
            ProfileElectronicContact ec = agentDetails.getAgentElectronicContact();
            if (ec != null) {
                this.ElectronicContact_Telephone_ServiceLine_Code_INT.setGlenixElementValue(ec.getElectronicContactTelephoneServiceLineCode());
                this.ElectronicContact_Telephone_Area_Code_INT.setText(ec.getTelephoneAreaC());
                this.ElectronicContact_Telephone_Minimal_Number_INT.setText(ec.getTelephoneMinimalN());
            } else {
                this.ElectronicContact_Telephone_ServiceLine_Code_INT.setGlenixElementValue(null);
                this.ElectronicContact_Telephone_Area_Code_INT.setText(null);
                this.ElectronicContact_Telephone_Minimal_Number_INT.setText(null);
            }
            this.intermediarysection.setVisible(true);
            this.intermediarysection.setManaged(true);
            this.Declaration_StatementAccepted_Indicator.getGlenixController().disableGlenixXBRL();
            this.Declaration_Signature_Date.getGlenixController().disableGlenixXBRL();
            this.Declaration_SignatoryIdentifier_Text.getGlenixController().disableGlenixXBRL();
            this.Declaration_StatementAccepted_Indicator.setGlenixElementValue(null);
            this.Declaration_Signature_Date.setGlenixElementValue(null);
            this.Declaration_SignatoryIdentifier_Text.setGlenixElementValue(null);
            this.PersonUnstructuredName_FullName_Text.setText(null);
            String declarationText = "I declare that:\n* All of the information I have provided to the agent for the preparation of this Self-managed superannuation fund return and attached schedules is true and correct\n* I authorise the agent to give this document to the Commissioner of Taxation.";
            this.Declaration_Statement_Text.setGlenixElementValue(declarationText);
        }
    }

    protected String formatTwoDp(Double amount) {
        if (amount == null) {
            return null;
        }
        return this.format2dp.format(amount);
    }

    public void setAllReportItemOrderNumbers() {
        int count = 1;
        for (Node n : this.memberinformationvbox.getChildren()) {
            if (!(n instanceof TaxReturnSMSF0008MemberInformationVBox)) continue;
            ((TaxReturnSMSF0008MemberInformationVBox)n).setReportItemOrderNumber("" + count);
            ++count;
        }
    }

    @FXML
    protected TaxReturnSMSF0008MemberInformationVBox addMemberInformation() {
        try {
            final TaxReturnSMSF0008MemberInformationVBox sw = new TaxReturnSMSF0008MemberInformationVBox();
            sw.getGlenixController().initialize(null, null);
            this.memberinformationvbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete member information");
            this.memberinformationvbox.getChildren().add((Object)b);
            ++this.memberinformationcount;
            sw.setReportItemOrderNumber("" + this.memberinformationcount);
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnSMSF0008Controller.this.memberinformationvbox.getChildren().remove((Object)sw);
                    TaxReturnSMSF0008Controller.this.memberinformationvbox.getChildren().remove((Object)b);
                    TaxReturnSMSF0008Controller.this.updateTotalMemberClosingBalances();
                    --TaxReturnSMSF0008Controller.this.memberinformationcount;
                    TaxReturnSMSF0008Controller.this.setAllReportItemOrderNumbers();
                }
            });
            sw.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    TaxReturnSMSF0008Controller.this.updateTotalMemberClosingBalances();
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    public void updateTotalMemberClosingBalances() {
        Double total = null;
        for (Node n : this.memberinformationvbox.getChildren()) {
            if (!(n instanceof TaxReturnSMSF0008MemberInformationVBox)) continue;
            total = this.addDouble(total, ((TaxReturnSMSF0008MemberInformationVBox)n).getClosingBalance());
        }
        if (total == null) {
            this.Equity_MemberAccountBalance_Amount_Closing.setGlenixElementValue(null);
        } else {
            this.Equity_MemberAccountBalance_Amount_Closing.setGlenixElementValue("" + total.intValue());
        }
    }

    public void updateLimitedRecourseInit() {
        this.Assets_LimitedRecourseBorrowing_Amount_JAUS_AustResidentialRealProperty.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateLimitedRecourse()));
        this.Assets_LimitedRecourseBorrowing_Amount_JAUS_AustNonResidentialRealProperty.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateLimitedRecourse()));
        this.Assets_LimitedRecourseBorrowing_Amount_JAUS_OverseasRealProperty.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateLimitedRecourse()));
        this.Assets_LimitedRecourseBorrowing_Amount_JAUS_AustralianShares.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateLimitedRecourse()));
        this.Assets_LimitedRecourseBorrowing_Amount_JAUS_OtherShares.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateLimitedRecourse()));
        this.Assets_LimitedRecourseBorrowing_Amount_JAUS_Other.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateLimitedRecourse()));
    }

    public void updateLimitedRecourse() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Assets_LimitedRecourseBorrowing_Amount_JAUS_AustResidentialRealProperty);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_LimitedRecourseBorrowing_Amount_JAUS_AustNonResidentialRealProperty);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_LimitedRecourseBorrowing_Amount_JAUS_OverseasRealProperty);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_LimitedRecourseBorrowing_Amount_JAUS_AustralianShares);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_LimitedRecourseBorrowing_Amount_JAUS_OtherShares);
        if ((total = this.addDouble(total, (GlenixLabelText)this.Assets_LimitedRecourseBorrowing_Amount_JAUS_Other)) == null) {
            this.Assets_LimitedRecourseBorrowing_Amount_JAUS.setGlenixElementValue(null);
        } else {
            this.Assets_LimitedRecourseBorrowing_Amount_JAUS.setGlenixElementValue("" + total.intValue());
        }
    }

    public void updateTotalAssetsInit() {
        this.Assets_Investment_UnitTrustsListed_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
        this.Assets_Investment_UnitTrustsUnlisted_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
        this.Assets_Investment_SecuritiesAndOrInsurancePoliciesHeldInLifeCompanies_Amount_Closing_JAUS_Instant.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
        this.Assets_ManagedInvestments_Amount_Closing_JAUS_Instant.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
        this.Assets_CashAndLiquidAssets_Total_Amount_Closing_JAUS_Instant.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
        this.Assets_DebtSecurities_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
        this.Assets_Investment_EquitySecuritiesListed_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
        this.Assets_LoansAndReceivables_Held_Amount_Closing_JAUS_Instant.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
        this.Assets_Investment_EquitySecuritiesUnlisted_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
        this.Assets_LimitedRecourseBorrowing_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
        this.Assets_Investment_PropertyNonResidential_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
        this.Assets_Investment_PropertyResidential_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
        this.Assets_Investment_Collectables_Amount_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
        this.Assets_Other_Amount_Closing_JAUS_Instant.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
        this.Assets_Investment_EquitySecurities_Amount_Closing_JFOREIGN_Instant.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
        this.Assets_Investment_PropertyNonResidential_Amount_JFOREIGN.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
        this.Assets_Investment_PropertyResidential_Amount_JFOREIGN.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
        this.Assets_ManagedInvestments_Amount_Closing_JFOREIGN_Instant.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
        this.Assets_Other_Amount_Closing_JFOREIGN_Instant.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssets()));
    }

    public void updateTotalAssets() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Assets_Investment_UnitTrustsListed_Amount_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_Investment_UnitTrustsUnlisted_Amount_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_Investment_SecuritiesAndOrInsurancePoliciesHeldInLifeCompanies_Amount_Closing_JAUS_Instant);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_ManagedInvestments_Amount_Closing_JAUS_Instant);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_CashAndLiquidAssets_Total_Amount_Closing_JAUS_Instant);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_DebtSecurities_Amount_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_Investment_EquitySecuritiesListed_Amount_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_LoansAndReceivables_Held_Amount_Closing_JAUS_Instant);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_Investment_EquitySecuritiesUnlisted_Amount_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_LimitedRecourseBorrowing_Amount_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_Investment_PropertyNonResidential_Amount_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_Investment_PropertyResidential_Amount_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_Investment_Collectables_Amount_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_Other_Amount_Closing_JAUS_Instant);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_Investment_EquitySecurities_Amount_Closing_JFOREIGN_Instant);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_Investment_PropertyNonResidential_Amount_JFOREIGN);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_Investment_PropertyResidential_Amount_JFOREIGN);
        total = this.addDouble(total, (GlenixLabelText)this.Assets_ManagedInvestments_Amount_Closing_JFOREIGN_Instant);
        if ((total = this.addDouble(total, (GlenixLabelText)this.Assets_Other_Amount_Closing_JFOREIGN_Instant)) == null) {
            this.TotalAssets.setGlenixElementValue(null);
        } else {
            this.TotalAssets.setGlenixElementValue("" + total.intValue());
        }
    }

    public void updateTotalBorrowingsInit() {
        this.Liabilities_BorrowingsLimited_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalBorrowings()));
        this.Liabilities_BorrowingsTemporary_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalBorrowings()));
        this.Liabilities_BorrowingsOther_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalBorrowings()));
    }

    public void updateTotalBorrowings() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Liabilities_BorrowingsLimited_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.Liabilities_BorrowingsTemporary_Amount);
        if ((total = this.addDouble(total, (GlenixLabelText)this.Liabilities_BorrowingsOther_Amount)) == null) {
            this.Liabilities_Borrowings_Amount.setGlenixElementValue(null);
        } else {
            this.Liabilities_Borrowings_Amount.setGlenixElementValue("" + total.intValue());
        }
    }

    public void updateTotalLiabilitiesInit() {
        this.Liabilities_Borrowings_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalLiabilities()));
        this.Equity_MemberAccountBalance_Amount_Closing.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalLiabilities()));
        this.Equity_NetAssetsNotAllocatedToMembers_Amount_Closing_Instant.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalLiabilities()));
        this.Liabilities_Other_Amount_RP_Instant.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalLiabilities()));
    }

    public void updateTotalLiabilities() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Liabilities_Borrowings_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.Equity_MemberAccountBalance_Amount_Closing);
        total = this.addDouble(total, (GlenixLabelText)this.Equity_NetAssetsNotAllocatedToMembers_Amount_Closing_Instant);
        if ((total = this.addDouble(total, (GlenixLabelText)this.Liabilities_Other_Amount_RP_Instant)) == null) {
            this.TotalLiabilities.setGlenixElementValue(null);
        } else {
            this.TotalLiabilities.setGlenixElementValue("" + total.intValue());
        }
    }

    public void updateAssessableContributionsInit() {
        this.SuperannuationContribution_EmployerAssessable_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateAssessableContributions()));
        this.SuperannuationContribution_PersonalAssessable_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateAssessableContributions()));
        this.SuperannuationContribution_EmployerContributionsTaxFileNumberNotQuoted_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> {
            this.updateAssessableContributions();
            this.calculateNoTFNContributions();
        }));
        this.SuperannuationContribution_LiabilityTransferToLifeInsuranceCompanyOrPooledSuperannuationTrustAssessable_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateAssessableContributions()));
    }

    public void updateAssessableContributions() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.SuperannuationContribution_EmployerAssessable_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.SuperannuationContribution_PersonalAssessable_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.SuperannuationContribution_EmployerContributionsTaxFileNumberNotQuoted_Amount);
        if ((total = this.subtractDouble(total, this.SuperannuationContribution_LiabilityTransferToLifeInsuranceCompanyOrPooledSuperannuationTrustAssessable_Amount)) == null) {
            this.AssessableContributions.setGlenixElementValue(null);
        } else {
            this.AssessableContributions.setGlenixElementValue("" + total.intValue());
        }
    }

    public void updateNonArmsLengthIncomeInit() {
        this.Income_NonArmsLengthPrivateCompanyDividendsNet_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNonArmsLengthIncome()));
        this.Income_NonArmsLengthTrustDistributionsNet_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNonArmsLengthIncome()));
        this.Income_NonArmsLengthOtherNet_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNonArmsLengthIncome()));
    }

    public void updateNonArmsLengthIncome() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Income_NonArmsLengthPrivateCompanyDividendsNet_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.Income_NonArmsLengthTrustDistributionsNet_Amount);
        if ((total = this.addDouble(total, (GlenixLabelText)this.Income_NonArmsLengthOtherNet_Amount)) == null) {
            this.NonArmsLengthNetAmount.setGlenixElementValue(null);
        } else {
            this.NonArmsLengthNetAmount.setGlenixElementValue("" + total.intValue());
        }
    }

    public void updateGrossIncomeInit() {
        this.Income_CapitalGainsNet_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossIncome()));
        this.Income_RentLeasingHiringGross_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossIncome()));
        this.Income_Interest_Gross_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossIncome()));
        this.Income_ForestryManagedInvestmentScheme_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossIncome()));
        this.Income_Net_Amount_JFOREIGN.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossIncome()));
        this.IncomeTax_FrankingCredits_ReceivedFromNewZealandCompanies_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossIncome()));
        this.Equity_InternationalDealings_ForeignFundTransfers_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossIncome()));
        this.Remuneration_ABNNotQuotedPaymentGross_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossIncome()));
        this.Income_PartnershipDistributionGross_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossIncome()));
        this.Income_DividendsUnfranked_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossIncome()));
        this.Income_DividendsFranked_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossIncome()));
        this.IncomeTax_FrankingCredits_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossIncome()));
        this.Income_TrustDistributionGross_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossIncome()));
        this.AssessableContributions.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossIncome()));
        this.Income_Other_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossIncome()));
        this.Income_AssessableIncomeDueToFundTaxStatusChange_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossIncome()));
        this.NonArmsLengthNetAmount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossIncome()));
    }

    public void updateGrossIncome() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Income_CapitalGainsNet_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.Income_RentLeasingHiringGross_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.Income_Interest_Gross_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.Income_ForestryManagedInvestmentScheme_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.Income_Net_Amount_JFOREIGN);
        total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_FrankingCredits_ReceivedFromNewZealandCompanies_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.Equity_InternationalDealings_ForeignFundTransfers_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.Remuneration_ABNNotQuotedPaymentGross_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.Income_PartnershipDistributionGross_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.Income_DividendsUnfranked_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.Income_DividendsFranked_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_FrankingCredits_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.Income_TrustDistributionGross_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.AssessableContributions);
        total = this.addDouble(total, (GlenixLabelText)this.Income_Other_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.Income_AssessableIncomeDueToFundTaxStatusChange_Amount);
        if ((total = this.addDouble(total, (GlenixLabelText)this.NonArmsLengthNetAmount)) == null) {
            this.GrossIncome.setGlenixElementValue(null);
        } else {
            this.GrossIncome.setGlenixElementValue("" + total.intValue());
        }
    }

    public void updateTotalAssessableIncomeInit() {
        this.TaxConcession_PensionIncomeExemptDeduction_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> {
            this.TaxConcession_PensionIncomeExemptDeduction_Amount_Restated.setText(this.TaxConcession_PensionIncomeExemptDeduction_Amount.getText());
            this.updateTotalAssessableIncome();
        }));
        this.GrossIncome.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssessableIncome()));
        this.Income_AssessableOther_Indicator.setSingleComboChangeListener((ChangeListener<Pair<String, String>>)((ChangeListener)(s, s1, s2) -> this.updateTotalAssessableIncome()));
    }

    public void updateTotalAssessableIncome() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.GrossIncome);
        if ((total = this.subtractDouble(total, this.TaxConcession_PensionIncomeExemptDeduction_Amount)) == null) {
            this.TotalAssessableIncome.setGlenixElementValue(null);
        } else {
            String otherIndicator = this.Income_AssessableOther_Indicator.getGlenixElementValue();
            if (otherIndicator != null && otherIndicator.equals("false") && total < 0.0) {
                this.TotalAssessableIncome.setGlenixElementValue("0");
            } else {
                this.TotalAssessableIncome.setGlenixElementValue("" + total.intValue());
            }
        }
    }

    public void updateTotalDeductibleExpensesInit() {
        this.Expense_Interest_Amount_Deductible_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalDeductibleExpenses()));
        this.Expense_Interest_Amount_Deductible_JFOREIGN.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalDeductibleExpenses()));
        this.Expense_CapitalWorks_Amount_Deductible.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalDeductibleExpenses()));
        this.Expense_DepreciationandAmortisation_Amount_Deductible.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalDeductibleExpenses()));
        this.Expense_PremiumsDeathOrDisability_Amount_Deductible.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalDeductibleExpenses()));
        this.Expense_DeathBenefitLumpSumIncrease_Amount_Deductible.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalDeductibleExpenses()));
        this.Expense_Operating_ApprovedAuditorFee_Amount_Deductible.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalDeductibleExpenses()));
        this.Expense_Investment_Amount_Deductible.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalDeductibleExpenses()));
        this.Expense_Operating_GeneralManagementAndAdministrationFees_Amount_Deductible.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalDeductibleExpenses()));
        this.Expense_ForestryManagedInvestmentScheme_Amount_Deductible.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalDeductibleExpenses()));
        this.Expense_Other_Amount_Deductible.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalDeductibleExpenses()));
        this.IncomeTax_Deduction_TaxLossesDeducted_Amount_Deductible.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalDeductibleExpenses()));
    }

    public void updateTotalDeductibleExpenses() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Interest_Amount_Deductible_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Interest_Amount_Deductible_JFOREIGN);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_CapitalWorks_Amount_Deductible);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_DepreciationandAmortisation_Amount_Deductible);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_PremiumsDeathOrDisability_Amount_Deductible);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_DeathBenefitLumpSumIncrease_Amount_Deductible);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Operating_ApprovedAuditorFee_Amount_Deductible);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Investment_Amount_Deductible);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Operating_GeneralManagementAndAdministrationFees_Amount_Deductible);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_ForestryManagedInvestmentScheme_Amount_Deductible);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Other_Amount_Deductible);
        if ((total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_Deduction_TaxLossesDeducted_Amount_Deductible)) == null) {
            this.TotalDeductibleExpenses.setGlenixElementValue(null);
        } else {
            this.TotalDeductibleExpenses.setGlenixElementValue("" + total.intValue());
        }
    }

    public void updateTotalNonDeductibleExpensesInit() {
        this.Expense_Interest_Amount_NonDeductible_JAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalNonDeductibleExpenses()));
        this.Expense_Interest_Amount_NonDeductible_JFOREIGN.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalNonDeductibleExpenses()));
        this.Expense_CapitalWorks_Amount_NonDeductible.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalNonDeductibleExpenses()));
        this.Expense_DepreciationandAmortisation_Amount_NonDeductible.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalNonDeductibleExpenses()));
        this.Expense_PremiumsDeathOrDisability_Amount_NonDeductible.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalNonDeductibleExpenses()));
        this.Expense_Operating_ApprovedAuditorFee_Amount_NonDeductible.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalNonDeductibleExpenses()));
        this.Expense_Investment_Amount_NonDeductible.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalNonDeductibleExpenses()));
        this.Expense_Operating_GeneralManagementAndAdministrationFees_Amount_NonDeductible.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalNonDeductibleExpenses()));
        this.Expense_ForestryManagedInvestmentScheme_Amount_NonDeductible.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalNonDeductibleExpenses()));
        this.Expense_Other_Amount_NonDeductible.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalNonDeductibleExpenses()));
    }

    public void updateTotalNonDeductibleExpenses() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Interest_Amount_NonDeductible_JAUS);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Interest_Amount_NonDeductible_JFOREIGN);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_CapitalWorks_Amount_NonDeductible);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_DepreciationandAmortisation_Amount_NonDeductible);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_PremiumsDeathOrDisability_Amount_NonDeductible);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Operating_ApprovedAuditorFee_Amount_NonDeductible);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Investment_Amount_NonDeductible);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_Operating_GeneralManagementAndAdministrationFees_Amount_NonDeductible);
        total = this.addDouble(total, (GlenixLabelText)this.Expense_ForestryManagedInvestmentScheme_Amount_NonDeductible);
        if ((total = this.addDouble(total, (GlenixLabelText)this.Expense_Other_Amount_NonDeductible)) == null) {
            this.TotalNonDeductibleExpenses.setGlenixElementValue(null);
        } else {
            this.TotalNonDeductibleExpenses.setGlenixElementValue("" + total.intValue());
        }
    }

    public void updateTaxableIncomeInit() {
        this.TotalDeductibleExpenses.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> {
            this.updateTaxableIncome();
            this.updateTotalExpenses();
        }));
        this.TotalAssessableIncome.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTaxableIncome()));
    }

    public void updateTaxableIncome() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.TotalAssessableIncome);
        if ((total = this.subtractDouble(total, this.TotalDeductibleExpenses)) == null) {
            this.Income_Taxable_Amount.setGlenixElementValue(null);
        } else {
            this.Income_Taxable_Amount.setGlenixElementValue("" + total.intValue());
        }
    }

    public void updateTotalExpensesInit() {
        this.TotalNonDeductibleExpenses.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTotalExpenses()));
    }

    public void updateTotalExpenses() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.TotalDeductibleExpenses);
        if ((total = this.addDouble(total, (GlenixLabelText)this.TotalNonDeductibleExpenses)) == null) {
            this.Expense_Total_Amount.setGlenixElementValue(null);
        } else {
            this.Expense_Total_Amount.setGlenixElementValue("" + total.intValue());
        }
    }

    public void updateNonRefundableNonCarryForwardInit() {
        this.Income_InternationalDealings_TaxOffset_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNonRefundableNonCarryForward()));
        this.IncomeTax_TaxOffsetsAndRebatesTotal_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNonRefundableNonCarryForward()));
    }

    public void updateNonRefundableNonCarryForward() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Income_InternationalDealings_TaxOffset_Amount);
        if ((total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_TaxOffsetsAndRebatesTotal_Amount)) == null) {
            this.IncomeTax_TaxOffsetNonRefundableNonCarryForward_Amount.setGlenixElementValue(null);
        } else {
            this.IncomeTax_TaxOffsetNonRefundableNonCarryForward_Amount.setGlenixElementValue(this.formatTwoDp(total));
        }
    }

    public void updateNonRefundableCarryForwardInit() {
        this.TaxOffsetClaim_NonRefundableOther_Amount_LimitedPartners.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNonRefundableCarryForward()));
        this.TaxOffsetClaim_NonRefundableOther_Amount_LimitedPartners_YPrevious.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNonRefundableCarryForward()));
        this.TaxOffsetClaim_NonRefundableOther_Amount_Investor.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNonRefundableCarryForward()));
        this.TaxOffsetClaim_NonRefundableOther_Amount_Investor_YPrevious.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateNonRefundableCarryForward()));
    }

    public void updateNonRefundableCarryForward() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.TaxOffsetClaim_NonRefundableOther_Amount_LimitedPartners);
        total = this.addDouble(total, (GlenixLabelText)this.TaxOffsetClaim_NonRefundableOther_Amount_LimitedPartners_YPrevious);
        total = this.addDouble(total, (GlenixLabelText)this.TaxOffsetClaim_NonRefundableOther_Amount_Investor);
        if ((total = this.addDouble(total, (GlenixLabelText)this.TaxOffsetClaim_NonRefundableOther_Amount_Investor_YPrevious)) == null) {
            this.IncomeTax_TaxOffsetNonRefundableCarryForward_Amount.setGlenixElementValue(null);
        } else {
            this.IncomeTax_TaxOffsetNonRefundableCarryForward_Amount.setGlenixElementValue(this.formatTwoDp(total));
        }
    }

    public void updateRefundableInit() {
        this.IncomeTax_FrankingCredits_Refundable_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateRefundable()));
        this.IncomeTax_TaxOffsetTFNNotQuoted_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateRefundable()));
        this.IncomeTax_TaxOffsetEntitlementForNationalRentalAffordabilityScheme_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateRefundable()));
        this.IncomeTax_TaxOffsetExplorationCredits_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateRefundable()));
    }

    public void updateRefundable() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_FrankingCredits_Refundable_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_TaxOffsetTFNNotQuoted_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_TaxOffsetEntitlementForNationalRentalAffordabilityScheme_Amount);
        if ((total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_TaxOffsetExplorationCredits_Amount)) == null) {
            this.IncomeTax_TotalRefundableTaxOffsets_Amount.setGlenixElementValue(null);
        } else {
            this.IncomeTax_TotalRefundableTaxOffsets_Amount.setGlenixElementValue(this.formatTwoDp(total));
        }
    }

    public void updateCreditsEligibleTotalInit() {
        this.Income_Interest_EarlyPaymentCredit_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateCreditsEligibleTotal()));
        this.IncomeTax_PayAsYouGoWithholding_CreditForAmountsWithheldFromForeignResidents_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateCreditsEligibleTotal()));
        this.IncomeTax_PayAsYouGoWithholding_CreditForAmountsWithheldTFNNotQuotedAndABNNotQuoted_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateCreditsEligibleTotal()));
        this.IncomeTax_PayAsYouGoWithholding_CreditForTaxWithheldFromCloselyHeldTrust_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateCreditsEligibleTotal()));
        this.IncomeTax_TaxOffsetCalculatedInterestTFNNotQuoted_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateCreditsEligibleTotal()));
        this.IncomeTax_PayAsYouGoWithholding_CreditForCapitalGainsWithheldFromForeignResidents_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateCreditsEligibleTotal()));
    }

    public void updateCreditsEligibleTotal() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.Income_Interest_EarlyPaymentCredit_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_PayAsYouGoWithholding_CreditForAmountsWithheldFromForeignResidents_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_PayAsYouGoWithholding_CreditForAmountsWithheldTFNNotQuotedAndABNNotQuoted_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_PayAsYouGoWithholding_CreditForTaxWithheldFromCloselyHeldTrust_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_TaxOffsetCalculatedInterestTFNNotQuoted_Amount);
        if ((total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_PayAsYouGoWithholding_CreditForCapitalGainsWithheldFromForeignResidents_Amount)) == null) {
            this.IncomeTax_Deduction_CreditsEligibleTotal_Amount.setGlenixElementValue(null);
        } else {
            this.IncomeTax_Deduction_CreditsEligibleTotal_Amount.setGlenixElementValue(this.formatTwoDp(total));
        }
    }

    public void calculateTaxOnTaxableIncomeInit() {
        this.SuperannuationFundDetails_AustralianSuperannuationFundStatus_Indicator.setSingleComboChangeListener((ChangeListener<Pair<String, String>>)((ChangeListener)(s, s1, s2) -> {
            this.calculateTaxOnTaxableIncome();
            this.calculateNoTFNContributions();
        }));
        this.Income_Taxable_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTaxOnTaxableIncome()));
    }

    public void calculateTaxOnTaxableIncome() {
        Double total = null;
        if ((total = this.addDouble(total, (GlenixLabelText)this.Income_Taxable_Amount)) == null) {
            this.IncomeTax_TotalTaxOnTaxableIncome_Amount.setGlenixElementValue(null);
        } else {
            String val = this.SuperannuationFundDetails_AustralianSuperannuationFundStatus_Indicator.getGlenixElementValue();
            if (val == null || !val.equals("true")) {
                total = total * 0.45;
            } else {
                total = total * 0.15;
                Double nal = this.NonArmsLengthNetAmount.getDouble();
                if (nal != null && nal > 0.0) {
                    total = total + nal * 0.3;
                }
            }
            if (total < 0.0) {
                total = 0.0;
            }
            this.IncomeTax_TotalTaxOnTaxableIncome_Amount.setGlenixElementValue(this.formatTwoDp(total));
        }
    }

    public void calculateNoTFNContributions() {
        Double total = null;
        if ((total = this.addDouble(total, (GlenixLabelText)this.SuperannuationContribution_EmployerContributionsTaxFileNumberNotQuoted_Amount)) == null) {
            this.IncomeTax_TFNNotQuotedContributionsTax_Amount.setGlenixElementValue(null);
        } else {
            String val = this.SuperannuationFundDetails_AustralianSuperannuationFundStatus_Indicator.getGlenixElementValue();
            total = val == null || !val.equals("true") ? Double.valueOf(total * 0.02) : Double.valueOf(total * 0.32);
            this.IncomeTax_TFNNotQuotedContributionsTax_Amount.setGlenixElementValue(this.formatTwoDp(total));
        }
    }

    public void updateGrossTaxInit() {
        this.IncomeTax_TotalTaxOnTaxableIncome_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossTax()));
        this.IncomeTax_TFNNotQuotedContributionsTax_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateGrossTax()));
    }

    public void updateGrossTax() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_TotalTaxOnTaxableIncome_Amount);
        if ((total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_TFNNotQuotedContributionsTax_Amount)) == null) {
            this.IncomeTax_TaxableGross_Amount.setGlenixElementValue(null);
        } else {
            this.IncomeTax_TaxableGross_Amount.setGlenixElementValue(this.formatTwoDp(total));
        }
    }

    public void updateSubtotalTaxPayableInit() {
        this.IncomeTax_TaxableGross_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateSubtotalTaxPayable()));
        this.IncomeTax_TaxOffsetNonRefundableNonCarryForward_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateSubtotalTaxPayable()));
    }

    public void updateSubtotalTaxPayable() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_TaxableGross_Amount);
        if ((total = this.subtractDouble(total, this.IncomeTax_TaxOffsetNonRefundableNonCarryForward_Amount)) == null) {
            this.IncomeTax_SubtotalTaxPayable_Amount.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.IncomeTax_SubtotalTaxPayable_Amount.setGlenixElementValue(this.formatTwoDp(total));
        }
    }

    public void updateCarriedFwdSubtotalTaxPayableInit() {
        this.IncomeTax_TaxOffsetNonRefundableCarryForward_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateCarriedFwdSubtotalTaxPayable()));
        this.IncomeTax_SubtotalTaxPayable_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateCarriedFwdSubtotalTaxPayable()));
    }

    public void updateCarriedFwdSubtotalTaxPayable() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_SubtotalTaxPayable_Amount);
        if ((total = this.subtractDouble(total, this.IncomeTax_TaxOffsetNonRefundableCarryForward_Amount)) == null) {
            this.IncomeTax_TaxOffsetCarriedForwardSubTotal_Amount.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.IncomeTax_TaxOffsetCarriedForwardSubTotal_Amount.setGlenixElementValue(this.formatTwoDp(total));
        }
    }

    public void updateTaxPayableInit() {
        this.IncomeTax_TotalRefundableTaxOffsets_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTaxPayable()));
        this.IncomeTax_TaxOffsetCarriedForwardSubTotal_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateTaxPayable()));
    }

    public void updateTaxPayable() {
        Double total = null;
        total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_TaxOffsetCarriedForwardSubTotal_Amount);
        if ((total = this.subtractDouble(total, this.IncomeTax_TotalRefundableTaxOffsets_Amount)) == null) {
            this.IncomeTax_Payable_Amount.setGlenixElementValue(null);
            this.IncomeTax_TotalRemainderOfRefundableTaxOffsets_Amount.setGlenixElementValue("0.00");
        } else if (total < 0.0) {
            this.IncomeTax_TotalRemainderOfRefundableTaxOffsets_Amount.setGlenixElementValue(this.formatTwoDp(-total.doubleValue()));
            this.IncomeTax_Payable_Amount.setGlenixElementValue("0.00");
        } else {
            this.IncomeTax_Payable_Amount.setGlenixElementValue(this.formatTwoDp(total));
            this.IncomeTax_TotalRemainderOfRefundableTaxOffsets_Amount.setGlenixElementValue("0.00");
        }
    }

    public void updateDueOrRefundableInit() {
        this.IncomeTax_Payable_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateDueOrRefundable()));
        this.IncomeTax_TotalRemainderOfRefundableTaxOffsets_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateDueOrRefundable()));
        this.IncomeTax_Deduction_CreditsEligibleTotal_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateDueOrRefundable()));
        this.InternationalDealings_AAMInterestSection102_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateDueOrRefundable()));
        this.IncomeTax_LiabilityInstalmentsTotal_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateDueOrRefundable()));
        this.IncomeTax_SupervisoryLevy_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateDueOrRefundable()));
        this.IncomeTax_SupervisoryLevyWoundupAdjustment_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateDueOrRefundable()));
        this.IncomeTax_SupervisoryLevyNewlyRegisteredAdjustment_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.updateDueOrRefundable()));
        this.OrganisationDetails_OperationCease_Indicator.setSingleComboChangeListener((ChangeListener<Pair<String, String>>)((ChangeListener)(s, s1, s2) -> this.updateDueOrRefundable()));
        this.Lodgment_FirstReturn_Indicator.setSingleComboChangeListener((ChangeListener<Pair<String, String>>)((ChangeListener)(s, s1, s2) -> this.updateDueOrRefundable()));
    }

    public void updateDueOrRefundable() {
        Double total = null;
        String val = this.Lodgment_FirstReturn_Indicator.getGlenixElementValue();
        if (val == null || val.equals("false")) {
            this.IncomeTax_SupervisoryLevyNewlyRegisteredAdjustment_Amount.setGlenixElementValue("");
        } else {
            this.IncomeTax_SupervisoryLevyNewlyRegisteredAdjustment_Amount.setGlenixElementValue("259.00");
        }
        val = this.OrganisationDetails_OperationCease_Indicator.getGlenixElementValue();
        if (val == null || val.equals("false")) {
            this.IncomeTax_SupervisoryLevyWoundupAdjustment_Amount.setGlenixElementValue("");
        } else {
            this.IncomeTax_SupervisoryLevyWoundupAdjustment_Amount.setGlenixElementValue("259.00");
        }
        total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_Payable_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.InternationalDealings_AAMInterestSection102_Amount);
        total = this.subtractDouble(total, this.IncomeTax_TotalRemainderOfRefundableTaxOffsets_Amount);
        total = this.subtractDouble(total, this.IncomeTax_Deduction_CreditsEligibleTotal_Amount);
        total = this.subtractDouble(total, this.IncomeTax_LiabilityInstalmentsTotal_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_SupervisoryLevy_Amount);
        total = this.subtractDouble(total, this.IncomeTax_SupervisoryLevyWoundupAdjustment_Amount);
        total = this.addDouble(total, (GlenixLabelText)this.IncomeTax_SupervisoryLevyNewlyRegisteredAdjustment_Amount);
        if (total == null) {
            this.IncomeTax_PayableOrRefundableTotal_Amount.setGlenixElementValue(null);
        } else {
            this.IncomeTax_PayableOrRefundableTotal_Amount.setGlenixElementValue(this.formatTwoDp(total));
        }
    }

    @FXML
    protected GlenixLabelCGTCodeSMSF0008Combo addGlenixLabelCGTCodeCombo() {
        try {
            final GlenixLabelCGTCodeSMSF0008Combo sw = new GlenixLabelCGTCodeSMSF0008Combo();
            sw.getGlenixController().initialize(null, null);
            this.cgtexemptionvbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete exemption or rollover");
            this.cgtexemptionvbox.getChildren().add((Object)b);
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnSMSF0008Controller.this.cgtexemptionvbox.getChildren().remove((Object)sw);
                    TaxReturnSMSF0008Controller.this.cgtexemptionvbox.getChildren().remove((Object)b);
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    public void setTaxReturnDetails(String type, String status, String year, LocalDate startDate, LocalDate endDate) {
        this.type = type;
        this.status = status;
        this.year = year;
        this.startDate = startDate;
        this.endDate = endDate;
        this.Report_TargetFinancial_Year.setGlenixElementValue(year);
    }
}

