/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.tr2018;

import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.Profile;
import au.com.glenix.trn.RS0002;
import au.com.glenix.widget.ErrorDisplay;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixLabelZeroDecimalNumber;
import au.com.glenix.widget.GlenixLabelZeroDecimalPositiveNumber;
import au.com.glenix.widget.GlenixVBox;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TaxReturnRS0002Controller
extends GlenixBranchController {
    private DocumentBuilder dBuilder;
    private RS0002 rs0002;
    private NumberFormat format2dp = new DecimalFormat("#0.00");
    @FXML
    private GlenixVBox rs0002VBox;
    @FXML
    private GlenixLabelLabel Identifiers_TaxFileNumber_Identifier;
    private ErrorDisplay errorDisplay;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Income_RealEstateProperty_Rental_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Income_RealEstateProperty_RentalRelatedOther_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber TotalIncome;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_RealEstateProperty_Marketing_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_RealEstateProperty_BodyCorporate_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_RealEstateProperty_Borrowing_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_RealEstateProperty_Cleaning_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_RealEstateProperty_CouncilRates_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_DepreciationandAmortisation_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_RealEstateProperty_Gardening_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_RealEstateProperty_Insurance_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_RealEstateProperty_LoanInterest_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_LandTax_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_RealEstateProperty_LegalFees_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_RealEstateProperty_PestControl_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_RealEstateProperty_AgentFeesCommission_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_RealEstateProperty_RepairsAndMaintenance_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_RealEstateProperty_CapitalWorksDeduction_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_RealEstateProperty_OfficeSupplies_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_Travel_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_RealEstateProperty_Water_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_RealEstateProperty_Sundry_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber TotalExpenses;
    @FXML
    private GlenixLabelZeroDecimalNumber Income_RealEstateProperty_RentalNet_Amount;

    public TaxReturnRS0002Controller(ErrorDisplay errorDisplay) {
        this.errorDisplay = errorDisplay;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
        }
        this.calculateTotalIncomeInit();
        this.calculateTotalExpensesInit();
        this.calculateNetRentInit();
    }

    public void setModel(RS0002 rs0002) throws Exception {
        Document doc;
        this.rs0002 = rs0002;
        this.clearGlenixXBRL();
        if (rs0002 != null && (doc = rs0002.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
    }

    private Double getDouble(GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    private Double addDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return result;
        }
        return d + result;
    }

    private Double subtractDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return -result.doubleValue();
        }
        return d - result;
    }

    private Double addDouble(Double d, Double dd) {
        if (dd == null) {
            return d;
        }
        if (d == null) {
            return dd;
        }
        return d + dd;
    }

    public void calculateTotalIncomeInit() {
        this.Income_RealEstateProperty_Rental_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalIncome()));
        this.Income_RealEstateProperty_RentalRelatedOther_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalIncome()));
    }

    private void calculateTotalIncome() {
        Double total = null;
        total = this.addDouble(total, this.Income_RealEstateProperty_Rental_Amount);
        if ((total = this.addDouble(total, this.Income_RealEstateProperty_RentalRelatedOther_Amount)) == null) {
            this.TotalIncome.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.TotalIncome.setGlenixElementValue("" + total.intValue());
        }
    }

    public void calculateTotalExpensesInit() {
        this.Expense_RealEstateProperty_Marketing_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
        this.Expense_RealEstateProperty_BodyCorporate_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
        this.Expense_RealEstateProperty_Borrowing_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
        this.Expense_RealEstateProperty_Cleaning_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
        this.Expense_RealEstateProperty_CouncilRates_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
        this.Expense_DepreciationandAmortisation_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
        this.Expense_RealEstateProperty_Gardening_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
        this.Expense_RealEstateProperty_Insurance_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
        this.Expense_RealEstateProperty_LoanInterest_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
        this.Expense_LandTax_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
        this.Expense_RealEstateProperty_LegalFees_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
        this.Expense_RealEstateProperty_PestControl_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
        this.Expense_RealEstateProperty_AgentFeesCommission_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
        this.Expense_RealEstateProperty_RepairsAndMaintenance_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
        this.Expense_RealEstateProperty_CapitalWorksDeduction_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
        this.Expense_RealEstateProperty_OfficeSupplies_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
        this.Expense_Travel_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
        this.Expense_RealEstateProperty_Water_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
        this.Expense_RealEstateProperty_Sundry_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTotalExpenses()));
    }

    private void calculateTotalExpenses() {
        Double total = null;
        total = this.addDouble(total, this.Expense_RealEstateProperty_Marketing_Amount);
        total = this.addDouble(total, this.Expense_RealEstateProperty_BodyCorporate_Amount);
        total = this.addDouble(total, this.Expense_RealEstateProperty_Borrowing_Amount);
        total = this.addDouble(total, this.Expense_RealEstateProperty_Cleaning_Amount);
        total = this.addDouble(total, this.Expense_RealEstateProperty_CouncilRates_Amount);
        total = this.addDouble(total, this.Expense_DepreciationandAmortisation_Amount);
        total = this.addDouble(total, this.Expense_RealEstateProperty_Gardening_Amount);
        total = this.addDouble(total, this.Expense_RealEstateProperty_Insurance_Amount);
        total = this.addDouble(total, this.Expense_RealEstateProperty_LoanInterest_Amount);
        total = this.addDouble(total, this.Expense_LandTax_Amount);
        total = this.addDouble(total, this.Expense_RealEstateProperty_LegalFees_Amount);
        total = this.addDouble(total, this.Expense_RealEstateProperty_PestControl_Amount);
        total = this.addDouble(total, this.Expense_RealEstateProperty_AgentFeesCommission_Amount);
        total = this.addDouble(total, this.Expense_RealEstateProperty_RepairsAndMaintenance_Amount);
        total = this.addDouble(total, this.Expense_RealEstateProperty_CapitalWorksDeduction_Amount);
        total = this.addDouble(total, this.Expense_RealEstateProperty_OfficeSupplies_Amount);
        total = this.addDouble(total, this.Expense_Travel_Amount);
        total = this.addDouble(total, this.Expense_RealEstateProperty_Water_Amount);
        if ((total = this.addDouble(total, this.Expense_RealEstateProperty_Sundry_Amount)) == null) {
            this.TotalExpenses.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.TotalExpenses.setGlenixElementValue("" + total.intValue());
        }
    }

    public void calculateNetRentInit() {
        this.TotalIncome.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateNetRent()));
        this.TotalExpenses.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateNetRent()));
    }

    private void calculateNetRent() {
        Double total = null;
        total = this.addDouble(total, this.TotalIncome);
        if ((total = this.subtractDouble(total, this.TotalExpenses)) == null) {
            this.Income_RealEstateProperty_RentalNet_Amount.setGlenixElementValue(null);
        } else {
            this.Income_RealEstateProperty_RentalNet_Amount.setGlenixElementValue("" + total.intValue());
        }
    }

    public void setBusinessDetails(BusinessMasterFile businessMasterFile) {
        if (businessMasterFile != null) {
            this.Identifiers_TaxFileNumber_Identifier.setGlenixElementValue(businessMasterFile.getBusinessTFN());
        }
    }

    public void setProfileDetails(Profile profileXBRL) {
    }
}

