/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.tr2018;

import au.com.glenix.tr2018.TaxReturnRDTIS0003GM;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.Profile;
import au.com.glenix.trn.RDTIS0003;
import au.com.glenix.widget.ErrorDisplay;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixLabelZeroDecimalPositiveNumber;
import au.com.glenix.widget.GlenixVBox;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TaxReturnRDTIS0003Controller
extends GlenixBranchController {
    private DocumentBuilder dBuilder;
    private RDTIS0003 rdtis0003;
    private NumberFormat format2dp = new DecimalFormat("#0.00");
    @FXML
    private GlenixVBox rdtis0003VBox;
    @FXML
    private VBox gmvbox;
    private int gmcount = 0;
    @FXML
    private GlenixLabelLabel Identifiers_TaxFileNumber_Identifier;
    private ErrorDisplay errorDisplay;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber TaxConcession_ResearchAndDevelopment_TaxOffsetEntityTurnover_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber TaxConcession_ResearchAndDevelopment_TaxOffsetAdditionalEntitiesTurnover_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber TaxConcession_ResearchAndDevelopment_TaxOffsetTurnoverExclusion_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber TaxConcession_ResearchAndDevelopment_TaxOffsetTurnoverTotal_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_ContractedExpenditureResearchServiceProvider_Amount_CTAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_ContractedExpenditureNonResearchServiceProvider_Amount_CTAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Remuneration_WagesAndSalaries_Salary_Amount_CTAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_OtherExpenditureRegisteredResearchAgency_Amount_CTAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_Feedstock_Amount_CTAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_AssociatesExpenditure_Amount_CTAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_DeclineInValuePlantAndDepreciatingAssets_Amount_CTAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_BalancingLosses_Amount_CTAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_CooperativeResearchCentreContributions_Amount_CTAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_AllocatedTotal_Amount_CTAUS;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_ContractedExpenditureResearchServiceProvider_Amount_CTFOR;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_ContractedExpenditureNonResearchServiceProvider_Amount_CTFOR;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Remuneration_WagesAndSalaries_Salary_Amount_CTFOR;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_OtherExpenditureRegisteredResearchAgency_Amount_CTFOR;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_Feedstock_Amount_CTFOR;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_AssociatesExpenditure_Amount_CTFOR;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_DeclineInValuePlantAndDepreciatingAssets_Amount_CTFOR;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_BalancingLosses_Amount_CTFOR;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_CooperativeResearchCentreContributions_Amount_CTFOR;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_AllocatedTotal_Amount_CTFOR;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_AllocatedTotal_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_AssociatesCarriedForward_Amount_YPrevious;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_AssociatesUnpaid_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_AssociatesClaimed_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_AssociatesNotClaimed_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Expense_ResearchAndDevelopment_AssociatesCarriedForward_Amount;

    public TaxReturnRDTIS0003Controller(ErrorDisplay errorDisplay) {
        this.errorDisplay = errorDisplay;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
        }
        this.calculateAssociatedFwdInit();
        this.calculateExpenditureTotalInit();
        this.calculateExpenditureAUSInit();
        this.calculateExpenditureFORInit();
        this.calculateAggregatedTurnoverInit();
    }

    public void setModel(RDTIS0003 rdtis0003) throws Exception {
        Document doc;
        this.rdtis0003 = rdtis0003;
        this.clearGlenixXBRL();
        if (rdtis0003 != null && (doc = rdtis0003.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
        this.gmcount = 0;
        this.gmvbox.getChildren().clear();
        if (rdtis0003 != null) {
            List<GlenixElement> ges = rdtis0003.getChildElementSet("rdtis0003GM");
            for (GlenixElement ge : ges) {
                TaxReturnRDTIS0003GM sw = this.addGM();
                Document doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                sw.getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
        }
    }

    private Double getDouble(GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    private Double addDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return result;
        }
        return d + result;
    }

    private Double subtractDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return -result.doubleValue();
        }
        return d - result;
    }

    private Double addDouble(Double d, Double dd) {
        if (dd == null) {
            return d;
        }
        if (d == null) {
            return dd;
        }
        return d + dd;
    }

    @FXML
    private TaxReturnRDTIS0003GM addGM() {
        try {
            final TaxReturnRDTIS0003GM sw = new TaxReturnRDTIS0003GM();
            sw.getGlenixController().initialize(null, null);
            this.gmvbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete transfer");
            this.gmvbox.getChildren().add((Object)b);
            ++this.gmcount;
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnRDTIS0003Controller.this.gmvbox.getChildren().remove((Object)sw);
                    TaxReturnRDTIS0003Controller.this.gmvbox.getChildren().remove((Object)b);
                    TaxReturnRDTIS0003Controller.this.gmcount--;
                    TaxReturnRDTIS0003Controller.this.calculateAggregatedTurnover();
                }
            });
            sw.setSingleChangeListener(new ChangeListener<String>(){

                public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                    TaxReturnRDTIS0003Controller.this.calculateAggregatedTurnover();
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    public void calculateAggregatedTurnoverInit() {
        this.TaxConcession_ResearchAndDevelopment_TaxOffsetEntityTurnover_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateAggregatedTurnover()));
        this.TaxConcession_ResearchAndDevelopment_TaxOffsetAdditionalEntitiesTurnover_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateAggregatedTurnover()));
        this.TaxConcession_ResearchAndDevelopment_TaxOffsetTurnoverExclusion_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateAggregatedTurnover()));
    }

    private void calculateAggregatedTurnover() {
        Double total = null;
        total = this.addDouble(total, this.TaxConcession_ResearchAndDevelopment_TaxOffsetEntityTurnover_Amount);
        for (Node n : this.gmvbox.getChildren()) {
            if (!(n instanceof TaxReturnRDTIS0003GM)) continue;
            total = this.addDouble(total, ((TaxReturnRDTIS0003GM)n).getGross());
        }
        total = this.addDouble(total, this.TaxConcession_ResearchAndDevelopment_TaxOffsetAdditionalEntitiesTurnover_Amount);
        if ((total = this.subtractDouble(total, this.TaxConcession_ResearchAndDevelopment_TaxOffsetTurnoverExclusion_Amount)) == null) {
            this.TaxConcession_ResearchAndDevelopment_TaxOffsetTurnoverTotal_Amount.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.TaxConcession_ResearchAndDevelopment_TaxOffsetTurnoverTotal_Amount.setGlenixElementValue("" + total.intValue());
        }
    }

    public void calculateExpenditureAUSInit() {
        this.Expense_ResearchAndDevelopment_ContractedExpenditureResearchServiceProvider_Amount_CTAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureAUS()));
        this.Expense_ResearchAndDevelopment_ContractedExpenditureNonResearchServiceProvider_Amount_CTAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureAUS()));
        this.Remuneration_WagesAndSalaries_Salary_Amount_CTAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureAUS()));
        this.Expense_ResearchAndDevelopment_OtherExpenditureRegisteredResearchAgency_Amount_CTAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureAUS()));
        this.Expense_ResearchAndDevelopment_Feedstock_Amount_CTAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureAUS()));
        this.Expense_ResearchAndDevelopment_AssociatesExpenditure_Amount_CTAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureAUS()));
        this.Expense_ResearchAndDevelopment_DeclineInValuePlantAndDepreciatingAssets_Amount_CTAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureAUS()));
        this.Expense_ResearchAndDevelopment_BalancingLosses_Amount_CTAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureAUS()));
        this.Expense_ResearchAndDevelopment_CooperativeResearchCentreContributions_Amount_CTAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureAUS()));
    }

    private void calculateExpenditureAUS() {
        Double total = null;
        total = this.addDouble(total, this.Expense_ResearchAndDevelopment_ContractedExpenditureResearchServiceProvider_Amount_CTAUS);
        total = this.addDouble(total, this.Expense_ResearchAndDevelopment_ContractedExpenditureNonResearchServiceProvider_Amount_CTAUS);
        total = this.addDouble(total, this.Remuneration_WagesAndSalaries_Salary_Amount_CTAUS);
        total = this.addDouble(total, this.Expense_ResearchAndDevelopment_OtherExpenditureRegisteredResearchAgency_Amount_CTAUS);
        total = this.addDouble(total, this.Expense_ResearchAndDevelopment_Feedstock_Amount_CTAUS);
        total = this.addDouble(total, this.Expense_ResearchAndDevelopment_AssociatesExpenditure_Amount_CTAUS);
        total = this.addDouble(total, this.Expense_ResearchAndDevelopment_DeclineInValuePlantAndDepreciatingAssets_Amount_CTAUS);
        total = this.addDouble(total, this.Expense_ResearchAndDevelopment_BalancingLosses_Amount_CTAUS);
        if ((total = this.addDouble(total, this.Expense_ResearchAndDevelopment_CooperativeResearchCentreContributions_Amount_CTAUS)) == null) {
            this.Expense_ResearchAndDevelopment_AllocatedTotal_Amount_CTAUS.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.Expense_ResearchAndDevelopment_AllocatedTotal_Amount_CTAUS.setGlenixElementValue("" + total.intValue());
        }
    }

    public void calculateExpenditureFORInit() {
        this.Expense_ResearchAndDevelopment_ContractedExpenditureResearchServiceProvider_Amount_CTFOR.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureFOR()));
        this.Expense_ResearchAndDevelopment_ContractedExpenditureNonResearchServiceProvider_Amount_CTFOR.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureFOR()));
        this.Remuneration_WagesAndSalaries_Salary_Amount_CTFOR.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureFOR()));
        this.Expense_ResearchAndDevelopment_OtherExpenditureRegisteredResearchAgency_Amount_CTFOR.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureFOR()));
        this.Expense_ResearchAndDevelopment_Feedstock_Amount_CTFOR.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureFOR()));
        this.Expense_ResearchAndDevelopment_AssociatesExpenditure_Amount_CTFOR.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureFOR()));
        this.Expense_ResearchAndDevelopment_DeclineInValuePlantAndDepreciatingAssets_Amount_CTFOR.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureFOR()));
        this.Expense_ResearchAndDevelopment_BalancingLosses_Amount_CTFOR.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureFOR()));
        this.Expense_ResearchAndDevelopment_CooperativeResearchCentreContributions_Amount_CTFOR.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureFOR()));
    }

    private void calculateExpenditureFOR() {
        Double total = null;
        total = this.addDouble(total, this.Expense_ResearchAndDevelopment_ContractedExpenditureResearchServiceProvider_Amount_CTFOR);
        total = this.addDouble(total, this.Expense_ResearchAndDevelopment_ContractedExpenditureNonResearchServiceProvider_Amount_CTFOR);
        total = this.addDouble(total, this.Remuneration_WagesAndSalaries_Salary_Amount_CTFOR);
        total = this.addDouble(total, this.Expense_ResearchAndDevelopment_OtherExpenditureRegisteredResearchAgency_Amount_CTFOR);
        total = this.addDouble(total, this.Expense_ResearchAndDevelopment_Feedstock_Amount_CTFOR);
        total = this.addDouble(total, this.Expense_ResearchAndDevelopment_AssociatesExpenditure_Amount_CTFOR);
        total = this.addDouble(total, this.Expense_ResearchAndDevelopment_DeclineInValuePlantAndDepreciatingAssets_Amount_CTFOR);
        total = this.addDouble(total, this.Expense_ResearchAndDevelopment_BalancingLosses_Amount_CTFOR);
        if ((total = this.addDouble(total, this.Expense_ResearchAndDevelopment_CooperativeResearchCentreContributions_Amount_CTFOR)) == null) {
            this.Expense_ResearchAndDevelopment_AllocatedTotal_Amount_CTFOR.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.Expense_ResearchAndDevelopment_AllocatedTotal_Amount_CTFOR.setGlenixElementValue("" + total.intValue());
        }
    }

    public void calculateExpenditureTotalInit() {
        this.Expense_ResearchAndDevelopment_AllocatedTotal_Amount_CTFOR.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureTotal()));
        this.Expense_ResearchAndDevelopment_AllocatedTotal_Amount_CTAUS.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateExpenditureTotal()));
    }

    private void calculateExpenditureTotal() {
        Double total = null;
        total = this.addDouble(total, this.Expense_ResearchAndDevelopment_AllocatedTotal_Amount_CTFOR);
        if ((total = this.addDouble(total, this.Expense_ResearchAndDevelopment_AllocatedTotal_Amount_CTAUS)) == null) {
            this.Expense_ResearchAndDevelopment_AllocatedTotal_Amount.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.Expense_ResearchAndDevelopment_AllocatedTotal_Amount.setGlenixElementValue("" + total.intValue());
        }
    }

    public void calculateAssociatedFwdInit() {
        this.Expense_ResearchAndDevelopment_AssociatesCarriedForward_Amount_YPrevious.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateAssociatedFwd()));
        this.Expense_ResearchAndDevelopment_AssociatesUnpaid_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateAssociatedFwd()));
        this.Expense_ResearchAndDevelopment_AssociatesClaimed_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateAssociatedFwd()));
        this.Expense_ResearchAndDevelopment_AssociatesNotClaimed_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateAssociatedFwd()));
    }

    private void calculateAssociatedFwd() {
        Double total = null;
        total = this.addDouble(total, this.Expense_ResearchAndDevelopment_AssociatesCarriedForward_Amount_YPrevious);
        total = this.addDouble(total, this.Expense_ResearchAndDevelopment_AssociatesUnpaid_Amount);
        total = this.subtractDouble(total, this.Expense_ResearchAndDevelopment_AssociatesClaimed_Amount);
        if ((total = this.subtractDouble(total, this.Expense_ResearchAndDevelopment_AssociatesNotClaimed_Amount)) == null) {
            this.Expense_ResearchAndDevelopment_AssociatesCarriedForward_Amount.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.Expense_ResearchAndDevelopment_AssociatesCarriedForward_Amount.setGlenixElementValue("" + total.intValue());
        }
    }

    public void setBusinessDetails(BusinessMasterFile businessMasterFile) {
        if (businessMasterFile != null) {
            this.Identifiers_TaxFileNumber_Identifier.setGlenixElementValue(businessMasterFile.getBusinessTFN());
        }
    }

    public void setProfileDetails(Profile profileXBRL) {
    }
}

