/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.tr2018;

import au.com.glenix.tr2018.TaxReturnPSS0002Payer;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.PSS0002;
import au.com.glenix.trn.Profile;
import au.com.glenix.widget.ErrorDisplay;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixVBox;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TaxReturnPSS0002Controller
extends GlenixBranchController {
    private DocumentBuilder dBuilder;
    private PSS0002 pss0002;
    private NumberFormat format2dp = new DecimalFormat("#0.00");
    @FXML
    private GlenixVBox pss0002VBox;
    @FXML
    private VBox payervbox;
    @FXML
    private GlenixLabelLabel Identifiers_TaxFileNumber_Identifier;
    private ErrorDisplay errorDisplay;

    public TaxReturnPSS0002Controller(ErrorDisplay errorDisplay) {
        this.errorDisplay = errorDisplay;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
        }
    }

    public void setModel(PSS0002 pss0002) throws Exception {
        Document doc;
        this.pss0002 = pss0002;
        this.clearGlenixXBRL();
        if (pss0002 != null && (doc = pss0002.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
        this.payervbox.getChildren().clear();
        if (pss0002 != null) {
            List<GlenixElement> ges = pss0002.getChildElementSet("pss0002Payer");
            for (GlenixElement ge : ges) {
                TaxReturnPSS0002Payer sw = this.addPSS0002Payer();
                Document doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                sw.getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
        }
    }

    @FXML
    private TaxReturnPSS0002Payer addPSS0002Payer() {
        try {
            final TaxReturnPSS0002Payer sw = new TaxReturnPSS0002Payer();
            sw.getGlenixController().initialize(null, null);
            this.payervbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete payer information");
            this.payervbox.getChildren().add((Object)b);
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnPSS0002Controller.this.payervbox.getChildren().remove((Object)sw);
                    TaxReturnPSS0002Controller.this.payervbox.getChildren().remove((Object)b);
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    public void setBusinessDetails(BusinessMasterFile businessMasterFile) {
        if (businessMasterFile != null) {
            this.Identifiers_TaxFileNumber_Identifier.setGlenixElementValue(businessMasterFile.getBusinessTFN());
        }
    }

    public void setProfileDetails(Profile profileXBRL) {
    }
}

