/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.tr2018;

import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.LS0006;
import au.com.glenix.trn.Profile;
import au.com.glenix.widget.ErrorDisplay;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixLabelZeroDecimalPositiveNumber;
import au.com.glenix.widget.GlenixVBox;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.fxml.FXML;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TaxReturnLS0006Controller
extends GlenixBranchController {
    private DocumentBuilder dBuilder;
    private LS0006 ls0006;
    private NumberFormat format2dp = new DecimalFormat("#0.00");
    @FXML
    private GlenixVBox ls0006VBox;
    @FXML
    private GlenixLabelLabel Identifiers_TaxFileNumber_Identifier;
    private ErrorDisplay errorDisplay;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_CarriedForward_Total_Amount_Y0;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_CarriedForward_Total_Amount_Y0MINUS1;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_CarriedForward_Total_Amount_Y0MINUS2;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_CarriedForward_Total_Amount_Y0MINUS3;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_CarriedForward_Total_Amount_Y0MINUS4;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_CarriedForward_Total_Amount_Y0MINUS5P;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_CarriedForward_Total_Amount_ALL;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_CarriedForward_Net_Amount_Y0;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_CarriedForward_Net_Amount_Y0MINUS1_INSTANT;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_CarriedForward_Net_Amount_Y0MINUS2_INSTANT;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_CarriedForward_Net_Amount_Y0MINUS3_INSTANT;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_CarriedForward_Net_Amount_Y0MINUS4_INSTANT;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_CarriedForward_Net_Amount_Y0MINUS5P_INSTANT;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_CarriedForward_Net_Amount_ALL;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_BalanceOfTaxLossesBroughtForwardFromPriorYear_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_Uplift_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_ForgivenDebtNet_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_Incurred_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_ConversionOfExcessFrankingOffsets_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_ExemptIncomeNet_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_Forgone_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_Total_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_TransferredOut_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_CarriedForward_LaterIncomeYearsTotal_Amount;
    @FXML
    private GlenixLabelLabel Identifiers_AustralianBusinessNumber_Identifier;

    public TaxReturnLS0006Controller(ErrorDisplay errorDisplay) {
        this.errorDisplay = errorDisplay;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
        }
        this.calculateLossCarriedForwardInit();
        this.calculateCapitalCarriedForwardInit();
        this.calculateRecCarriedForwardInit();
    }

    public void setModel(LS0006 ls0006) throws Exception {
        Document doc;
        this.ls0006 = ls0006;
        this.clearGlenixXBRL();
        if (ls0006 != null && (doc = ls0006.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
    }

    private Double getDouble(GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    private Double addDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return result;
        }
        return d + result;
    }

    private Double subtractDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return -result.doubleValue();
        }
        return d - result;
    }

    private Double addDouble(Double d, Double dd) {
        if (dd == null) {
            return d;
        }
        if (d == null) {
            return dd;
        }
        return d + dd;
    }

    public void calculateLossCarriedForwardInit() {
        this.Tax_Losses_CarriedForward_Total_Amount_Y0.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateLossCarriedForward()));
        this.Tax_Losses_CarriedForward_Total_Amount_Y0MINUS1.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateLossCarriedForward()));
        this.Tax_Losses_CarriedForward_Total_Amount_Y0MINUS2.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateLossCarriedForward()));
        this.Tax_Losses_CarriedForward_Total_Amount_Y0MINUS3.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateLossCarriedForward()));
        this.Tax_Losses_CarriedForward_Total_Amount_Y0MINUS4.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateLossCarriedForward()));
        this.Tax_Losses_CarriedForward_Total_Amount_Y0MINUS5P.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateLossCarriedForward()));
    }

    private void calculateLossCarriedForward() {
        Double total = null;
        total = this.addDouble(total, this.Tax_Losses_CarriedForward_Total_Amount_Y0);
        total = this.addDouble(total, this.Tax_Losses_CarriedForward_Total_Amount_Y0MINUS1);
        total = this.addDouble(total, this.Tax_Losses_CarriedForward_Total_Amount_Y0MINUS2);
        total = this.addDouble(total, this.Tax_Losses_CarriedForward_Total_Amount_Y0MINUS3);
        total = this.addDouble(total, this.Tax_Losses_CarriedForward_Total_Amount_Y0MINUS4);
        if ((total = this.addDouble(total, this.Tax_Losses_CarriedForward_Total_Amount_Y0MINUS5P)) == null) {
            this.Tax_Losses_CarriedForward_Total_Amount_ALL.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.Tax_Losses_CarriedForward_Total_Amount_ALL.setGlenixElementValue("" + total.intValue());
        }
    }

    public void calculateCapitalCarriedForwardInit() {
        this.Capital_Losses_CarriedForward_Net_Amount_Y0.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalCarriedForward()));
        this.Capital_Losses_CarriedForward_Net_Amount_Y0MINUS1_INSTANT.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalCarriedForward()));
        this.Capital_Losses_CarriedForward_Net_Amount_Y0MINUS2_INSTANT.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalCarriedForward()));
        this.Capital_Losses_CarriedForward_Net_Amount_Y0MINUS3_INSTANT.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalCarriedForward()));
        this.Capital_Losses_CarriedForward_Net_Amount_Y0MINUS4_INSTANT.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalCarriedForward()));
        this.Capital_Losses_CarriedForward_Net_Amount_Y0MINUS5P_INSTANT.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalCarriedForward()));
    }

    private void calculateCapitalCarriedForward() {
        Double total = null;
        total = this.addDouble(total, this.Capital_Losses_CarriedForward_Net_Amount_Y0);
        total = this.addDouble(total, this.Capital_Losses_CarriedForward_Net_Amount_Y0MINUS1_INSTANT);
        total = this.addDouble(total, this.Capital_Losses_CarriedForward_Net_Amount_Y0MINUS2_INSTANT);
        total = this.addDouble(total, this.Capital_Losses_CarriedForward_Net_Amount_Y0MINUS3_INSTANT);
        total = this.addDouble(total, this.Capital_Losses_CarriedForward_Net_Amount_Y0MINUS4_INSTANT);
        if ((total = this.addDouble(total, this.Capital_Losses_CarriedForward_Net_Amount_Y0MINUS5P_INSTANT)) == null) {
            this.Capital_Losses_CarriedForward_Net_Amount_ALL.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.Capital_Losses_CarriedForward_Net_Amount_ALL.setGlenixElementValue("" + total.intValue());
        }
    }

    public void calculateRecCarriedForwardInit() {
        this.Tax_Losses_BalanceOfTaxLossesBroughtForwardFromPriorYear_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateRecCarriedForward()));
        this.Tax_Losses_Uplift_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateRecCarriedForward()));
        this.Tax_Losses_ForgivenDebtNet_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateRecCarriedForward()));
        this.Tax_Losses_Incurred_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateRecCarriedForward()));
        this.Tax_Losses_ConversionOfExcessFrankingOffsets_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateRecCarriedForward()));
        this.Tax_Losses_ExemptIncomeNet_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateRecCarriedForward()));
        this.Tax_Losses_Forgone_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateRecCarriedForward()));
        this.Tax_Losses_Total_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateRecCarriedForward()));
        this.Tax_Losses_TransferredOut_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateRecCarriedForward()));
    }

    private void calculateRecCarriedForward() {
        Double total = null;
        total = this.addDouble(total, this.Tax_Losses_BalanceOfTaxLossesBroughtForwardFromPriorYear_Amount);
        total = this.addDouble(total, this.Tax_Losses_Uplift_Amount);
        total = this.subtractDouble(total, this.Tax_Losses_ForgivenDebtNet_Amount);
        total = this.addDouble(total, this.Tax_Losses_Incurred_Amount);
        total = this.addDouble(total, this.Tax_Losses_ConversionOfExcessFrankingOffsets_Amount);
        total = this.subtractDouble(total, this.Tax_Losses_ExemptIncomeNet_Amount);
        total = this.subtractDouble(total, this.Tax_Losses_Forgone_Amount);
        total = this.subtractDouble(total, this.Tax_Losses_Total_Amount);
        if ((total = this.subtractDouble(total, this.Tax_Losses_TransferredOut_Amount)) == null) {
            this.Tax_Losses_CarriedForward_LaterIncomeYearsTotal_Amount.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.Tax_Losses_CarriedForward_LaterIncomeYearsTotal_Amount.setGlenixElementValue("" + total.intValue());
        }
    }

    public void setBusinessDetails(BusinessMasterFile businessMasterFile) {
        if (businessMasterFile == null) {
            this.Identifiers_TaxFileNumber_Identifier.setGlenixElementValue(null);
            this.Identifiers_AustralianBusinessNumber_Identifier.setText(null);
        } else {
            this.Identifiers_TaxFileNumber_Identifier.setGlenixElementValue(businessMasterFile.getBusinessTFN());
            this.Identifiers_AustralianBusinessNumber_Identifier.setText(businessMasterFile.getBusinessABN());
        }
    }

    public void setProfileDetails(Profile profileXBRL) {
    }
}

