/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.tr2018;

import au.com.glenix.tr2018.TaxReturnIDS0006CurrencyCode;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.IDS0006TransactionType;
import au.com.glenix.widget.GlenixTitledPaneController;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TaxReturnIDS0006TransactionTypeController
extends GlenixTitledPaneController {
    @FXML
    private VBox currencycodevbox;
    private int currencycodecount = 0;
    private DocumentBuilder dBuilder;
    @FXML
    private Button deleteButton;
    protected ChangeListener<String> changeListener = null;

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setModel(IDS0006TransactionType fc) throws Exception {
        this.currencycodevbox.getChildren().clear();
        this.currencycodecount = 0;
        if (fc != null) {
            Document doc = this.dBuilder.newDocument();
            fc.appendToElement(doc);
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
            List<GlenixElement> ges = fc.getChildElementSet("CurrencyCode");
            for (GlenixElement ge : ges) {
                TaxReturnIDS0006CurrencyCode sw = this.addCurrencyCode();
                doc = this.dBuilder.newDocument();
                ge.appendToElement(doc);
                sw.getGlenixController().loadGlenixXBRL(doc, doc.getDocumentElement());
            }
        }
    }

    @FXML
    private TaxReturnIDS0006CurrencyCode addCurrencyCode() {
        if (this.currencycodecount >= 3) {
            return null;
        }
        try {
            final TaxReturnIDS0006CurrencyCode sw = new TaxReturnIDS0006CurrencyCode();
            sw.getGlenixController().initialize(null, null);
            this.currencycodevbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete currency code");
            this.currencycodevbox.getChildren().add((Object)b);
            ++this.currencycodecount;
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnIDS0006TransactionTypeController.this.currencycodevbox.getChildren().remove((Object)sw);
                    TaxReturnIDS0006TransactionTypeController.this.currencycodevbox.getChildren().remove((Object)b);
                    TaxReturnIDS0006TransactionTypeController.this.currencycodecount--;
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setSingleChangeListener(ChangeListener<String> changeListener) {
        this.changeListener = changeListener;
    }

    public void addDeleteListener(EventHandler<ActionEvent> deleteListener) {
        this.deleteButton.addEventHandler(ActionEvent.ACTION, deleteListener);
    }
}

