/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.tr2018;

import au.com.glenix.tr2018.TaxReturnIDS0006ForeignCountry;
import au.com.glenix.tr2018.TaxReturnIDS0006HubArrangement;
import au.com.glenix.tr2018.TaxReturnIDS0006InternallyRecordedDealings;
import au.com.glenix.tr2018.TaxReturnIDS0006RestructuringEvent;
import au.com.glenix.tr2018.TaxReturnIDS0006SpecifiedCountry;
import au.com.glenix.tr2018.TaxReturnIDS0006TransactionType;
import au.com.glenix.tr2018.TaxReturnIDS0006TransferorTrustExemptionCode;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.IDS0006;
import au.com.glenix.trn.IDS0006ForeignCountries;
import au.com.glenix.trn.IDS0006SpecifiedCountries;
import au.com.glenix.trn.IDS0006TransactionType;
import au.com.glenix.trn.Profile;
import au.com.glenix.widget.ErrorDisplay;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixFlowPane;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixTitledPane;
import au.com.glenix.widget.GlenixVBox;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.TitledPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TaxReturnIDS0006Controller
extends GlenixBranchController {
    protected DocumentBuilder dBuilder;
    private IDS0006 ids0006;
    protected NumberFormat format2dp = new DecimalFormat("#0.00");
    @FXML
    protected GlenixVBox ids0006VBox;
    @FXML
    protected GlenixFlowPane sectionafp;
    @FXML
    protected GlenixFlowPane sectioncfp;
    @FXML
    protected GlenixLabelLabel Identifiers_TaxFileNumber_Identifier;
    protected ErrorDisplay errorDisplay;
    protected int foreigncountriescount = 0;
    @FXML
    protected TitledPane foreigncountriestp;
    protected int specifiedcountriescount = 0;
    @FXML
    protected TitledPane specifiedcountriestp;
    protected int transactiontypecount = 0;
    @FXML
    protected TitledPane transactiontypetp;
    protected int internallyrecordeddealingscount = 0;
    @FXML
    protected TitledPane internallyrecordeddealingstp;
    protected int transferortrustexemptioncodecount = 0;
    @FXML
    protected TitledPane transferortrustexemptioncodetp;
    protected int hubarrangementcount = 0;
    @FXML
    protected TitledPane hubarrangementtp;
    protected int restructuringeventcount = 0;
    @FXML
    protected TitledPane restructuringeventtp;

    public TaxReturnIDS0006Controller(ErrorDisplay errorDisplay) {
        this.errorDisplay = errorDisplay;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
        }
        this.specifiedcountriescount = 0;
        this.foreigncountriescount = 0;
        this.transactiontypecount = 0;
        this.internallyrecordeddealingscount = 0;
        this.hubarrangementcount = 0;
        this.transferortrustexemptioncodecount = 0;
        this.restructuringeventcount = 0;
    }

    public void setModel(IDS0006 ids0006) throws Exception {
        Document doc;
        this.ids0006 = ids0006;
        this.clearGlenixXBRL();
        if (ids0006 != null && (doc = ids0006.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
        ArrayList<Node> remove = new ArrayList<Node>();
        for (Node n : this.sectionafp.getChildren()) {
            if (n instanceof TaxReturnIDS0006ForeignCountry) {
                remove.add(n);
            }
            if (n instanceof TaxReturnIDS0006SpecifiedCountry) {
                remove.add(n);
            }
            if (n instanceof TaxReturnIDS0006TransactionType) {
                remove.add(n);
            }
            if (n instanceof TaxReturnIDS0006InternallyRecordedDealings) {
                remove.add(n);
            }
            if (!(n instanceof TaxReturnIDS0006RestructuringEvent)) continue;
            remove.add(n);
        }
        this.sectionafp.getChildren().removeAll(remove);
        remove = new ArrayList();
        for (Node n : this.sectioncfp.getChildren()) {
            if (n instanceof TaxReturnIDS0006TransferorTrustExemptionCode) {
                remove.add(n);
            }
            if (!(n instanceof TaxReturnIDS0006HubArrangement)) continue;
            remove.add(n);
        }
        this.sectioncfp.getChildren().removeAll(remove);
        this.foreigncountriescount = 0;
        this.specifiedcountriescount = 0;
        this.transactiontypecount = 0;
        this.internallyrecordeddealingscount = 0;
        this.hubarrangementcount = 0;
        this.transferortrustexemptioncodecount = 0;
        this.restructuringeventcount = 0;
        if (ids0006 != null) {
            Document doc2;
            GlenixTitledPane sw;
            List<GlenixElement> ges = ids0006.getChildElementSet("ForeignCountries");
            for (GlenixElement ge : ges) {
                sw = this.addForeignCountry();
                ((TaxReturnIDS0006ForeignCountry)sw).setModel((IDS0006ForeignCountries)ge);
            }
            ges = ids0006.getChildElementSet("SpecifiedCountries");
            for (GlenixElement ge : ges) {
                sw = this.addSpecifiedCountry();
                ((TaxReturnIDS0006SpecifiedCountry)sw).setModel((IDS0006SpecifiedCountries)ge);
            }
            ges = ids0006.getChildElementSet("TransactionType");
            for (GlenixElement ge : ges) {
                sw = this.addTransactionType();
                ((TaxReturnIDS0006TransactionType)sw).setModel((IDS0006TransactionType)ge);
            }
            ges = ids0006.getChildElementSet("InternallyRecordedDealings");
            for (GlenixElement ge : ges) {
                sw = this.addInternallyRecordedDealing();
                doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                ((TaxReturnIDS0006InternallyRecordedDealings)sw).getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
            ges = ids0006.getChildElementSet("HubArrangement");
            for (GlenixElement ge : ges) {
                sw = this.addHubArrangement();
                doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                ((TaxReturnIDS0006HubArrangement)sw).getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
            ges = ids0006.getChildElementSet("TransferorTrustExemptionCode");
            for (GlenixElement ge : ges) {
                sw = this.addTransferorTrustExemptionCode();
                doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                ((TaxReturnIDS0006TransferorTrustExemptionCode)sw).getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
            ges = ids0006.getChildElementSet("RestructuringEvent");
            for (GlenixElement ge : ges) {
                sw = this.addRestructuringEvent();
                doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                ((TaxReturnIDS0006RestructuringEvent)sw).getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
        }
    }

    protected Double getDouble(GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    protected Double addDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return result;
        }
        return d + result;
    }

    protected Double subtractDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return -result.doubleValue();
        }
        return d - result;
    }

    protected Double addDouble(Double d, Double dd) {
        if (dd == null) {
            return d;
        }
        if (d == null) {
            return dd;
        }
        return d + dd;
    }

    @FXML
    protected TaxReturnIDS0006ForeignCountry addForeignCountry() {
        if (this.foreigncountriescount >= 3) {
            return null;
        }
        try {
            final TaxReturnIDS0006ForeignCountry sw = new TaxReturnIDS0006ForeignCountry();
            sw.getGlenixController().initialize(null, null);
            ObservableList children = this.sectionafp.getChildren();
            int index = children.indexOf((Object)this.foreigncountriestp);
            while (this.sectionafp.getChildren().get(index + 1) instanceof TaxReturnIDS0006ForeignCountry) {
                ++index;
            }
            this.sectionafp.getChildren().add(index + 1, (Object)sw);
            ++this.foreigncountriescount;
            sw.addDeleteListener(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnIDS0006Controller.this.sectionafp.getChildren().remove((Object)sw);
                    --TaxReturnIDS0006Controller.this.foreigncountriescount;
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    protected TaxReturnIDS0006SpecifiedCountry addSpecifiedCountry() {
        if (this.specifiedcountriescount >= 3) {
            return null;
        }
        try {
            final TaxReturnIDS0006SpecifiedCountry sw = new TaxReturnIDS0006SpecifiedCountry();
            sw.getGlenixController().initialize(null, null);
            ObservableList children = this.sectionafp.getChildren();
            int index = children.indexOf((Object)this.specifiedcountriestp);
            while (this.sectionafp.getChildren().get(index + 1) instanceof TaxReturnIDS0006SpecifiedCountry) {
                ++index;
            }
            this.sectionafp.getChildren().add(index + 1, (Object)sw);
            ++this.specifiedcountriescount;
            sw.addDeleteListener(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnIDS0006Controller.this.sectionafp.getChildren().remove((Object)sw);
                    --TaxReturnIDS0006Controller.this.specifiedcountriescount;
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    protected TaxReturnIDS0006TransactionType addTransactionType() {
        if (this.transactiontypecount >= 3) {
            return null;
        }
        try {
            final TaxReturnIDS0006TransactionType sw = new TaxReturnIDS0006TransactionType();
            sw.getGlenixController().initialize(null, null);
            ObservableList children = this.sectionafp.getChildren();
            int index = children.indexOf((Object)this.transactiontypetp);
            while (this.sectionafp.getChildren().get(index + 1) instanceof TaxReturnIDS0006TransactionType) {
                ++index;
            }
            this.sectionafp.getChildren().add(index + 1, (Object)sw);
            ++this.transactiontypecount;
            sw.addDeleteListener(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnIDS0006Controller.this.sectionafp.getChildren().remove((Object)sw);
                    --TaxReturnIDS0006Controller.this.transactiontypecount;
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    protected TaxReturnIDS0006InternallyRecordedDealings addInternallyRecordedDealing() {
        if (this.internallyrecordeddealingscount >= 99) {
            return null;
        }
        try {
            final TaxReturnIDS0006InternallyRecordedDealings sw = new TaxReturnIDS0006InternallyRecordedDealings();
            sw.getGlenixController().initialize(null, null);
            ObservableList children = this.sectionafp.getChildren();
            int index = children.indexOf((Object)this.internallyrecordeddealingstp);
            ++index;
            while (index < this.sectionafp.getChildren().size() && this.sectionafp.getChildren().get(index) instanceof TaxReturnIDS0006InternallyRecordedDealings) {
                ++index;
            }
            if (index == this.sectionafp.getChildren().size()) {
                this.sectionafp.getChildren().add((Object)sw);
            } else {
                this.sectionafp.getChildren().add(index, (Object)sw);
            }
            ++this.internallyrecordeddealingscount;
            sw.addDeleteListener(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnIDS0006Controller.this.sectionafp.getChildren().remove((Object)sw);
                    --TaxReturnIDS0006Controller.this.internallyrecordeddealingscount;
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    protected TaxReturnIDS0006TransferorTrustExemptionCode addTransferorTrustExemptionCode() {
        if (this.transferortrustexemptioncodecount >= 3) {
            return null;
        }
        try {
            final TaxReturnIDS0006TransferorTrustExemptionCode sw = new TaxReturnIDS0006TransferorTrustExemptionCode();
            sw.getGlenixController().initialize(null, null);
            ObservableList children = this.sectioncfp.getChildren();
            int index = children.indexOf((Object)this.transferortrustexemptioncodetp);
            while (this.sectioncfp.getChildren().get(index + 1) instanceof TaxReturnIDS0006TransferorTrustExemptionCode) {
                ++index;
            }
            this.sectioncfp.getChildren().add(index + 1, (Object)sw);
            ++this.transferortrustexemptioncodecount;
            sw.addDeleteListener(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnIDS0006Controller.this.sectioncfp.getChildren().remove((Object)sw);
                    --TaxReturnIDS0006Controller.this.transferortrustexemptioncodecount;
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    protected TaxReturnIDS0006HubArrangement addHubArrangement() {
        if (this.hubarrangementcount >= 3) {
            return null;
        }
        try {
            final TaxReturnIDS0006HubArrangement sw = new TaxReturnIDS0006HubArrangement();
            sw.getGlenixController().initialize(null, null);
            ObservableList children = this.sectioncfp.getChildren();
            int index = children.indexOf((Object)this.hubarrangementtp);
            while (this.sectioncfp.getChildren().get(index + 1) instanceof TaxReturnIDS0006HubArrangement) {
                ++index;
            }
            this.sectioncfp.getChildren().add(index + 1, (Object)sw);
            ++this.hubarrangementcount;
            sw.addDeleteListener(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnIDS0006Controller.this.sectioncfp.getChildren().remove((Object)sw);
                    --TaxReturnIDS0006Controller.this.hubarrangementcount;
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    protected TaxReturnIDS0006RestructuringEvent addRestructuringEvent() {
        if (this.restructuringeventcount >= 3) {
            return null;
        }
        try {
            final TaxReturnIDS0006RestructuringEvent sw = new TaxReturnIDS0006RestructuringEvent();
            sw.getGlenixController().initialize(null, null);
            ObservableList children = this.sectionafp.getChildren();
            int index = children.indexOf((Object)this.restructuringeventtp);
            while (this.sectionafp.getChildren().get(index + 1) instanceof TaxReturnIDS0006RestructuringEvent) {
                ++index;
            }
            this.sectionafp.getChildren().add(index + 1, (Object)sw);
            ++this.restructuringeventcount;
            sw.addDeleteListener(new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnIDS0006Controller.this.sectionafp.getChildren().remove((Object)sw);
                    --TaxReturnIDS0006Controller.this.restructuringeventcount;
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    public void setBusinessDetails(BusinessMasterFile businessMasterFile) {
        if (businessMasterFile != null) {
            this.Identifiers_TaxFileNumber_Identifier.setGlenixElementValue(businessMasterFile.getBusinessTFN());
        }
    }

    public void setProfileDetails(Profile profileXBRL) {
    }
}

