/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.tr2018;

import au.com.glenix.tr2018.GlenixLabelCountryLabel;
import au.com.glenix.tr2018.TaxReturnFTER0002DeclarationOfTrustee;
import au.com.glenix.tr2018.TaxReturnFTER0002DeclarationSectionINTVBox;
import au.com.glenix.tr2018.TaxReturnFTER0002InterposedEntityVBox;
import au.com.glenix.tr2018.TaxReturnFTER0002TrusteeVBox;
import au.com.glenix.tr2018.TaxReturnIEE0003PeriodDetailsControl;
import au.com.glenix.tr2018.TaxReturnIEE0003PeriodDetailsSubstituted;
import au.com.glenix.trn.AgentDetails;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.FTER0002;
import au.com.glenix.trn.FTER0002InterposedEntity;
import au.com.glenix.trn.FTER0002Trustee;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.Profile;
import au.com.glenix.trn.TFND0004AddressDetailsBusiness;
import au.com.glenix.widget.ErrorDisplay;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixNCVBox;
import au.com.glenix.widget.GlenixVBox;
import java.net.URL;
import java.time.LocalDate;
import java.util.List;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TaxReturnFTER0002Controller
extends GlenixBranchController {
    private DocumentBuilder dBuilder;
    private FTER0002 fter0002;
    @FXML
    private GlenixVBox fter0002VBox;
    @FXML
    private VBox intermediarysection;
    @FXML
    private GlenixLabelLabel Identifiers_TaxFileNumber_Identifier;
    private ErrorDisplay errorDisplay;
    @FXML
    private GlenixLabelLabel Identifiers_AustralianBusinessNumber_Identifier;
    @FXML
    private GlenixLabelLabel OrganisationNameDetails_OrganisationalName_Text;
    @FXML
    private GlenixLabelLabel AddressDetails_Line1_Text;
    @FXML
    private GlenixLabelLabel AddressDetails_Line2_Text;
    @FXML
    private GlenixLabelLabel AddressDetails_LocalityName_Text;
    @FXML
    private GlenixLabelLabel AddressDetails_StateOrTerritory_Code;
    @FXML
    private GlenixLabelLabel AddressDetails_Postcode_Text;
    @FXML
    private GlenixLabelCountryLabel AddressDetails_Country_Code;
    private AgentDetails agentDetails;
    int cmpcount = 0;
    @FXML
    private VBox perioddetailscontrolvbox;
    int trusteecount = 0;
    @FXML
    private VBox trusteesvbox;
    int subcount = 0;
    @FXML
    private VBox perioddetailssubstitutedvbox;
    int interposedcount = 0;
    @FXML
    private VBox interposedentityvbox;
    int trusteedeccount = 0;
    @FXML
    private VBox trusteedeclarationsvbox;
    int tadeccount = 0;
    @FXML
    private VBox taxagentdeclarationvbox;
    private TaxReturnFTER0002DeclarationSectionINTVBox taxReturnFTER0002DeclarationSectionINTVBox;
    @FXML
    private GlenixLabelLabel Lodgment_PeriodYear_Year;
    private String type;
    private String year;

    public TaxReturnFTER0002Controller(ErrorDisplay errorDisplay) {
        this.errorDisplay = errorDisplay;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
        }
    }

    public void setBusinessDetails(BusinessMasterFile businessMasterFile) {
        if (businessMasterFile == null) {
            this.Identifiers_AustralianBusinessNumber_Identifier.setText(null);
            this.Identifiers_TaxFileNumber_Identifier.setText(null);
            this.OrganisationNameDetails_OrganisationalName_Text.setText(null);
            this.AddressDetails_Line1_Text.setText(null);
            this.AddressDetails_Line2_Text.setText(null);
            this.AddressDetails_LocalityName_Text.setText(null);
            this.AddressDetails_StateOrTerritory_Code.setText(null);
            this.AddressDetails_Postcode_Text.setText(null);
            this.AddressDetails_Country_Code.setGlenixElementValue(null);
        } else {
            this.Identifiers_AustralianBusinessNumber_Identifier.setText(businessMasterFile.getBusinessABN());
            this.Identifiers_TaxFileNumber_Identifier.setText(businessMasterFile.getBusinessTFN());
            this.OrganisationNameDetails_OrganisationalName_Text.setText(businessMasterFile.getBusinessLegalName());
            TFND0004AddressDetailsBusiness addr = businessMasterFile.getBusinessPostalAddress();
            if (addr != null) {
                this.AddressDetails_Line1_Text.setText(addr.getLine1T());
                this.AddressDetails_Line2_Text.setText(addr.getLine2T());
                this.AddressDetails_LocalityName_Text.setText(addr.getLocalityNameT());
                this.AddressDetails_StateOrTerritory_Code.setText(addr.getStateOrTerritoryC());
                this.AddressDetails_Postcode_Text.setText(addr.getPostcodeT());
                this.AddressDetails_Country_Code.setGlenixElementValue(addr.getCountryC());
            } else {
                this.AddressDetails_Line1_Text.setText(null);
                this.AddressDetails_Line2_Text.setText(null);
                this.AddressDetails_LocalityName_Text.setText(null);
                this.AddressDetails_StateOrTerritory_Code.setText(null);
                this.AddressDetails_Postcode_Text.setText(null);
                this.AddressDetails_Country_Code.setGlenixElementValue(null);
            }
        }
    }

    public void setProfileDetails(Profile profileXBRL) {
        this.agentDetails = null;
        if (profileXBRL != null) {
            this.agentDetails = profileXBRL.getAgentDetails();
        }
        String agentABN = null;
        if (this.agentDetails != null) {
            agentABN = this.agentDetails.getAgentABN();
        }
        if (this.taxReturnFTER0002DeclarationSectionINTVBox != null) {
            this.taxReturnFTER0002DeclarationSectionINTVBox.setAgentDetails(this.agentDetails);
        }
    }

    public void setModel(FTER0002 fter0002) throws Exception {
        Document doc;
        this.fter0002 = fter0002;
        this.clearGlenixXBRL();
        if (fter0002 != null && (doc = fter0002.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
        this.perioddetailscontrolvbox.getChildren().clear();
        this.trusteesvbox.getChildren().clear();
        this.perioddetailssubstitutedvbox.getChildren().clear();
        this.interposedentityvbox.getChildren().clear();
        this.trusteedeclarationsvbox.getChildren().clear();
        this.taxagentdeclarationvbox.getChildren().clear();
        this.cmpcount = 0;
        this.trusteecount = 0;
        this.subcount = 0;
        this.interposedcount = 0;
        this.trusteedeccount = 0;
        this.tadeccount = 0;
        if (fter0002 != null) {
            Document doc2;
            GlenixNCVBox sw;
            List<GlenixElement> ges = fter0002.getChildElementSet("PeriodDetailsControlOutsideAustraliaPartPeriod");
            for (GlenixElement ge : ges) {
                sw = this.addPeriodDetailsControl();
                doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                sw.getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
            ges = fter0002.getChildElementSet("Trustee");
            for (GlenixElement ge : ges) {
                sw = this.addTrustee();
                ((TaxReturnFTER0002TrusteeVBox)sw).setModel((FTER0002Trustee)ge);
            }
            ges = fter0002.getChildElementSet("PeriodDetailsSubstitutedAccountingPeriod");
            for (GlenixElement ge : ges) {
                sw = this.addPeriodDetailsSubstituted();
                doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                sw.getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
            ges = fter0002.getChildElementSet("InterposedEntity");
            for (GlenixElement ge : ges) {
                sw = this.addInterposedEntity();
                ((TaxReturnFTER0002InterposedEntityVBox)sw).setModel((FTER0002InterposedEntity)ge);
            }
            ges = fter0002.getChildElementSet("DeclarationOfTrustee");
            for (GlenixElement ge : ges) {
                sw = this.addTrusteeDeclaration();
                doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                sw.getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
            ges = fter0002.getChildElementSet("DeclarationSectionINT");
            for (GlenixElement ge : ges) {
                sw = this.addTaxAgentDeclaration();
                doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                ((TaxReturnFTER0002DeclarationSectionINTVBox)sw).getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
        }
    }

    private Double getDouble(GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    private Double addDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return result;
        }
        return d + result;
    }

    private Double subtractDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return -result.doubleValue();
        }
        return d - result;
    }

    private Double addDouble(Double d, Double dd) {
        if (dd == null) {
            return d;
        }
        if (d == null) {
            return dd;
        }
        return d + dd;
    }

    @FXML
    private TaxReturnIEE0003PeriodDetailsControl addPeriodDetailsControl() {
        if (this.cmpcount > 11) {
            return null;
        }
        try {
            final TaxReturnIEE0003PeriodDetailsControl sw = new TaxReturnIEE0003PeriodDetailsControl();
            sw.getGlenixController().initialize(null, null);
            this.perioddetailscontrolvbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete period");
            this.perioddetailscontrolvbox.getChildren().add((Object)b);
            ++this.cmpcount;
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnFTER0002Controller.this.perioddetailscontrolvbox.getChildren().remove((Object)sw);
                    TaxReturnFTER0002Controller.this.perioddetailscontrolvbox.getChildren().remove((Object)b);
                    --TaxReturnFTER0002Controller.this.cmpcount;
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    private TaxReturnFTER0002TrusteeVBox addTrustee() {
        if (this.trusteecount > 9) {
            return null;
        }
        try {
            final TaxReturnFTER0002TrusteeVBox sw = new TaxReturnFTER0002TrusteeVBox();
            sw.getGlenixController().initialize(null, null);
            this.trusteesvbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete trustee");
            this.trusteesvbox.getChildren().add((Object)b);
            ++this.trusteecount;
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnFTER0002Controller.this.trusteesvbox.getChildren().remove((Object)sw);
                    TaxReturnFTER0002Controller.this.trusteesvbox.getChildren().remove((Object)b);
                    --TaxReturnFTER0002Controller.this.trusteecount;
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    private TaxReturnIEE0003PeriodDetailsSubstituted addPeriodDetailsSubstituted() {
        if (this.subcount > 0) {
            return null;
        }
        try {
            final TaxReturnIEE0003PeriodDetailsSubstituted sw = new TaxReturnIEE0003PeriodDetailsSubstituted();
            sw.getGlenixController().initialize(null, null);
            this.perioddetailssubstitutedvbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete period");
            this.perioddetailssubstitutedvbox.getChildren().add((Object)b);
            ++this.subcount;
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnFTER0002Controller.this.perioddetailssubstitutedvbox.getChildren().remove((Object)sw);
                    TaxReturnFTER0002Controller.this.perioddetailssubstitutedvbox.getChildren().remove((Object)b);
                    --TaxReturnFTER0002Controller.this.subcount;
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    private TaxReturnFTER0002InterposedEntityVBox addInterposedEntity() {
        if (this.interposedcount > 119) {
            return null;
        }
        try {
            final TaxReturnFTER0002InterposedEntityVBox sw = new TaxReturnFTER0002InterposedEntityVBox();
            sw.getGlenixController().initialize(null, null);
            this.interposedentityvbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete interposed entity");
            this.interposedentityvbox.getChildren().add((Object)b);
            ++this.interposedcount;
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnFTER0002Controller.this.interposedentityvbox.getChildren().remove((Object)sw);
                    TaxReturnFTER0002Controller.this.interposedentityvbox.getChildren().remove((Object)b);
                    --TaxReturnFTER0002Controller.this.interposedcount;
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    private TaxReturnFTER0002DeclarationOfTrustee addTrusteeDeclaration() {
        if (this.trusteedeccount > 9) {
            return null;
        }
        try {
            final TaxReturnFTER0002DeclarationOfTrustee sw = new TaxReturnFTER0002DeclarationOfTrustee();
            sw.getGlenixController().initialize(null, null);
            this.trusteedeclarationsvbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete trustee declaration");
            this.trusteedeclarationsvbox.getChildren().add((Object)b);
            ++this.trusteedeccount;
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnFTER0002Controller.this.trusteedeclarationsvbox.getChildren().remove((Object)sw);
                    TaxReturnFTER0002Controller.this.trusteedeclarationsvbox.getChildren().remove((Object)b);
                    --TaxReturnFTER0002Controller.this.trusteedeccount;
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    private TaxReturnFTER0002DeclarationSectionINTVBox addTaxAgentDeclaration() {
        if (this.tadeccount > 0) {
            return null;
        }
        try {
            this.taxReturnFTER0002DeclarationSectionINTVBox = new TaxReturnFTER0002DeclarationSectionINTVBox();
            this.taxReturnFTER0002DeclarationSectionINTVBox.getGlenixController().initialize(null, null);
            this.taxReturnFTER0002DeclarationSectionINTVBox.setAgentDetails(this.agentDetails);
            this.taxagentdeclarationvbox.getChildren().add((Object)this.taxReturnFTER0002DeclarationSectionINTVBox);
            final Button b = new Button();
            b.setText("Delete tax agent declaration");
            this.taxagentdeclarationvbox.getChildren().add((Object)b);
            ++this.tadeccount;
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnFTER0002Controller.this.taxagentdeclarationvbox.getChildren().remove((Object)TaxReturnFTER0002Controller.this.taxReturnFTER0002DeclarationSectionINTVBox);
                    TaxReturnFTER0002Controller.this.taxagentdeclarationvbox.getChildren().remove((Object)b);
                    --TaxReturnFTER0002Controller.this.tadeccount;
                }
            });
            return this.taxReturnFTER0002DeclarationSectionINTVBox;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    public void setTaxReturnDetails(String type, String status, String year, LocalDate startDate, LocalDate endDate) {
        this.type = type;
        this.year = year;
        this.updateYear();
        if ("fter0002".equals(type)) {
            this.intermediarysection.setVisible(true);
            this.intermediarysection.setManaged(true);
        } else {
            this.intermediarysection.setVisible(false);
            this.intermediarysection.setManaged(false);
        }
    }

    public void updateYear() {
        this.Lodgment_PeriodYear_Year.setGlenixElementValue(this.year);
    }
}

