/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.tr2018;

import au.com.glenix.tr2018.GlenixLabelCountryLabel;
import au.com.glenix.tr2018.GlenixLabelServiceLineCodeCombo;
import au.com.glenix.tr2018.TaxReturnDIS0003Investor;
import au.com.glenix.trn.AgentDetails;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.DIS0003;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.Profile;
import au.com.glenix.trn.ProfileElectronicContact;
import au.com.glenix.trn.TFND0004AddressDetailsBusiness;
import au.com.glenix.widget.ErrorDisplay;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelCheckbox;
import au.com.glenix.widget.GlenixLabelDate;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelOnly;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixVBox;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.util.List;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TaxReturnDIS0003Controller
extends GlenixBranchController {
    private DocumentBuilder dBuilder;
    private DIS0003 dis0003;
    private NumberFormat format2dp = new DecimalFormat("#0.00");
    @FXML
    private GlenixVBox dis0003VBox;
    @FXML
    private VBox investorvbox;
    @FXML
    private VBox intermediarysection;
    @FXML
    private GlenixLabelLabel Identifiers_TaxAgentNumber_Identifier;
    @FXML
    private GlenixLabelLabel Identifiers_AustralianBusinessNumber_Identifier_INT;
    @FXML
    private GlenixLabelLabel Identifiers_TaxFileNumber_Identifier;
    private ErrorDisplay errorDisplay;
    @FXML
    private GlenixLabelLabel Identifiers_AustralianBusinessNumber_Identifier;
    @FXML
    private GlenixLabelLabel OrganisationNameDetails_OrganisationalName_Text;
    @FXML
    private GlenixLabelLabel AddressDetails_Line1_Text_BUSC;
    @FXML
    private GlenixLabelLabel AddressDetails_Line2_Text_BUSC;
    @FXML
    private GlenixLabelLabel AddressDetails_LocalityName_Text_BUSC;
    @FXML
    private GlenixLabelLabel AddressDetails_StateOrTerritory_Code_BUSC;
    @FXML
    private GlenixLabelLabel AddressDetails_Postcode_Text_BUSC;
    @FXML
    private GlenixLabelCountryLabel AddressDetails_Country_Code_BUSC;
    @FXML
    private GlenixLabelLabel AddressDetails_Line1_Text_POSC;
    @FXML
    private GlenixLabelLabel AddressDetails_Line2_Text_POSC;
    @FXML
    private GlenixLabelLabel AddressDetails_LocalityName_Text_POSC;
    @FXML
    private GlenixLabelLabel AddressDetails_StateOrTerritory_Code_POSC;
    @FXML
    private GlenixLabelLabel AddressDetails_Postcode_Text_POSC;
    @FXML
    private GlenixLabelCountryLabel AddressDetails_Country_Code_POSC;
    @FXML
    private GlenixLabelServiceLineCodeCombo ElectronicContact_Telephone_ServiceLine_Code_INT;
    @FXML
    private GlenixLabelLabel ElectronicContact_Telephone_Area_Code_INT;
    @FXML
    private GlenixLabelLabel ElectronicContact_Telephone_Minimal_Number_INT;
    @FXML
    private VBox declarationsection;
    @FXML
    private GlenixLabelCheckbox Declaration_StatementAccepted_Indicator_INT;
    @FXML
    private GlenixLabelText Declaration_SignatoryIdentifier_Text_INT;
    @FXML
    private GlenixLabelDate Declaration_Signature_Date_INT;
    @FXML
    private GlenixLabelOnly Declaration_Statement_Text;
    @FXML
    private GlenixLabelCheckbox Declaration_StatementAccepted_Indicator;
    @FXML
    private GlenixLabelDate Declaration_Signature_Date;
    @FXML
    private GlenixLabelText Declaration_SignatoryIdentifier_Text;
    @FXML
    private GlenixVBox postaladdress;
    @FXML
    private GlenixVBox businessaddress;
    @FXML
    private GlenixLabelLabel Report_TargetFinancial_Year;
    private String type;
    private String year;

    public TaxReturnDIS0003Controller(ErrorDisplay errorDisplay) {
        this.errorDisplay = errorDisplay;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
        }
    }

    public void setModel(DIS0003 dis0003) throws Exception {
        String taabn;
        Document doc;
        this.dis0003 = dis0003;
        this.clearGlenixXBRL();
        if (dis0003 != null && (doc = dis0003.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
        this.investorvbox.getChildren().clear();
        if (dis0003 != null) {
            List<GlenixElement> ges = dis0003.getChildElementSet("Investor");
            for (GlenixElement ge : ges) {
                TaxReturnDIS0003Investor sw = this.addInvestor();
                Document doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                sw.getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
        }
        if ((taabn = this.Identifiers_AustralianBusinessNumber_Identifier_INT.getGlenixElementValue()) != null && !taabn.isEmpty()) {
            this.intermediarysection.setVisible(true);
            this.intermediarysection.setManaged(true);
        } else {
            this.intermediarysection.setVisible(false);
            this.intermediarysection.setManaged(false);
        }
    }

    private Double getDouble(GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    private Double addDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return result;
        }
        return d + result;
    }

    private Double subtractDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return -result.doubleValue();
        }
        return d - result;
    }

    private Double addDouble(Double d, Double dd) {
        if (dd == null) {
            return d;
        }
        if (d == null) {
            return dd;
        }
        return d + dd;
    }

    @FXML
    private TaxReturnDIS0003Investor addInvestor() {
        try {
            final TaxReturnDIS0003Investor sw = new TaxReturnDIS0003Investor();
            sw.getGlenixController().initialize(null, null);
            this.investorvbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete investor");
            this.investorvbox.getChildren().add((Object)b);
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnDIS0003Controller.this.investorvbox.getChildren().remove((Object)sw);
                    TaxReturnDIS0003Controller.this.investorvbox.getChildren().remove((Object)b);
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    public void setBusinessDetails(BusinessMasterFile businessMasterFile) {
        if (businessMasterFile == null) {
            this.Identifiers_AustralianBusinessNumber_Identifier.setText(null);
            this.Identifiers_TaxFileNumber_Identifier.setText(null);
            this.OrganisationNameDetails_OrganisationalName_Text.setText(null);
            this.AddressDetails_Line1_Text_BUSC.setText(null);
            this.AddressDetails_Line2_Text_BUSC.setText(null);
            this.AddressDetails_LocalityName_Text_BUSC.setText(null);
            this.AddressDetails_StateOrTerritory_Code_BUSC.setText(null);
            this.AddressDetails_Postcode_Text_BUSC.setText(null);
            this.AddressDetails_Country_Code_BUSC.setGlenixElementValue(null);
            this.AddressDetails_Line1_Text_POSC.setText(null);
            this.AddressDetails_Line2_Text_POSC.setText(null);
            this.AddressDetails_LocalityName_Text_POSC.setText(null);
            this.AddressDetails_StateOrTerritory_Code_POSC.setText(null);
            this.AddressDetails_Postcode_Text_POSC.setText(null);
            this.AddressDetails_Country_Code_POSC.setGlenixElementValue(null);
        } else {
            this.Identifiers_AustralianBusinessNumber_Identifier.setText(businessMasterFile.getBusinessABN());
            this.Identifiers_TaxFileNumber_Identifier.setText(businessMasterFile.getBusinessTFN());
            this.OrganisationNameDetails_OrganisationalName_Text.setText(businessMasterFile.getBusinessLegalName());
            TFND0004AddressDetailsBusiness addr = businessMasterFile.getBusinessBusinessAddress();
            if (addr != null) {
                this.AddressDetails_Line1_Text_BUSC.setText(addr.getLine1T());
                this.AddressDetails_Line2_Text_BUSC.setText(addr.getLine2T());
                this.AddressDetails_LocalityName_Text_BUSC.setText(addr.getLocalityNameT());
                this.AddressDetails_StateOrTerritory_Code_BUSC.setText(addr.getStateOrTerritoryC());
                this.AddressDetails_Postcode_Text_BUSC.setText(addr.getPostcodeT());
                this.AddressDetails_Country_Code_BUSC.setGlenixElementValue(addr.getCountryC());
            } else {
                this.AddressDetails_Line1_Text_BUSC.setText(null);
                this.AddressDetails_Line2_Text_BUSC.setText(null);
                this.AddressDetails_LocalityName_Text_BUSC.setText(null);
                this.AddressDetails_StateOrTerritory_Code_BUSC.setText(null);
                this.AddressDetails_Postcode_Text_BUSC.setText(null);
                this.AddressDetails_Country_Code_BUSC.setGlenixElementValue(null);
            }
            addr = businessMasterFile.getBusinessPostalAddress();
            if (addr != null) {
                this.AddressDetails_Line1_Text_POSC.setText(addr.getLine1T());
                this.AddressDetails_Line2_Text_POSC.setText(addr.getLine2T());
                this.AddressDetails_LocalityName_Text_POSC.setText(addr.getLocalityNameT());
                this.AddressDetails_StateOrTerritory_Code_POSC.setText(addr.getStateOrTerritoryC());
                this.AddressDetails_Postcode_Text_POSC.setText(addr.getPostcodeT());
                this.AddressDetails_Country_Code_POSC.setGlenixElementValue(addr.getCountryC());
            } else {
                this.AddressDetails_Line1_Text_POSC.setText(null);
                this.AddressDetails_Line2_Text_POSC.setText(null);
                this.AddressDetails_LocalityName_Text_POSC.setText(null);
                this.AddressDetails_StateOrTerritory_Code_POSC.setText(null);
                this.AddressDetails_Postcode_Text_POSC.setText(null);
                this.AddressDetails_Country_Code_POSC.setGlenixElementValue(null);
            }
        }
    }

    public void setProfileDetails(Profile profileXBRL) {
        AgentDetails agentDetails = null;
        if (profileXBRL != null) {
            agentDetails = profileXBRL.getAgentDetails();
        }
        String agentABN = null;
        if (agentDetails != null) {
            agentABN = agentDetails.getAgentABN();
        }
        if (agentABN == null || agentABN.isEmpty() || !"dis0003".equals(this.type)) {
            this.Identifiers_AustralianBusinessNumber_Identifier_INT.setText(null);
            this.Identifiers_TaxAgentNumber_Identifier.setText(null);
            this.ElectronicContact_Telephone_ServiceLine_Code_INT.setGlenixElementValue(null);
            this.ElectronicContact_Telephone_Area_Code_INT.setText(null);
            this.ElectronicContact_Telephone_Minimal_Number_INT.setText(null);
            this.Declaration_SignatoryIdentifier_Text_INT.setText(null);
            this.Declaration_Signature_Date_INT.setGlenixElementValue(null);
            this.Declaration_StatementAccepted_Indicator_INT.setGlenixElementValue(null);
            this.intermediarysection.setVisible(false);
            this.intermediarysection.setManaged(false);
            this.Declaration_StatementAccepted_Indicator.getGlenixController().enableGlenixXBRL();
            this.Declaration_Signature_Date.getGlenixController().enableGlenixXBRL();
            this.Declaration_SignatoryIdentifier_Text.getGlenixController().enableGlenixXBRL();
            String declarationText = "I declare that the information transmitted in this Dividend and Interest Schedule is true and correct and that I am authorised to make this declaration.";
            this.Declaration_Statement_Text.setGlenixElementValue(declarationText);
        } else {
            this.Identifiers_AustralianBusinessNumber_Identifier_INT.setText(agentDetails.getAgentABN());
            this.Identifiers_TaxAgentNumber_Identifier.setText(agentDetails.getAgentNumber());
            ProfileElectronicContact ec = agentDetails.getAgentElectronicContact();
            if (ec != null) {
                this.ElectronicContact_Telephone_ServiceLine_Code_INT.setGlenixElementValue(ec.getElectronicContactTelephoneServiceLineCode());
                this.ElectronicContact_Telephone_Area_Code_INT.setText(ec.getTelephoneAreaC());
                this.ElectronicContact_Telephone_Minimal_Number_INT.setText(ec.getTelephoneMinimalN());
            } else {
                this.ElectronicContact_Telephone_ServiceLine_Code_INT.setGlenixElementValue(null);
                this.ElectronicContact_Telephone_Area_Code_INT.setText(null);
                this.ElectronicContact_Telephone_Minimal_Number_INT.setText(null);
            }
            this.intermediarysection.setVisible(true);
            this.intermediarysection.setManaged(true);
            this.Declaration_StatementAccepted_Indicator.getGlenixController().disableGlenixXBRL();
            this.Declaration_Signature_Date.getGlenixController().disableGlenixXBRL();
            this.Declaration_SignatoryIdentifier_Text.getGlenixController().disableGlenixXBRL();
            this.Declaration_StatementAccepted_Indicator.setGlenixElementValue(null);
            this.Declaration_Signature_Date.setGlenixElementValue(null);
            this.Declaration_SignatoryIdentifier_Text.setGlenixElementValue(null);
            String declarationText = "I declare that:\n* All of the information I have provided to the agent for the preparation of this document is true and correct\n* I authorise the agent to give this document to the Commissioner of Taxation.";
            this.Declaration_Statement_Text.setGlenixElementValue(declarationText);
        }
    }

    public void setTaxReturnDetails(String type, String status, String year, LocalDate startDate, LocalDate endDate) {
        this.type = type;
        this.year = year;
        this.updateYear();
        if ("dis0003".equals(type)) {
            this.declarationsection.setVisible(true);
            this.declarationsection.setManaged(true);
            this.postaladdress.setVisible(true);
            this.postaladdress.setManaged(true);
            this.businessaddress.setVisible(true);
            this.businessaddress.setManaged(true);
        } else {
            this.declarationsection.setVisible(false);
            this.declarationsection.setManaged(false);
            this.postaladdress.setVisible(false);
            this.postaladdress.setManaged(false);
            this.businessaddress.setVisible(false);
            this.businessaddress.setManaged(false);
        }
    }

    public void updateYear() {
        if ("dis0003".equals(this.type)) {
            this.Report_TargetFinancial_Year.setGlenixElementValue(this.year);
        } else {
            this.Report_TargetFinancial_Year.setGlenixElementValue(null);
        }
    }
}

