/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.tr2018;

import au.com.glenix.tr2018.TaxReturnCGTS0006EarnoutArrangement;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.CGTS0006;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.Profile;
import au.com.glenix.widget.ErrorDisplay;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixLabelZeroDecimalPositiveNumber;
import au.com.glenix.widget.GlenixVBox;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TaxReturnCGTS0006Controller
extends GlenixBranchController {
    private DocumentBuilder dBuilder;
    private CGTS0006 cgts0006;
    private NumberFormat format2dp = new DecimalFormat("#0.00");
    @FXML
    private GlenixVBox cgts0006VBox;
    @FXML
    private VBox earnoutarrangementvbox;
    @FXML
    private GlenixLabelLabel Identifiers_TaxFileNumber_Identifier;
    private ErrorDisplay errorDisplay;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Gains_Total_Amount_ListedCompanyShares;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Gains_Total_Amount_OtherShares;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Gains_Total_Amount_ListedUnitTrusts;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Gains_Total_Amount_OtherUnits;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Gains_Total_Amount_AustralianRealProperty;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Gains_Total_Amount_OverseasRealProperty;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Gains_Total_Amount_CapitalGainsTrustDistributions;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Gains_Total_Amount_Collectables;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Gains_Total_Amount_OtherCapitalAssets;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber CapitalGainsTax_DeferredRelief_Amount_OtherCapitalAssets;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Gains_Total_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_Total_Amount_ListedCompanyShares;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_Total_Amount_OtherShares;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_Total_Amount_ListedUnitTrusts;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_Total_Amount_OtherUnits;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_Total_Amount_AustralianRealProperty;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_Total_Amount_OverseasRealProperty;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_Total_Amount_Collectables;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_Total_Amount_OtherCapitalAssets;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_Total_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_Total_Amount_Applied_Y0;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_NetTotal_Amount_Applied_Y0Minus;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_TransferredTotal_Amount_Applied;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_Total_Amount_Applied;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber TaxConcession_CapitalGains_SmallBusinessActiveAssetReduction_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber TaxConcession_CapitalGains_SmallBusinessRetirementExemption_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber TaxConcession_CapitalGains_SmallBusinessRollover_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber TaxConcession_CapitalGains_DiscountAndSmallBusinessConcessionsTotal_Amount;

    public TaxReturnCGTS0006Controller(ErrorDisplay errorDisplay) {
        this.errorDisplay = errorDisplay;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
        }
        this.calculateCapitalGainInit();
        this.calculateCapitalLossInit();
        this.calculateConcessionsInit();
        this.calculateAppliedLossesInit();
    }

    public void setModel(CGTS0006 cgts0006) throws Exception {
        Document doc;
        this.cgts0006 = cgts0006;
        this.clearGlenixXBRL();
        if (cgts0006 != null && (doc = cgts0006.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
        this.earnoutarrangementvbox.getChildren().clear();
        if (cgts0006 != null) {
            List<GlenixElement> ges = cgts0006.getChildElementSet("cgts0006EarnoutArrangement");
            for (GlenixElement ge : ges) {
                TaxReturnCGTS0006EarnoutArrangement sw = this.addEarnoutArrangement();
                Document doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                sw.getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
        }
    }

    private Double getDouble(GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    private Double addDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return result;
        }
        return d + result;
    }

    private Double subtractDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return -result.doubleValue();
        }
        return d - result;
    }

    private Double addDouble(Double d, Double dd) {
        if (dd == null) {
            return d;
        }
        if (d == null) {
            return dd;
        }
        return d + dd;
    }

    public void calculateCapitalGainInit() {
        this.Capital_Gains_Total_Amount_ListedCompanyShares.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalGain()));
        this.Capital_Gains_Total_Amount_OtherShares.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalGain()));
        this.Capital_Gains_Total_Amount_ListedUnitTrusts.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalGain()));
        this.Capital_Gains_Total_Amount_OtherUnits.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalGain()));
        this.Capital_Gains_Total_Amount_AustralianRealProperty.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalGain()));
        this.Capital_Gains_Total_Amount_OverseasRealProperty.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalGain()));
        this.Capital_Gains_Total_Amount_CapitalGainsTrustDistributions.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalGain()));
        this.Capital_Gains_Total_Amount_Collectables.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalGain()));
        this.Capital_Gains_Total_Amount_OtherCapitalAssets.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalGain()));
        this.CapitalGainsTax_DeferredRelief_Amount_OtherCapitalAssets.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalGain()));
    }

    private void calculateCapitalGain() {
        Double total = null;
        total = this.addDouble(total, this.Capital_Gains_Total_Amount_ListedCompanyShares);
        total = this.addDouble(total, this.Capital_Gains_Total_Amount_OtherShares);
        total = this.addDouble(total, this.Capital_Gains_Total_Amount_ListedUnitTrusts);
        total = this.addDouble(total, this.Capital_Gains_Total_Amount_OtherUnits);
        total = this.addDouble(total, this.Capital_Gains_Total_Amount_AustralianRealProperty);
        total = this.addDouble(total, this.Capital_Gains_Total_Amount_OverseasRealProperty);
        total = this.addDouble(total, this.Capital_Gains_Total_Amount_CapitalGainsTrustDistributions);
        total = this.addDouble(total, this.Capital_Gains_Total_Amount_Collectables);
        total = this.addDouble(total, this.Capital_Gains_Total_Amount_OtherCapitalAssets);
        if ((total = this.addDouble(total, this.CapitalGainsTax_DeferredRelief_Amount_OtherCapitalAssets)) == null) {
            this.Capital_Gains_Total_Amount.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.Capital_Gains_Total_Amount.setGlenixElementValue("" + total.intValue());
        }
    }

    public void calculateCapitalLossInit() {
        this.Capital_Losses_Total_Amount_ListedCompanyShares.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalLoss()));
        this.Capital_Losses_Total_Amount_OtherShares.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalLoss()));
        this.Capital_Losses_Total_Amount_ListedUnitTrusts.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalLoss()));
        this.Capital_Losses_Total_Amount_OtherUnits.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalLoss()));
        this.Capital_Losses_Total_Amount_AustralianRealProperty.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalLoss()));
        this.Capital_Losses_Total_Amount_OverseasRealProperty.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalLoss()));
        this.Capital_Losses_Total_Amount_Collectables.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalLoss()));
        this.Capital_Losses_Total_Amount_OtherCapitalAssets.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalLoss()));
    }

    private void calculateCapitalLoss() {
        Double total = null;
        total = this.addDouble(total, this.Capital_Losses_Total_Amount_ListedCompanyShares);
        total = this.addDouble(total, this.Capital_Losses_Total_Amount_OtherShares);
        total = this.addDouble(total, this.Capital_Losses_Total_Amount_ListedUnitTrusts);
        total = this.addDouble(total, this.Capital_Losses_Total_Amount_OtherUnits);
        total = this.addDouble(total, this.Capital_Losses_Total_Amount_AustralianRealProperty);
        total = this.addDouble(total, this.Capital_Losses_Total_Amount_OverseasRealProperty);
        total = this.addDouble(total, this.Capital_Losses_Total_Amount_Collectables);
        if ((total = this.addDouble(total, this.Capital_Losses_Total_Amount_OtherCapitalAssets)) == null) {
            this.Capital_Losses_Total_Amount.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.Capital_Losses_Total_Amount.setGlenixElementValue("" + total.intValue());
        }
    }

    public void calculateAppliedLossesInit() {
        this.Capital_Losses_Total_Amount_Applied_Y0.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateAppliedLosses()));
        this.Capital_Losses_NetTotal_Amount_Applied_Y0Minus.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateAppliedLosses()));
        this.Capital_Losses_TransferredTotal_Amount_Applied.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateAppliedLosses()));
    }

    private void calculateAppliedLosses() {
        Double total = null;
        total = this.addDouble(total, this.Capital_Losses_Total_Amount_Applied_Y0);
        total = this.addDouble(total, this.Capital_Losses_NetTotal_Amount_Applied_Y0Minus);
        if ((total = this.addDouble(total, this.Capital_Losses_TransferredTotal_Amount_Applied)) == null) {
            this.Capital_Losses_Total_Amount_Applied.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.Capital_Losses_Total_Amount_Applied.setGlenixElementValue("" + total.intValue());
        }
    }

    public void calculateConcessionsInit() {
        this.TaxConcession_CapitalGains_SmallBusinessActiveAssetReduction_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateConcessions()));
        this.TaxConcession_CapitalGains_SmallBusinessRetirementExemption_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateConcessions()));
        this.TaxConcession_CapitalGains_SmallBusinessRollover_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateConcessions()));
    }

    private void calculateConcessions() {
        Double total = null;
        total = this.addDouble(total, this.TaxConcession_CapitalGains_SmallBusinessActiveAssetReduction_Amount);
        total = this.addDouble(total, this.TaxConcession_CapitalGains_SmallBusinessRetirementExemption_Amount);
        if ((total = this.addDouble(total, this.TaxConcession_CapitalGains_SmallBusinessRollover_Amount)) == null) {
            this.TaxConcession_CapitalGains_DiscountAndSmallBusinessConcessionsTotal_Amount.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.TaxConcession_CapitalGains_DiscountAndSmallBusinessConcessionsTotal_Amount.setGlenixElementValue("" + total.intValue());
        }
    }

    @FXML
    private TaxReturnCGTS0006EarnoutArrangement addEarnoutArrangement() {
        try {
            final TaxReturnCGTS0006EarnoutArrangement sw = new TaxReturnCGTS0006EarnoutArrangement();
            sw.getGlenixController().initialize(null, null);
            this.earnoutarrangementvbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete earnout arrangement");
            this.earnoutarrangementvbox.getChildren().add((Object)b);
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnCGTS0006Controller.this.earnoutarrangementvbox.getChildren().remove((Object)sw);
                    TaxReturnCGTS0006Controller.this.earnoutarrangementvbox.getChildren().remove((Object)b);
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    public void setBusinessDetails(BusinessMasterFile businessMasterFile) {
        if (businessMasterFile != null) {
            this.Identifiers_TaxFileNumber_Identifier.setGlenixElementValue(businessMasterFile.getBusinessTFN());
        }
    }

    public void setProfileDetails(Profile profileXBRL) {
    }
}

