/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.tr2018;

import au.com.glenix.tr2018.TaxReturnCGNFT0002Subsidiary;
import au.com.glenix.trn.AgentDetails;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.CGNFT0002;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.Profile;
import au.com.glenix.trn.ProfileElectronicContact;
import au.com.glenix.widget.ErrorDisplay;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelOnly;
import au.com.glenix.widget.GlenixVBox;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.ResourceBundle;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TaxReturnCGNFT0002Controller
extends GlenixBranchController {
    private DocumentBuilder dBuilder;
    private CGNFT0002 cgnft0002;
    private NumberFormat format2dp = new DecimalFormat("#0.00");
    @FXML
    private VBox subsidiaryvbox;
    @FXML
    private GlenixLabelLabel Identifiers_TaxFileNumber_Identifier;
    private ErrorDisplay errorDisplay;
    @FXML
    private GlenixLabelLabel Identifiers_AustralianBusinessNumber_Identifier;
    @FXML
    private GlenixVBox intermediarysection;
    @FXML
    private GlenixLabelLabel Identifiers_AustralianBusinessNumber_Identifier_INT_TrueAndCorrect;
    @FXML
    private GlenixLabelLabel PersonUnstructuredName_FullName_Text_INT_TrueAndCorrect;
    @FXML
    private GlenixLabelLabel ElectronicContact_Telephone_Area_Code_INT_TrueAndCorrect;
    @FXML
    private GlenixLabelLabel ElectronicContact_Telephone_Minimal_Number_INT_TrueAndCorrect;
    @FXML
    private GlenixLabelLabel Identifiers_TaxAgentNumber_Identifier_INT_TrueAndCorrect;
    @FXML
    private GlenixLabelOnly Declaration_Statement_Text;

    public TaxReturnCGNFT0002Controller(ErrorDisplay errorDisplay) {
        this.errorDisplay = errorDisplay;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setModel(CGNFT0002 cgnft0002) throws Exception {
        String taabn;
        Document doc;
        this.cgnft0002 = cgnft0002;
        this.clearGlenixXBRL();
        if (cgnft0002 != null && (doc = cgnft0002.buildDocument()) != null) {
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
        this.subsidiaryvbox.getChildren().clear();
        if (cgnft0002 != null) {
            List<GlenixElement> ges = cgnft0002.getChildElementSet("cgnft0002CP");
            for (GlenixElement ge : ges) {
                TaxReturnCGNFT0002Subsidiary sw = this.addSubsidiary();
                Document doc2 = this.dBuilder.newDocument();
                ge.appendToElement(doc2);
                sw.getGlenixController().loadGlenixXBRL(doc2, doc2.getDocumentElement());
            }
        }
        if ((taabn = this.Identifiers_AustralianBusinessNumber_Identifier_INT_TrueAndCorrect.getGlenixElementValue()) != null && !taabn.isEmpty()) {
            this.intermediarysection.setVisible(true);
            this.intermediarysection.setManaged(true);
        } else {
            this.intermediarysection.setVisible(false);
            this.intermediarysection.setManaged(false);
        }
    }

    @FXML
    private TaxReturnCGNFT0002Subsidiary addSubsidiary() {
        try {
            final TaxReturnCGNFT0002Subsidiary sw = new TaxReturnCGNFT0002Subsidiary();
            sw.getGlenixController().initialize(null, null);
            this.subsidiaryvbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete subsidiary");
            this.subsidiaryvbox.getChildren().add((Object)b);
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnCGNFT0002Controller.this.subsidiaryvbox.getChildren().remove((Object)sw);
                    TaxReturnCGNFT0002Controller.this.subsidiaryvbox.getChildren().remove((Object)b);
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void setBusinessDetails(BusinessMasterFile businessMasterFile) {
        if (businessMasterFile == null) {
            this.Identifiers_AustralianBusinessNumber_Identifier.setText(null);
            this.Identifiers_TaxFileNumber_Identifier.setText(null);
        } else {
            this.Identifiers_AustralianBusinessNumber_Identifier.setText(businessMasterFile.getBusinessABN());
            this.Identifiers_TaxFileNumber_Identifier.setText(businessMasterFile.getBusinessTFN());
        }
    }

    public void setProfileDetails(Profile profileXBRL) {
        AgentDetails agentDetails = null;
        if (profileXBRL != null) {
            agentDetails = profileXBRL.getAgentDetails();
        }
        String agentABN = null;
        if (agentDetails != null) {
            agentABN = agentDetails.getAgentABN();
        }
        if (agentABN == null || agentABN.isEmpty()) {
            this.Identifiers_AustralianBusinessNumber_Identifier_INT_TrueAndCorrect.setText(null);
            this.Identifiers_TaxAgentNumber_Identifier_INT_TrueAndCorrect.setText(null);
            this.ElectronicContact_Telephone_Area_Code_INT_TrueAndCorrect.setText(null);
            this.ElectronicContact_Telephone_Minimal_Number_INT_TrueAndCorrect.setText(null);
            this.PersonUnstructuredName_FullName_Text_INT_TrueAndCorrect.setText(null);
            this.intermediarysection.setVisible(false);
            this.intermediarysection.setManaged(false);
            String declarationText = "I certify that I am the public officer, agent or trustee of the head company of this group or the person who was its public officer, agent or trustee before the group ceased to exist; all membership requirements have been met; the information given on this notification is true and correct; and that I consent to the collection of this information.";
            this.Declaration_Statement_Text.setGlenixElementValue(declarationText);
        } else {
            this.Identifiers_AustralianBusinessNumber_Identifier_INT_TrueAndCorrect.setText(agentDetails.getAgentABN());
            this.Identifiers_TaxAgentNumber_Identifier_INT_TrueAndCorrect.setText(agentDetails.getAgentNumber());
            ProfileElectronicContact ec = agentDetails.getAgentElectronicContact();
            if (ec != null) {
                this.PersonUnstructuredName_FullName_Text_INT_TrueAndCorrect.setText(ec.getPersonUnstructuredNameFullNameT());
                this.ElectronicContact_Telephone_Area_Code_INT_TrueAndCorrect.setText(ec.getTelephoneAreaC());
                this.ElectronicContact_Telephone_Minimal_Number_INT_TrueAndCorrect.setText(ec.getTelephoneMinimalN());
            } else {
                this.PersonUnstructuredName_FullName_Text_INT_TrueAndCorrect.setText(null);
                this.ElectronicContact_Telephone_Area_Code_INT_TrueAndCorrect.setText(null);
                this.ElectronicContact_Telephone_Minimal_Number_INT_TrueAndCorrect.setText(null);
            }
            this.intermediarysection.setVisible(true);
            this.intermediarysection.setManaged(true);
            String declarationText = "I declare that:\n* All of the information I have provided to the agent for the preparation of this document is true and correct\n* I authorise the agent to give this document to the Commissioner of Taxation.";
            this.Declaration_Statement_Text.setGlenixElementValue(declarationText);
        }
    }
}

