/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.tr2018;

import au.com.glenix.tr2018.TaxReturnCGLS0006JE;
import au.com.glenix.tr2018.TaxReturnCGLS0006TRFR;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.CGLS0006;
import au.com.glenix.trn.GlenixElement;
import au.com.glenix.trn.Profile;
import au.com.glenix.widget.ErrorDisplay;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelLabel;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixLabelZeroDecimalPositiveNumber;
import au.com.glenix.widget.GlenixNCVBox;
import au.com.glenix.widget.GlenixVBox;
import java.net.URL;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.layout.VBox;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TaxReturnCGLS0006Controller
extends GlenixBranchController {
    private DocumentBuilder dBuilder;
    private CGLS0006 cgls0006;
    private NumberFormat format2dp = new DecimalFormat("#0.00");
    @FXML
    private GlenixVBox cgls0006VBox;
    @FXML
    private VBox trfrvbox;
    @FXML
    private VBox jevbox;
    private int jecount = 0;
    private int trfrcount = 0;
    @FXML
    private GlenixLabelLabel Identifiers_TaxFileNumber_Identifier;
    private ErrorDisplay errorDisplay;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_BalanceOfTaxLossesBroughtForwardFromPriorYear_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_Uplift_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_TransferredFromJoiningEntitiesUnderSubdivision707A_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_TransferredWithNilAvailableFractionApplied_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_ForgivenDebtNet_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_Incurred_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_ConversionOfExcessFrankingOffsets_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_ExemptIncomeNet_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_Forgone_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_Total_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_TransferredOut_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_CarriedForward_LaterIncomeYearsTotal_Amount;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_CarriedForward_Total_Amount_GRP;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_CarriedForward_Total_Amount_TRFD;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_CarriedForward_Total_Amount_TOT;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_Deducted_Amount_GRP;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_Deducted_Amount_TRFD;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Tax_Losses_Deducted_Amount_TOT;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_AppliedNet_Amount_GRP;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_AppliedNet_Amount_TRFD;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_AppliedNet_Amount_TOT;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_CarriedForward_Net_Amount_GRP;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_CarriedForward_Net_Amount_TRFD;
    @FXML
    private GlenixLabelZeroDecimalPositiveNumber Capital_Losses_CarriedForward_Net_Amount_TOT;

    public TaxReturnCGLS0006Controller(ErrorDisplay errorDisplay) {
        this.errorDisplay = errorDisplay;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
        }
        this.calculateCapitalLossCarriedInit();
        this.calculateCapitalLossDeductedInit();
        this.calculateTaxLossCarriedInit();
        this.calculateTaxLossDeductedInit();
        this.calculateCarriedForwardInit();
    }

    public void setModel(CGLS0006 cgls0006) throws Exception {
        Document doc;
        GlenixNCVBox sw;
        List<GlenixElement> ges;
        Document doc2;
        this.cgls0006 = cgls0006;
        this.clearGlenixXBRL();
        if (cgls0006 != null && (doc2 = cgls0006.buildDocument()) != null) {
            this.loadGlenixXBRL(doc2, doc2.getDocumentElement());
        }
        this.jecount = 0;
        this.trfrcount = 0;
        this.trfrvbox.getChildren().clear();
        if (cgls0006 != null) {
            ges = cgls0006.getChildElementSet("cgls0006TRFR");
            for (GlenixElement ge : ges) {
                sw = this.addTRFR();
                doc = this.dBuilder.newDocument();
                ge.appendToElement(doc);
                ((TaxReturnCGLS0006TRFR)sw).getGlenixController().loadGlenixXBRL(doc, doc.getDocumentElement());
            }
        }
        this.jevbox.getChildren().clear();
        if (cgls0006 != null) {
            ges = cgls0006.getChildElementSet("cgls0006JE");
            for (GlenixElement ge : ges) {
                sw = this.addJE();
                doc = this.dBuilder.newDocument();
                ge.appendToElement(doc);
                ((TaxReturnCGLS0006JE)sw).getGlenixController().loadGlenixXBRL(doc, doc.getDocumentElement());
            }
        }
    }

    private Double getDouble(GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return 0.0;
        }
        return result;
    }

    private Double addDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return result;
        }
        return d + result;
    }

    private Double subtractDouble(Double d, GlenixLabelText glt) {
        Double result = glt.getDouble();
        if (result == null) {
            return d;
        }
        if (d == null) {
            return -result.doubleValue();
        }
        return d - result;
    }

    private Double addDouble(Double d, Double dd) {
        if (dd == null) {
            return d;
        }
        if (d == null) {
            return dd;
        }
        return d + dd;
    }

    public void calculateCarriedForwardInit() {
        this.Tax_Losses_BalanceOfTaxLossesBroughtForwardFromPriorYear_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCarriedForward()));
        this.Tax_Losses_Uplift_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCarriedForward()));
        this.Tax_Losses_TransferredFromJoiningEntitiesUnderSubdivision707A_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCarriedForward()));
        this.Tax_Losses_TransferredWithNilAvailableFractionApplied_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCarriedForward()));
        this.Tax_Losses_ForgivenDebtNet_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCarriedForward()));
        this.Tax_Losses_Incurred_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCarriedForward()));
        this.Tax_Losses_ConversionOfExcessFrankingOffsets_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCarriedForward()));
        this.Tax_Losses_ExemptIncomeNet_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCarriedForward()));
        this.Tax_Losses_Forgone_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCarriedForward()));
        this.Tax_Losses_Total_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCarriedForward()));
        this.Tax_Losses_TransferredOut_Amount.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCarriedForward()));
    }

    private void calculateCarriedForward() {
        Double total = null;
        total = this.addDouble(total, this.Tax_Losses_BalanceOfTaxLossesBroughtForwardFromPriorYear_Amount);
        total = this.addDouble(total, this.Tax_Losses_Uplift_Amount);
        total = this.addDouble(total, this.Tax_Losses_TransferredFromJoiningEntitiesUnderSubdivision707A_Amount);
        total = this.subtractDouble(total, this.Tax_Losses_TransferredWithNilAvailableFractionApplied_Amount);
        total = this.subtractDouble(total, this.Tax_Losses_ForgivenDebtNet_Amount);
        total = this.addDouble(total, this.Tax_Losses_Incurred_Amount);
        total = this.addDouble(total, this.Tax_Losses_ConversionOfExcessFrankingOffsets_Amount);
        total = this.subtractDouble(total, this.Tax_Losses_ExemptIncomeNet_Amount);
        total = this.subtractDouble(total, this.Tax_Losses_Forgone_Amount);
        total = this.subtractDouble(total, this.Tax_Losses_Total_Amount);
        if ((total = this.subtractDouble(total, this.Tax_Losses_TransferredOut_Amount)) == null) {
            this.Tax_Losses_CarriedForward_LaterIncomeYearsTotal_Amount.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.Tax_Losses_CarriedForward_LaterIncomeYearsTotal_Amount.setGlenixElementValue("" + total.intValue());
        }
    }

    public void calculateTaxLossCarriedInit() {
        this.Tax_Losses_CarriedForward_Total_Amount_GRP.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTaxLossCarried()));
        this.Tax_Losses_CarriedForward_Total_Amount_TRFD.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTaxLossCarried()));
    }

    private void calculateTaxLossCarried() {
        Double total = null;
        total = this.addDouble(total, this.Tax_Losses_CarriedForward_Total_Amount_GRP);
        if ((total = this.addDouble(total, this.Tax_Losses_CarriedForward_Total_Amount_TRFD)) == null) {
            this.Tax_Losses_CarriedForward_Total_Amount_TOT.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.Tax_Losses_CarriedForward_Total_Amount_TOT.setGlenixElementValue("" + total.intValue());
        }
    }

    public void calculateTaxLossDeductedInit() {
        this.Tax_Losses_Deducted_Amount_GRP.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTaxLossDeducted()));
        this.Tax_Losses_Deducted_Amount_TRFD.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateTaxLossDeducted()));
    }

    private void calculateTaxLossDeducted() {
        Double total = null;
        total = this.addDouble(total, this.Tax_Losses_Deducted_Amount_GRP);
        if ((total = this.addDouble(total, this.Tax_Losses_Deducted_Amount_TRFD)) == null) {
            this.Tax_Losses_Deducted_Amount_TOT.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.Tax_Losses_Deducted_Amount_TOT.setGlenixElementValue("" + total.intValue());
        }
    }

    public void calculateCapitalLossDeductedInit() {
        this.Capital_Losses_AppliedNet_Amount_GRP.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalLossDeducted()));
        this.Capital_Losses_AppliedNet_Amount_TRFD.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalLossDeducted()));
    }

    private void calculateCapitalLossDeducted() {
        Double total = null;
        total = this.addDouble(total, this.Capital_Losses_AppliedNet_Amount_GRP);
        if ((total = this.addDouble(total, this.Capital_Losses_AppliedNet_Amount_TRFD)) == null) {
            this.Capital_Losses_AppliedNet_Amount_TOT.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.Capital_Losses_AppliedNet_Amount_TOT.setGlenixElementValue("" + total.intValue());
        }
    }

    public void calculateCapitalLossCarriedInit() {
        this.Capital_Losses_CarriedForward_Net_Amount_GRP.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalLossCarried()));
        this.Capital_Losses_CarriedForward_Net_Amount_TRFD.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(s, s1, s2) -> this.calculateCapitalLossCarried()));
    }

    private void calculateCapitalLossCarried() {
        Double total = null;
        total = this.addDouble(total, this.Capital_Losses_CarriedForward_Net_Amount_GRP);
        if ((total = this.addDouble(total, this.Capital_Losses_CarriedForward_Net_Amount_TRFD)) == null) {
            this.Capital_Losses_CarriedForward_Net_Amount_TOT.setGlenixElementValue(null);
        } else {
            if (total < 0.0) {
                total = 0.0;
            }
            this.Capital_Losses_CarriedForward_Net_Amount_TOT.setGlenixElementValue("" + total.intValue());
        }
    }

    @FXML
    private TaxReturnCGLS0006TRFR addTRFR() {
        try {
            final TaxReturnCGLS0006TRFR sw = new TaxReturnCGLS0006TRFR();
            sw.getGlenixController().initialize(null, null);
            this.trfrvbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete transfer");
            this.trfrvbox.getChildren().add((Object)b);
            ++this.trfrcount;
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnCGLS0006Controller.this.trfrvbox.getChildren().remove((Object)sw);
                    TaxReturnCGLS0006Controller.this.trfrvbox.getChildren().remove((Object)b);
                    TaxReturnCGLS0006Controller.this.trfrcount--;
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    @FXML
    private TaxReturnCGLS0006JE addJE() {
        try {
            final TaxReturnCGLS0006JE sw = new TaxReturnCGLS0006JE();
            sw.getGlenixController().initialize(null, null);
            this.jevbox.getChildren().add((Object)sw);
            final Button b = new Button();
            b.setText("Delete transfer");
            this.jevbox.getChildren().add((Object)b);
            ++this.jecount;
            b.addEventHandler(ActionEvent.ACTION, (EventHandler)new EventHandler<ActionEvent>(){

                public void handle(ActionEvent actionEvent) {
                    TaxReturnCGLS0006Controller.this.jevbox.getChildren().remove((Object)sw);
                    TaxReturnCGLS0006Controller.this.jevbox.getChildren().remove((Object)b);
                    TaxReturnCGLS0006Controller.this.jecount--;
                }
            });
            return sw;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.errorDisplay.displayError(e.getMessage());
            return null;
        }
    }

    public void setBusinessDetails(BusinessMasterFile businessMasterFile) {
        if (businessMasterFile != null) {
            this.Identifiers_TaxFileNumber_Identifier.setGlenixElementValue(businessMasterFile.getBusinessTFN());
        }
    }

    public void setProfileDetails(Profile profileXBRL) {
    }
}

