/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationController;
import au.com.glenix.TrashTransactionTableController;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.Transaction;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;

public class TrashTransactionTableCloudController
extends TrashTransactionTableController {
    private boolean doupdate = true;

    public TrashTransactionTableCloudController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    @Override
    @FXML
    protected void deleteSelectedTransactions() {
    }

    @Override
    @FXML
    protected void deleteAllTransactions() {
    }

    @Override
    @FXML
    protected void restoreSelectedTransactions() {
        this.transaction = null;
        ObservableList selectedTransactions = this.transactionTable.getSelectionModel().getSelectedItems();
        if (selectedTransactions != null && selectedTransactions.size() > 0) {
            try {
                for (Transaction t : selectedTransactions) {
                    if (this.lodgedActivityStatementIsChanged(t)) {
                        throw new Exception("Error, one of the lines is on a lodged Activity Statment.");
                    }
                    if (!this.transactionBatchIsLocked(t)) continue;
                    throw new Exception("Error, one of the lines is on an authorised or lodged Batch.");
                }
                for (Transaction t : selectedTransactions) {
                    t.setTransactionStatus("posted");
                }
                this.xbrlFileController.saveTransactions((Collection<Transaction>)selectedTransactions);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
                this.error_message.setText(e.getMessage());
                return;
            }
        } else {
            String message = "Error, there are no selected transactions to restore.";
            this.xbrlFileController.setStatusBarMessage(message);
            this.error_message.setText(message);
            return;
        }
        this.updateFilter();
        this.refreshTable();
        this.updateTotalAmount();
    }

    @Override
    @FXML
    protected void restoreAllTransactions() {
    }

    public void retrieveTransactions() {
        if (!this.doupdate) {
            return;
        }
        LocalDate maxDate = this.filterToDate.getLocalDate();
        LocalDate minDate = this.filterFromDate.getLocalDate();
        try {
            GlenixTrnXBRL newTrns = this.xbrlFileController.getCancelledTransactionList(minDate, maxDate, null);
            this.setTransactions(newTrns, minDate, maxDate, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    protected String getReportHeading() {
        return "Trash";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactions(GlenixTrnXBRL transactions, LocalDate minDate, LocalDate maxDate, String divisionIdentifier) throws Exception {
        boolean setupdate = true;
        if (!this.doupdate) {
            setupdate = false;
        } else {
            this.doupdate = false;
        }
        try {
            this.filterToDate.setLocalDate(maxDate);
            this.filterFromDate.setLocalDate(minDate);
            if (maxDate != null && minDate != null && minDate.compareTo(maxDate) <= 0) {
                this.page_heading.setText(this.getReportHeading() + " from " + minDate.format(this.displayDateFormatter) + " to " + minDate.format(this.displayDateFormatter));
            } else {
                this.page_heading.setText(this.getReportHeading());
            }
            if (transactions == null) {
                this.setTransactionObservableList((ObservableList<Transaction>)FXCollections.observableList(new ArrayList()));
                if (setupdate) {
                    this.doupdate = true;
                }
                return;
            }
            ArrayList<Transaction> tal = transactions.getTransactionArrayList();
            if (tal == null || tal.isEmpty()) {
                this.setTransactionObservableList((ObservableList<Transaction>)FXCollections.observableList(new ArrayList()));
                if (setupdate) {
                    this.doupdate = true;
                }
                return;
            }
            this.setTransactionObservableList((ObservableList<Transaction>)FXCollections.observableList(transactions.getTransactionArrayList()));
        }
        finally {
            if (setupdate) {
                this.doupdate = true;
            }
        }
    }
}

