/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.GlenixLabelCounterpartyCombo;
import au.com.glenix.TransactionEditShortFormVBox;
import au.com.glenix.cloud.CloudApplicationController;
import au.com.glenix.cloud.GlenixLabelBlankMonthsHistoryCombo;
import au.com.glenix.cloud.TransactionEditShortFormCloudVBox;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.Batch;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.OutgoingMailServer;
import au.com.glenix.trn.Profile;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixFlowPane;
import au.com.glenix.widget.GlenixLabelDate;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPDFWrapperNewPageCallback;
import java.io.File;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.UUID;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.scene.layout.Region;
import javafx.scene.web.HTMLEditor;
import javafx.util.Callback;
import javafx.util.Pair;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TransactionsTableReceiveMoneyController
extends GlenixBranchController
implements GlenixPDFWrapperNewPageCallback {
    protected HashSet<String> transactionTransactionTypeSet;
    protected DocumentBuilder dBuilder;
    @FXML
    protected GlenixFlowPane fp1;
    @FXML
    protected Label error_message;
    @FXML
    protected Label page_heading;
    @FXML
    protected TableView<ReceivableRow> transactionTable;
    @FXML
    protected TableColumn reconciliationDetailsAndAmountColumn;
    @FXML
    protected TableColumn transactionCounterpartyColumn;
    @FXML
    protected TableColumn amountColumn;
    @FXML
    protected TableColumn accountColumn;
    @FXML
    protected TableColumn provisionColumn;
    @FXML
    protected TableColumn transactionCommentColumn;
    @FXML
    protected TableColumn transactionDateColumn;
    @FXML
    protected TableColumn taxAmountColumn;
    @FXML
    protected TransactionEditShortFormVBox transactionEditFormVBox;
    @FXML
    protected GlenixLabelText filterText;
    @FXML
    protected GlenixLabelBlankMonthsHistoryCombo displayMonths;
    @FXML
    protected GlenixLabelDate filterToDate;
    protected LocalDate lastMinDate;
    protected LocalDate lastMaxDate = null;
    protected CloudApplicationController xbrlFileController = null;
    protected GlenixTrnXBRL transactions = null;
    protected ObservableList<ReceivableRow> receivableRowObservableList = null;
    protected FilteredList<ReceivableRow> filteredItems = null;
    protected String pattern = "dd MMM yyyy";
    protected DateTimeFormatter displayDateFormatter;
    protected Transaction transaction = null;
    @FXML
    protected Label total_label;
    protected DecimalFormat amountFormat;
    protected DecimalFormat quantityFormat;
    protected LocalDate lastLocalDate = null;
    @FXML
    protected HTMLEditor html_message;
    @FXML
    protected GlenixLabelText email_to;
    @FXML
    protected GlenixLabelText email_from;
    @FXML
    protected GlenixLabelText email_subject;
    protected boolean doupdate = true;
    protected boolean suspendSelectionChange = false;
    protected HashSet<ReceivableRow> selectedRows = new HashSet();
    @FXML
    protected GlenixLabelCounterpartyCombo counterpartyIdentifier;
    @FXML
    protected ScrollPane transaction_scroll_pane;
    @FXML
    protected Region otherpane;
    protected Double totalAmount = 0.0;
    protected boolean selection_visible = true;
    protected Double totalSelectedAmount = 0.0;
    protected int totalSelectedCount = 0;

    public TransactionsTableReceiveMoneyController(CloudApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
        this.amountFormat = new DecimalFormat("$#,##0.00");
        this.amountFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.quantityFormat = new DecimalFormat("#,##0.######");
        this.quantityFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.transactionTransactionTypeSet = new HashSet();
        this.transactionTransactionTypeSet.add("sales_invoice");
        this.transactionTransactionTypeSet.add("sales_credit");
    }

    protected void setupActionColumn() {
        if (this.transactionTable != null) {
            this.transactionTable.setRowFactory(tv -> {
                TableRow row = new TableRow();
                row.setOnMouseClicked(event -> {
                    block14: {
                        if (event.getClickCount() != 1 && event.getClickCount() == 2) {
                            if (!row.isEmpty()) {
                                ReceivableRow receivableRow = (ReceivableRow)row.getItem();
                                Transaction t = receivableRow.getTransaction();
                                if (receivableRow != null && t != null) {
                                    try {
                                        String batchIdentifier = t.getBatchIdentifier();
                                        if (batchIdentifier != null && !batchIdentifier.isEmpty()) {
                                            String tt = t.getTransactionType();
                                            if (tt == null || tt.equals("pay_slip")) {
                                                this.xbrlFileController.gotoBatchPaySlipEdit(t, batchIdentifier);
                                            } else {
                                                this.xbrlFileController.gotoBatchTransactionEdit(t, batchIdentifier);
                                            }
                                            break block14;
                                        }
                                        String homeOfficeIdentifier = t.getHomeOfficeIdentifier();
                                        if (homeOfficeIdentifier != null && !homeOfficeIdentifier.isEmpty()) {
                                            this.xbrlFileController.gotoHomeOfficeTransactionsE(t, homeOfficeIdentifier);
                                            break block14;
                                        }
                                        String fuelTaxCreditIdentifier = t.getFuelTaxCreditIdentifier();
                                        if (fuelTaxCreditIdentifier != null && !fuelTaxCreditIdentifier.isEmpty()) {
                                            this.xbrlFileController.gotoFuelTaxCreditTransactionsE(t, fuelTaxCreditIdentifier);
                                            break block14;
                                        }
                                        String tt = t.getTransactionType();
                                        if (tt != null && (tt.equals("sales_invoice") || tt.equals("sales_credit"))) {
                                            this.xbrlFileController.gotoSendInvoiceE(t);
                                            break block14;
                                        }
                                        if (tt != null && (tt.equals("purchase_invoice") || tt.equals("purchase_credit"))) {
                                            this.xbrlFileController.gotoReceiveInvoiceE(t);
                                            break block14;
                                        }
                                        this.error_message.setText(null);
                                        this.xbrlFileController.setStatusBarMessage(null);
                                        this.loadTransaction(t);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        this.error_message.setText("Error, could not go to transaction edit page.");
                                        this.xbrlFileController.setStatusBarMessage("Error, could not go to transaction edit page.");
                                    }
                                } else {
                                    this.error_message.setText("Error, could not get transaction.");
                                    this.xbrlFileController.setStatusBarMessage("Error, could not get transaction.");
                                }
                            } else {
                                this.clearTransaction();
                            }
                        }
                    }
                });
                return row;
            });
            this.transactionTable.getSelectionModel().selectedItemProperty().addListener((ChangeListener)new ChangeListener<ReceivableRow>(){

                public void changed(ObservableValue<? extends ReceivableRow> observable, ReceivableRow oldValue, final ReceivableRow newValue) {
                    if (newValue != null && newValue.getTransaction() != TransactionsTableReceiveMoneyController.this.transaction) {
                        TransactionsTableReceiveMoneyController.this.error_message.setText("Loading...");
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    Thread.sleep(100L);
                                    Platform.runLater(() -> TransactionsTableReceiveMoneyController.this.loadTransaction(newValue.getTransaction()));
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                            }
                        }).start();
                    }
                }
            });
        }
        if (this.displayMonths != null) {
            this.displayMonths.setSingleComboChangeListener(new ChangeListener<Pair<String, String>>(){

                public void changed(ObservableValue<? extends Pair<String, String>> observable, Pair<String, String> oldValue, Pair<String, String> newValue) {
                    TransactionsTableReceiveMoneyController.this.retrieveTransactions();
                }
            });
        }
        this.filterToDate.setSingleDateChangeListener(new ChangeListener<LocalDate>(){

            public void changed(ObservableValue<? extends LocalDate> observable, LocalDate oldValue, LocalDate newValue) {
                TransactionsTableReceiveMoneyController.this.retrieveTransactions();
            }
        });
        this.transactionTable.getSelectionModel().getSelectedItems().addListener(new ListChangeListener(){

            public void onChanged(ListChangeListener.Change change) {
                TransactionsTableReceiveMoneyController.this.updateSelectedRows();
                TransactionsTableReceiveMoneyController.this.updateSelectedAmount();
            }
        });
    }

    protected void updateSelectedRows() {
        if (this.suspendSelectionChange) {
            return;
        }
        ObservableList selectedItems = this.transactionTable.getSelectionModel().getSelectedItems();
        for (ReceivableRow ttl : this.filteredItems) {
            if (selectedItems.contains((Object)ttl)) {
                if (this.selectedRows.contains(ttl)) continue;
                this.selectedRows.add(ttl);
                continue;
            }
            if (!this.selectedRows.contains(ttl)) continue;
            this.selectedRows.remove(ttl);
        }
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        this.transactionEditFormVBox.addCounterpartyComboChangeListener(new ChangeListener<Transaction>(){

            public void changed(ObservableValue<? extends Transaction> observable, Transaction oldValue, Transaction newValue) {
                if (newValue == null) {
                    TransactionsTableReceiveMoneyController.this.addNewNoAccountLines(TransactionsTableReceiveMoneyController.this.transaction, null);
                } else {
                    TransactionsTableReceiveMoneyController.this.addNewNoAccountLines(TransactionsTableReceiveMoneyController.this.transaction, newValue.getCounterpartyIdentifier());
                }
            }
        });
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        this.displayDateFormatter = DateTimeFormatter.ofPattern(this.pattern);
        if (this.transactionEditFormVBox != null) {
            this.lastLocalDate = LocalDate.now();
            this.transactionEditFormVBox.setTransactionLocalDate(this.lastLocalDate);
        }
        this.setupActionColumn();
        if (this.filterText != null) {
            this.filterText.addTextChangeListener((ChangeListener<String>)((ChangeListener)(obs, oldValue, newValue) -> this.updateFilter()));
        }
        if (this.counterpartyIdentifier != null) {
            this.counterpartyIdentifier.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(obs, oldValue, newValue) -> this.updateFilter()));
        }
        if (this.transactionCounterpartyColumn != null) {
            this.transactionCounterpartyColumn.setCellFactory((Callback)new Callback<TableColumn<ReceivableRow, String>, TableCell<ReceivableRow, String>>(){

                public TableCell call(TableColumn<ReceivableRow, String> param) {
                    TableCell<ReceivableRow, String> cell = new TableCell<ReceivableRow, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                ReceivableRow rr = (ReceivableRow)this.getTableView().getItems().get(this.getIndex());
                                Transaction t = rr.getTransaction();
                                String id = t.getCounterpartyIdentifier();
                                boolean isset = false;
                                if (id != null) {
                                    try {
                                        Transaction ct = TransactionsTableReceiveMoneyController.this.xbrlFileController.getCounterpartyTransaction(id);
                                        if (ct != null) {
                                            this.setText(ct.getCounterpartyLegalName());
                                            isset = true;
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (!isset) {
                                    this.setText(null);
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.transactionDateColumn != null) {
            this.transactionDateColumn.setCellFactory((Callback)new Callback<TableColumn<ReceivableRow, LocalDate>, TableCell<ReceivableRow, LocalDate>>(){

                public TableCell call(TableColumn<ReceivableRow, LocalDate> param) {
                    TableCell<ReceivableRow, LocalDate> cell = new TableCell<ReceivableRow, LocalDate>(){

                        public void updateItem(LocalDate item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else if (item == null) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableReceiveMoneyController.this.displayDateFormatter.format(item));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.taxAmountColumn != null) {
            this.taxAmountColumn.setCellFactory((Callback)new Callback<TableColumn<ReceivableRow, Double>, TableCell<ReceivableRow, Double>>(){

                public TableCell call(TableColumn<ReceivableRow, Double> param) {
                    TableCell<ReceivableRow, Double> cell = new TableCell<ReceivableRow, Double>(){

                        public void updateItem(Double item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty || item == null) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableReceiveMoneyController.this.amountFormat.format(item));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.accountColumn != null) {
            this.accountColumn.setCellFactory((Callback)new Callback<TableColumn<ReceivableRow, String>, TableCell<ReceivableRow, String>>(){

                public TableCell call(TableColumn<ReceivableRow, String> param) {
                    TableCell<ReceivableRow, String> cell = new TableCell<ReceivableRow, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                boolean isset = false;
                                if (item != null) {
                                    try {
                                        Transaction ct = TransactionsTableReceiveMoneyController.this.xbrlFileController.getAccountTransaction(item);
                                        if (ct != null) {
                                            this.setText(ct.getAccountName());
                                            isset = true;
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (!isset) {
                                    this.setText("split...");
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.provisionColumn != null) {
            this.provisionColumn.setCellFactory((Callback)new Callback<TableColumn<ReceivableRow, String>, TableCell<ReceivableRow, String>>(){

                public TableCell call(TableColumn<ReceivableRow, String> param) {
                    TableCell<ReceivableRow, String> cell = new TableCell<ReceivableRow, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                boolean isset = false;
                                if (item != null) {
                                    try {
                                        Transaction ct = TransactionsTableReceiveMoneyController.this.xbrlFileController.getProvisionTransaction(item);
                                        if (ct != null) {
                                            this.setText(ct.getProvisionName());
                                            isset = true;
                                        }
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                if (!isset) {
                                    this.setText("split...");
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        this.transactionEditFormVBox.heightProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observable, Number oldValue, Number newValue) {
                Double tph = TransactionsTableReceiveMoneyController.this.otherpane.getHeight();
                if ((tph = Double.valueOf(tph + oldValue.doubleValue() - newValue.doubleValue())) < 320.0) {
                    tph = 320.0;
                }
                TransactionsTableReceiveMoneyController.this.otherpane.setPrefHeight(tph.doubleValue());
                TransactionsTableReceiveMoneyController.this.transaction_scroll_pane.setPrefHeight(newValue.doubleValue());
            }
        });
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element xbrlEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        if (resultElement == null) {
            resultDoc.appendChild(xbrlEl);
        } else {
            resultElement.appendChild(xbrlEl);
        }
        super.buildGlenixXBRL(resultDoc, xbrlEl);
    }

    @Override
    public void loadGlenixXBRL(Document loadDoc, Element loadElement) throws Exception {
        if (loadElement.getNamespaceURI() != null && loadElement.getNamespaceURI().equals("http://www.glenix.com.au/") && loadElement.getLocalName() != null && loadElement.getLocalName().equals("glenix")) {
            NodeList nodeList = loadElement.getChildNodes();
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                if (node.getNodeType() != 1) continue;
                Element el = (Element)node;
                super.loadGlenixXBRL(loadDoc, el);
            }
        }
    }

    public void setCounterpartyTransactionList(ObservableList<Transaction> counterpartyObservableList) {
        if (this.transactionEditFormVBox != null) {
            this.transactionEditFormVBox.setCounterpartyTransactionList(counterpartyObservableList);
        }
        if (this.counterpartyIdentifier != null) {
            this.counterpartyIdentifier.setItems(counterpartyObservableList);
        }
    }

    public void setProvisionList(ObservableList<Transaction> provisionObservableList) {
        if (this.transactionEditFormVBox != null) {
            this.transactionEditFormVBox.setProvisionList(provisionObservableList);
        }
    }

    public void setAccountList(ObservableList<Transaction> accountObservableList) {
        if (this.transactionEditFormVBox != null) {
            this.transactionEditFormVBox.setAccountList(accountObservableList);
        }
    }

    protected LocalDate calcFromDate(LocalDate maxDate, Integer dm) {
        if (maxDate == null) {
            return null;
        }
        if (dm == null || dm == 0) {
            return maxDate.plusDays(1L);
        }
        LocalDate minDate = maxDate.withDayOfMonth(1);
        if (dm > 1) {
            return minDate.minusMonths(dm - 1);
        }
        return minDate;
    }

    public void postButtonRetrieveTransactions() {
        this.retrieveTransactions();
    }

    public void retrieveTransactions() {
        if (!this.doupdate) {
            return;
        }
        LocalDate maxDate = this.filterToDate.getLocalDate();
        String dmStr = this.displayMonths.getGlenixElementValue();
        Integer dm = 0;
        if (dmStr != null && !dmStr.isEmpty()) {
            try {
                dm = Integer.parseInt(dmStr);
            }
            catch (Exception e) {
                e.printStackTrace();
                dm = 0;
            }
        }
        this.lastMinDate = this.calcFromDate(maxDate, dm);
        try {
            GlenixTrnXBRL newTrns = this.xbrlFileController.getFreshAccountsReceivableTransactionList(this.lastMinDate, maxDate, null);
            this.setTransactions(newTrns, dm, this.lastMinDate, maxDate, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    protected String getReportHeading() {
        return "Accounts receivable";
    }

    protected String getTransactionType() {
        return "cash_received";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactions(GlenixTrnXBRL transactions, Integer months, LocalDate minDate, LocalDate maxDate, String divisionIdentifier) throws Exception {
        boolean setupdate = true;
        if (!this.doupdate) {
            setupdate = false;
        } else {
            this.doupdate = false;
        }
        try {
            this.transactions = transactions;
            this.filterToDate.setLocalDate(maxDate);
            if (months == null) {
                this.displayMonths.setGlenixElementValue(null);
            } else {
                this.displayMonths.setGlenixElementValue(months.toString());
            }
            this.lastMaxDate = maxDate;
            if (maxDate != null) {
                if (this.lastMinDate != null && this.lastMinDate.compareTo(maxDate) <= 0) {
                    this.page_heading.setText(this.getReportHeading() + " as at " + maxDate.format(this.displayDateFormatter) + " including all transactions from " + this.lastMinDate.format(this.displayDateFormatter));
                } else {
                    this.page_heading.setText(this.getReportHeading() + " as at " + maxDate.format(this.displayDateFormatter));
                }
            } else {
                this.page_heading.setText(this.getReportHeading());
            }
            if (transactions == null) {
                this.setReceivableRowObservableList((ObservableList<ReceivableRow>)FXCollections.observableList(new ArrayList()));
                if (setupdate) {
                    this.doupdate = true;
                }
                return;
            }
            ArrayList<Transaction> tal = transactions.getTransactionArrayList();
            if (tal == null || tal.isEmpty()) {
                this.setReceivableRowObservableList((ObservableList<ReceivableRow>)FXCollections.observableList(new ArrayList()));
                if (setupdate) {
                    this.doupdate = true;
                }
                return;
            }
            ArrayList<ReceivableRow> rral = new ArrayList<ReceivableRow>();
            for (Transaction t : tal) {
                String tt = t.getTransactionType();
                if (tt != null && tt.equals(this.getTransactionType())) {
                    for (int i = 0; i < t.getTransactionLineCount(); ++i) {
                        TransactionLine tl = t.getTransactionLine(i);
                        ReceivableRow rr = new ReceivableRow(t, tl);
                        rral.add(rr);
                    }
                    continue;
                }
                ReceivableRow rr = new ReceivableRow(t, null);
                rral.add(rr);
            }
            ObservableList rrol = FXCollections.observableList(rral);
            this.setReceivableRowObservableList((ObservableList<ReceivableRow>)rrol);
        }
        finally {
            if (setupdate) {
                this.doupdate = true;
            }
        }
    }

    protected void createFilteredItems() {
        if (this.receivableRowObservableList == null) {
            if (this.filteredItems == null) {
                return;
            }
            this.filteredItems.clear();
            return;
        }
        this.filteredItems = new FilteredList(this.receivableRowObservableList, t -> {
            if (t == null) {
                return false;
            }
            return t.getTransactionLineAccountIdentifier() == null;
        });
        this.transactionTable.setItems(this.filteredItems);
        this.updateTotalAmount();
        this.updateTotalLabel();
    }

    protected void setReceivableRowObservableList(ObservableList<ReceivableRow> receivableRowObservableList) {
        if (receivableRowObservableList != null) {
            receivableRowObservableList.sort((Comparator)new Comparator<ReceivableRow>(){

                @Override
                public int compare(ReceivableRow t1, ReceivableRow t2) {
                    return t1.compareTo(t2);
                }
            });
        }
        this.selectedRows = new HashSet();
        this.receivableRowObservableList = receivableRowObservableList;
        this.createFilteredItems();
    }

    protected void updateFilter() {
        String filterTextValue = null;
        if (this.filterText != null) {
            filterTextValue = this.filterText.getText();
        }
        this.updateFilter(filterTextValue);
    }

    protected void updateFilter(String newValue) {
        this.suspendSelectionChange = true;
        if (this.filteredItems != null) {
            this.filteredItems.setPredicate(t -> {
                String formattedDate;
                LocalDate localDate;
                String filterCid;
                if (t == null) {
                    return false;
                }
                if (t.getTransactionLineAccountIdentifier() != null) {
                    return false;
                }
                String cid = t.getCounterpartyIdentifier();
                if (!(this.counterpartyIdentifier == null || (filterCid = this.counterpartyIdentifier.getGlenixElementValue()) == null || filterCid.isEmpty() || cid != null && !cid.isEmpty() && filterCid.equals(cid))) {
                    return false;
                }
                if (newValue == null || newValue.isEmpty()) {
                    return true;
                }
                String transactionComment = t.getTransactionComment();
                if (transactionComment != null && transactionComment.toLowerCase().contains(newValue.toLowerCase())) {
                    return true;
                }
                if (cid != null && !cid.isEmpty()) {
                    try {
                        String cname;
                        Transaction ct = this.xbrlFileController.getCounterpartyTransaction(cid);
                        if (ct != null && (cname = ct.getCounterpartyLegalName()) != null && !cname.isEmpty() && cname.toLowerCase().contains(newValue.toLowerCase())) {
                            return true;
                        }
                    }
                    catch (Exception ct) {
                        // empty catch block
                    }
                }
                if ((localDate = t.getTransactionDateAsDate()) != null && (formattedDate = this.displayDateFormatter.format(localDate)) != null && !formattedDate.isEmpty() && formattedDate.toLowerCase().contains(newValue.toLowerCase())) {
                    return true;
                }
                String rd = t.getReconciliationDetailsAndAmount();
                return rd != null && !rd.isEmpty() && rd.toLowerCase().contains(newValue.toLowerCase());
            });
        }
        for (int row = 0; row < this.transactionTable.getItems().size(); ++row) {
            ReceivableRow ttl = (ReceivableRow)this.transactionTable.getItems().get(row);
            if (!this.selectedRows.contains(ttl)) continue;
            this.transactionTable.getSelectionModel().select(row);
        }
        this.suspendSelectionChange = false;
        this.updateTotalAmount();
    }

    @FXML
    private void addTransaction() {
        try {
            this.loadTransaction(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    protected void loadTransaction(Transaction newTransaction) {
        String ci;
        block24: {
            if (newTransaction != null) {
                String type = newTransaction.getTransactionType();
                if (type != null && type.equals("reconciliation")) {
                    this.error_message.setText(null);
                    if (this.transactionEditFormVBox != null) {
                        try {
                            this.transactionEditFormVBox.setTransactionElement(null, false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.error_message.setText(e.getMessage());
                            this.xbrlFileController.setStatusBarMessage(e.getMessage());
                        }
                    }
                    this.transaction = null;
                    return;
                }
                if (type != null && (type.equals("sales_invoice") || type.equals("sales_credit"))) {
                    this.error_message.setText("Error, cannot edit sales invoice or credit on this page. Double click to go to the sales invoice edit page.");
                    if (this.transactionEditFormVBox != null) {
                        try {
                            this.transactionEditFormVBox.setTransactionElement(null, false);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.error_message.setText(e.getMessage());
                            this.xbrlFileController.setStatusBarMessage(e.getMessage());
                        }
                    }
                    this.transaction = null;
                    return;
                }
                try {
                    String batchIdentifier = newTransaction.getBatchIdentifier();
                    if (batchIdentifier != null && !batchIdentifier.isEmpty()) {
                        this.error_message.setText("Error, the selected transaction is on a batch. Double click to go to edit.");
                        this.xbrlFileController.setStatusBarMessage("Error, the selected transaction is on a batch. Double click to go to edit.");
                        if (this.transactionEditFormVBox != null) {
                            this.transactionEditFormVBox.setTransactionElement(null, false);
                        }
                        this.transaction = null;
                        break block24;
                    }
                    if (type != null && type.equals("pay_slip")) {
                        this.error_message.setText("Error, cannot edit pay slip on this page. Double click to go to the pay slip edit page.");
                        if (this.transactionEditFormVBox != null) {
                            this.transactionEditFormVBox.setTransactionElement(null, false);
                        }
                        this.transaction = null;
                    } else {
                        if (this.transactionEditFormVBox != null) {
                            this.transactionEditFormVBox.setTransactionElement(newTransaction);
                        }
                        this.transaction = newTransaction;
                    }
                    this.error_message.setText(null);
                    this.xbrlFileController.setStatusBarMessage(null);
                }
                catch (Exception e) {
                    this.transaction = null;
                    e.printStackTrace();
                    this.error_message.setText("Error, could not quick edit transaction.");
                    this.xbrlFileController.setStatusBarMessage("Error, could not quick edit transaction.");
                    try {
                        this.transactionEditFormVBox.setTransactionElement(null, false);
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.transaction_scroll_pane.setPrefHeight(this.transaction_scroll_pane.getMinHeight());
                this.transaction = null;
                this.error_message.setText(null);
                this.xbrlFileController.setStatusBarMessage(null);
                if (this.transactionEditFormVBox != null) {
                    try {
                        this.transactionEditFormVBox.setTransactionElement(null, false);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.error_message.setText(e.getMessage());
                        this.xbrlFileController.setStatusBarMessage(e.getMessage());
                    }
                }
            }
        }
        if (this.transaction != null && (ci = this.transaction.getCounterpartyIdentifier()) != null && !ci.isEmpty()) {
            this.addNewNoAccountLines(this.transaction, ci);
        }
        this.updateTotalAmount();
    }

    public void setTransaction(Transaction transaction) {
        this.loadTransaction(transaction);
    }

    public void setTransactionDefaults() throws Exception {
        if (this.transaction == null) {
            return;
        }
        String tt = this.transaction.getTransactionType();
        if (tt == null) {
            String defaulttt = this.getTransactionType();
            if (defaulttt != null && !defaulttt.isEmpty()) {
                this.transaction.setTransactionType(defaulttt);
            } else {
                this.transaction.setTransactionType("cash_received");
            }
        }
    }

    private boolean lodgedActivityStatementIsChanged(boolean statusChange) {
        if (this.transaction == null) {
            return false;
        }
        HashSet<String> ass = new HashSet<String>();
        boolean hasas = false;
        for (int i = 0; i < this.transaction.getTransactionLineCount(); ++i) {
            String status;
            ActivityStatement as;
            TransactionLine tl = this.transaction.getTransactionLine(i);
            String asNumber = tl.getActivityStatementNumber();
            if (asNumber == null || asNumber.isEmpty()) continue;
            hasas = true;
            GlenixTrnXBRL asTrn = null;
            try {
                asTrn = this.xbrlFileController.loadActivityStatement(asNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (asTrn == null || (as = asTrn.getActivityStatement()) == null || (status = as.getSBRDocumentStatus()) == null || status.equals("created") || status.equals("list_complete") || status.equals("list_in_progress") || status.equals("prefill_complete") || status.equals("prefill_in_progress") || status.equals("prelodge_complete") || status.equals("prelodge_in_progress")) continue;
            if (statusChange) {
                return true;
            }
            ass.add(asNumber);
        }
        if (this.transactionEditFormVBox == null) {
            return hasas;
        }
        return this.transactionEditFormVBox.basChanged(ass);
    }

    private boolean transactionBatchIsLocked() {
        String bi;
        Transaction bt;
        Batch b;
        String trBi = null;
        if (this.transaction != null && (b = this.transaction.getBatch()) != null && (trBi = b.getBatchIdentifier()) != null && !trBi.isEmpty()) {
            String status;
            bt = null;
            try {
                bt = this.xbrlFileController.getBatchTransaction(trBi);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bt != null && (status = bt.getBatchStatus()) != null && !status.equals("created")) {
                return true;
            }
        }
        if (this.transactionEditFormVBox != null && (bi = this.transactionEditFormVBox.getTransactionBatchIdentifier()) != null && !bi.isEmpty() && !bi.equals(trBi)) {
            bt = null;
            try {
                bt = this.xbrlFileController.getBatchTransaction(bi);
            }
            catch (Exception status) {
                // empty catch block
            }
            if (bt != null && (status = bt.getBatchStatus()) != null && !status.equals("created")) {
                return true;
            }
        }
        return false;
    }

    protected void saveTransaction() throws Exception {
        Document resultDoc = this.dBuilder.newDocument();
        this.transactionEditFormVBox.buildGlenixXBRLTransactionPart(resultDoc, null);
        this.transaction.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
        this.setTransactionDefaults();
        this.xbrlFileController.saveTransaction(this.transaction);
    }

    protected void validateTransaction() throws Exception {
        String status;
        if (this.transactionEditFormVBox == null) {
            throw new Exception("Error, no transaction edit form found");
        }
        boolean statusChange = false;
        if (this.transaction != null && !(status = this.transaction.getTransactionStatus()).equals("posted")) {
            statusChange = true;
        }
        if (this.lodgedActivityStatementIsChanged(statusChange)) {
            this.transactionEditFormVBox.setTransactionElement(this.transaction);
            throw new Exception("Error, one of the modified lines is on a lodged Activity Statment.");
        }
        if (this.transactionBatchIsLocked()) {
            this.transactionEditFormVBox.setTransactionElement(this.transaction);
            throw new Exception("Error, you cannot modify the transaction as it is on an authorised or lodged Batch.");
        }
        LocalDate ld = this.transactionEditFormVBox.getTransactionLocalDate();
        if (ld == null) {
            throw new Exception("Error, a transaction date is blank or incorrect");
        }
        String counterpartyIdentifier = this.transactionEditFormVBox.getCounterpartyIdentifier();
        if (counterpartyIdentifier == null || counterpartyIdentifier.isEmpty()) {
            throw new Exception("Error, the transaction does not have a counterparty, select a counterparty");
        }
        if (!this.transactionEditFormVBox.allLinesHaveAccount()) {
            throw new Exception("Error, a transaction line is missing an account");
        }
    }

    private void postTransactionE() throws Exception {
        this.validateTransaction();
        if (this.transaction == null) {
            this.transaction = this.xbrlFileController.addTransaction();
        }
        if (this.transaction == null) {
            throw new Exception("Error, transaction is null");
        }
        this.transaction.setTransactionStatus("posted");
        this.saveTransaction();
        this.error_message.setText("Saved");
        this.lastLocalDate = this.transactionEditFormVBox.getTransactionLocalDate();
    }

    @FXML
    private void postTransaction() {
        try {
            this.postTransactionE();
            this.postButtonRetrieveTransactions();
            this.updateFilter();
            this.refreshTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void clearTransaction() {
        if (this.transactionEditFormVBox != null) {
            try {
                this.transactionEditFormVBox.setTransactionElement(null);
                this.transaction = null;
                if (this.lastLocalDate != null) {
                    this.transactionEditFormVBox.setTransactionLocalDate(this.lastLocalDate);
                }
                this.transactionEditFormVBox.requestFocus();
                this.error_message.setText("New transaction");
                this.xbrlFileController.setStatusBarMessage(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            }
        }
    }

    @FXML
    public void postAndClearTransaction() {
        try {
            this.postTransactionE();
            this.clearTransaction();
            this.retrieveTransactions();
            this.updateFilter();
            this.refreshTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void copyToNewTransaction() {
        try {
            this.transaction = null;
            this.transactionEditFormVBox.setActivityStatmentNumber(null);
            this.transactionEditFormVBox.setBatchTransactionElement(null);
            this.transactionEditFormVBox.clearAllReconciliationNumbers();
            this.transactionEditFormVBox.requestFocus();
            this.error_message.setText("New transaction");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void cancelTransaction() {
        try {
            String status;
            boolean statusChange = false;
            if (this.transaction != null && !(status = this.transaction.getTransactionStatus()).equals("cancelled")) {
                statusChange = true;
            }
            if (this.lodgedActivityStatementIsChanged(statusChange)) {
                this.transactionEditFormVBox.setTransactionElement(this.transaction);
                this.error_message.setText("Error, one of the modified lines is on a lodged Activity Statment.");
                this.xbrlFileController.setStatusBarMessage("Error, one of the modified lines is on a lodged Activity Statment.");
                return;
            }
            if (this.transactionBatchIsLocked()) {
                this.transactionEditFormVBox.setTransactionElement(this.transaction);
                this.error_message.setText("Error, you cannot modify the transaction as it is on an authorised or lodged Batch.");
                this.xbrlFileController.setStatusBarMessage("Error, you cannot modify the transaction as it is on an authorised or lodged Batch.");
                return;
            }
            if (this.transaction == null) {
                throw new Exception("Error, transaction is null, no transaction to cancel");
            }
            this.transaction.setTransactionStatus("cancelled");
            this.saveTransaction();
            this.error_message.setText("Cancelled");
            this.postButtonRetrieveTransactions();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        this.updateFilter();
        this.refreshTable();
    }

    protected Double addDouble(Double d1, Double d2) {
        if (d1 == null) {
            return d2;
        }
        if (d2 == null) {
            return d1;
        }
        return d1 + d2;
    }

    public void refreshTable() {
        this.transactionTable.refresh();
    }

    protected void updateTotalLabel() {
        if (this.total_label == null) {
            return;
        }
        if (this.totalSelectedCount == 0) {
            this.total_label.setText("Total displayed amount: " + this.amountFormat.format(this.totalAmount) + ", No transactions/transaction lines selected");
            return;
        }
        if (this.selection_visible) {
            this.total_label.setText("Total displayed amount: " + this.amountFormat.format(this.totalAmount) + ", Total selected amount: " + this.amountFormat.format(this.totalSelectedAmount));
        } else {
            this.total_label.setText("Total displayed amount: " + this.amountFormat.format(this.totalAmount) + ", Total selected amount: " + this.amountFormat.format(this.totalSelectedAmount) + " (some selections are filtered out)");
        }
    }

    protected void updateTotalAmount() {
        Double totalAmount = 0.0;
        if (this.filteredItems != null) {
            for (ReceivableRow t : this.filteredItems) {
                totalAmount = this.addDouble(totalAmount, t.getTotalAmount());
            }
        }
        this.totalAmount = totalAmount;
        this.updateTotalLabel();
    }

    protected void updateSelectedAmount() {
        Double totalAmount = 0.0;
        boolean hasselected = false;
        boolean selection_visible = true;
        HashMap<String, Double> workings = new HashMap<String, Double>();
        for (ReceivableRow ttl : this.selectedRows) {
            workings.put(ttl.getReconciliationNumber(), ttl.getReconciliationAmount());
            hasselected = true;
            if (this.filteredItems.contains((Object)ttl)) continue;
            selection_visible = false;
        }
        for (Double d : workings.values()) {
            totalAmount = this.addDouble(totalAmount, d);
        }
        if (hasselected) {
            this.totalSelectedAmount = (double)Math.round(totalAmount * 100.0) / 100.0;
            this.totalSelectedCount = this.selectedRows.size();
            this.selection_visible = selection_visible;
            this.updateTotalLabel();
        } else {
            this.totalSelectedAmount = 0.0;
            this.totalSelectedCount = 0;
            this.selection_visible = selection_visible;
            this.updateTotalLabel();
        }
    }

    @FXML
    protected void addTransactionLine() {
        try {
            this.transactionEditFormVBox.addTransactionLine(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    protected void deleteSelectedTransactionLines() {
        block8: {
            try {
                if (this.transaction != null) {
                    HashSet<String> ass = new HashSet<String>();
                    for (int i = 0; i < this.transaction.getTransactionLineCount(); ++i) {
                        String status;
                        ActivityStatement as;
                        TransactionLine tl = this.transaction.getTransactionLine(i);
                        String asNumber = tl.getActivityStatementNumber();
                        if (asNumber == null || asNumber.isEmpty()) continue;
                        GlenixTrnXBRL asTrn = null;
                        try {
                            asTrn = this.xbrlFileController.loadActivityStatement(asNumber);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (asTrn == null || (as = asTrn.getActivityStatement()) == null || (status = as.getSBRDocumentStatus()) == null || status.equals("created") || status.equals("list_complete") || status.equals("list_in_progress") || status.equals("prefill_complete") || status.equals("prefill_in_progress") || status.equals("prelodge_complete") || status.equals("prelodge_in_progress")) continue;
                        ass.add(asNumber);
                    }
                    if (ass.size() == 0) {
                        this.transactionEditFormVBox.deleteSelectedTransactionLines(null);
                    } else {
                        this.transactionEditFormVBox.deleteSelectedTransactionLines(ass);
                    }
                    break block8;
                }
                this.transactionEditFormVBox.deleteSelectedTransactionLines(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            }
        }
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        String filterTextValue;
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPageLandscape();
        gpw.setColumns(10);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 266.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 266.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 50.0);
        gpw.setColumnLeftPosAndWidthMM(3, 70.0, 24.0);
        gpw.setColumnLeftPosAndWidthMM(4, 94.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(5, 134.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(6, 174.0, 26.0);
        gpw.setColumnLeftPosAndWidthMM(7, 204.0, 30.0);
        gpw.setColumnLeftPosAndWidthMM(8, 234.0, 30.0);
        gpw.setColumnLeftPosAndWidthMM(9, 264.0, 20.0);
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        gpw.setColumnFont(9, gpw.muliLightFont);
        Double fontSize = this.convertFontSize(this.page_heading.getFont().getSize());
        gpw.prepareString(0, this.page_heading.getText(), true, fontSize);
        gpw.drawStrings(10.0);
        fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        StringBuilder filterBuilder = new StringBuilder();
        String prefix = "";
        if (this.filterText != null && (filterTextValue = this.filterText.getGlenixElementValue()) != null && !filterTextValue.isEmpty()) {
            filterBuilder.append("Filter text: ");
            filterBuilder.append(filterTextValue);
            prefix = ", ";
        }
        if (filterBuilder.length() > 0) {
            gpw.prepareString(1, filterBuilder.toString(), true, fontSize);
            gpw.drawStrings(10.0);
        }
        Double totalAmount = 0.0;
        Double totalProvisionAmount = 0.0;
        this.drawPDFColumnHeadings(gpw);
        gpw.setAddPageCallback(this);
        for (ReceivableRow t : this.filteredItems) {
            String ai;
            Double amountDouble;
            String comment;
            String legalName;
            Transaction ct;
            gpw.prepareString(2, t.getReconciliationDetailsAndAmount(), true, fontSize);
            String dateStr = null;
            if (this.displayDateFormatter != null) {
                dateStr = this.displayDateFormatter.format(t.getTransactionDateAsDate());
            }
            gpw.prepareString(3, dateStr, true, fontSize);
            String ci = t.getCounterpartyIdentifier();
            if (ci != null && !ci.isEmpty() && (ct = this.xbrlFileController.getCounterpartyTransaction(ci)) != null && (legalName = ct.getCounterpartyLegalName()) != null) {
                gpw.prepareString(4, legalName, true, fontSize);
            }
            if ((comment = t.getTransactionComment()) != null && !comment.isEmpty()) {
                gpw.prepareString(5, comment, true, fontSize);
            }
            if ((amountDouble = t.getTotalAmount()) != null) {
                totalAmount = totalAmount + amountDouble;
                gpw.prepareString(6, this.amountFormat.format(amountDouble), true, fontSize, "right");
            }
            if ((ai = t.getAccountIdentifier()) != null && !ai.isEmpty()) {
                String accountName;
                Transaction at = this.xbrlFileController.getAccountTransaction(ai);
                if (at != null && (accountName = at.getAccountName()) != null) {
                    gpw.prepareString(7, accountName, true, fontSize);
                }
            } else {
                gpw.prepareString(7, "split...", true, fontSize);
            }
            String pi = t.getProvisionIdentifier();
            if (pi != null && !pi.isEmpty()) {
                String provisionName;
                Transaction pt = this.xbrlFileController.getProvisionTransaction(ai);
                if (pt != null && (provisionName = pt.getProvisionName()) != null) {
                    gpw.prepareString(8, provisionName, true, fontSize);
                }
            } else {
                gpw.prepareString(8, "split...", true);
            }
            Double taxAmountDouble = t.getTotalProvisionAmount();
            if (taxAmountDouble != null) {
                totalProvisionAmount = totalProvisionAmount + taxAmountDouble;
                gpw.prepareString(9, this.amountFormat.format(taxAmountDouble), true, fontSize, "right");
            }
            gpw.drawStrings(5.0);
        }
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(6, gpw.muliBoldFont);
        gpw.setColumnFont(9, gpw.muliBoldFont);
        gpw.prepareString(2, "Totals", true, fontSize);
        gpw.prepareString(6, this.amountFormat.format(totalAmount), true, fontSize, "right");
        gpw.prepareString(9, this.amountFormat.format(totalProvisionAmount), true, fontSize, "right");
        gpw.drawStrings();
        gpw.addFooter();
        return gpw;
    }

    private void drawPDFColumnHeadings(GlenixPDFWrapper gpw) throws Exception {
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliBoldFont);
        gpw.setColumnFont(4, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        gpw.setColumnFont(6, gpw.muliBoldFont);
        gpw.setColumnFont(7, gpw.muliBoldFont);
        gpw.setColumnFont(8, gpw.muliBoldFont);
        gpw.setColumnFont(9, gpw.muliBoldFont);
        Double fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        gpw.prepareString(2, this.reconciliationDetailsAndAmountColumn.getText(), true, fontSize);
        gpw.prepareString(3, this.transactionDateColumn.getText(), true, fontSize);
        gpw.prepareString(4, this.transactionCounterpartyColumn.getText(), true, fontSize);
        gpw.prepareString(5, this.transactionCommentColumn.getText(), true, fontSize);
        gpw.prepareString(6, this.amountColumn.getText(), true, fontSize, "right");
        gpw.prepareString(7, this.accountColumn.getText(), true, fontSize);
        gpw.prepareString(8, this.provisionColumn.getText(), true, fontSize);
        gpw.prepareString(9, this.taxAmountColumn.getText(), true, fontSize, "right");
        gpw.drawStrings(5.0);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        gpw.setColumnFont(9, gpw.muliLightFont);
    }

    @Override
    public void newPDFPageAdded(GlenixPDFWrapper gpw) throws Exception {
        this.drawPDFColumnHeadings(gpw);
    }

    public Set<String> getTransactionTransactionTypeSet() {
        return this.transactionTransactionTypeSet;
    }

    protected void addNewNoAccountLines(Transaction transaction, String counterpartyIdentifier) {
        try {
            Set<String> ttset = this.getTransactionTransactionTypeSet();
            Set<String> usedRecNos = this.transactionEditFormVBox.getReconciliationNumberSet();
            if (transaction != null) {
                for (int i = 0; i < transaction.getTransactionLineCount(); ++i) {
                    TransactionLine tl = transaction.getTransactionLine(i);
                    String recNumber = tl.getReconciliationNumber();
                    if (recNumber == null || recNumber.isEmpty()) continue;
                    usedRecNos.add(recNumber);
                }
            }
            HashMap<String, TransactionLine> recAmts = new HashMap<String, TransactionLine>();
            if (counterpartyIdentifier != null && !counterpartyIdentifier.isEmpty()) {
                for (ReceivableRow rr : this.filteredItems) {
                    TransactionLine prevTl;
                    String recNumber;
                    Transaction t;
                    String tt;
                    String tci = rr.getCounterpartyIdentifier();
                    if (tci == null || !tci.equals(counterpartyIdentifier) || (tt = (t = rr.getTransaction()).getTransactionType()) == null || !ttset.contains(tt) || usedRecNos.contains(recNumber = t.getTransactionReconciliationNumber()) || (prevTl = (TransactionLine)recAmts.get(recNumber)) != null) continue;
                    TransactionLine newTl = new TransactionLine();
                    newTl.setReconciliationNumber(recNumber);
                    newTl.setReconciliationAmount(t.getTransactionReconciliationAmount());
                    newTl.setLineComment("Invoice: " + t.getDocumentNumber());
                    newTl.setInvoiceComment(t.getTransactionComment());
                    recAmts.put(recNumber, newTl);
                }
            }
            for (TransactionLine tl : recAmts.values()) {
                ((TransactionEditShortFormCloudVBox)this.transactionEditFormVBox).addTransactionLineNoAccount(tl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    private void sendEmail() {
        File file = null;
        try {
            if (this.transaction == null) {
                throw new Exception("Error, the transaction is not yet saved.");
            }
            Profile p = this.xbrlFileController.getOutgoingMailServer();
            if (p == null) {
                throw new Exception("Error, outgoing mail server is not set up");
            }
            OutgoingMailServer outgoingMailServer = p.getOutgoingMailServer();
            if (outgoingMailServer == null) {
                throw new Exception("Error, outgoing mail server is not set up");
            }
            String host = outgoingMailServer.getOutgoingMailServerName();
            if (host == null || host.isEmpty()) {
                throw new Exception("Error, outgoing mail server host is not set up");
            }
            String port = outgoingMailServer.getOutgoingMailServerPort();
            if (port == null || port.isEmpty()) {
                throw new Exception("Error, outgoing mail server host is not set up");
            }
            String username = outgoingMailServer.getOutgoingMailUsername();
            String password = outgoingMailServer.getOutgoingMailPassword();
            String to = this.email_to.getGlenixElementValue();
            if (to == null || to.isEmpty()) {
                throw new Exception("Error, to email address is not set");
            }
            String from = this.email_from.getGlenixElementValue();
            if (from == null || from.isEmpty()) {
                throw new Exception("Error, from email address is not set");
            }
            String subject = this.email_subject.getGlenixElementValue();
            if (subject == null || subject.isEmpty()) {
                throw new Exception("Error, subject is not set");
            }
            String message_html = this.html_message.getHtmlText();
            if (message_html == null || message_html.isEmpty()) {
                throw new Exception("Error, message is not set");
            }
            Properties properties = System.getProperties();
            properties.setProperty("mail.smtp.host", host);
            if (username != null && !username.isEmpty()) {
                properties.setProperty("mail.user", username);
            }
            if (password != null && !password.isEmpty()) {
                properties.setProperty("mail.password", password);
            }
            Session session = Session.getDefaultInstance(properties);
            MimeMessage message = new MimeMessage(session);
            message.setFrom(new InternetAddress(from));
            message.addRecipient(Message.RecipientType.TO, new InternetAddress(to));
            message.setSubject(subject);
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent(message_html, "text/html");
            MimeMultipart multipart = new MimeMultipart();
            ((Multipart)multipart).addBodyPart(messageBodyPart);
            messageBodyPart = new MimeBodyPart();
            String tmpdir = System.getProperty("java.io.tmpdir");
            UUID uuid = UUID.randomUUID();
            String randomUUIDString = uuid.toString();
            file = tmpdir != null && !tmpdir.isEmpty() ? new File(tmpdir + "/Tax_Invoice_" + randomUUIDString + ".pdf") : new File("Tax_Invoice_" + randomUUIDString + ".pdf");
            this.xbrlFileController.buildPDFSalesInvoice(file, this.transaction);
            FileDataSource source = new FileDataSource(file);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName("Tax_Invoice.pdf");
            ((Multipart)multipart).addBodyPart(messageBodyPart);
            message.setContent(multipart);
            Transport.send(message);
            this.error_message.setText("Sales invoice has been emailed.");
            this.xbrlFileController.setStatusBarMessage("Sales invoice has been emailed.");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }

    @FXML
    private void pdfTransaction() {
        if (this.transaction == null) {
            return;
        }
        String tt = this.transaction.getTransactionType();
        if (tt == null) {
            return;
        }
        if (tt.equals("cash_received")) {
            this.xbrlFileController.pdfCashReceived(this.transaction);
        } else {
            this.xbrlFileController.pdfSalesInvoice(this.transaction);
        }
    }

    public boolean displayDebitsAsPositive() {
        return true;
    }

    @FXML
    protected void splitSelectedTransactions() {
        try {
            boolean hasselected = false;
            StringBuilder trsb = new StringBuilder();
            for (ReceivableRow rr : this.transactionTable.getSelectionModel().getSelectedItems()) {
                String tn;
                if (hasselected) {
                    trsb.append(",");
                }
                if ((tn = rr.getTransactionNumber()) == null || tn.isEmpty()) continue;
                String tln = rr.getLineNumber();
                if (tln != null && !tln.isEmpty()) {
                    trsb.append(tn + "|" + tln);
                } else {
                    trsb.append(tn);
                }
                hasselected = true;
            }
            if (!hasselected) {
                throw new Exception("Error, no transactions selected.");
            }
            GlenixResult gr = this.xbrlFileController.sendSplit(trsb.toString());
            if (gr == null) {
                throw new Exception("Error, unable to read post split response");
            }
            String resultCode = gr.getResultCode();
            if (resultCode == null) {
                throw new Exception("Error, unable to read post split response code");
            }
            if (!resultCode.equals("OK")) {
                throw new Exception(gr.getResultDescription());
            }
            this.error_message.setText("Split saved");
            this.xbrlFileController.setStatusBarMessage("Split saved");
            this.retrieveTransactions();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public class ReceivableRow
    implements Comparable<ReceivableRow> {
        protected Transaction receivableT;
        protected TransactionLine cashReceivedTL;

        public ReceivableRow(Transaction receivableT, TransactionLine cashReceivedTL) throws Exception {
            if (receivableT == null) {
                throw new Exception("Error, must have a transaction");
            }
            this.receivableT = receivableT;
            this.cashReceivedTL = cashReceivedTL;
        }

        public String getReconciliationDetailsAndAmount() {
            if (TransactionsTableReceiveMoneyController.this.displayDebitsAsPositive()) {
                if (this.cashReceivedTL != null) {
                    return this.cashReceivedTL.getReconciliationDetailsAndCreditAmount();
                }
                return this.receivableT.getTransactionReconciliationDetailsAndAmount();
            }
            if (this.cashReceivedTL != null) {
                return this.cashReceivedTL.getReconciliationDetailsAndAmount();
            }
            return this.receivableT.getTransactionReconciliationDetailsAndCreditAmount();
        }

        public Double getReconciliationAmount() {
            if (TransactionsTableReceiveMoneyController.this.displayDebitsAsPositive()) {
                if (this.cashReceivedTL != null) {
                    return this.cashReceivedTL.getReconciliationAmountAsDouble();
                }
                return this.receivableT.getTransactionReconciliationAmountAsDouble();
            }
            if (this.cashReceivedTL != null) {
                return this.cashReceivedTL.getCreditReconciliationAmountAsDouble();
            }
            return this.receivableT.getTransactionCreditReconciliationAmountAsDouble();
        }

        public String getReconciliationMaxDate() {
            if (this.cashReceivedTL != null) {
                return this.cashReceivedTL.getReconciliationMaxDate();
            }
            return this.receivableT.getTransactionReconciliationMaxDate();
        }

        public String getReconciliationNumber() {
            if (this.cashReceivedTL != null) {
                return this.cashReceivedTL.getReconciliationNumber();
            }
            return this.receivableT.getTransactionReconciliationNumber();
        }

        public Integer getReconciliationNumberAsInt() {
            if (this.cashReceivedTL != null) {
                String num = this.cashReceivedTL.getReconciliationNumber();
                if (num == null || num.isEmpty()) {
                    return null;
                }
                return Integer.parseInt(num);
            }
            String num = this.receivableT.getTransactionReconciliationNumber();
            if (num == null || num.isEmpty()) {
                return null;
            }
            return Integer.parseInt(num);
        }

        public LocalDate getTransactionDateAsDate() {
            return this.receivableT.getTransactionDateAsDate();
        }

        public String getCounterpartyIdentifier() {
            return this.receivableT.getCounterpartyIdentifier();
        }

        public String getTransactionComment() {
            return this.receivableT.getTransactionComment();
        }

        public String getComment() {
            if (this.cashReceivedTL != null) {
                return this.cashReceivedTL.getLineCommentString();
            }
            return this.receivableT.getTransactionComment();
        }

        public String getCombinedComment() {
            if (this.cashReceivedTL != null) {
                return this.receivableT.getTransactionComment() + " - " + this.cashReceivedTL.getLineCommentString();
            }
            return this.receivableT.getTransactionComment();
        }

        public Double getTotalAmount() {
            if (TransactionsTableReceiveMoneyController.this.displayDebitsAsPositive()) {
                if (this.cashReceivedTL != null) {
                    return this.cashReceivedTL.getDebitAmount("cash_received");
                }
                return this.receivableT.getCreditTotalAmount();
            }
            if (this.cashReceivedTL != null) {
                return this.cashReceivedTL.getCreditAmount("cash_payment");
            }
            return this.receivableT.getDebitTotalAmount();
        }

        public String getTotalAmountFormatted() {
            Double amt = this.getTotalAmount();
            return TransactionsTableReceiveMoneyController.this.amountFormat.format(amt);
        }

        public String getAccountIdentifier() {
            if (this.cashReceivedTL != null) {
                return "";
            }
            return this.receivableT.getUniqueAccountIdentifier();
        }

        public String getProvisionIdentifier() {
            if (this.cashReceivedTL != null) {
                return "";
            }
            return this.receivableT.getUniqueProvisionIdentifier();
        }

        public Double getTotalProvisionAmount() {
            if (TransactionsTableReceiveMoneyController.this.displayDebitsAsPositive()) {
                if (this.cashReceivedTL != null) {
                    return null;
                }
                return this.receivableT.getCreditTotalProvisionAmount();
            }
            if (this.cashReceivedTL != null) {
                return null;
            }
            return this.receivableT.getDebitTotalProvisionAmount();
        }

        public Double getTotalQuantity() {
            if (this.cashReceivedTL != null) {
                return null;
            }
            if (TransactionsTableReceiveMoneyController.this.displayDebitsAsPositive()) {
                return this.receivableT.getCreditTotalQuantity();
            }
            return this.receivableT.getDebitTotalQuantity();
        }

        public Transaction getTransaction() {
            return this.receivableT;
        }

        public TransactionLine getTransactionLine() {
            return this.cashReceivedTL;
        }

        public String getTransactionNumber() {
            return this.receivableT.getTransactionNumber();
        }

        public String getTransactionLineAccountIdentifier() {
            if (this.cashReceivedTL == null) {
                return null;
            }
            return this.cashReceivedTL.getAccountIdentifier();
        }

        public String getLineNumber() {
            if (this.cashReceivedTL == null) {
                return null;
            }
            return this.cashReceivedTL.getLineNumber();
        }

        @Override
        public int compareTo(ReceivableRow rr2) {
            Transaction t2;
            Transaction t1;
            String rr1date = this.getReconciliationMaxDate();
            String rr2date = rr2.getReconciliationMaxDate();
            if (rr1date == null || rr1date.isEmpty()) {
                if (rr2date != null && !rr2date.isEmpty()) {
                    return -1;
                }
            } else {
                if (rr2date == null || rr2date.isEmpty()) {
                    return 1;
                }
                int result = rr1date.compareTo(rr2date);
                if (result != 0) {
                    return result;
                }
            }
            Integer rr1Int = this.getReconciliationNumberAsInt();
            Integer rr2Int = rr2.getReconciliationNumberAsInt();
            if (rr1Int == null) {
                if (rr2Int != null) {
                    return -1;
                }
            } else {
                if (rr2Int == null) {
                    return 1;
                }
                int result = rr1Int.compareTo(rr2Int);
                if (result != 0) {
                    return result;
                }
            }
            if ((t1 = this.getTransaction()) == (t2 = rr2.getTransaction())) {
                TransactionLine tl1 = this.getTransactionLine();
                TransactionLine tl2 = rr2.getTransactionLine();
                if (tl1 == null) {
                    if (tl2 != null) {
                        return -1;
                    }
                } else {
                    if (tl2 == null) {
                        return 1;
                    }
                    Integer tl1line = tl1.getLineNumberAsInt();
                    Integer tl2line = tl2.getLineNumberAsInt();
                    if (tl1line == null) {
                        if (tl2line != null) {
                            return -1;
                        }
                    } else {
                        if (tl2line == null) {
                            return 1;
                        }
                        int result = tl1line.compareTo(tl2line);
                        if (result != 0) {
                            return result;
                        }
                    }
                }
            }
            String t1date = t1.getTransactionDate();
            String t2date = t2.getTransactionDate();
            if (t1date == null || t1date.isEmpty()) {
                if (t2date != null && !t2date.isEmpty()) {
                    return -1;
                }
            } else {
                if (t2date == null || t2date.isEmpty()) {
                    return 1;
                }
                int result = t1date.compareTo(t2date);
                if (result != 0) {
                    return result;
                }
            }
            String t1ci = t1.getCounterpartyIdentifier();
            String t2ci = t2.getCounterpartyIdentifier();
            if (t1ci == null || t1ci.isEmpty()) {
                if (t2ci != null && !t2ci.isEmpty()) {
                    return -1;
                }
            } else {
                if (t2ci == null || t2ci.isEmpty()) {
                    return 1;
                }
                String t1cname = null;
                String t2cname = null;
                try {
                    Transaction t1ct = TransactionsTableReceiveMoneyController.this.xbrlFileController.getCounterpartyTransaction(t1ci);
                    if (t1ct != null) {
                        t1cname = t1ct.getCounterpartyLegalName();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    Transaction t2ct = TransactionsTableReceiveMoneyController.this.xbrlFileController.getCounterpartyTransaction(t2ci);
                    if (t2ct != null) {
                        t2cname = t2ct.getCounterpartyLegalName();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (t1cname == null || t1cname.isEmpty()) {
                    if (t2cname != null && !t2cname.isEmpty()) {
                        return -1;
                    }
                } else {
                    if (t2cname == null || t2cname.isEmpty()) {
                        return 1;
                    }
                    int result = t1cname.compareTo(t2cname);
                    if (result != 0) {
                        return result;
                    }
                }
            }
            String t1comment = t1.getTransactionComment();
            String t2comment = t2.getTransactionComment();
            if (t1comment == null || t1comment.isEmpty()) {
                if (t2comment != null && !t2comment.isEmpty()) {
                    return -1;
                }
            } else {
                if (t2comment == null || t2comment.isEmpty()) {
                    return 1;
                }
                int result = t1comment.compareTo(t2comment);
                if (result != 0) {
                    return result;
                }
            }
            return t1.toString().compareTo(t2.toString());
        }
    }
}

