/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.cloud.CloudApplicationController;
import au.com.glenix.cloud.TransactionsTableReceiveMoneyController;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import java.time.LocalDate;
import java.util.HashSet;
import javafx.fxml.FXML;

public class TransactionsTablePayMoneyController
extends TransactionsTableReceiveMoneyController {
    public TransactionsTablePayMoneyController(CloudApplicationController xbrlFileController) {
        super(xbrlFileController);
        this.transactionTransactionTypeSet = new HashSet();
        this.transactionTransactionTypeSet.add("purchase_invoice");
        this.transactionTransactionTypeSet.add("purchase_credit");
    }

    @Override
    public void retrieveTransactions() {
        if (!this.doupdate) {
            return;
        }
        LocalDate maxDate = this.filterToDate.getLocalDate();
        String dmStr = this.displayMonths.getGlenixElementValue();
        Integer dm = 0;
        if (dmStr != null && !dmStr.isEmpty()) {
            try {
                dm = Integer.parseInt(dmStr);
            }
            catch (Exception e) {
                e.printStackTrace();
                dm = 0;
            }
        }
        this.lastMinDate = this.calcFromDate(maxDate, dm);
        try {
            GlenixTrnXBRL newTrns = this.xbrlFileController.getFreshAccountsPayableTransactionList(this.lastMinDate, maxDate, null);
            this.setTransactions(newTrns, dm, this.lastMinDate, maxDate, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    protected String getReportHeading() {
        return "Accounts payable";
    }

    @Override
    protected String getTransactionType() {
        return "cash_payment";
    }

    @Override
    protected void loadTransaction(Transaction newTransaction) {
        if (newTransaction != null) {
            String type = newTransaction.getTransactionType();
            if (type != null && (type.equals("purchase_invoice") || type.equals("purchase_credit"))) {
                super.loadTransaction(null);
                this.error_message.setText("Error, cannot edit purchase invoice or credit on this page. Double click to go to the purchase invoice edit page.");
            } else {
                super.loadTransaction(newTransaction);
            }
        } else {
            super.loadTransaction(null);
        }
    }

    @Override
    public boolean displayDebitsAsPositive() {
        return false;
    }

    @FXML
    private void pdfTransaction() {
        if (this.transaction == null) {
            return;
        }
        String tt = this.transaction.getTransactionType();
        if (tt == null) {
            return;
        }
        if (tt.equals("cash_payment")) {
            this.xbrlFileController.pdfCashPayment(this.transaction);
        } else {
            this.xbrlFileController.pdfPurchaseInvoice(this.transaction);
        }
    }

    public class PayableRow
    extends TransactionsTableReceiveMoneyController.ReceivableRow {
        public PayableRow(Transaction receivableT, TransactionLine cashReceivedTL) throws Exception {
            super(TransactionsTablePayMoneyController.this, receivableT, cashReceivedTL);
        }
    }
}

