/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixLabelAccountCombo;
import au.com.glenix.GlenixLabelCounterpartyCombo;
import au.com.glenix.TransactionsTableASController;
import au.com.glenix.trn.ASLStatement;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.ActivityStatementList;
import au.com.glenix.trn.ActivityStatementListResponse;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.GSTObligation;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.PAYGWObligation;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixLabelYesNoCombo;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;

public class TransactionsTableASCloudController
extends TransactionsTableASController {
    protected DateTimeFormatter asEndDateDescFormatter = DateTimeFormatter.ofPattern("MMM yyyy");
    @FXML
    protected GlenixLabelAccountCombo roundingsAccountIdentifier;
    @FXML
    protected GlenixLabelYesNoCombo accountsPayableSelection;
    @FXML
    protected GlenixLabelCounterpartyCombo counterpartyIdentifier;

    public TransactionsTableASCloudController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    @Override
    @FXML
    protected void generateTransactions() {
        block9: {
            ActivityStatement as = this.glenixTrnXBRLActivityStatement.getActivityStatement();
            if (as == null) {
                this.error_message.setText("Error, no activity statement selected");
                return;
            }
            try {
                String asNumber = as.getActivityStatementNumber();
                if (asNumber == null || asNumber.isEmpty()) {
                    throw new Exception("Error, no activity statement number found");
                }
                LocalDate gstStartDate = as.getStartDateAsDate();
                if (gstStartDate == null) break block9;
                Integer addm = 0;
                try {
                    addm = Integer.parseInt(this.additionalMonths.getGlenixElementValue());
                }
                catch (Exception e) {
                    addm = 0;
                }
                gstStartDate = gstStartDate.minusMonths(addm.intValue()).withDayOfMonth(1);
                LocalDate gstEndDate = as.getEndDateAsDate();
                if (gstEndDate != null) {
                    ArrayList<ASLStatement> aslss;
                    ActivityStatementListResponse aslr;
                    ActivityStatementList asl;
                    GlenixTrnXBRL aslx;
                    this.transactionTransactionLineArrayList = this.xbrlFileController.markActivityStatementTransactions(asNumber, null, gstStartDate, gstEndDate, null, null, null, null);
                    String endDate = as.getEndDate();
                    String din = as.getBusinessDocumentGovernmentGeneratedIdentifierText();
                    if (endDate != null && !endDate.isEmpty() && din != null && !din.isEmpty() && (aslx = this.xbrlFileController.getActivityStatementList()) != null && (asl = aslx.getActivityStatementList()) != null && (aslr = asl.getActivityStatementListResponse()) != null && (aslss = aslr.getASLStatementList()) != null) {
                        for (ASLStatement asls : aslss) {
                            String originalASNumber;
                            ArrayList<Transaction.TransactionTransactionLine> asTrnLines;
                            int cmp;
                            String asdin;
                            String ased = asls.getEndDate();
                            String asasn = asls.getActivityStatementNumber();
                            if (ased == null || ased.isEmpty() || !ased.equals(endDate) || asasn == null || asasn.isEmpty() || asasn.equals(asNumber) || (asdin = asls.getBusinessDocument_GovernmentGeneratedIdentifier_Text()) == null || asdin.isEmpty() || (cmp = din.compareTo(asdin)) < 0 || (asTrnLines = this.xbrlFileController.getActivityStatementTransactions(originalASNumber = asls.getActivityStatementNumber())) == null || asTrnLines.size() <= 0) continue;
                            this.transactionTransactionLineArrayList.addAll(asTrnLines);
                        }
                    }
                    this.setTransactionTransactionLineObservableList(this.transactionTransactionLineArrayList);
                    this.transactionTransactionLineTable.refresh();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            }
        }
    }

    @FXML
    private void removeSelectedTransaction() {
        try {
            ActivityStatement as = this.glenixTrnXBRLActivityStatement.getActivityStatement();
            if (as == null) {
                throw new Exception("Error, no activity statement selected");
            }
            String asNumber = as.getActivityStatementNumber();
            if (asNumber == null || asNumber.isEmpty()) {
                throw new Exception("Error, no activity statement number found");
            }
            boolean hasselected = false;
            StringBuilder trsb = new StringBuilder();
            for (Transaction.TransactionTransactionLine ttl : this.transactionTransactionLineTable.getSelectionModel().getSelectedItems()) {
                String tn;
                if (hasselected) {
                    trsb.append(",");
                }
                if ((tn = ttl.getTransactionNumber()) == null || tn.isEmpty()) continue;
                String tln = ttl.getLineNumber();
                if (tln != null && !tln.isEmpty()) {
                    trsb.append(tn + "|" + tln);
                }
                hasselected = true;
            }
            if (!hasselected) {
                throw new Exception("Error, no transactions selected.");
            }
            this.transactionTransactionLineArrayList = this.xbrlFileController.removeActivityStatementTransactions(asNumber, trsb.toString());
            this.setTransactionTransactionLineObservableList(this.transactionTransactionLineArrayList);
            this.transactionTransactionLineTable.getSelectionModel().clearSelection();
            this.transactionTransactionLineTable.refresh();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public void setBusinessTransactions(Business business) throws Exception {
        throw new Exception("Error, use setTransactionTransactionLineObservableList");
    }

    @Override
    @FXML
    protected void gotoActivityStatementLodge() {
        if (this.glenixTrnXBRLActivityStatement == null) {
            this.error_message.setText("Error, no activity statement selected");
            return;
        }
        ActivityStatement as = this.glenixTrnXBRLActivityStatement.getActivityStatement();
        if (as == null) {
            this.error_message.setText("Error, no activity statement selected");
            return;
        }
        String asNumber = as.getActivityStatementNumber();
        if (asNumber == null || asNumber.isEmpty()) {
            this.error_message.setText("Error, no activity statement number found");
            return;
        }
        try {
            this.xbrlFileController.gotoActivityStatement(asNumber, this.glenixTrnXBRLActivityStatement);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    private Integer addInteger(Integer i1, Integer i2) {
        if (i1 == null) {
            return i2;
        }
        if (i2 == null) {
            return i1;
        }
        return i1 + i2;
    }

    private Integer subtractInteger(Integer i1, Integer i2) {
        if (i1 == null) {
            if (i2 == null) {
                return null;
            }
            return -i2.intValue();
        }
        if (i2 == null) {
            return i1;
        }
        return i1 - i2;
    }

    private Double addDouble(Double i1, Double i2) {
        if (i1 == null) {
            return i2;
        }
        if (i2 == null) {
            return i1;
        }
        return i1 + i2;
    }

    private Double subtractDouble(Double i1, Double i2) {
        if (i1 == null) {
            if (i2 == null) {
                return null;
            }
            return -i2.doubleValue();
        }
        if (i2 == null) {
            return i1;
        }
        return i1 - i2;
    }

    private Double sumMap(HashMap<String, Double> map) {
        Double result = null;
        for (Double d : map.values()) {
            result = this.addDouble(result, d);
        }
        return result;
    }

    private String getTransactionRR(Transaction rt, String pi) {
        for (int i = 0; i < rt.getTransactionLineCount(); ++i) {
            TransactionLine tl = rt.getTransactionLine(i);
            String tlpi = tl.getProvisionIdentifier();
            if (tlpi == null || !tlpi.equals(pi)) continue;
            return tl.getProvisionReconciliationNumber();
        }
        return null;
    }

    @FXML
    protected void reconcileActivityStatementTransactions() {
        try {
            String resultCode;
            GlenixResult gr;
            Object rtrr;
            TransactionLine tl;
            ArrayList<Transaction> pts;
            Integer tmp;
            String luxostr;
            String luxcstr;
            Integer tmp2;
            String wetostr;
            String wetcstr;
            Integer tmp3;
            String ftcostr;
            String ftccstr;
            String gstrecstr;
            String gstpayablestr;
            GlenixTrnXBRL oASXBRL;
            if (this.activityStatement == null) {
                throw new Exception("Error, activity statement not set");
            }
            String status = this.activityStatement.getSBRDocumentStatus();
            if (status == null || !status.equals("lodge_complete")) {
                throw new Exception("Error, cannot reconcile until BAS is lodged");
            }
            String asNumber = this.activityStatement.getActivityStatementNumber();
            if (asNumber == null || asNumber.isEmpty()) {
                throw new Exception("Error, no activity statement number found");
            }
            ActivityStatement originalActivityStatement = null;
            String originalASNumber = this.activityStatement.getOriginalActivityStatementNumber();
            if (originalASNumber != null && !originalASNumber.isEmpty() && (oASXBRL = this.xbrlFileController.loadActivityStatement(originalASNumber)) != null && (originalActivityStatement = oASXBRL.getActivityStatement()) == null) {
                throw new Exception("Error, original activity statement set but cannot load it");
            }
            String roundingAI = this.roundingsAccountIdentifier.getGlenixElementValue();
            if (roundingAI == null || roundingAI.isEmpty()) {
                throw new Exception("Error, you need to select an account to post the roundings to.");
            }
            String counterpartyIdentifierValue = this.counterpartyIdentifier.getGlenixElementValue();
            if (counterpartyIdentifierValue == null || counterpartyIdentifierValue.isEmpty()) {
                throw new Exception("Error, you need to select a counterparty for the payment/reconciliation transaction.");
            }
            String moveToPayables = this.accountsPayableSelection.getGlenixElementValue();
            Integer gstpayable = null;
            Integer gstreceivable = null;
            Integer ftc = null;
            Integer wet = null;
            Integer lux = null;
            GSTObligation gsto = this.activityStatement.getGSTObligation();
            if (gsto != null) {
                gstpayablestr = gsto.getGoodsAndServicesTaxPayableAmount();
                if (gstpayablestr != null && !gstpayablestr.isEmpty()) {
                    gstpayable = Integer.parseInt(gstpayablestr);
                }
                if ((gstrecstr = gsto.getGoodsAndServicesTaxClaimableCreditsAmount()) != null && !gstrecstr.isEmpty()) {
                    gstreceivable = Integer.parseInt(gstrecstr);
                }
                if ((ftccstr = gsto.getFuelTaxClaimableCreditsAmount()) != null && !ftccstr.isEmpty()) {
                    ftc = Integer.parseInt(ftccstr);
                }
                if ((ftcostr = gsto.getFuelTaxOverclaimedCreditsAmount()) != null && !ftcostr.isEmpty()) {
                    if (ftc != null) {
                        tmp3 = Integer.parseInt(ftcostr);
                        if (tmp3 != null) {
                            ftc = ftc - tmp3;
                        }
                    } else {
                        ftc = Integer.parseInt(ftcostr);
                    }
                }
                if ((wetcstr = gsto.getWineEqualisationTaxClaimableCreditsAmount()) != null && !wetcstr.isEmpty()) {
                    wet = Integer.parseInt(wetcstr);
                }
                if ((wetostr = gsto.getWineEqualisationTaxLiabilityAmount()) != null && !wetostr.isEmpty()) {
                    if (wet != null) {
                        tmp2 = Integer.parseInt(wetostr);
                        if (tmp2 != null) {
                            wet = wet - tmp2;
                        }
                    } else {
                        wet = Integer.parseInt(wetostr);
                    }
                }
                if ((luxcstr = gsto.getLuxuryCarTaxClaimableCreditsAmount()) != null && !luxcstr.isEmpty()) {
                    lux = Integer.parseInt(luxcstr);
                }
                if ((luxostr = gsto.getLuxuryCarTaxLiabilityAmount()) != null && !luxostr.isEmpty()) {
                    if (lux != null) {
                        tmp = Integer.parseInt(luxostr);
                        if (tmp != null) {
                            lux = lux - tmp;
                        }
                    } else {
                        lux = Integer.parseInt(luxostr);
                    }
                }
            }
            if (originalActivityStatement != null && (gsto = originalActivityStatement.getGSTObligation()) != null) {
                Integer tmp4;
                Integer tmp5;
                Integer tmp6;
                Integer tmp7;
                Integer tmp8;
                gstpayablestr = gsto.getGoodsAndServicesTaxPayableAmount();
                if (gstpayablestr != null && !gstpayablestr.isEmpty() && gstpayable != null && (tmp8 = Integer.valueOf(Integer.parseInt(gstpayablestr))) != null) {
                    gstpayable = gstpayable - tmp8;
                }
                if ((gstrecstr = gsto.getGoodsAndServicesTaxClaimableCreditsAmount()) != null && !gstrecstr.isEmpty() && gstreceivable != null && (tmp7 = Integer.valueOf(Integer.parseInt(gstrecstr))) != null) {
                    gstreceivable = gstreceivable - tmp7;
                }
                if ((ftccstr = gsto.getFuelTaxClaimableCreditsAmount()) != null && !ftccstr.isEmpty() && ftc != null && (tmp6 = Integer.valueOf(Integer.parseInt(ftccstr))) != null) {
                    ftc = ftc - tmp6;
                }
                if ((ftcostr = gsto.getFuelTaxOverclaimedCreditsAmount()) != null && !ftcostr.isEmpty() && ftc != null && (tmp3 = Integer.valueOf(Integer.parseInt(ftcostr))) != null) {
                    ftc = ftc + tmp3;
                }
                if ((wetcstr = gsto.getWineEqualisationTaxClaimableCreditsAmount()) != null && !wetcstr.isEmpty() && wet != null && (tmp5 = Integer.valueOf(Integer.parseInt(wetcstr))) != null) {
                    wet = wet - tmp5;
                }
                if ((wetostr = gsto.getWineEqualisationTaxLiabilityAmount()) != null && !wetostr.isEmpty() && wet != null && (tmp2 = Integer.valueOf(Integer.parseInt(wetostr))) != null) {
                    wet = wet + tmp2;
                }
                if ((luxcstr = gsto.getLuxuryCarTaxClaimableCreditsAmount()) != null && !luxcstr.isEmpty() && lux != null && (tmp4 = Integer.valueOf(Integer.parseInt(luxcstr))) != null) {
                    lux = lux - tmp4;
                }
                if ((luxostr = gsto.getLuxuryCarTaxLiabilityAmount()) != null && !luxostr.isEmpty() && lux != null && (tmp = Integer.valueOf(Integer.parseInt(luxostr))) != null) {
                    lux = lux + tmp;
                }
            }
            Integer paygwamt = null;
            PAYGWObligation paygw = this.activityStatement.getPAYGWObligation();
            if (paygw != null) {
                String tmpstr = paygw.getDNOABNITPAYGWithholdingDetailsAmount();
                if (tmpstr != null && !tmpstr.isEmpty()) {
                    paygwamt = this.addInteger(paygwamt, Integer.parseInt(tmpstr));
                }
                if ((tmpstr = paygw.getW2ITPAYGWithholdingDetailsAmount()) != null && !tmpstr.isEmpty()) {
                    paygwamt = this.addInteger(paygwamt, Integer.parseInt(tmpstr));
                }
                if ((tmpstr = paygw.getW3ITPAYGWithholdingDetailsAmount()) != null && !tmpstr.isEmpty()) {
                    paygwamt = this.addInteger(paygwamt, Integer.parseInt(tmpstr));
                }
                if (originalActivityStatement != null && (paygw = originalActivityStatement.getPAYGWObligation()) != null) {
                    tmpstr = paygw.getDNOABNITPAYGWithholdingDetailsAmount();
                    if (tmpstr != null && !tmpstr.isEmpty()) {
                        paygwamt = this.subtractInteger(paygwamt, Integer.parseInt(tmpstr));
                    }
                    if ((tmpstr = paygw.getW2ITPAYGWithholdingDetailsAmount()) != null && !tmpstr.isEmpty()) {
                        paygwamt = this.subtractInteger(paygwamt, Integer.parseInt(tmpstr));
                    }
                    if ((tmpstr = paygw.getW3ITPAYGWithholdingDetailsAmount()) != null && !tmpstr.isEmpty()) {
                        paygwamt = this.subtractInteger(paygwamt, Integer.parseInt(tmpstr));
                    }
                }
            }
            HashSet<String> gstpi = new HashSet<String>();
            HashSet<String> gstri = new HashSet<String>();
            HashSet<String> ftci = new HashSet<String>();
            HashSet<String> weti = new HashSet<String>();
            HashSet<String> luxi = new HashSet<String>();
            HashSet<String> paygwi = new HashSet<String>();
            String gstpaidpi = null;
            String gstrecpi = null;
            String ftcpaidpi = null;
            String wetpaidpi = null;
            String luxipaidpi = null;
            String paygwpaidpi = null;
            Business b = this.provisionTrnXBRL.getBusiness();
            if (b != null && (pts = b.getTransactionArrayList()) != null) {
                for (int i = 0; i < pts.size(); ++i) {
                    Transaction pt = pts.get(i);
                    if (pt == null) continue;
                    String pi = pt.getProvisionIdentifier();
                    String basc = pt.getProvisionGrossBASClassification();
                    if (basc == null) continue;
                    if (basc.equals("GST_Taxable_Sales")) {
                        gstpi.add(pi);
                        continue;
                    }
                    if (basc.equals("Sales_Adjustments")) {
                        gstpi.add(pi);
                        continue;
                    }
                    if (basc.equals("Capital_Purchases")) {
                        gstri.add(pi);
                        continue;
                    }
                    if (basc.equals("Non_Capital_Purchases")) {
                        gstri.add(pi);
                        continue;
                    }
                    if (basc.equals("Purchase_Adjustments")) {
                        gstri.add(pi);
                        continue;
                    }
                    if (basc.equals("Fuel_Tax_Overclaimed_Credits_Tax_Amount")) {
                        ftci.add(pi);
                        continue;
                    }
                    if (basc.equals("Fuel_Tax_Claimable_Credits_Tax_Amount")) {
                        ftci.add(pi);
                        continue;
                    }
                    if (basc.equals("Wine_Equalisation_Tax_Claimable_Credits")) {
                        weti.add(pi);
                        continue;
                    }
                    if (basc.equals("Wine_Equalisation_Tax_Liability")) {
                        weti.add(pi);
                        continue;
                    }
                    if (basc.equals("Luxury_Car_Tax_Claimable_Credits")) {
                        luxi.add(pi);
                        continue;
                    }
                    if (basc.equals("Luxury_Car_Tax_Liability")) {
                        luxi.add(pi);
                        continue;
                    }
                    if (basc.equals("PAYG_Withholding_Payable")) {
                        paygwi.add(pi);
                        continue;
                    }
                    if (basc.equals("No_ABN_Withholding")) {
                        paygwi.add(pi);
                        continue;
                    }
                    if (basc.equals("Other_PAYG_Withholding")) {
                        paygwi.add(pi);
                        continue;
                    }
                    if (basc.equals("GST_Paid_to_ATO")) {
                        gstpaidpi = pi;
                        continue;
                    }
                    if (basc.equals("GST_Received_from_ATO")) {
                        gstrecpi = pi;
                        continue;
                    }
                    if (basc.equals("Fuel_Tax_Credits_Refunded_from_ATO")) {
                        ftcpaidpi = pi;
                        continue;
                    }
                    if (basc.equals("Wine_Equalisation_Paid_to_ATO")) {
                        wetpaidpi = pi;
                        continue;
                    }
                    if (basc.equals("Luxury_Car_Tax_Paid_to_ATO")) {
                        luxipaidpi = pi;
                        continue;
                    }
                    if (!basc.equals("PAYG_Withheld_Paid_to_ATO")) continue;
                    paygwpaidpi = pi;
                }
            }
            HashMap<String, Double> mgstp = new HashMap<String, Double>();
            HashMap<String, Double> mgstr = new HashMap<String, Double>();
            HashMap<String, Double> mftcr = new HashMap<String, Double>();
            HashMap<String, Double> mwetr = new HashMap<String, Double>();
            HashMap<String, Double> mluxr = new HashMap<String, Double>();
            HashMap<String, Double> mpaygwp = new HashMap<String, Double>();
            for (Transaction.TransactionTransactionLine ttl : this.transactionTransactionLineArrayList) {
                String pi = ttl.getProvisionIdentifier();
                if (gstpi.contains(pi)) {
                    mgstp.put(ttl.getProvisionReconciliationNumber(), ttl.getProvisionReconciliationAmount());
                }
                if (gstri.contains(pi)) {
                    mgstr.put(ttl.getProvisionReconciliationNumber(), ttl.getProvisionReconciliationAmount());
                }
                if (ftci.contains(pi)) {
                    mftcr.put(ttl.getProvisionReconciliationNumber(), ttl.getProvisionReconciliationAmount());
                }
                if (weti.contains(pi)) {
                    mwetr.put(ttl.getProvisionReconciliationNumber(), ttl.getProvisionReconciliationAmount());
                }
                if (luxi.contains(pi)) {
                    mluxr.put(ttl.getProvisionReconciliationNumber(), ttl.getProvisionReconciliationAmount());
                }
                if (!paygwi.contains(pi)) continue;
                mpaygwp.put(ttl.getProvisionReconciliationNumber(), ttl.getProvisionReconciliationAmount());
            }
            Double agstp = this.sumMap(mgstp);
            Double agstr = this.sumMap(mgstr);
            Double aftcr = this.sumMap(mftcr);
            Double awetr = this.sumMap(mwetr);
            Double aluxr = this.sumMap(mluxr);
            Double apaygwp = this.sumMap(mpaygwp);
            if (agstp != null) {
                agstp = -agstp.doubleValue();
            }
            if (apaygwp != null) {
                apaygwp = -apaygwp.doubleValue();
            }
            Double maxdiff = 10.0;
            if (agstp != null && gstpayable == null || agstp == null && gstpayable != null || agstp != null && gstpayable != null && Math.abs(agstp - (double)gstpayable.intValue()) > maxdiff) {
                throw new Exception("Error, calculated GST payable is different to the BAS. This can happen if the account is incorrectly reconciled or the transactions have been changed since the BAS is lodged");
            }
            if (agstr != null && gstreceivable == null || agstr == null && gstreceivable != null || agstr != null && gstreceivable != null && Math.abs(agstr - (double)gstreceivable.intValue()) > maxdiff) {
                throw new Exception("Error, calculated GST receivable is different to the BAS. This can happen if the account is incorrectly reconciled or the transactions have been changed since the BAS is lodged");
            }
            if (aftcr != null && ftc == null || aftcr == null && ftc != null || aftcr != null && ftc != null && Math.abs(aftcr - (double)ftc.intValue()) > maxdiff) {
                throw new Exception("Error, calculated FTC is different to the BAS. This can happen if the account is incorrectly reconciled or the transactions have been changed since the BAS is lodged");
            }
            if (awetr != null && wet == null || awetr == null && wet != null || awetr != null && wet != null && Math.abs(awetr - (double)wet.intValue()) > maxdiff) {
                throw new Exception("Error, calculated WET is different to the BAS. This can happen if the account is incorrectly reconciled or the transactions have been changed since the BAS is lodged");
            }
            if (aluxr != null && lux == null || aluxr == null && lux != null || aluxr != null && lux != null && Math.abs(aluxr - (double)lux.intValue()) > maxdiff) {
                throw new Exception("Error, calculated LUX is different to the BAS. This can happen if the account is incorrectly reconciled or the transactions have been changed since the BAS is lodged");
            }
            if (apaygwp != null && paygwamt == null || apaygwp == null && paygwamt != null || apaygwp != null && paygwamt != null && Math.abs(apaygwp - (double)paygwamt.intValue()) > maxdiff) {
                throw new Exception("Error, calculated PAYG Witholding is different to the BAS. This can happen if the account is incorrectly reconciled or the transactions have been changed since the BAS is lodged");
            }
            Transaction rt = new Transaction();
            boolean payable = true;
            if (moveToPayables != null && !moveToPayables.isEmpty() && moveToPayables.equals("false")) {
                payable = false;
            }
            if (payable) {
                rt.setTransactionType("purchase_invoice");
            } else {
                rt.setTransactionType("general_journal");
            }
            rt.setTransactionStatus("posted");
            rt.setTransactionDate(this.activityStatement.getEndDate());
            rt.setTransactionComment(this.asEndDateDescFormatter.format(this.activityStatement.getEndDateAsDate()) + " " + this.activityStatement.getReportNameText());
            rt.setCounterpartyIdentifier(counterpartyIdentifierValue);
            if (mgstp.size() > 0) {
                if (gstpaidpi == null || gstpaidpi.isEmpty()) {
                    throw new Exception("GST paid to ATO tax code needed but not found");
                }
                if (payable) {
                    tl = rt.addBlankTransactionLine();
                    tl.setAccountIdentifier(roundingAI);
                    tl.setProvisionIdentifier(gstpaidpi);
                    tl.setAmount(gstpayable.doubleValue());
                    tl.setProvisionAmount(agstp);
                    tl.setActivityStatementNumber(asNumber);
                } else {
                    tl = rt.addBlankTransactionLine();
                    tl.setAccountIdentifier(roundingAI);
                    tl.setProvisionIdentifier(gstpaidpi);
                    tl.setAmount(agstp);
                    tl.setProvisionAmount(agstp);
                    tl.setActivityStatementNumber(asNumber);
                    tl = rt.addBlankTransactionLine();
                    tl.setAccountIdentifier(roundingAI);
                    tl.setProvisionIdentifier(gstpaidpi);
                    tl.setAmount(-agstp.doubleValue());
                    tl.setProvisionAmount(-gstpayable.doubleValue());
                    tl.setActivityStatementNumber(asNumber);
                }
            }
            if (mgstr.size() > 0) {
                if (gstrecpi == null || gstrecpi.isEmpty()) {
                    throw new Exception("GST received from ATO tax code needed but not found");
                }
                if (payable) {
                    tl = rt.addBlankTransactionLine();
                    tl.setAccountIdentifier(roundingAI);
                    tl.setProvisionIdentifier(gstrecpi);
                    tl.setAmount(-gstreceivable.doubleValue());
                    tl.setProvisionAmount(-agstr.doubleValue());
                    tl.setActivityStatementNumber(asNumber);
                } else {
                    tl = rt.addBlankTransactionLine();
                    tl.setAccountIdentifier(roundingAI);
                    tl.setProvisionIdentifier(gstrecpi);
                    tl.setAmount(-agstr.doubleValue());
                    tl.setProvisionAmount(-agstr.doubleValue());
                    tl.setActivityStatementNumber(asNumber);
                    tl = rt.addBlankTransactionLine();
                    tl.setAccountIdentifier(roundingAI);
                    tl.setProvisionIdentifier(gstrecpi);
                    tl.setAmount(agstr);
                    tl.setProvisionAmount(gstreceivable.doubleValue());
                    tl.setActivityStatementNumber(asNumber);
                }
            }
            if (mftcr.size() > 0) {
                if (ftcpaidpi == null || ftcpaidpi.isEmpty()) {
                    throw new Exception("FTC received from ATO tax code needed but not found");
                }
                if (payable) {
                    tl = rt.addBlankTransactionLine();
                    tl.setAccountIdentifier(roundingAI);
                    tl.setProvisionIdentifier(ftcpaidpi);
                    tl.setAmount(-ftc.doubleValue());
                    tl.setProvisionAmount(-aftcr.doubleValue());
                    tl.setActivityStatementNumber(asNumber);
                } else {
                    tl = rt.addBlankTransactionLine();
                    tl.setAccountIdentifier(roundingAI);
                    tl.setProvisionIdentifier(ftcpaidpi);
                    tl.setAmount(-aftcr.doubleValue());
                    tl.setProvisionAmount(-aftcr.doubleValue());
                    tl.setActivityStatementNumber(asNumber);
                    tl = rt.addBlankTransactionLine();
                    tl.setAccountIdentifier(roundingAI);
                    tl.setProvisionIdentifier(ftcpaidpi);
                    tl.setAmount(aftcr);
                    tl.setProvisionAmount(ftc.doubleValue());
                    tl.setActivityStatementNumber(asNumber);
                }
            }
            if (mwetr.size() > 0) {
                if (wetpaidpi == null || wetpaidpi.isEmpty()) {
                    throw new Exception("WET paid to ATO tax code needed but not found");
                }
                if (payable) {
                    tl = rt.addBlankTransactionLine();
                    tl.setAccountIdentifier(roundingAI);
                    tl.setProvisionIdentifier(wetpaidpi);
                    tl.setAmount(-wet.doubleValue());
                    tl.setProvisionAmount(-awetr.doubleValue());
                    tl.setActivityStatementNumber(asNumber);
                } else {
                    tl = rt.addBlankTransactionLine();
                    tl.setAccountIdentifier(roundingAI);
                    tl.setProvisionIdentifier(wetpaidpi);
                    tl.setAmount(-awetr.doubleValue());
                    tl.setProvisionAmount(-awetr.doubleValue());
                    tl.setActivityStatementNumber(asNumber);
                    tl = rt.addBlankTransactionLine();
                    tl.setAccountIdentifier(roundingAI);
                    tl.setProvisionIdentifier(wetpaidpi);
                    tl.setAmount(awetr);
                    tl.setProvisionAmount(wet.doubleValue());
                    tl.setActivityStatementNumber(asNumber);
                }
            }
            if (mluxr.size() > 0) {
                if (luxipaidpi == null || luxipaidpi.isEmpty()) {
                    throw new Exception("Luxury car tax paid to ATO tax code needed but not found");
                }
                if (payable) {
                    tl = rt.addBlankTransactionLine();
                    tl.setAccountIdentifier(roundingAI);
                    tl.setProvisionIdentifier(luxipaidpi);
                    tl.setAmount(-lux.doubleValue());
                    tl.setProvisionAmount(-aluxr.doubleValue());
                    tl.setActivityStatementNumber(asNumber);
                } else {
                    tl = rt.addBlankTransactionLine();
                    tl.setAccountIdentifier(roundingAI);
                    tl.setProvisionIdentifier(luxipaidpi);
                    tl.setAmount(-aluxr.doubleValue());
                    tl.setProvisionAmount(-aluxr.doubleValue());
                    tl.setActivityStatementNumber(asNumber);
                    tl = rt.addBlankTransactionLine();
                    tl.setAccountIdentifier(roundingAI);
                    tl.setProvisionIdentifier(luxipaidpi);
                    tl.setAmount(aluxr);
                    tl.setProvisionAmount(lux.doubleValue());
                    tl.setActivityStatementNumber(asNumber);
                }
            }
            if (mpaygwp.size() > 0) {
                if (paygwpaidpi == null || paygwpaidpi.isEmpty()) {
                    throw new Exception("PAYGW paid to ATO tax code needed but not found");
                }
                if (payable) {
                    tl = rt.addBlankTransactionLine();
                    tl.setAccountIdentifier(roundingAI);
                    tl.setProvisionIdentifier(paygwpaidpi);
                    tl.setAmount(paygwamt.doubleValue());
                    tl.setProvisionAmount(apaygwp);
                    tl.setActivityStatementNumber(asNumber);
                } else {
                    tl = rt.addBlankTransactionLine();
                    tl.setAccountIdentifier(roundingAI);
                    tl.setProvisionIdentifier(paygwpaidpi);
                    tl.setAmount(apaygwp);
                    tl.setProvisionAmount(apaygwp);
                    tl.setActivityStatementNumber(asNumber);
                    tl = rt.addBlankTransactionLine();
                    tl.setAccountIdentifier(roundingAI);
                    tl.setProvisionIdentifier(paygwpaidpi);
                    tl.setAmount(-apaygwp.doubleValue());
                    tl.setProvisionAmount(-paygwamt.doubleValue());
                    tl.setActivityStatementNumber(asNumber);
                }
            }
            this.xbrlFileController.saveTransaction(rt);
            StringBuilder rrsb = new StringBuilder();
            boolean hasselected = false;
            for (String rr : mgstp.keySet()) {
                if (hasselected) {
                    rrsb.append(",");
                }
                rrsb.append(rr);
                hasselected = true;
            }
            if (hasselected) {
                rtrr = this.getTransactionRR(rt, gstpaidpi);
                rrsb.append("," + (String)rtrr);
                gr = this.xbrlFileController.sendReconcile(rrsb.toString());
                if (gr == null) {
                    throw new Exception("Error, unable to read post reconciliation response");
                }
                resultCode = gr.getResultCode();
                if (resultCode == null) {
                    throw new Exception("Error, unable to read post reconciliation response code");
                }
                if (!resultCode.equals("OK")) {
                    throw new Exception(gr.getResultDescription());
                }
            }
            rrsb = new StringBuilder();
            hasselected = false;
            for (String rr : mgstr.keySet()) {
                if (hasselected) {
                    rrsb.append(",");
                }
                rrsb.append(rr);
                hasselected = true;
            }
            if (hasselected) {
                rtrr = this.getTransactionRR(rt, gstrecpi);
                rrsb.append("," + rtrr);
                gr = this.xbrlFileController.sendReconcile(rrsb.toString());
                if (gr == null) {
                    throw new Exception("Error, unable to read post reconciliation response");
                }
                resultCode = gr.getResultCode();
                if (resultCode == null) {
                    throw new Exception("Error, unable to read post reconciliation response code");
                }
                if (!resultCode.equals("OK")) {
                    throw new Exception(gr.getResultDescription());
                }
            }
            rrsb = new StringBuilder();
            hasselected = false;
            for (String rr : mftcr.keySet()) {
                if (hasselected) {
                    rrsb.append(",");
                }
                rrsb.append(rr);
                hasselected = true;
            }
            if (hasselected) {
                rtrr = this.getTransactionRR(rt, ftcpaidpi);
                rrsb.append("," + rtrr);
                gr = this.xbrlFileController.sendReconcile(rrsb.toString());
                if (gr == null) {
                    throw new Exception("Error, unable to read post reconciliation response");
                }
                resultCode = gr.getResultCode();
                if (resultCode == null) {
                    throw new Exception("Error, unable to read post reconciliation response code");
                }
                if (!resultCode.equals("OK")) {
                    throw new Exception(gr.getResultDescription());
                }
            }
            rrsb = new StringBuilder();
            hasselected = false;
            for (String rr : mwetr.keySet()) {
                if (hasselected) {
                    rrsb.append(",");
                }
                rrsb.append(rr);
                hasselected = true;
            }
            if (hasselected) {
                rtrr = this.getTransactionRR(rt, wetpaidpi);
                rrsb.append("," + rtrr);
                gr = this.xbrlFileController.sendReconcile(rrsb.toString());
                if (gr == null) {
                    throw new Exception("Error, unable to read post reconciliation response");
                }
                resultCode = gr.getResultCode();
                if (resultCode == null) {
                    throw new Exception("Error, unable to read post reconciliation response code");
                }
                if (!resultCode.equals("OK")) {
                    throw new Exception(gr.getResultDescription());
                }
            }
            rrsb = new StringBuilder();
            hasselected = false;
            for (String rr : mluxr.keySet()) {
                if (hasselected) {
                    rrsb.append(",");
                }
                rrsb.append(rr);
                hasselected = true;
            }
            if (hasselected) {
                rtrr = this.getTransactionRR(rt, luxipaidpi);
                rrsb.append("," + rtrr);
                gr = this.xbrlFileController.sendReconcile(rrsb.toString());
                if (gr == null) {
                    throw new Exception("Error, unable to read post reconciliation response");
                }
                resultCode = gr.getResultCode();
                if (resultCode == null) {
                    throw new Exception("Error, unable to read post reconciliation response code");
                }
                if (!resultCode.equals("OK")) {
                    throw new Exception(gr.getResultDescription());
                }
            }
            rrsb = new StringBuilder();
            hasselected = false;
            for (String rr : mpaygwp.keySet()) {
                if (hasselected) {
                    rrsb.append(",");
                }
                rrsb.append(rr);
                hasselected = true;
            }
            if (hasselected) {
                rtrr = this.getTransactionRR(rt, paygwpaidpi);
                rrsb.append("," + (String)rtrr);
                gr = this.xbrlFileController.sendReconcile(rrsb.toString());
                if (gr == null) {
                    throw new Exception("Error, unable to read post reconciliation response");
                }
                resultCode = gr.getResultCode();
                if (resultCode == null) {
                    throw new Exception("Error, unable to read post reconciliation response code");
                }
                if (!resultCode.equals("OK")) {
                    throw new Exception(gr.getResultDescription());
                }
            }
            this.error_message.setText("Reconciliation complete");
            this.xbrlFileController.setStatusBarMessage("Reconciliation complete");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public void setAccountList(ObservableList<Transaction> accountObservableList) {
        super.setAccountList(accountObservableList);
        this.roundingsAccountIdentifier.setItems(accountObservableList);
    }

    @Override
    public void setCounterpartyTransactionList(ObservableList<Transaction> counterpartyObservableList) {
        super.setCounterpartyTransactionList(counterpartyObservableList);
        this.counterpartyIdentifier.setItems(counterpartyObservableList);
    }
}

