/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationController;
import au.com.glenix.cloud.TransactionSendInvoiceController;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.ElectronicContact;
import java.util.ArrayList;
import javafx.fxml.FXML;
import javafx.util.Pair;

public class TransactionReceiveInvoiceController
extends TransactionSendInvoiceController {
    public TransactionReceiveInvoiceController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    @Override
    public void setTransactionDefaults() throws Exception {
        if (this.transaction == null) {
            return;
        }
        String tt = this.transaction.getTransactionType();
        if (tt == null) {
            this.transaction.setTransactionType("purchase_invoice");
        }
    }

    protected void setupEmail() {
        this.html_message.setHtmlText("<html><head></head><body><p>Dear Supplier,</p><p>please find attached your invoice.</p></body></html>");
        this.email_from.setGlenixElementValue(null);
        this.email_subject.setGlenixElementValue("Tax Invoice");
        BusinessMasterFile bmf = this.xbrlFileController.getBusinessMasterFile();
        if (bmf != null) {
            String name;
            ElectronicContact bec = bmf.getBusinessElectronicContact();
            if (bec != null) {
                this.email_from.setGlenixElementValue(bec.getElectronicMailAddressT());
            }
            if ((name = bmf.getBusinessTradingName()) == null || name.isEmpty()) {
                name = bmf.getBusinessLegalName();
            }
            this.email_subject.setGlenixElementValue(name + " - Purchase order");
        }
    }

    @Override
    protected void setTransactionTypeOptions() {
        ArrayList<Pair<String, String>> options = new ArrayList<Pair<String, String>>();
        options.add(new Pair((Object)"purchase_invoice", (Object)"Purchase invoice"));
        options.add(new Pair((Object)"purchase_credit", (Object)"Purchase credit"));
        this.transactionEditFormVBox.setTransactionTypeVisibleOptions(options, true, "purchase_invoice");
    }

    @FXML
    private void pdfTransaction() {
        if (this.transaction == null) {
            return;
        }
        String tt = this.transaction.getTransactionType();
        if (tt == null) {
            return;
        }
        if (tt.equals("cash_payment")) {
            this.xbrlFileController.pdfCashPayment(this.transaction);
        } else {
            this.xbrlFileController.pdfPurchaseInvoice(this.transaction);
        }
    }
}

