/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.widget.GlenixBranchController;
import java.io.File;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.Label;

public class TemplateSalesInvoiceController
extends GlenixBranchController {
    @FXML
    protected Label page_heading;
    @FXML
    protected Label page_help;
    @FXML
    protected Label error_message;
    @FXML
    protected Label filename;
    protected GlenixTrnXBRL glenixTrnXBRL;
    protected File file;
    protected ApplicationController xbrlFileController = null;

    public TemplateSalesInvoiceController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.page_help.setText("On this page you can upload a .odt file which serves as the template for your sales invoice pdf files.");
    }

    public void setBusinessMasterFile(BusinessMasterFile bmf) {
        if (bmf == null) {
            this.page_heading.setText("Sales invoice template upload");
        } else {
            this.page_heading.setText(bmf.getBusinessLegalName() + " - Sales invoice template upload");
        }
    }

    @FXML
    public void openFile() {
        try {
            this.file = this.xbrlFileController.openTemplateFile();
            if (this.file == null) {
                this.filename.setText(null);
            } else {
                this.filename.setText(this.file.getAbsolutePath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void uploadFile() {
        try {
            if (this.file == null) {
                throw new Exception("Error, you have not yet selected a .odt file.");
            }
            this.xbrlFileController.uploadTemplateSalesInvoice(this.file);
            this.error_message.setText("Upload complete");
            this.file = null;
            this.filename.setText(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void downloadFile() {
        try {
            this.xbrlFileController.downloadTemplateSalesInvoice();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void downloadDefaultFile() {
        try {
            this.xbrlFileController.downloadDefaultTemplateSalesInvoice();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void deleteFile() {
        try {
            this.xbrlFileController.deleteTemplateSalesInvoice();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }
}

