/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationController;
import au.com.glenix.cloud.TemplateSalesInvoiceController;
import au.com.glenix.trn.BusinessMasterFile;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;

public class TemplateSalesCreditController
extends TemplateSalesInvoiceController {
    public TemplateSalesCreditController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.page_help.setText("On this page you can upload a .odt file which serves as the template for your sales credit pdf files.");
    }

    @Override
    public void setBusinessMasterFile(BusinessMasterFile bmf) {
        if (bmf == null) {
            this.page_heading.setText("Sales credit template upload");
        } else {
            this.page_heading.setText(bmf.getBusinessLegalName() + " - Sales credit template upload");
        }
    }

    @Override
    @FXML
    public void uploadFile() {
        try {
            if (this.file == null) {
                throw new Exception("Error, you have not yet selected a .odt file.");
            }
            this.xbrlFileController.uploadTemplateSalesCredit(this.file);
            this.error_message.setText("Upload complete");
            this.file = null;
            this.filename.setText(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    @FXML
    public void downloadFile() {
        try {
            this.xbrlFileController.downloadTemplateSalesCredit();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    @FXML
    public void downloadDefaultFile() {
        try {
            this.xbrlFileController.downloadDefaultTemplateSalesCredit();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    @FXML
    public void deleteFile() {
        try {
            this.xbrlFileController.deleteTemplateSalesCredit();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }
}

