/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationController;
import au.com.glenix.cloud.TemplateSalesInvoiceController;
import au.com.glenix.trn.BusinessMasterFile;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;

public class TemplateCashPaymentController
extends TemplateSalesInvoiceController {
    public TemplateCashPaymentController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.page_help.setText("On this page you can upload a .odt file which serves as the template for your cash payment pdf files.");
    }

    @Override
    public void setBusinessMasterFile(BusinessMasterFile bmf) {
        if (bmf == null) {
            this.page_heading.setText("Cash payment template upload");
        } else {
            this.page_heading.setText(bmf.getBusinessLegalName() + " - Cash payment template upload");
        }
    }

    @Override
    @FXML
    public void uploadFile() {
        try {
            if (this.file == null) {
                throw new Exception("Error, you have not yet selected a .odt file.");
            }
            this.xbrlFileController.uploadTemplateCashPayment(this.file);
            this.error_message.setText("Upload complete");
            this.file = null;
            this.filename.setText(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    @FXML
    public void downloadFile() {
        try {
            this.xbrlFileController.downloadTemplateCashPayment();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    @FXML
    public void downloadDefaultFile() {
        try {
            this.xbrlFileController.downloadDefaultTemplateCashPayment();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    @FXML
    public void deleteFile() {
        try {
            this.xbrlFileController.deleteTemplateCashPayment();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }
}

