/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixLabelCounterpartyCombo;
import au.com.glenix.GlenixLabelProvisionCombo;
import au.com.glenix.IncomeAndExpenditureController;
import au.com.glenix.trn.Transaction;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;

public class ProfitAndLossController
extends IncomeAndExpenditureController {
    @FXML
    protected GlenixLabelCounterpartyCombo counterpartyIdentifier;
    @FXML
    protected GlenixLabelProvisionCombo provisionIdentifier;

    public ProfitAndLossController(ApplicationController applicationController) {
        super(applicationController);
    }

    @Override
    @FXML
    protected void updateFilter() {
        LocalDate fromDateValue = null;
        if (this.filterFromDate != null) {
            fromDateValue = this.filterFromDate.getLocalDate();
        }
        LocalDate toDateValue = null;
        if (this.filterToDate != null) {
            toDateValue = this.filterToDate.getLocalDate();
        }
        try {
            List<Transaction> trns = this.applicationController.getAccountProvisionTotals(null, fromDateValue, toDateValue, this.counterpartyIdentifier.getGlenixElementValue(), this.provisionIdentifier.getGlenixElementValue());
            if (trns == null) {
                throw new Exception("Error, unable to generate Profit and loss report");
            }
            this.setSummaryTransaction(trns);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public void addTotalLines(HashMap<String, IncomeAndExpenditureController.ReportLine> reportLineHashMap) throws Exception {
        HashSet<String> removeLines = new HashSet<String>();
        IncomeAndExpenditureController.ReportLine incomeHeader = new IncomeAndExpenditureController.ReportLine(null);
        incomeHeader.setClassification("incomeheader");
        incomeHeader.setName("Income");
        IncomeAndExpenditureController.ReportLine totalIncome = new IncomeAndExpenditureController.ReportLine(null);
        totalIncome.setClassification("totalincome");
        totalIncome.setSubClassification("totalincome");
        totalIncome.setName("Total income");
        IncomeAndExpenditureController.ReportLine expenseHeader = new IncomeAndExpenditureController.ReportLine(null);
        expenseHeader.setClassification("expenseheader");
        expenseHeader.setName("Expenses");
        IncomeAndExpenditureController.ReportLine totalExpense = new IncomeAndExpenditureController.ReportLine(null);
        totalExpense.setClassification("totalexpense");
        totalExpense.setSubClassification("totalexpense");
        totalExpense.setName("Total expenses");
        IncomeAndExpenditureController.ReportLine netIncome = new IncomeAndExpenditureController.ReportLine(null);
        netIncome.setClassification("netincome");
        netIncome.setSubClassification("netincome");
        netIncome.setName("Net income");
        IncomeAndExpenditureController.ReportLine equityHeader = new IncomeAndExpenditureController.ReportLine(null);
        equityHeader.setClassification("equityheader");
        equityHeader.setName("Distributions from equity");
        IncomeAndExpenditureController.ReportLine totalEquity = new IncomeAndExpenditureController.ReportLine(null);
        totalEquity.setClassification("totalequity");
        totalEquity.setSubClassification("totalequity");
        totalEquity.setName("Total distributions from equity");
        IncomeAndExpenditureController.ReportLine totalEquityIncrease = new IncomeAndExpenditureController.ReportLine(null);
        totalEquityIncrease.setClassification("totalequityincrease");
        totalEquityIncrease.setName("Total increase/(decrease) in equity");
        for (String key : reportLineHashMap.keySet()) {
            Double tmp;
            IncomeAndExpenditureController.ReportLine rl = reportLineHashMap.get(key);
            String classification = rl.getClassification();
            if (classification != null && classification.equals("income")) {
                tmp = rl.getGrossAsDoubleCalc();
                if (tmp != null) {
                    totalIncome.addAmount(-tmp.doubleValue());
                    totalEquityIncrease.addAmount(-tmp.doubleValue());
                }
                if ((tmp = rl.getQuantityAsDoubleCalc()) != null) {
                    totalIncome.addQuantity(-tmp.doubleValue());
                    totalEquityIncrease.addAmount(-tmp.doubleValue());
                }
                totalIncome.addTransactionLines("cash_payment", rl.getTransactionLines());
                totalEquityIncrease.addTransactionLines("cash_payment", rl.getTransactionLines());
                continue;
            }
            if (classification != null && classification.equals("expense")) {
                tmp = rl.getGrossAsDoubleCalc();
                if (tmp != null) {
                    totalExpense.addAmount(tmp);
                    totalEquityIncrease.addAmount(-tmp.doubleValue());
                }
                if ((tmp = rl.getQuantityAsDoubleCalc()) != null) {
                    totalExpense.addQuantity(tmp);
                    totalEquityIncrease.addAmount(-tmp.doubleValue());
                }
                totalExpense.addTransactionLines("cash_payment", rl.getTransactionLines());
                totalEquityIncrease.addTransactionLines("cash_payment", rl.getTransactionLines());
                continue;
            }
            if (classification != null && classification.equals("distribution")) {
                tmp = rl.getGrossAsDoubleCalc();
                if (tmp != null) {
                    totalEquity.addAmount(-tmp.doubleValue());
                    totalEquityIncrease.addAmount(-tmp.doubleValue());
                }
                if ((tmp = rl.getQuantityAsDoubleCalc()) != null) {
                    totalEquity.addQuantity(-tmp.doubleValue());
                    totalEquityIncrease.addQuantity(-tmp.doubleValue());
                }
                totalEquity.addTransactionLines("cash_payment", rl.getTransactionLines());
                totalEquityIncrease.addTransactionLines("cash_payment", rl.getTransactionLines());
                continue;
            }
            removeLines.add(key);
        }
        reportLineHashMap.put("incomeheader", incomeHeader);
        reportLineHashMap.put("totalincome", totalIncome);
        reportLineHashMap.put("expenseheader", expenseHeader);
        reportLineHashMap.put("totalexpense", totalExpense);
        Double tmp = totalIncome.getGrossAsDouble();
        if (tmp != null) {
            netIncome.addAmount(-tmp.doubleValue());
        }
        if ((tmp = totalIncome.getQuantityAsDouble()) != null) {
            netIncome.addQuantity(-tmp.doubleValue());
        }
        netIncome.addTransactionLines("cash_payment", totalIncome.getTransactionLines());
        tmp = totalExpense.getGrossAsDouble();
        if (tmp != null) {
            netIncome.addAmount(tmp);
        }
        if ((tmp = totalExpense.getQuantityAsDouble()) != null) {
            netIncome.addQuantity(tmp);
        }
        netIncome.addTransactionLines("cash_payment", totalExpense.getTransactionLines());
        reportLineHashMap.put("netincome", netIncome);
        if (totalEquity.hasValue()) {
            reportLineHashMap.put("equityheader", equityHeader);
            reportLineHashMap.put("totalequity", totalEquity);
            reportLineHashMap.put("totalequityincrease", totalEquityIncrease);
        }
        for (String key : removeLines) {
            reportLineHashMap.remove(key);
        }
    }

    public String getCounterpartyIdentifier() {
        return this.counterpartyIdentifier.getGlenixElementValue();
    }

    public String getProvisionIdentifier() {
        return this.provisionIdentifier.getGlenixElementValue();
    }

    public void setCounterpartyIdentifier(String ci) {
        this.counterpartyIdentifier.setGlenixElementValue(ci);
    }

    public void setProvisionIdentifier(String pi) {
        this.provisionIdentifier.setGlenixElementValue(pi);
    }

    public void setCounterpartyTransactionList(ObservableList<Transaction> counterpartyObservableList) {
        this.counterpartyIdentifier.setItems(counterpartyObservableList);
    }

    public void setProvisionList(ObservableList<Transaction> provisionObservableList) {
        this.provisionIdentifier.setItems(provisionObservableList);
    }

    @Override
    public void gotoIncomeAndExpenditureAccountDetail(String ai) {
        try {
            this.applicationController.gotoProfitAndLossAccountDetail(ai, this.filterFromDate.getLocalDate(), this.filterToDate.getLocalDate(), this.counterpartyIdentifier.getGlenixElementValue(), this.provisionIdentifier.getGlenixElementValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public void gotoIncomeAndExpenditureProvisionDetail(String pi) {
    }
}

