/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixLabelAccountCombo;
import au.com.glenix.GlenixLabelCounterpartyCombo;
import au.com.glenix.GlenixLabelProvisionCombo;
import au.com.glenix.IncomeAndExpenditureAccountDetailController;
import au.com.glenix.cloud.GlenixLabelBlankMonthsHistoryCombo;
import au.com.glenix.trn.Transaction;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.TableRow;
import javafx.scene.input.MouseEvent;

public class ProfitAndLossAccountDetailController
extends IncomeAndExpenditureAccountDetailController {
    @FXML
    protected GlenixLabelCounterpartyCombo filterCounterpartyIdentifier;
    @FXML
    protected GlenixLabelProvisionCombo filterProvisionIdentifier;
    @FXML
    protected GlenixLabelAccountCombo filterAccountIdentifier;
    @FXML
    protected GlenixLabelBlankMonthsHistoryCombo displayMonths;
    protected DateTimeFormatter outputDateFormatter = DateTimeFormatter.ofPattern("dd MMM yyyy");
    protected NumberFormat formatTwoDp = new DecimalFormat("$#,##0.00");

    public ProfitAndLossAccountDetailController(ApplicationController applicationController) {
        super(applicationController);
    }

    @Override
    public void updateHeading() {
        if (this.account == null) {
            this.page_heading.setText("Profit and loss account transactions");
            this.setGlenixElementDescription("Profit and loss account transactions");
        } else {
            this.page_heading.setText(this.account.getAccountName() + " - transactions");
            this.setGlenixElementDescription(this.account.getAccountName() + " - transactions");
            String classification = this.account.getAccountClassificationReference();
            this.multiplier = 1;
            if (classification != null && (classification.equals("income") || classification.equals("netincome") || classification.equals("totalincome") || classification.equals("equity") || classification.equals("distribution") || classification.equals("liability") || classification.equals("totalliability") || classification.equals("totalequity"))) {
                this.multiplier = -1;
            }
        }
    }

    @Override
    public void setupIncomeAndExpenditureTable() {
        this.incomeAndExpenditure.setRowFactory(tv -> {
            TableRow<Transaction.TransactionTransactionLine> row = new TableRow<Transaction.TransactionTransactionLine>(){};
            row.setOnMouseClicked(arg_0 -> this.lambda$null$0((TableRow)row, arg_0));
            return row;
        });
    }

    public String getCounterpartyIdentifier() {
        if (this.filterCounterpartyIdentifier == null) {
            return null;
        }
        return this.filterCounterpartyIdentifier.getGlenixElementValue();
    }

    public String getProvisionIdentifier() {
        if (this.filterProvisionIdentifier == null) {
            return null;
        }
        return this.filterProvisionIdentifier.getGlenixElementValue();
    }

    public String getAccountIdentifier() {
        if (this.filterAccountIdentifier == null) {
            return null;
        }
        return this.filterAccountIdentifier.getGlenixElementValue();
    }

    public void setCounterpartyIdentifier(String ci) {
        if (this.filterCounterpartyIdentifier != null) {
            this.filterCounterpartyIdentifier.setGlenixElementValue(ci);
        }
    }

    public void setProvisionIdentifier(String pi) {
        if (this.filterProvisionIdentifier != null) {
            this.filterProvisionIdentifier.setGlenixElementValue(pi);
        }
    }

    public void setAccountIdentifier(String ai) {
        if (this.filterAccountIdentifier != null) {
            this.filterAccountIdentifier.setGlenixElementValue(ai);
        }
    }

    @Override
    public void setCounterpartyTransactionList(ObservableList<Transaction> counterpartyObservableList) {
        super.setCounterpartyTransactionList(counterpartyObservableList);
        if (this.filterCounterpartyIdentifier != null) {
            this.filterCounterpartyIdentifier.setItems(counterpartyObservableList);
        }
    }

    @Override
    public void setProvisionList(ObservableList<Transaction> provisionObservableList) {
        super.setProvisionList(provisionObservableList);
        if (this.filterProvisionIdentifier != null) {
            this.filterProvisionIdentifier.setItems(provisionObservableList);
        }
    }

    @Override
    public void setAccountList(ObservableList<Transaction> provisionObservableList) {
        super.setAccountList(provisionObservableList);
        if (this.filterAccountIdentifier != null) {
            this.filterAccountIdentifier.setItems(provisionObservableList);
        }
    }

    @Override
    @FXML
    protected void updateFilter() {
        String filterTextValue = null;
        if (this.filterText != null) {
            filterTextValue = this.filterText.getText();
        }
        LocalDate fromDateValue = null;
        if (this.filterFromDate != null) {
            fromDateValue = this.filterFromDate.getLocalDate();
        }
        LocalDate toDateValue = null;
        if (this.filterToDate != null) {
            toDateValue = this.filterToDate.getLocalDate();
        }
        String ci = null;
        if (this.filterCounterpartyIdentifier != null) {
            ci = this.filterCounterpartyIdentifier.getGlenixElementValue();
        }
        String pi = null;
        if (this.filterProvisionIdentifier != null) {
            pi = this.filterProvisionIdentifier.getGlenixElementValue();
        }
        this.updateFilter(filterTextValue, fromDateValue, toDateValue, ci, pi);
    }

    @Override
    @FXML
    protected void updateFilterReload() {
        if (this.account == null) {
            this.error_message.setText("Error, account is not set.");
            this.applicationController.setStatusBarMessage("Error, account is not set.");
            return;
        }
        String ai = this.account.getAccountIdentifier();
        if (ai == null || ai.isEmpty()) {
            this.error_message.setText("Error, account identifier is not set.");
            this.applicationController.setStatusBarMessage("Error, account identifier is not set.");
            return;
        }
        String filterTextValue = null;
        if (this.filterText != null) {
            filterTextValue = this.filterText.getText();
        }
        LocalDate fromDateValue = null;
        if (this.filterFromDate != null) {
            fromDateValue = this.filterFromDate.getLocalDate();
        }
        LocalDate toDateValue = null;
        if (this.filterToDate != null) {
            toDateValue = this.filterToDate.getLocalDate();
        }
        String ci = null;
        if (this.filterCounterpartyIdentifier != null) {
            ci = this.filterCounterpartyIdentifier.getGlenixElementValue();
        }
        String pi = null;
        if (this.filterProvisionIdentifier != null) {
            pi = this.filterProvisionIdentifier.getGlenixElementValue();
        }
        try {
            ArrayList<Transaction.TransactionTransactionLine> ttl = this.applicationController.getTransactionLineListByAccount(ai, null, fromDateValue, toDateValue, ci, pi);
            this.transactionLineObservableList = FXCollections.observableList(ttl);
            this.setTransactionObservableList((ObservableList<Transaction.TransactionTransactionLine>)this.transactionLineObservableList);
            this.updateFilter(filterTextValue, fromDateValue, toDateValue, ci, pi);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
            return;
        }
    }

    protected void updateFilter(String newValue, LocalDate fromDate, LocalDate toDate, String ci, String pi) {
        this.filteredItems.setPredicate(ttl -> {
            String formattedDate;
            String pid;
            String ttlpi;
            String ttlci;
            LocalDate localDate = ttl.getTransactionDateAsDate();
            if (fromDate != null || toDate != null) {
                if (localDate == null) {
                    return false;
                }
                if (fromDate != null && localDate.isBefore(fromDate)) {
                    return false;
                }
                if (toDate != null && localDate.isAfter(toDate)) {
                    return false;
                }
            }
            if (!(ci == null || ci.isEmpty() || (ttlci = ttl.getCounterpartyIdentifier()) != null && ttlci.equals(ci))) {
                return false;
            }
            if (!(pi == null || pi.isEmpty() || (ttlpi = ttl.getProvisionIdentifier()) != null && ttlpi.equals(pi))) {
                return false;
            }
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String transactionComment = ttl.getTransactionCommentLineComment();
            if (transactionComment != null && transactionComment.toLowerCase().contains(newValue.toLowerCase())) {
                return true;
            }
            String cid = ttl.getCounterpartyIdentifier();
            if (cid != null && !cid.isEmpty()) {
                try {
                    String cname;
                    Transaction ct = this.applicationController.getCounterpartyTransaction(cid);
                    if (ct != null && (cname = ct.getCounterpartyLegalName()) != null && !cname.isEmpty() && cname.toLowerCase().contains(newValue.toLowerCase())) {
                        return true;
                    }
                }
                catch (Exception ct) {
                    // empty catch block
                }
            }
            if ((pid = ttl.getProvisionIdentifier()) != null && !pid.isEmpty()) {
                try {
                    String pname;
                    Transaction pt = this.applicationController.getProvisionTransaction(pid);
                    if (pt != null && (pname = pt.getProvisionName()) != null && !pname.isEmpty() && pname.toLowerCase().contains(newValue.toLowerCase())) {
                        return true;
                    }
                }
                catch (Exception pt) {
                    // empty catch block
                }
            }
            return localDate != null && (formattedDate = this.displayDateFormatter.format(localDate)) != null && !formattedDate.isEmpty() && formattedDate.toLowerCase().contains(newValue.toLowerCase());
        });
        this.updateTotalAmount();
    }

    @FXML
    protected void backToProfitAndLoss() {
        try {
            this.applicationController.gotoProfitAndLoss(this.filterFromDate.getLocalDate(), this.filterToDate.getLocalDate(), this.filterCounterpartyIdentifier.getGlenixElementValue(), this.filterProvisionIdentifier.getGlenixElementValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    private /* synthetic */ void lambda$null$0(TableRow row, MouseEvent event) {
        block33: {
            Transaction t;
            Transaction.TransactionTransactionLine reportItem;
            if (event.getClickCount() == 2 && !row.isEmpty() && (reportItem = (Transaction.TransactionTransactionLine)row.getItem()) != null && (t = reportItem.getTransaction()) != null) {
                try {
                    String tt;
                    t = this.applicationController.getTransactionByTransactionNumber(t.getTransactionNumber());
                    if (t == null || (tt = t.getTransactionType()) == null) break block33;
                    if (tt.equals("sales_invoice") || tt.equals("sales_credit") || tt.equals("sales_quote")) {
                        try {
                            String batchIdentifier = t.getBatchIdentifier();
                            if (batchIdentifier != null && !batchIdentifier.isEmpty()) {
                                this.applicationController.gotoBatchTransactionEdit(t, batchIdentifier);
                                break block33;
                            }
                            this.applicationController.gotoSalesTransactionsE(t);
                        }
                        catch (Exception e) {
                            this.error_message.setText(e.getMessage());
                            this.applicationController.setStatusBarMessage(e.getMessage());
                            e.printStackTrace();
                        }
                        break block33;
                    }
                    if (tt.equals("cash_received")) {
                        try {
                            String monthsStr;
                            String batchIdentifier = t.getBatchIdentifier();
                            if (batchIdentifier != null && !batchIdentifier.isEmpty()) {
                                this.applicationController.gotoBatchTransactionEdit(t, batchIdentifier);
                                break block33;
                            }
                            int months = 0;
                            if (this.displayMonths != null && (monthsStr = this.displayMonths.getGlenixElementValue()) != null && !monthsStr.isEmpty()) {
                                months = Integer.parseInt(monthsStr);
                            }
                            LocalDate fromDate = null;
                            if (this.filterFromDate != null) {
                                fromDate = this.filterFromDate.getLocalDate();
                            }
                            LocalDate toDate = null;
                            if (this.filterToDate != null) {
                                fromDate = this.filterToDate.getLocalDate();
                            }
                            this.applicationController.gotoReceiveMoneyE(t, months, fromDate, toDate, null);
                        }
                        catch (Exception e) {
                            this.error_message.setText(e.getMessage());
                            this.applicationController.setStatusBarMessage(e.getMessage());
                            e.printStackTrace();
                        }
                        break block33;
                    }
                    if (tt.equals("purchase_invoice") || tt.equals("purchase_credit") || tt.equals("purchase_quote")) {
                        try {
                            String batchIdentifier = t.getBatchIdentifier();
                            if (batchIdentifier != null && !batchIdentifier.isEmpty()) {
                                this.applicationController.gotoBatchTransactionEdit(t, batchIdentifier);
                                break block33;
                            }
                            this.applicationController.gotoOtherPurchasesTransactionsE(t);
                        }
                        catch (Exception e) {
                            this.error_message.setText(e.getMessage());
                            this.applicationController.setStatusBarMessage(e.getMessage());
                            e.printStackTrace();
                        }
                        break block33;
                    }
                    if (tt.equals("cash_payment")) {
                        try {
                            String monthsStr;
                            String batchIdentifier = t.getBatchIdentifier();
                            if (batchIdentifier != null && !batchIdentifier.isEmpty()) {
                                this.applicationController.gotoBatchTransactionEdit(t, batchIdentifier);
                                break block33;
                            }
                            int months = 0;
                            if (this.displayMonths != null && (monthsStr = this.displayMonths.getGlenixElementValue()) != null && !monthsStr.isEmpty()) {
                                months = Integer.parseInt(monthsStr);
                            }
                            LocalDate fromDate = null;
                            if (this.filterFromDate != null) {
                                fromDate = this.filterFromDate.getLocalDate();
                            }
                            LocalDate toDate = null;
                            if (this.filterToDate != null) {
                                fromDate = this.filterToDate.getLocalDate();
                            }
                            this.applicationController.gotoPayMoneyE(t, months, fromDate, toDate, null);
                        }
                        catch (Exception e) {
                            this.error_message.setText(e.getMessage());
                            this.applicationController.setStatusBarMessage(e.getMessage());
                            e.printStackTrace();
                        }
                        break block33;
                    }
                    if (tt.equals("pay_slip")) {
                        String batchIdentifier = t.getBatchIdentifier();
                        if (batchIdentifier != null && !batchIdentifier.isEmpty()) {
                            try {
                                this.applicationController.gotoBatchPaySlipEdit(t, batchIdentifier);
                            }
                            catch (Exception e) {
                                this.error_message.setText(e.getMessage());
                                this.applicationController.setStatusBarMessage(e.getMessage());
                                e.printStackTrace();
                            }
                        }
                    } else if (tt.equals("general_journal")) {
                        try {
                            this.applicationController.gotoGeneralJournalTransactions(t);
                        }
                        catch (Exception e) {
                            this.error_message.setText(e.getMessage());
                            this.applicationController.setStatusBarMessage(e.getMessage());
                            e.printStackTrace();
                        }
                    }
                }
                catch (Exception e) {
                    this.error_message.setText(e.getMessage());
                    this.applicationController.setStatusBarMessage(e.getMessage());
                    e.printStackTrace();
                }
            }
        }
    }
}

