/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationController;
import au.com.glenix.BusinessMasterFileController;
import au.com.glenix.Glenix;
import au.com.glenix.cloud.CloudApplicationController;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.LicenseFee;
import au.com.glenix.trn.Transaction;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.web.WebEngine;
import javafx.scene.web.WebView;
import org.w3c.dom.Document;

public class NewFilePartTwoCloudController
extends BusinessMasterFileController {
    @FXML
    protected Label description;
    @FXML
    protected Hyperlink license_fee_link;
    @FXML
    protected TextField license_fee_link_text_field;
    @FXML
    protected WebView webView;
    protected String thirtyDaysGuarantee = "Note we offer a 30 day money back guarantee, after which there are no refunds.";

    public NewFilePartTwoCloudController(ApplicationController applicationController) {
        super(applicationController);
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        WebEngine webEngine = this.webView.getEngine();
        webEngine.locationProperty().addListener((ChangeListener)new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                if (newValue != null && newValue.indexOf("ggg.basoff.com.au") > 0) {
                    NewFilePartTwoCloudController.this.checkPayment();
                }
            }
        });
        webEngine.setOnAlert(event -> this.showAlert((String)event.getData()));
        webEngine.setConfirmHandler(message -> this.showConfirm((String)message));
    }

    private void showAlert(String message) {
        Dialog alert = new Dialog();
        alert.getDialogPane().setContentText(message);
        alert.getDialogPane().getButtonTypes().add((Object)ButtonType.OK);
        alert.showAndWait();
    }

    private boolean showConfirm(String message) {
        Dialog confirm = new Dialog();
        confirm.getDialogPane().setContentText(message);
        confirm.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.YES, ButtonType.NO});
        boolean result = confirm.showAndWait().filter(ButtonType.YES::equals).isPresent();
        System.out.println(result);
        return result;
    }

    public void checkPayment() {
        try {
            BusinessMasterFile bmf;
            LocalDate expires;
            this.xbrlFileController.invalidateBusinessMasterFileXBRLCache();
            GlenixTrnXBRL busx = this.xbrlFileController.getBusinessMasterFileXBRL();
            if (busx != null && (expires = (bmf = busx.getBusinessMasterFile()).getBusinessMasterFileLicenseExpiresAsDate()) != null && !expires.isBefore(LocalDate.now())) {
                this.gotoPrintInvoice();
            }
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    @Override
    public void setBusinessMasterFile(BusinessMasterFile businessMasterFile) throws Exception {
        super.setBusinessMasterFile(businessMasterFile);
        LicenseFee lf = businessMasterFile.getLicenseFee();
        if (lf == null) {
            throw new Exception("Error, license fee is not set");
        }
        String licenseFeeIdentifier = lf.getLicenseFeeIdentifier();
        String licenseFeeDescription = lf.getLicenseFeeDescription();
        String licenseFeeAmount = lf.getLicenseFeeAmount();
        String licenseFeeGSTAmount = lf.getLicenseFeeGSTAmount();
        this.description.setText(licenseFeeDescription + ": $" + licenseFeeAmount + " (including GST $" + licenseFeeGSTAmount + "). " + this.thirtyDaysGuarantee);
        String link = CloudApplicationController.glenix_payment_url + licenseFeeIdentifier;
        if (this.license_fee_link != null) {
            this.license_fee_link.setText(link);
        }
        this.license_fee_link_text_field.setText(link);
        WebEngine webEngine = this.webView.getEngine();
        try {
            String hpplink = CloudApplicationController.stgeorgehppurl + "&customerReference=" + licenseFeeIdentifier + "&amount=" + licenseFeeAmount;
            webEngine.load(hpplink);
        }
        catch (Exception e) {
            e.printStackTrace();
            webEngine.load(link);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getData(String address) throws Exception {
        URL page = new URL(address);
        StringBuffer text = new StringBuffer();
        HttpURLConnection conn = (HttpURLConnection)page.openConnection();
        conn.connect();
        try {
            String line;
            InputStreamReader in = new InputStreamReader((InputStream)conn.getContent());
            BufferedReader buff = new BufferedReader(in);
            while ((line = buff.readLine()) != null) {
                text.append(line + "\n");
            }
            String string = text.toString();
            return string;
        }
        finally {
            conn.disconnect();
        }
    }

    @Override
    @FXML
    protected void saveBusinessMasterFile() {
        try {
            this.xbrlFileController.invalidateBusinessMasterFileXBRLCache();
            BusinessMasterFile updatebmf = this.xbrlFileController.getBusinessMasterFile();
            LocalDate expires = updatebmf.getBusinessMasterFileLicenseExpiresAsDate();
            if (expires == null || expires.isBefore(LocalDate.now())) {
                LicenseFee lf = this.businessMasterFile.getLicenseFee();
                if (lf == null) {
                    throw new Exception("Error, license fee is not set");
                }
                String licenseFeeIdentifier = lf.getLicenseFeeIdentifier();
                String licenseFeeDescription = lf.getLicenseFeeDescription();
                String licenseFeeAmount = lf.getLicenseFeeAmount();
                String licenseFeeGSTAmount = lf.getLicenseFeeGSTAmount();
                this.description.setText(licenseFeeDescription + ": $" + licenseFeeAmount + " (including GST $" + licenseFeeGSTAmount + "). " + this.thirtyDaysGuarantee);
                String link = CloudApplicationController.glenix_payment_url + licenseFeeIdentifier;
                if (this.license_fee_link != null) {
                    this.license_fee_link.setText(link);
                }
                this.license_fee_link_text_field.setText(link);
                WebEngine webEngine = this.webView.getEngine();
                webEngine.load(this.license_fee_link_text_field.getText());
                throw new Exception("Error, payment has not been recorded, please pay first and then click continue");
            }
            this.gotoPrintInvoice();
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    protected void gotoPrintInvoice() {
        try {
            ArrayList<Transaction> accs;
            ArrayList<Transaction> provs;
            String createGSTCodes = this.businessMasterFile.getBusinessIsRegisteredForGST();
            InputStream xmlis = null;
            GlenixTrnXBRL provXBRL = this.xbrlFileController.getGlenixTrnXBRLProvision();
            boolean createprovs = true;
            if (provXBRL != null && (provs = provXBRL.getTransactionArrayList()) != null && provs.size() > 0) {
                createprovs = false;
            }
            if (createprovs && (xmlis = createGSTCodes == null || !createGSTCodes.equals("false") ? Glenix.class.getResourceAsStream("templates/provision.xml") : Glenix.class.getResourceAsStream("templates/provision_nogst.xml")) != null) {
                Document provisionDocument = this.dBuilder.parse(xmlis);
                this.xbrlFileController.saveFileEncrypt("provision.xml", provisionDocument);
            }
            GlenixTrnXBRL accXBRL = this.xbrlFileController.getAccountTransactionList();
            boolean createaccs = true;
            if (accXBRL != null && (accs = accXBRL.getTransactionArrayList()) != null && accs.size() > 0) {
                createaccs = false;
            }
            if (createaccs) {
                xmlis = null;
                xmlis = createGSTCodes == null || !createGSTCodes.equals("false") ? Glenix.class.getResourceAsStream("templates/account.xml") : Glenix.class.getResourceAsStream("templates/account_nogst.xml");
                if (xmlis != null) {
                    Document provisionDocument = this.dBuilder.parse(xmlis);
                    this.xbrlFileController.saveFileEncrypt("account.xml", provisionDocument);
                }
            }
            this.error_message.setText("Saved");
            this.xbrlFileController.gotoBusinessMasterFilePrintInvoice();
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    protected void back() {
        try {
            this.xbrlFileController.gotoNewFileE(this.businessMasterFile, null);
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }
}

