/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationBorderPane;
import au.com.glenix.GlenixApplication;
import au.com.glenix.cloud.CloudApplicationBorderPane;
import java.util.prefs.Preferences;
import javafx.application.Application;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.geometry.Rectangle2D;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.input.KeyCharacterCombination;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyCodeCombination;
import javafx.scene.input.KeyCombination;
import javafx.scene.text.Font;
import javafx.stage.Screen;
import javafx.stage.Stage;

public class GlenixCloud
extends Application
implements GlenixApplication {
    public static String versionNumber = "3.0.1.7";
    public static String codeName = "BAS Off";
    public static String messageDomain = "basoff.com.au";
    private ApplicationBorderPane applicationBorderPane;

    protected ApplicationBorderPane createApplicationBorderPane(Stage stage) throws Exception {
        return new CloudApplicationBorderPane(stage, this);
    }

    public String getCodeName() {
        return codeName;
    }

    public void start(Stage stage) throws Exception {
        Font.loadFont((String)this.getClass().getResource("/muli/Muli-Light.ttf").toExternalForm(), (double)15.0);
        Font.loadFont((String)this.getClass().getResource("/muli/Muli-Regular.ttf").toExternalForm(), (double)15.0);
        Font.loadFont((String)this.getClass().getResource("/muli/Muli-Bold.ttf").toExternalForm(), (double)15.0);
        Rectangle2D primaryScreenBounds = Screen.getPrimary().getVisualBounds();
        Preferences preferences = Preferences.userNodeForPackage(GlenixCloud.class);
        String stage_x = preferences.get("stage_x", null);
        Double left = primaryScreenBounds.getMinX();
        boolean userconfigleft = false;
        if (stage_x != null && !stage_x.isEmpty()) {
            try {
                left = Double.parseDouble(stage_x);
                userconfigleft = true;
            }
            catch (Exception e) {
                left = null;
            }
            if (left == null) {
                left = primaryScreenBounds.getMinX();
                userconfigleft = false;
            }
        }
        Double width = 960.0;
        String stage_width = preferences.get("stage_width", null);
        if (stage_width != null && !stage_width.isEmpty()) {
            try {
                width = Double.parseDouble(stage_width);
            }
            catch (Exception e) {
                width = null;
            }
            if (width == null) {
                width = 960.0;
            }
        }
        if (width > primaryScreenBounds.getWidth()) {
            width = primaryScreenBounds.getWidth();
            if (width < 100.0) {
                width = 100.0;
            }
        } else if (!userconfigleft) {
            left = primaryScreenBounds.getWidth() - width;
        }
        stage.setX(left.doubleValue());
        stage.setWidth(width.doubleValue());
        String stage_y = preferences.get("stage_y", null);
        Double top = primaryScreenBounds.getMinY();
        if (stage_y != null && !stage_y.isEmpty()) {
            try {
                top = Double.parseDouble(stage_y);
            }
            catch (Exception e) {
                top = null;
            }
            if (top == null) {
                top = primaryScreenBounds.getMinY();
            }
        }
        Double height = primaryScreenBounds.getHeight();
        String stage_height = preferences.get("stage_height", null);
        if (stage_height != null && !stage_height.isEmpty()) {
            try {
                height = Double.parseDouble(stage_height);
            }
            catch (Exception e) {
                height = null;
            }
            if (height == null) {
                height = primaryScreenBounds.getHeight();
            }
        }
        if (height < 100.0) {
            height = 100.0;
        }
        stage.setY(top.doubleValue());
        stage.setHeight(height.doubleValue());
        this.applicationBorderPane = this.createApplicationBorderPane(stage);
        this.applicationBorderPane.glenixInitialise();
        Scene scene = new Scene((Parent)this.applicationBorderPane);
        stage.setScene(scene);
        stage.show();
        stage.setTitle("BAS Off (accounting software)");
        stage.widthProperty().addListener((ChangeListener)new ChangeListener<Number>(){

            public void changed(ObservableValue<? extends Number> observableValue, Number oldStageWidth, Number newStageWidth) {
                GlenixCloud.this.applicationBorderPane.setColumnsWidth(newStageWidth);
            }
        });
        this.applicationBorderPane.setColumnsWidth(stage.getWidth());
        this.applicationBorderPane.updateTheme();
        this.applicationBorderPane.gotoWelcomePage(false);
        KeyCodeCombination keyCombinationCtrlF = new KeyCodeCombination(KeyCode.F, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
        scene.getAccelerators().put((Object)keyCombinationCtrlF, () -> this.applicationBorderPane.focusSearch());
        KeyCodeCombination keyCodeCombinationCtrlPlus = new KeyCodeCombination(KeyCode.EQUALS, new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN, KeyCombination.SHIFT_ANY});
        scene.getAccelerators().put((Object)keyCodeCombinationCtrlPlus, () -> this.applicationBorderPane.increaseFont());
        KeyCharacterCombination keyCharCombinationCtrlMinus = new KeyCharacterCombination("-", new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
        scene.getAccelerators().put((Object)keyCharCombinationCtrlMinus, () -> this.applicationBorderPane.decreaseFont());
        KeyCharacterCombination keyCharCombinationCtrlZero = new KeyCharacterCombination("0", new KeyCombination.Modifier[]{KeyCombination.CONTROL_DOWN});
        scene.getAccelerators().put((Object)keyCharCombinationCtrlZero, () -> this.applicationBorderPane.resetFont());
    }

    public static void main(String[] args) {
        GlenixCloud.launch((String[])args);
    }

    public void stop() {
        try {
            if (this.applicationBorderPane != null) {
                this.applicationBorderPane.closeGlenixFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

