/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.cloud.CloudApplicationController;
import au.com.glenix.cloud.TransactionsTableReceiveMoneyController;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixLabelDate;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.SelectionMode;
import javafx.util.Pair;

public class GeneralJournalController
extends TransactionsTableReceiveMoneyController {
    @FXML
    protected GlenixLabelDate filterFromDate;

    public GeneralJournalController(CloudApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        this.transactionTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.setTransactionTypeOptions();
    }

    protected void setTransactionTypeOptions() {
        ArrayList<Pair<String, String>> options = new ArrayList<Pair<String, String>>();
        options.add(new Pair((Object)"general_journal", (Object)"General journal"));
        this.transactionEditFormVBox.setTransactionTypeVisibleOptions(options, false, "general_journal");
    }

    @Override
    public boolean displayDebitsAsPositive() {
        return true;
    }

    @Override
    protected void addNewNoAccountLines(Transaction transaction, String counterpartyIdentifier) {
    }

    @Override
    public void retrieveTransactions() {
    }

    @Override
    public void postButtonRetrieveTransactions() {
        this.gjRetrieveTransactions();
    }

    public void gjRetrieveTransactions() {
        if (!this.doupdate) {
            return;
        }
        LocalDate maxDate = this.filterToDate.getLocalDate();
        LocalDate minDate = this.filterFromDate.getLocalDate();
        if (minDate != null && maxDate != null) {
            try {
                GlenixTrnXBRL newTrns = this.xbrlFileController.getGeneralJournalTransactionList(minDate, maxDate, null);
                this.setTransactions(newTrns, minDate, maxDate, null);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
            }
        }
    }

    @Override
    protected String getReportHeading() {
        return "General journals";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTransactions(GlenixTrnXBRL transactions, LocalDate minDate, LocalDate maxDate, String divisionIdentifier) throws Exception {
        boolean setupdate = true;
        if (!this.doupdate) {
            setupdate = false;
        } else {
            this.doupdate = false;
        }
        try {
            this.filterToDate.setLocalDate(maxDate);
            this.filterFromDate.setLocalDate(minDate);
            if (maxDate != null && minDate != null && minDate.compareTo(maxDate) <= 0) {
                this.page_heading.setText(this.getReportHeading() + " from " + minDate.format(this.displayDateFormatter) + " to " + minDate.format(this.displayDateFormatter));
            } else {
                this.page_heading.setText(this.getReportHeading());
            }
            if (transactions == null) {
                this.setReceivableRowObservableList((ObservableList<TransactionsTableReceiveMoneyController.ReceivableRow>)FXCollections.observableList(new ArrayList()));
                if (setupdate) {
                    this.doupdate = true;
                }
                return;
            }
            ArrayList<Transaction> tal = transactions.getTransactionArrayList();
            if (tal == null || tal.isEmpty()) {
                this.setReceivableRowObservableList((ObservableList<TransactionsTableReceiveMoneyController.ReceivableRow>)FXCollections.observableList(new ArrayList()));
                if (setupdate) {
                    this.doupdate = true;
                }
                return;
            }
            ArrayList<JournalRow> rral = new ArrayList<JournalRow>();
            for (Transaction t : tal) {
                String tt = t.getTransactionType();
                if (tt == null || !tt.equals("general_journal")) continue;
                JournalRow rr = new JournalRow(t, null);
                rral.add(rr);
            }
            ObservableList rrol = FXCollections.observableList(rral);
            this.setReceivableRowObservableList((ObservableList<TransactionsTableReceiveMoneyController.ReceivableRow>)rrol);
        }
        finally {
            if (setupdate) {
                this.doupdate = true;
            }
        }
    }

    @FXML
    private void pdfTransaction() {
        if (this.transaction == null) {
            return;
        }
        this.xbrlFileController.pdfGeneralJournal(this.transaction);
    }

    @Override
    protected void validateTransaction() throws Exception {
        super.validateTransaction();
        Double total = this.transactionEditFormVBox.getTotalAmount();
        if (total == null || Math.abs(total) >= 0.005) {
            throw new Exception("Error, the journal is not balanced. Total must be zero.");
        }
    }

    public class JournalRow
    extends TransactionsTableReceiveMoneyController.ReceivableRow {
        public JournalRow(Transaction receivableT, TransactionLine cashReceivedTL) throws Exception {
            super(GeneralJournalController.this, receivableT, cashReceivedTL);
        }

        @Override
        public String getTotalAmountFormatted() {
            Double credits;
            Double debits = this.receivableT.getTotalDebits();
            if (debits.equals(credits = this.receivableT.getTotalCredits())) {
                return GeneralJournalController.this.amountFormat.format(debits);
            }
            return "(imbalance) " + GeneralJournalController.this.amountFormat.format(debits);
        }
    }
}

