/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationController;
import au.com.glenix.FileAccessController;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.GlenixCertificate;
import au.com.glenix.trn.GlenixCertificateList;
import java.io.ByteArrayInputStream;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;

public class FileAccessCloudController
extends FileAccessController {
    public FileAccessCloudController(ApplicationController applicationController) {
        super(applicationController);
    }

    protected String getPublicKeyDerStr(GlenixCertificate gc) {
        String publicKeyDer = gc.getPublicCertificate();
        if (publicKeyDer != null && !publicKeyDer.isEmpty()) {
            return publicKeyDer;
        }
        publicKeyDer = gc.getPemEncodedPublicCertificate();
        if (publicKeyDer == null || publicKeyDer.isEmpty()) {
            return null;
        }
        publicKeyDer = publicKeyDer.replace("-----BEGIN CERTIFICATE-----\n", "");
        publicKeyDer = publicKeyDer.replace("-----END CERTIFICATE-----", "");
        publicKeyDer = publicKeyDer.replaceAll("\n", "");
        publicKeyDer = publicKeyDer.replaceAll("\r", "");
        publicKeyDer = publicKeyDer.trim();
        return publicKeyDer;
    }

    protected X509Certificate readX509Certificate(String publicKeyStr) throws Exception {
        ByteArrayInputStream bis;
        if (publicKeyStr == null || publicKeyStr.isEmpty()) {
            throw new Exception("Error, public key string is empty cannot read X509 cert.");
        }
        String tmpString = publicKeyStr.replaceAll("\n", "");
        tmpString = tmpString.replaceAll("\r", "");
        byte[] pubcertbytes = Base64.getDecoder().decode(tmpString);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        Collection<? extends Certificate> certCollection = cf.generateCertificates(bis = new ByteArrayInputStream(pubcertbytes));
        Iterator<? extends Certificate> certIterator = certCollection.iterator();
        if (certIterator.hasNext()) {
            X509Certificate firstCert = (X509Certificate)certIterator.next();
            return firstCert;
        }
        throw new Exception("Error, cannot extract X509 cert from provided string.");
    }

    protected PublicKey readPublicKey(String publicKeyStr) throws Exception {
        X509Certificate x509 = this.readX509Certificate(publicKeyStr);
        if (x509 == null) {
            return null;
        }
        return x509.getPublicKey();
    }

    @Override
    @FXML
    protected void deleteSelectedCertificates() {
        if (this.glenixTrnXBRL == null) {
            this.error_message.setText("Error, file is not yet opened");
            this.xbrlFileController.setStatusBarMessage("Error, file is not yet opened");
            return;
        }
        Business b = this.glenixTrnXBRL.getBusiness();
        if (b == null) {
            this.error_message.setText("Error, file is not yet opened");
            this.xbrlFileController.setStatusBarMessage("Error, file is not yet opened");
            return;
        }
        try {
            ObservableList selectedCerts = this.certificate_table.getSelectionModel().getSelectedItems();
            if (selectedCerts == null || selectedCerts.size() == 0) {
                throw new Exception("Error, no certificates selected");
            }
            GlenixCertificateList gcl = new GlenixCertificateList();
            if (gcl == null) {
                throw new Exception("Error, unable to create certificate list");
            }
            for (X509Certificate x509 : selectedCerts) {
                boolean found = false;
                GlenixCertificate gc = gcl.addGlenixCertificate();
                gc.setAccessLevel("delete");
                gc.setAccessScope("delete");
                GlenixCertificateList bgcl = b.getGlenixCertificateList();
                for (GlenixCertificate bgc : bgcl.getGlenixCertificateList()) {
                    String bgcStr = this.getPublicKeyDerStr(bgc);
                    X509Certificate bgcx509 = this.readX509(bgcStr);
                    if (bgcx509 == null || !Arrays.equals(bgcx509.getEncoded(), x509.getEncoded())) continue;
                    gc.setPemEncodedPublicCertificate(bgc.getPemEncodedPublicCertificate());
                    gc.setPublicCertificate(bgc.getPublicCertificate());
                    found = true;
                    break;
                }
                if (found) continue;
                throw new Exception("Error, the sleected certificate was not found in the access list");
            }
            this.xbrlFileController.saveGlenixCertificateList(gcl);
            this.setModel(this.xbrlFileController.getFileAccess());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    @FXML
    protected void addAccessForGlen() {
        String glenspublickey = "-----BEGIN CERTIFICATE-----\nMIICzzCCAbegAwIBAgIVAKfAm94O9avK3jbrekrACPP3mDJwMA0GCSqGSIb3DQEB\nCwUAMCExHzAdBgNVBAMMFkdsZW4gU3RlcGhlbiBIYXNzZWxtYW4wHhcNMTgwNzE3\nMDAwMDAwWhcNMjMwNzE3MDAwMDAwWjAhMR8wHQYDVQQDDBZHbGVuIFN0ZXBoZW4g\nSGFzc2VsbWFuMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAsW38ftSe\n/wY/3czkxdpj8P6QCrXtT4Iykwn6Cm7+oEKkcSBk8EtVWYcm/kS9lzhMK80cOLPs\nagDy99t//LmVGkfWzB4vktXEKzhSI8O23yZfihix2cABx+4g4jKcogXZ0nwFs+5y\nuOEiSJyji+1Uuq/cBK73Xk7A9H1iFeTrj6gFFFCvxAqwYza43Biu6l6RbsaKAgXE\nNMYTF+MLp9CU7hR+fqAelpXA48xf0hRV/8W0y56kfumjpIisA157XgrGmmI/wVf0\nbbneTfplFDJ+tf0hjlRHkVUSO7W3vHmBDqDQI/TtFXPVqeAXvIVmDfvA3YATma/L\nyWCkgKuAnYIJKwIDAQABMA0GCSqGSIb3DQEBCwUAA4IBAQCteKRHWo6Ev4XMBfyJ\nq7q1jiZNQqiazi/oi6ZsvcpdgMDP1Zr7YG4T3N71HNBjhzj9OVoN1Ne9Whgf6RNM\nBF8y13vNoI71dqo87GicR4qCE0ICzUKCl00RLR0KG/gO2aIeXYWQ6Ro1qmFVgCcc\ncYOCw1/ydlbpiHRIAD0+nKcXgsoGbbkMjZSS6IWahGSTsebkHfB46lirsH3znnu8\noY6yWwq3XtjbwmwYYBKVtPiCK3fV+5SoUTVFLWMt2VRwtywJ98sL2YFL6iX+CrMA\nMDxdcgNl4sUjv1PHGXKK9vj4/yRMClqDDb+YPVzq8e3u5lB6lyag26LFXB1B2Ati\n5Wm3\n-----END CERTIFICATE-----";
        try {
            GlenixCertificate gc = new GlenixCertificate();
            gc.setPemEncodedPublicCertificate(glenspublickey);
            String publicKeyDer = glenspublickey.replace("-----BEGIN CERTIFICATE-----\n", "");
            publicKeyDer = publicKeyDer.replace("-----END CERTIFICATE-----", "");
            publicKeyDer = publicKeyDer.replaceAll("\n", "");
            publicKeyDer = publicKeyDer.replaceAll("\r", "");
            publicKeyDer = publicKeyDer.trim();
            gc.setPublicCertificate(publicKeyDer);
            gc.setAccessLevel("write");
            gc.setAccessScope("admin");
            this.xbrlFileController.saveGlenixCertificate(gc);
            this.error_message.setText("Saved");
            this.xbrlFileController.setStatusBarMessage("Saved");
            this.setModel(this.xbrlFileController.getFileAccess());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }
}

