/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationController;
import au.com.glenix.CounterpartyTFNDController;
import au.com.glenix.GlenixSBRResponse;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.Counterparty;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.SBRDocumentTFND0004;
import au.com.glenix.trn.Transaction;
import java.util.ArrayList;
import javafx.fxml.FXML;
import org.w3c.dom.Document;

public class CounterpartyTFNDCloudController
extends CounterpartyTFNDController {
    public CounterpartyTFNDCloudController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FXML
    public void lodgeCounterpartyTFND() {
        String status = null;
        if (this.sbrDocumentTFND0004 != null) {
            status = this.sbrDocumentTFND0004.getSBRDocumentStatus();
        }
        if (status != null && status.equals("lodge_complete")) {
            this.error_message.setText("Error, the document has been lodged you cannot relodge it");
            this.xbrlFileController.setStatusBarMessage("Error, the document has been lodged you cannot relodge it");
            return;
        }
        try {
            ArrayList<SBRDocumentTFND0004> sbrDocumentTFND0004List;
            Counterparty aCounterparty;
            Transaction t;
            this.lodgeButton.disableProperty().set(true);
            this.saveButton.disableProperty().set(true);
            this.validate();
            this.error_message.setText(null);
            String passwordStr = this.password.getGlenixElementValue();
            if (passwordStr == null || passwordStr.isEmpty()) {
                throw new Exception("Error, you must enter your login password");
            }
            if (!this.xbrlFileController.reverifyPassword(passwordStr.toCharArray())) {
                throw new Exception("Error, password is not correct");
            }
            this.xbrlFileController.setStatusBarMessage("Begin lodge...");
            if (this.sbrDocumentTFND0004 == null) {
                this.sbrDocumentTFND0004 = this.counterparty.addNewSBRDocumentTFND0004();
            }
            Document resultDoc = this.dBuilder.newDocument();
            this.sbrDocumentTFND0004VBox.setSBRDocumentDateTimeToNow();
            this.sbrDocumentTFND0004VBox.buildGlenixXBRLSubPart(resultDoc, null);
            this.sbrDocumentTFND0004.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
            GlenixSBRResponse response = this.xbrlFileController.saveAndLodgeCounterpartyTFND(this.counterparty.getCounterpartyIdentifier(), this.sbrDocumentTFND0004);
            response.parseResponse();
            Document resdoc = response.getDocumentByHref("res.xml");
            if (resdoc == null) {
                throw new Exception("Error, unable to read response from server");
            }
            GlenixResult gr = new GlenixResult();
            gr.loadDocumentElement(resdoc, resdoc.getDocumentElement());
            String resultCode = gr.getResultCode();
            String resultDescription = gr.getResultDescription();
            if (resultCode == null || resultCode.isEmpty() || !resultCode.equals("OK")) {
                if (resultCode != null && !resultCode.isEmpty()) {
                    if (resultDescription != null && !resultDescription.isEmpty()) {
                        throw new Exception(resultCode + " - " + resultDescription);
                    }
                    throw new Exception("Error, save failed with result code: " + resultCode);
                }
                if (resultDescription != null && !resultDescription.isEmpty()) {
                    throw new Exception(resultDescription);
                }
                throw new Exception("Error, save failed with no result code");
            }
            Document datadoc = response.getDocumentByHref("data.xml");
            if (datadoc == null) {
                throw new Exception("Error, unable to get activity statement, cannot read response from server");
            }
            GlenixTrnXBRL glenixTrnXBRL = new GlenixTrnXBRL();
            glenixTrnXBRL.loadDocumentElement(datadoc, datadoc.getDocumentElement());
            this.error_message.setText(null);
            Business business = glenixTrnXBRL.getBusiness();
            if (business != null && business.getTransactionCount() == 1 && (t = business.getTransaction(0)) != null && (aCounterparty = t.getCounterparty()) != null && (sbrDocumentTFND0004List = aCounterparty.getSBRDocumentTFND0004List()) != null && sbrDocumentTFND0004List.size() == 1) {
                this.setModel(aCounterparty, sbrDocumentTFND0004List.get(0));
                this.setProfileDetails(this.xbrlFileController.getProfileXBRL());
                String newstatus = sbrDocumentTFND0004List.get(0).getSBRDocumentStatus();
                if (newstatus != null && newstatus.equals("lodge_complete")) {
                    this.error_message.setText("Lodge complete");
                } else {
                    this.error_message.setText("Lodge failed, check messages");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        finally {
            this.saveButton.disableProperty().set(false);
            this.lodgeButton.disableProperty().set(false);
        }
    }
}

