/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.Account;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPDFWrapperNewPageCallback;
import java.net.URL;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;

public class CalculationRuleListController
extends GlenixBranchController
implements GlenixPDFWrapperNewPageCallback {
    @FXML
    private TableView<Account.AccountCalculationRule> accountTable;
    @FXML
    private Label error_message;
    @FXML
    private Label page_heading;
    @FXML
    private TableColumn accountName;
    @FXML
    private TableColumn calculationRuleIdentifier;
    @FXML
    private TableColumn calculationRuleName;
    private ApplicationController xbrlFileController = null;
    private Account account = null;
    private ObservableList<Account.AccountCalculationRule> calculationRuleObservableList;

    public CalculationRuleListController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        this.accountTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                if (event.getClickCount() == 2) {
                    if (!row.isEmpty()) {
                        Account.AccountCalculationRule cr = (Account.AccountCalculationRule)row.getItem();
                        if (cr != null) {
                            try {
                                this.xbrlFileController.gotoCalculationRuleEdit(cr.getAccount(), cr.getCalculationIndex());
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.error_message.setText("Error, could not go to calculation rule page.");
                            }
                        } else {
                            this.error_message.setText("Error, could not get calculation rule.");
                        }
                    } else {
                        this.addCalculationRule();
                    }
                }
            });
            return row;
        });
        this.accountTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    @FXML
    private void addCalculationRule() {
        try {
            this.xbrlFileController.gotoCalculationRuleEdit(this.account, -1);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setModel(Account account) throws Exception {
        this.account = account;
        this.error_message.setText(null);
        this.xbrlFileController.setStatusBarMessage(null);
        this.setCalculationRuleObservableList();
    }

    private void setCalculationRuleObservableList() {
        ArrayList<Account.AccountCalculationRule> crs = new ArrayList<Account.AccountCalculationRule>();
        for (int i = 0; i < this.account.getCalculationRuleCount(); ++i) {
            Account.AccountCalculationRule cr = this.account.getAccountCalculationRule(i);
            crs.add(cr);
        }
        this.calculationRuleObservableList = FXCollections.observableList(crs);
        this.accountTable.setItems(this.calculationRuleObservableList);
    }

    public void refreshTable() {
        this.setCalculationRuleObservableList();
        this.accountTable.refresh();
    }

    @FXML
    protected void deleteSelectedRules() {
        try {
            this.xbrlFileController.deleteSelectedCalculationRules(this.account, (ObservableList<Account.AccountCalculationRule>)this.accountTable.getSelectionModel().getSelectedItems());
            this.account = this.xbrlFileController.getAccount(this.account);
            this.refreshTable();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPage();
        gpw.setColumns(5);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 60.0);
        gpw.setColumnLeftPosAndWidthMM(3, 80.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(4, 120.0, 80.0);
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        Double fontSize = this.convertFontSize(this.page_heading.getFont().getSize());
        gpw.prepareString(0, this.page_heading.getText(), true, fontSize);
        gpw.drawStrings(10.0);
        fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        this.drawPDFColumnHeadings(gpw);
        gpw.setAddPageCallback(this);
        for (Account.AccountCalculationRule t : this.calculationRuleObservableList) {
            gpw.prepareString(2, t.getAccountName(), true, fontSize);
            gpw.prepareString(3, t.getCalculationRuleIdentifier(), true, fontSize);
            gpw.prepareString(4, t.getCalculationRuleName(), true, fontSize);
            gpw.drawStrings(5.0);
        }
        gpw.addFooter();
        return gpw;
    }

    private void drawPDFColumnHeadings(GlenixPDFWrapper gpw) throws Exception {
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliBoldFont);
        gpw.setColumnFont(4, gpw.muliBoldFont);
        Double fontSize = this.convertFontSize(new Double(this.xbrlFileController.getCurrentFontSize()));
        gpw.prepareString(2, this.accountName.getText(), true, fontSize);
        gpw.prepareString(3, this.calculationRuleIdentifier.getText(), true, fontSize);
        gpw.prepareString(4, this.calculationRuleName.getText(), true, fontSize);
        gpw.drawStrings(5.0);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
    }

    @Override
    public void newPDFPageAdded(GlenixPDFWrapper gpw) throws Exception {
        this.drawPDFColumnHeadings(gpw);
    }
}

