/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixLabelAccountListVBox;
import au.com.glenix.trn.Account;
import au.com.glenix.trn.CalculationRule;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixBranchController;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class CalculationRuleController
extends GlenixBranchController {
    @FXML
    private Label error_message;
    @FXML
    protected GlenixLabelAccountListVBox calculationRuleApplyToIdentifiers;
    private ApplicationController applicationController = null;
    private DocumentBuilder dBuilder;
    private Account account = null;
    private CalculationRule calculationRule = null;

    public CalculationRuleController(ApplicationController applicationController) {
        this.applicationController = applicationController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setCalculationRule(Account account, CalculationRule calculationRule) throws Exception {
        if (account == null) {
            throw new Exception("Error, account cannot be set to null in calculation rule edit");
        }
        this.account = account;
        this.calculationRule = calculationRule;
        this.error_message.setText(null);
        this.applicationController.setStatusBarMessage(null);
        this.clearGlenixXBRL();
        if (calculationRule != null) {
            Document doc = this.dBuilder.newDocument();
            calculationRule.appendToElement(doc);
            this.loadGlenixXBRL(doc, doc.getDocumentElement());
        }
    }

    public void setAccountList(ObservableList<Transaction> accountObservableList) {
        this.calculationRuleApplyToIdentifiers.setItems(accountObservableList);
    }

    @FXML
    private void saveCalculationRule() {
        try {
            Document resultDoc = this.dBuilder.newDocument();
            super.buildGlenixXBRL(resultDoc, null);
            if (this.calculationRule == null) {
                this.calculationRule = this.account.addCalculationRule();
            }
            this.calculationRule.loadDocumentElement(resultDoc, resultDoc.getDocumentElement());
            this.applicationController.saveCalculationRule(this.account, this.calculationRule);
            this.error_message.setText("Saved");
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    @FXML
    public void gotoCalculationRuleList() {
        try {
            this.applicationController.gotoCalculationRuleList(this.account);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void gotoAccount() {
        try {
            this.applicationController.gotoAccountEdit(this.account);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }
}

