/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationController;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPDFWrapperNewPageCallback;
import java.net.URL;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.ResourceBundle;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

public class BusinessListController
extends GlenixBranchController
implements GlenixPDFWrapperNewPageCallback {
    @FXML
    private Label page_heading;
    @FXML
    protected Label error_message;
    protected ApplicationController applicationController = null;
    protected DocumentBuilder dBuilder;
    @FXML
    private TableView<Business> businessTable;
    @FXML
    private TableColumn businessLegalNameColumn;
    @FXML
    private TableColumn businessABNColumn;
    private GlenixTrnXBRL bmfList = null;
    private ObservableList<Business> businessObservableList;

    public BusinessListController(ApplicationController applicationController) {
        this.applicationController = applicationController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
        this.businessTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                block10: {
                    if (event.getClickCount() == 2) {
                        if (!row.isEmpty()) {
                            Business business = (Business)row.getItem();
                            if (business != null) {
                                String businessIdentifier = business.getBusinessIdentifier();
                                if (businessIdentifier != null && !businessIdentifier.isEmpty()) {
                                    try {
                                        LocalDate licenseExpires = business.getBusinessMasterFileLicenseExpiresAsDate();
                                        LocalDate now = LocalDate.now();
                                        this.applicationController.setSelectedBusinessIdentifier(businessIdentifier);
                                        if (licenseExpires == null || licenseExpires.isBefore(now)) {
                                            this.applicationController.gotoNewFileE(business.getBusinessMasterFile(), "Your license has expired, please purchase a new license to continue. Note that read only access is allowed.");
                                            break block10;
                                        }
                                        this.applicationController.gotoBusinessMasterFile();
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        this.error_message.setText(e.getMessage());
                                        this.applicationController.setStatusBarMessage(e.getMessage());
                                    }
                                } else {
                                    this.error_message.setText("Error, could not get business identifier.");
                                    this.applicationController.setStatusBarMessage("Error, could not get business identifier.");
                                }
                            } else {
                                this.error_message.setText("Error, could not get business.");
                                this.applicationController.setStatusBarMessage("Error, could not get business.");
                            }
                        } else {
                            this.newBusiness();
                        }
                    }
                }
            });
            return row;
        });
    }

    public void setMessage(String message) {
        this.error_message.setText(message);
    }

    @FXML
    public void newBusiness() {
        try {
            if (this.applicationController != null) {
                this.applicationController.closeGlenixFile();
                this.applicationController.gotoNewFileE(null, null);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    public void setBusinessMasterFile(GlenixTrnXBRL bmfList) {
        this.bmfList = bmfList;
        this.setBusinessObservableList();
        this.businessTable.refresh();
    }

    public void setBusinessObservableList() {
        if (this.bmfList == null) {
            this.businessTable.getItems().clear();
            return;
        }
        ArrayList<Business> businessArrayList = this.bmfList.getBusinessArrayList();
        this.businessObservableList = FXCollections.observableList(businessArrayList);
        this.businessTable.setItems(this.businessObservableList);
    }

    public void refreshTable() {
        this.setBusinessObservableList();
        this.businessTable.refresh();
    }

    @FXML
    private void gotoBusinessMasterFile() {
        try {
            BusinessMasterFile bmf;
            Business b = (Business)this.businessTable.getSelectionModel().getSelectedItem();
            if (b != null && (bmf = b.getBusinessMasterFile()) != null) {
                String bi = bmf.getBusinessIdentifier();
                this.applicationController.setSelectedBusinessIdentifier(bi);
                this.applicationController.gotoBusinessMasterFile();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void deleteBusiness() {
        System.out.println("TODO");
    }

    @FXML
    private void deleteMyAccess() {
        System.out.println("TODO");
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPage();
        gpw.setColumns(4);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 180.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 146.0);
        gpw.setColumnLeftPosAndWidthMM(3, 170.0, 30.0);
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        Double fontSize = this.convertFontSize(this.page_heading.getFont().getSize());
        gpw.prepareString(0, this.page_heading.getText(), true, fontSize);
        gpw.drawStrings(10.0);
        fontSize = this.convertFontSize(new Double(this.applicationController.getCurrentFontSize()));
        this.drawPDFColumnHeadings(gpw);
        gpw.setAddPageCallback(this);
        for (Business b : this.businessObservableList) {
            gpw.prepareString(2, b.getBusinessLegalName(), true, fontSize);
            gpw.prepareString(3, b.getBusinessABN(), true, fontSize);
            gpw.drawStrings(5.0);
        }
        gpw.addFooter();
        return gpw;
    }

    private void drawPDFColumnHeadings(GlenixPDFWrapper gpw) throws Exception {
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliBoldFont);
        Double fontSize = this.convertFontSize(new Double(this.applicationController.getCurrentFontSize()));
        gpw.prepareString(2, this.businessLegalNameColumn.getText(), true, fontSize);
        gpw.prepareString(3, this.businessABNColumn.getText(), true, fontSize);
        gpw.drawStrings(5.0);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
    }

    @Override
    public void newPDFPageAdded(GlenixPDFWrapper gpw) throws Exception {
        this.drawPDFColumnHeadings(gpw);
    }
}

