/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationController;
import au.com.glenix.BatchSTPLodgeController;
import au.com.glenix.GlenixSBRResponse;
import au.com.glenix.trn.Batch;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixLabelLabel;
import javafx.application.Platform;
import javafx.fxml.FXML;
import org.w3c.dom.Document;

public class BatchSTPLodgeCloudController
extends BatchSTPLodgeController {
    @FXML
    private GlenixLabelLabel ssid;

    public BatchSTPLodgeCloudController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    @Override
    public void setBatchTransactionElement(Transaction batchTransaction) {
        super.setBatchTransactionElement(batchTransaction);
        try {
            String ssidStr = this.xbrlFileController.getSignedSoftwareSubscriptionIdentifier();
            if (ssidStr != null && !ssidStr.isEmpty()) {
                ssidStr = ssidStr.substring(0, 10);
            }
            this.ssid.setGlenixElementValue(ssidStr);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    @FXML
    protected void lodgeBatchPEE0003() {
        if (this.batchTransaction == null) {
            this.error_message.setText("Error, batch not yet saved. Must save before lodge.");
            this.xbrlFileController.setStatusBarMessage("Error, batch not yet saved. Must save before lodge.");
            return;
        }
        final String batchIdentifier = this.batchTransaction.getBatchIdentifier();
        if (batchIdentifier == null || batchIdentifier.isEmpty()) {
            this.error_message.setText("Error, batch identifier not set.");
            this.xbrlFileController.setStatusBarMessage("Error, batch identifier not set.");
            return;
        }
        try {
            String passwordStr = this.password.getGlenixElementValue();
            if (passwordStr == null || passwordStr.isEmpty()) {
                throw new Exception("Error, you must enter your login password");
            }
            if (!this.xbrlFileController.reverifyPassword(passwordStr.toCharArray())) {
                throw new Exception("Error, password is not correct");
            }
            this.error_message.setText("Begin lodge");
            this.xbrlFileController.setStatusBarMessage("Begin lodge");
            this.setMessageTimestamp();
            Document resultDoc = this.dBuilder.newDocument();
            this.buildGlenixXBRLTransaction(resultDoc, null);
            if (this.batchTransaction == null) {
                this.batchTransaction = new Transaction();
            }
            this.batchTransaction.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
            if (this.batchTransaction == null) {
                throw new Exception("Error, cannot save batch");
            }
            Batch batch = this.batchTransaction.getBatch();
            if (batch == null) {
                throw new Exception("Error, batch is null cannot lodge.");
            }
            String passwordString = this.password.getText();
            this.password.setText(null);
            GlenixSBRResponse response = this.xbrlFileController.saveAndLodgeSTPBatch(this.batchTransaction);
            response.parseResponse();
            Document resdoc = response.getDocumentByHref("data.xml");
            if (resdoc == null) {
                throw new Exception("Error, unable to get STP batch, cannot read response from server");
            }
            GlenixTrnXBRL glenixTrnXBRLBatch = new GlenixTrnXBRL();
            glenixTrnXBRLBatch.loadDocumentElement(resdoc, resdoc.getDocumentElement());
            final Transaction sentBatchTransaction = glenixTrnXBRLBatch.getBatchTransaction(batchIdentifier);
            this.setBatchTransactionElement(sentBatchTransaction);
            this.setProfileDetails(this.xbrlFileController.getProfileXBRL());
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String thisBatchIdentifier = batchIdentifier;
                        Transaction thisBatchTransaction = sentBatchTransaction;
                        int sleep_one = 70000;
                        Thread.sleep(sleep_one);
                        if (BatchSTPLodgeCloudController.this.batchTransaction == thisBatchTransaction) {
                            Platform.runLater(() -> {
                                try {
                                    Transaction nextBatchTransaction = BatchSTPLodgeCloudController.this.xbrlFileController.getBatchTransactionReload(thisBatchIdentifier);
                                    BatchSTPLodgeCloudController.this.setBatchTransactionElement(nextBatchTransaction);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    BatchSTPLodgeCloudController.this.error_message.setText(e.getMessage());
                                    BatchSTPLodgeCloudController.this.xbrlFileController.setStatusBarMessage(e.getMessage());
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        Platform.runLater(() -> {
                            e.printStackTrace();
                            BatchSTPLodgeCloudController.this.error_message.setText(e.getMessage());
                            BatchSTPLodgeCloudController.this.xbrlFileController.setStatusBarMessage(e.getMessage());
                        });
                    }
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    @FXML
    protected void updateBatchPEE0003() {
        if (this.batchTransaction == null) {
            this.error_message.setText("Error, batch not yet saved. Must save before update.");
            this.xbrlFileController.setStatusBarMessage("Error, batch not yet saved. Must save before update.");
            return;
        }
        final String batchIdentifier = this.batchTransaction.getBatchIdentifier();
        if (batchIdentifier == null || batchIdentifier.isEmpty()) {
            this.error_message.setText("Error, batch identifier not set.");
            this.xbrlFileController.setStatusBarMessage("Error, batch identifier not set.");
            return;
        }
        try {
            String passwordStr = this.password.getGlenixElementValue();
            if (passwordStr == null || passwordStr.isEmpty()) {
                throw new Exception("Error, you must enter your login password");
            }
            if (!this.xbrlFileController.reverifyPassword(passwordStr.toCharArray())) {
                throw new Exception("Error, password is not correct");
            }
            this.error_message.setText("Begin update");
            this.xbrlFileController.setStatusBarMessage("Begin update");
            this.setMessageTimestamp();
            Document resultDoc = this.dBuilder.newDocument();
            this.buildGlenixXBRLTransaction(resultDoc, null);
            if (this.batchTransaction == null) {
                this.batchTransaction = new Transaction();
            }
            this.batchTransaction.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
            if (this.batchTransaction == null) {
                throw new Exception("Error, cannot save batch");
            }
            Batch batch = this.batchTransaction.getBatch();
            if (batch == null) {
                throw new Exception("Error, batch is null cannot update.");
            }
            String passwordString = this.password.getText();
            this.password.setText(null);
            GlenixSBRResponse response = this.xbrlFileController.saveAndUpdateSTPBatch(this.batchTransaction);
            response.parseResponse();
            Document resdoc = response.getDocumentByHref("data.xml");
            if (resdoc == null) {
                throw new Exception("Error, unable to get STP batch, cannot read response from server");
            }
            GlenixTrnXBRL glenixTrnXBRLBatch = new GlenixTrnXBRL();
            glenixTrnXBRLBatch.loadDocumentElement(resdoc, resdoc.getDocumentElement());
            final Transaction sentBatchTransaction = glenixTrnXBRLBatch.getBatchTransaction(batchIdentifier);
            this.setBatchTransactionElement(sentBatchTransaction);
            this.setProfileDetails(this.xbrlFileController.getProfileXBRL());
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String thisBatchIdentifier = batchIdentifier;
                        Transaction thisBatchTransaction = sentBatchTransaction;
                        int sleep_one = 70000;
                        Thread.sleep(sleep_one);
                        if (BatchSTPLodgeCloudController.this.batchTransaction == thisBatchTransaction) {
                            Platform.runLater(() -> {
                                try {
                                    Transaction nextBatchTransaction = BatchSTPLodgeCloudController.this.xbrlFileController.getBatchTransactionReload(thisBatchIdentifier);
                                    BatchSTPLodgeCloudController.this.setBatchTransactionElement(nextBatchTransaction);
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    BatchSTPLodgeCloudController.this.error_message.setText(e.getMessage());
                                    BatchSTPLodgeCloudController.this.xbrlFileController.setStatusBarMessage(e.getMessage());
                                }
                            });
                        }
                    }
                    catch (Exception e) {
                        Platform.runLater(() -> {
                            e.printStackTrace();
                            BatchSTPLodgeCloudController.this.error_message.setText(e.getMessage());
                            BatchSTPLodgeCloudController.this.xbrlFileController.setStatusBarMessage(e.getMessage());
                        });
                    }
                }
            }).start();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    @FXML
    protected void pullMessages() {
        if (this.batchTransaction == null) {
            this.error_message.setText("Error, batch not yet lodged. Must lodge before pull messages.");
            this.xbrlFileController.setStatusBarMessage("Error, batch not yet lodged. Must lodge before pull messages.");
            return;
        }
        String batchIdentifier = this.batchTransaction.getBatchIdentifier();
        if (batchIdentifier == null || batchIdentifier.isEmpty()) {
            this.error_message.setText("Error, batch identifier not set.");
            this.xbrlFileController.setStatusBarMessage("Error, batch identifier not set.");
            return;
        }
        try {
            this.error_message.setText("Begin pull messages");
            this.xbrlFileController.setStatusBarMessage("Begin pull messages");
            if (this.batchTransaction == null) {
                throw new Exception("Error, cannot save batch");
            }
            Batch batch = this.batchTransaction.getBatch();
            if (batch == null) {
                throw new Exception("Error, batch is null cannot pull messages.");
            }
            String passwordString = this.password.getText();
            this.password.setText(null);
            GlenixSBRResponse response = this.xbrlFileController.pullMessagesSTPBatch(this.batchTransaction);
            response.parseResponse();
            Document resdoc = response.getDocumentByHref("data.xml");
            if (resdoc == null) {
                throw new Exception("Error, unable to get STP batch, cannot read response from server");
            }
            GlenixTrnXBRL glenixTrnXBRLBatch = new GlenixTrnXBRL();
            glenixTrnXBRLBatch.loadDocumentElement(resdoc, resdoc.getDocumentElement());
            this.setBatchTransactionElement(glenixTrnXBRLBatch.getBatchTransaction(batchIdentifier));
            this.setProfileDetails(this.xbrlFileController.getProfileXBRL());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }
}

