/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.cloud.CloudApplicationController;
import au.com.glenix.cloud.TransactionEditShortFormCloudVBox;
import au.com.glenix.cloud.TransactionsTableReceiveMoneyController;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixLabelTwoDecimalNumber;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.SelectionMode;
import javafx.util.Pair;

public class BankReconciliationController
extends TransactionsTableReceiveMoneyController {
    @FXML
    protected GlenixLabelTwoDecimalNumber bank_balance;
    protected GlenixTrnXBRL accountsReceivableTransactions = null;

    public BankReconciliationController(CloudApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        this.transactionTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.setTransactionTypeOptions();
        this.bank_balance.addTextChangeListener(new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                BankReconciliationController.this.updateTotalLabel();
            }
        });
    }

    protected void setTransactionTypeOptions() {
        ArrayList<Pair<String, String>> options = new ArrayList<Pair<String, String>>();
        options.add(new Pair((Object)"cash_received", (Object)"Cash received"));
        options.add(new Pair((Object)"cash_payment", (Object)"Cash payment"));
        this.transactionEditFormVBox.setTransactionTypeVisibleOptions(options, true, "purchase_invoice");
    }

    @Override
    public void retrieveTransactions() {
        if (!this.doupdate) {
            return;
        }
        LocalDate maxDate = this.filterToDate.getLocalDate();
        String dmStr = this.displayMonths.getGlenixElementValue();
        Integer dm = 0;
        if (dmStr != null && !dmStr.isEmpty()) {
            try {
                dm = Integer.parseInt(dmStr);
            }
            catch (Exception e) {
                e.printStackTrace();
                dm = 0;
            }
        }
        this.lastMinDate = this.calcFromDate(maxDate, dm);
        try {
            GlenixTrnXBRL newTrns = this.xbrlFileController.getFreshBankReconciliationTransactionList(this.lastMinDate, maxDate, null);
            this.setTransactions(newTrns, dm, this.lastMinDate, maxDate, null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setTransactions(GlenixTrnXBRL transactions, Integer months, LocalDate minDate, LocalDate maxDate, String divisionIdentifier) throws Exception {
        boolean setupdate = true;
        if (!this.doupdate) {
            setupdate = false;
        } else {
            this.doupdate = false;
        }
        try {
            this.transactions = transactions;
            this.filterToDate.setLocalDate(maxDate);
            if (months == null) {
                this.displayMonths.setGlenixElementValue(null);
            } else {
                this.displayMonths.setGlenixElementValue(months.toString());
            }
            this.lastMaxDate = maxDate;
            if (maxDate != null) {
                if (this.lastMinDate != null && this.lastMinDate.compareTo(maxDate) <= 0) {
                    this.page_heading.setText("Bank reconciliation as at " + maxDate.format(this.displayDateFormatter) + " including all transactions from " + this.lastMinDate.format(this.displayDateFormatter));
                } else {
                    this.page_heading.setText("Bank reconciliation as at " + maxDate.format(this.displayDateFormatter));
                }
            } else {
                this.page_heading.setText("Bank reconciliation");
            }
            if (transactions == null) {
                this.setReceivableRowObservableList((ObservableList<TransactionsTableReceiveMoneyController.ReceivableRow>)FXCollections.observableList(new ArrayList()));
                if (setupdate) {
                    this.doupdate = true;
                }
                return;
            }
            ArrayList<Transaction> tal = transactions.getTransactionArrayList();
            if (tal == null || tal.isEmpty()) {
                this.setReceivableRowObservableList((ObservableList<TransactionsTableReceiveMoneyController.ReceivableRow>)FXCollections.observableList(new ArrayList()));
                if (setupdate) {
                    this.doupdate = true;
                }
                return;
            }
            ArrayList<CashRow> rral = new ArrayList<CashRow>();
            for (Transaction t : tal) {
                String tt = t.getTransactionType();
                if (tt != null && tt.equals("reconciliation")) {
                    LocalDate md = t.getTransactionReconciliationMaxDateAsDate();
                    Double recamt = t.getTransactionReconciliationAmountAsDouble();
                    if (recamt == null || !recamt.equals(0.0) || md == null || minDate != null && !md.isBefore(minDate) || minDate == null && maxDate != null && md.isAfter(maxDate)) {
                        CashRow rr = new CashRow(t, null);
                        rral.add(rr);
                    }
                    for (int i = 0; i < t.getTransactionLineCount(); ++i) {
                        TransactionLine tl = t.getTransactionLine(i);
                        md = tl.getReconciliationMaxDateAsDate();
                        recamt = tl.getReconciliationAmountAsDouble();
                        if (recamt != null && recamt.equals(0.0) && md != null && (minDate == null || md.isBefore(minDate)) && (minDate != null || maxDate == null || !md.isAfter(maxDate))) continue;
                        CashRow rr = new CashRow(t, tl);
                        rral.add(rr);
                    }
                    continue;
                }
                CashRow rr = new CashRow(t, null);
                rral.add(rr);
            }
            ObservableList rrol = FXCollections.observableList(rral);
            this.setReceivableRowObservableList((ObservableList<TransactionsTableReceiveMoneyController.ReceivableRow>)rrol);
        }
        finally {
            if (setupdate) {
                this.doupdate = true;
            }
        }
    }

    @Override
    protected void updateTotalLabel() {
        if (this.total_label == null) {
            return;
        }
        super.updateTotalLabel();
        if (this.totalSelectedCount == 0) {
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"success"});
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"error"});
            return;
        }
        Double bb = this.bank_balance.getDouble();
        if (bb == null) {
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"success"});
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"error"});
        } else if (bb.equals(this.totalSelectedAmount)) {
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"error"});
            this.total_label.getStyleClass().add((Object)"success");
        } else {
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"success"});
            this.total_label.getStyleClass().add((Object)"error");
        }
    }

    public void setAccountsReceivableTransactions(GlenixTrnXBRL accountsReceivableTransactions) throws Exception {
        this.accountsReceivableTransactions = accountsReceivableTransactions;
    }

    @Override
    protected void addNewNoAccountLines(Transaction transaction, String counterpartyIdentifier) {
        try {
            Set<String> usedRecNos = this.transactionEditFormVBox.getReconciliationNumberSet();
            if (transaction != null) {
                for (int i = 0; i < transaction.getTransactionLineCount(); ++i) {
                    TransactionLine tl = transaction.getTransactionLine(i);
                    String recNumber = tl.getReconciliationNumber();
                    if (recNumber == null || recNumber.isEmpty()) continue;
                    usedRecNos.add(recNumber);
                }
            }
            HashMap<String, TransactionLine> recAmts = new HashMap<String, TransactionLine>();
            if (counterpartyIdentifier != null && !counterpartyIdentifier.isEmpty()) {
                ArrayList<Transaction> actrns = this.accountsReceivableTransactions.getTransactionArrayList();
                for (Transaction t : actrns) {
                    TransactionLine prevTl;
                    String recNumber;
                    String tt;
                    String tci = t.getCounterpartyIdentifier();
                    if (tci == null || !tci.equals(counterpartyIdentifier) || (tt = t.getTransactionType()) == null || !tt.equals("sales_invoice") && !tt.equals("sales_credit") || usedRecNos.contains(recNumber = t.getTransactionReconciliationNumber()) || (prevTl = (TransactionLine)recAmts.get(recNumber)) != null) continue;
                    TransactionLine newTl = new TransactionLine();
                    newTl.setReconciliationNumber(recNumber);
                    newTl.setReconciliationAmount(t.getTransactionReconciliationAmount());
                    newTl.setLineComment("Invoice: " + t.getDocumentNumber());
                    recAmts.put(recNumber, newTl);
                }
            }
            for (TransactionLine tl : recAmts.values()) {
                ((TransactionEditShortFormCloudVBox)this.transactionEditFormVBox).addTransactionLineNoAccount(tl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    protected void postBankReconcilationNoStm() {
        try {
            if (this.selectedRows == null || this.selectedRows.size() <= 0) {
                throw new Exception("Error, no transactions selected.");
            }
            StringBuilder rrsb = new StringBuilder();
            boolean hasselected = false;
            for (TransactionsTableReceiveMoneyController.ReceivableRow rr : this.selectedRows) {
                if (hasselected) {
                    rrsb.append(",");
                }
                rrsb.append(rr.getReconciliationNumber());
                hasselected = true;
            }
            GlenixResult gr = this.xbrlFileController.sendReconcile(rrsb.toString());
            if (gr == null) {
                throw new Exception("Error, unable to read post reconciliation response");
            }
            String resultCode = gr.getResultCode();
            if (resultCode == null) {
                throw new Exception("Error, unable to read post reconciliation response code");
            }
            if (!resultCode.equals("OK")) {
                throw new Exception(gr.getResultDescription());
            }
            this.error_message.setText("Reconciliation saved");
            this.xbrlFileController.setStatusBarMessage("Reconciliation saved");
            this.bank_balance.setText(null);
            this.retrieveTransactions();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    protected void postBankReconcilation() {
        try {
            GlenixResult gr;
            if (this.selectedRows == null || this.selectedRows.size() <= 0) {
                throw new Exception("Error, no transactions selected.");
            }
            Double bb = this.bank_balance.getDouble();
            StringBuilder rrsb = new StringBuilder();
            boolean hasselected = false;
            HashSet<String> recnos = new HashSet<String>();
            for (TransactionsTableReceiveMoneyController.ReceivableRow rr : this.selectedRows) {
                recnos.add(rr.getReconciliationNumber());
            }
            for (String recno : recnos) {
                if (hasselected) {
                    rrsb.append(",");
                }
                rrsb.append(recno);
                hasselected = true;
            }
            if (!hasselected) {
                throw new Exception("Error, no transactions selected.");
            }
            if (this.totalSelectedAmount == null || !this.totalSelectedAmount.equals(bb)) {
                throw new Exception("Error, selected transactions do not equal bank balance.");
            }
            if (!this.totalSelectedAmount.equals(0.0)) {
                Transaction rect = this.xbrlFileController.addTransaction();
                if (this.lastMaxDate == null) {
                    throw new Exception("Error, no date set. Select a date first.");
                }
                rect.setTransactionDate(this.lastMaxDate.format(DateTimeFormatter.ISO_LOCAL_DATE));
                rect.setTransactionType("reconciliation");
                rect.setTransactionStatus("posted");
                rect.setTransactionComment("Closing bank statement balance");
                TransactionLine tl = rect.addBlankTransactionLine();
                tl.setAmount(bb);
                tl.setLineComment("Bank statement balance");
                GlenixTrnXBRL gt = this.xbrlFileController.saveTransactionGetXBRL(rect);
                Business sb = gt.getBusiness();
                if (sb == null) {
                    throw new Exception("Error, unable to save bank statement balance.");
                }
                Transaction saveT = sb.getTransaction(0);
                if (saveT == null) {
                    throw new Exception("Error, unable to save bank statement balance transaction.");
                }
                String stmrec = saveT.getTransactionReconciliationNumber();
                if (stmrec == null || stmrec.isEmpty()) {
                    throw new Exception("Error, unable to get reconciliation reference for saved bank statement balance.");
                }
                rrsb.append(",");
                rrsb.append(stmrec);
            }
            if ((gr = this.xbrlFileController.sendReconcile(rrsb.toString())) == null) {
                throw new Exception("Error, unable to read post reconciliation response");
            }
            String resultCode = gr.getResultCode();
            if (resultCode == null) {
                throw new Exception("Error, unable to read post reconciliation response code");
            }
            if (!resultCode.equals("OK")) {
                throw new Exception(gr.getResultDescription());
            }
            this.error_message.setText("Reconciliation saved");
            this.xbrlFileController.setStatusBarMessage("Reconciliation saved");
            this.bank_balance.setText(null);
            this.retrieveTransactions();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    public class CashRow
    extends TransactionsTableReceiveMoneyController.ReceivableRow {
        public CashRow(Transaction receivableT, TransactionLine cashReceivedTL) throws Exception {
            super(BankReconciliationController.this, receivableT, cashReceivedTL);
        }

        @Override
        public Double getTotalAmount() {
            if (this.cashReceivedTL != null) {
                Double res = this.cashReceivedTL.getCreditAmount(this.receivableT.getTransactionType());
                if (res == null) {
                    return null;
                }
                return -res.doubleValue();
            }
            return this.receivableT.getCreditTotalAmount();
        }
    }
}

