/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationController;
import au.com.glenix.cloud.BalanceSheetAccountDetailController;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.Provision;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixPDFWrapper;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class BalanceSheetProvisionDetailController
extends BalanceSheetAccountDetailController {
    protected Provision provision;
    protected Set<String> provisionIdentifiers = null;

    public BalanceSheetProvisionDetailController(ApplicationController applicationController) {
        super(applicationController);
    }

    public void setTransactionLineList(Set<String> provisionIdentifier, List<Transaction.TransactionTransactionLine> transactionLines) throws Exception {
        this.provision = null;
        this.provisionIdentifiers = provisionIdentifier;
        if (provisionIdentifier != null && provisionIdentifier.size() == 1) {
            for (String pi : provisionIdentifier) {
                Transaction t = this.applicationController.getProvisionTransaction(pi);
                if (t == null) continue;
                this.provision = t.getProvision();
            }
        }
        this.updateHeading();
        if (transactionLines == null) {
            this.incomeAndExpenditure.setItems(null);
            return;
        }
        this.transactionLineObservableList = FXCollections.observableList(transactionLines);
        this.setTransactionObservableList((ObservableList<Transaction.TransactionTransactionLine>)this.transactionLineObservableList);
        this.updateFilter();
        this.incomeAndExpenditure.refresh();
    }

    @Override
    public void setTransactionLineList(String provisionIdentifier, List<Transaction.TransactionTransactionLine> transactionLines) throws Exception {
        Transaction t;
        this.provision = null;
        this.provisionIdentifiers = null;
        if (provisionIdentifier != null && !provisionIdentifier.isEmpty() && (t = this.applicationController.getProvisionTransaction(provisionIdentifier)) != null) {
            this.provision = t.getProvision();
        }
        this.updateHeading();
        if (transactionLines == null) {
            this.incomeAndExpenditure.setItems(null);
            return;
        }
        this.transactionLineObservableList = FXCollections.observableList(transactionLines);
        this.setTransactionObservableList((ObservableList<Transaction.TransactionTransactionLine>)this.transactionLineObservableList);
        this.updateFilter();
        this.incomeAndExpenditure.refresh();
    }

    @Override
    protected void setTransactionObservableList(ObservableList<Transaction.TransactionTransactionLine> transactionLineObservableList) {
        if (transactionLineObservableList != null) {
            transactionLineObservableList.sort((Comparator)new Comparator<Transaction.TransactionTransactionLine>(){

                @Override
                public int compare(Transaction.TransactionTransactionLine ttl1, Transaction.TransactionTransactionLine ttl2) {
                    Transaction t2;
                    Transaction t1;
                    String rr1date = ttl1.getProvisionReconciliationMaxDate();
                    String rr2date = ttl2.getProvisionReconciliationMaxDate();
                    if (rr1date == null || rr1date.isEmpty()) {
                        if (rr2date != null && !rr2date.isEmpty()) {
                            return -1;
                        }
                    } else {
                        if (rr2date == null || rr2date.isEmpty()) {
                            return 1;
                        }
                        int result = rr1date.compareTo(rr2date);
                        if (result != 0) {
                            return result;
                        }
                    }
                    Integer rr1Int = ttl1.getReconciliationNumberAsInt();
                    Integer rr2Int = ttl2.getReconciliationNumberAsInt();
                    if (rr1Int == null) {
                        if (rr2Int != null) {
                            return -1;
                        }
                    } else {
                        if (rr2Int == null) {
                            return 1;
                        }
                        int result = rr1Int.compareTo(rr2Int);
                        if (result != 0) {
                            return result;
                        }
                    }
                    if ((t1 = ttl1.getTransaction()) == (t2 = ttl2.getTransaction())) {
                        int tl1line = ttl1.getLineNumberAsInt();
                        int tl2line = ttl2.getLineNumberAsInt();
                        return tl1line - tl2line;
                    }
                    String t1date = t1.getTransactionDate();
                    String t2date = t2.getTransactionDate();
                    if (t1date == null || t1date.isEmpty()) {
                        if (t2date != null && !t2date.isEmpty()) {
                            return -1;
                        }
                    } else {
                        if (t2date == null || t2date.isEmpty()) {
                            return 1;
                        }
                        int result = t1date.compareTo(t2date);
                        if (result != 0) {
                            return result;
                        }
                    }
                    String t1comment = t1.getTransactionComment();
                    String t2comment = t2.getTransactionComment();
                    if (t1comment == null || t1comment.isEmpty()) {
                        if (t2comment != null && !t2comment.isEmpty()) {
                            return -1;
                        }
                    } else {
                        if (t2comment == null || t2comment.isEmpty()) {
                            return 1;
                        }
                        int result = t1comment.compareTo(t2comment);
                        if (result != 0) {
                            return result;
                        }
                    }
                    return ttl1.toString().compareTo(ttl2.toString());
                }
            });
        }
        this.transactionLineObservableList = transactionLineObservableList;
        this.clearSelection();
        this.createFilteredItems();
    }

    @Override
    public void updateHeading() {
        if (this.provision == null) {
            this.page_heading.setText("Provision reconciliation");
            this.setGlenixElementDescription("Provision reconciliation");
        } else {
            this.page_heading.setText(this.provision.getProvisionName() + " - reconciliation");
            this.setGlenixElementDescription(this.provision.getProvisionName() + " - reconciliation");
            String classification = this.provision.getProvisionClassificationReference();
            this.multiplier = 1;
            if (classification != null && (classification.equals("income") || classification.equals("netincome") || classification.equals("totalincome") || classification.equals("equity") || classification.equals("distribution") || classification.equals("liability") || classification.equals("totalliability") || classification.equals("totalequity"))) {
                this.multiplier = -1;
            }
        }
    }

    @Override
    public void setupReconciliationDetailsColumn() {
        if (this.reconciliationDetailsAndAmountColumn != null) {
            this.reconciliationDetailsAndAmountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                Transaction.TransactionTransactionLine ttl;
                                boolean isset = false;
                                if (item != null && !item.isEmpty() && (ttl = (Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())) != null) {
                                    LocalDate recdate = ttl.getProvisionReconciliationMaxDateAsDate();
                                    Double amount = ttl.getProvisionReconciliationAmount();
                                    if (recdate != null && amount != null) {
                                        if (BalanceSheetProvisionDetailController.this.multiplier < 0) {
                                            amount = -amount.doubleValue();
                                        }
                                        item = item + " (" + BalanceSheetProvisionDetailController.this.outputDateFormatter.format(recdate) + ", " + BalanceSheetProvisionDetailController.this.formatTwoDp.format(amount) + ")";
                                        this.setText(item);
                                        isset = true;
                                    }
                                }
                                if (!isset) {
                                    this.setText("null");
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
    }

    @Override
    protected void updateTotalLabel() {
        if (this.total_label == null) {
            return;
        }
        if (this.totalSelectedCount == 0) {
            this.total_label.setText("Total displayed tax amount: " + this.amountFormat.format(this.totalProvisionAmount) + ", total gross: " + this.amountFormat.format(this.totalAmount) + ", total net: " + this.amountFormat.format(this.totalAmount - this.totalProvisionAmount) + ", No transactions/transaction lines selected");
            return;
        }
        if (this.selection_visible) {
            this.total_label.setText("Total displayed tax amount: " + this.amountFormat.format(this.totalProvisionAmount) + ", total gross: " + this.amountFormat.format(this.totalAmount) + ", total net: " + this.amountFormat.format(this.totalAmount - this.totalProvisionAmount) + ", Total selected tax amount: " + this.amountFormat.format(this.totalSelectedProvisionAmount));
        } else {
            this.total_label.setText("Total displayed tax amount: " + this.amountFormat.format(this.totalProvisionAmount) + ", total gross: " + this.amountFormat.format(this.totalAmount) + ", total net: " + this.amountFormat.format(this.totalAmount - this.totalProvisionAmount) + ", Total selected tax amount: " + this.amountFormat.format(this.totalSelectedProvisionAmount) + " (some selections are filtered out)");
        }
    }

    @Override
    protected void updateTotalLabelStyle() {
        if (this.totalSelectedCount == 0) {
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"success"});
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"error"});
            return;
        }
        Double bb = this.statement_balance.getDouble();
        if (bb == null) {
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"success"});
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"error"});
        } else if (bb.equals(this.totalSelectedProvisionAmount)) {
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"error"});
            this.total_label.getStyleClass().add((Object)"success");
        } else {
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"success"});
            this.total_label.getStyleClass().add((Object)"error");
        }
    }

    @Override
    @FXML
    protected void updateFilterReload() {
        if (this.provision == null && (this.provisionIdentifiers == null || this.provisionIdentifiers.size() == 0)) {
            this.error_message.setText("Error, provision is not set.");
            this.applicationController.setStatusBarMessage("Error, provision is not set.");
            return;
        }
        String filterTextValue = null;
        if (this.filterText != null) {
            filterTextValue = this.filterText.getText();
        }
        LocalDate toDateValue = null;
        if (this.filterToDate != null) {
            this.lastMaxDate = toDateValue = this.filterToDate.getLocalDate();
        }
        LocalDate fromDateValue = this.calcFromDate(toDateValue);
        String ci = null;
        if (this.filterCounterpartyIdentifier != null) {
            ci = this.filterCounterpartyIdentifier.getGlenixElementValue();
        }
        String ai = null;
        if (this.filterAccountIdentifier != null) {
            ai = this.filterAccountIdentifier.getGlenixElementValue();
        }
        if (this.provision != null) {
            String pi = this.provision.getProvisionIdentifier();
            if (pi == null || pi.isEmpty()) {
                this.error_message.setText("Error, provision identifier is not set.");
                this.applicationController.setStatusBarMessage("Error, provision identifier is not set.");
                return;
            }
            try {
                ArrayList<Transaction.TransactionTransactionLine> ttl = this.applicationController.getTransactionLineListByProvisionReconciliation(pi, null, fromDateValue, toDateValue, ci, ai);
                this.transactionLineObservableList = FXCollections.observableList(ttl);
                this.setTransactionObservableList((ObservableList<Transaction.TransactionTransactionLine>)this.transactionLineObservableList);
                this.updateFilter(filterTextValue, null, toDateValue, ci, ai);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.applicationController.setStatusBarMessage(e.getMessage());
                return;
            }
        }
        try {
            ArrayList<Transaction.TransactionTransactionLine> ttl = this.applicationController.getTransactionLineListByProvisionReconciliation(this.provisionIdentifiers, null, fromDateValue, toDateValue, ci, ai);
            this.transactionLineObservableList = FXCollections.observableList(ttl);
            this.setTransactionObservableList((ObservableList<Transaction.TransactionTransactionLine>)this.transactionLineObservableList);
            this.updateFilter(filterTextValue, null, toDateValue, ci, ai);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
            return;
        }
    }

    @Override
    @FXML
    protected void updateFilter() {
        String filterTextValue = null;
        if (this.filterText != null) {
            filterTextValue = this.filterText.getText();
        }
        LocalDate fromDateValue = null;
        if (this.filterFromDate != null) {
            fromDateValue = this.filterFromDate.getLocalDate();
        }
        LocalDate toDateValue = null;
        if (this.filterToDate != null) {
            toDateValue = this.filterToDate.getLocalDate();
        }
        String ci = null;
        if (this.filterCounterpartyIdentifier != null) {
            ci = this.filterCounterpartyIdentifier.getGlenixElementValue();
        }
        String ai = null;
        if (this.filterAccountIdentifier != null) {
            ai = this.filterAccountIdentifier.getGlenixElementValue();
        }
        this.updateFilter(filterTextValue, fromDateValue, toDateValue, ci, ai);
    }

    @Override
    protected void updateFilter(String newValue, LocalDate fromDate, LocalDate toDate, String ci, String ai) {
        this.filteredItems.setPredicate(ttl -> {
            String formattedDate;
            String aid;
            String ttlai;
            String ttlci;
            LocalDate localDate = ttl.getTransactionDateAsDate();
            if (fromDate != null || toDate != null) {
                if (localDate == null) {
                    return false;
                }
                if (fromDate != null && localDate.isBefore(fromDate)) {
                    return false;
                }
                if (toDate != null && localDate.isAfter(toDate)) {
                    return false;
                }
            }
            if (!(ci == null || ci.isEmpty() || (ttlci = ttl.getCounterpartyIdentifier()) != null && ttlci.equals(ci))) {
                return false;
            }
            if (!(ai == null || ai.isEmpty() || (ttlai = ttl.getAccountIdentifier()) != null && ttlai.equals(ai))) {
                return false;
            }
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String transactionComment = ttl.getTransactionCommentLineComment();
            if (transactionComment != null && transactionComment.toLowerCase().contains(newValue.toLowerCase())) {
                return true;
            }
            String cid = ttl.getCounterpartyIdentifier();
            if (cid != null && !cid.isEmpty()) {
                try {
                    String cname;
                    Transaction ct = this.applicationController.getCounterpartyTransaction(cid);
                    if (ct != null && (cname = ct.getCounterpartyLegalName()) != null && !cname.isEmpty() && cname.toLowerCase().contains(newValue.toLowerCase())) {
                        return true;
                    }
                }
                catch (Exception ct) {
                    // empty catch block
                }
            }
            if ((aid = ttl.getAccountIdentifier()) != null && !aid.isEmpty()) {
                try {
                    String aname;
                    Transaction at = this.applicationController.getAccountTransaction(aid);
                    if (at != null && (aname = at.getAccountName()) != null && !aname.isEmpty() && aname.toLowerCase().contains(newValue.toLowerCase())) {
                        return true;
                    }
                }
                catch (Exception at) {
                    // empty catch block
                }
            }
            if (localDate != null && (formattedDate = this.displayDateFormatter.format(localDate)) != null && !formattedDate.isEmpty() && formattedDate.toLowerCase().contains(newValue.toLowerCase())) {
                return true;
            }
            String recDet = ttl.getProvisionReconciliationDetailsAndAmount();
            return recDet != null && !recDet.isEmpty() && recDet.toLowerCase().contains(newValue.toLowerCase());
        });
        this.updateTotalAmount();
    }

    @Override
    @FXML
    protected void splitSelectedTransactions() {
        try {
            boolean hasselected = false;
            StringBuilder trsb = new StringBuilder();
            for (Transaction.TransactionTransactionLine ttl : this.incomeAndExpenditure.getSelectionModel().getSelectedItems()) {
                String tn;
                if (hasselected) {
                    trsb.append(",");
                }
                if ((tn = ttl.getTransactionNumber()) == null || tn.isEmpty()) continue;
                String tln = ttl.getLineNumber();
                if (tln != null && !tln.isEmpty()) {
                    trsb.append(tn + "|" + tln + "|" + tln);
                } else {
                    trsb.append(tn);
                }
                hasselected = true;
            }
            if (!hasselected) {
                throw new Exception("Error, no transactions selected.");
            }
            GlenixResult gr = this.applicationController.sendSplit(trsb.toString());
            if (gr == null) {
                throw new Exception("Error, unable to read post split response");
            }
            String resultCode = gr.getResultCode();
            if (resultCode == null) {
                throw new Exception("Error, unable to read post split response code");
            }
            if (!resultCode.equals("OK")) {
                throw new Exception(gr.getResultDescription());
            }
            this.error_message.setText("Split saved");
            this.applicationController.setStatusBarMessage("Split saved");
            this.clearSelection();
            this.updateFilterReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    @FXML
    protected void postReconcilation() {
        try {
            if (this.selectedRows == null || this.selectedRows.size() <= 0) {
                throw new Exception("Error, no transactions selected.");
            }
            StringBuilder rrsb = new StringBuilder();
            boolean hasselected = false;
            for (Transaction.TransactionTransactionLine rr : this.selectedRows) {
                if (hasselected) {
                    rrsb.append(",");
                }
                rrsb.append(rr.getProvisionReconciliationNumber());
                hasselected = true;
            }
            GlenixResult gr = this.applicationController.sendReconcile(rrsb.toString());
            if (gr == null) {
                throw new Exception("Error, unable to read post reconciliation response");
            }
            String resultCode = gr.getResultCode();
            if (resultCode == null) {
                throw new Exception("Error, unable to read post reconciliation response code");
            }
            if (!resultCode.equals("OK")) {
                throw new Exception(gr.getResultDescription());
            }
            this.error_message.setText("Reconciliation saved");
            this.applicationController.setStatusBarMessage("Reconciliation saved");
            this.statement_balance.setText(null);
            this.statement_description.setText(null);
            this.clearSelection();
            this.updateFilterReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    @FXML
    protected void postStatementReconcilation() {
        try {
            GlenixResult gr;
            if (this.selectedRows == null || this.selectedRows.size() <= 0) {
                throw new Exception("Error, no transactions selected.");
            }
            Double bb = this.statement_balance.getDouble();
            StringBuilder rrsb = new StringBuilder();
            boolean hasselected = false;
            HashSet<String> recnos = new HashSet<String>();
            for (Transaction.TransactionTransactionLine rr : this.selectedRows) {
                recnos.add(rr.getProvisionReconciliationNumber());
            }
            for (String recno : recnos) {
                if (hasselected) {
                    rrsb.append(",");
                }
                rrsb.append(recno);
                hasselected = true;
            }
            if (!hasselected) {
                throw new Exception("Error, no transactions selected.");
            }
            if (this.totalSelectedProvisionAmount == null || !this.totalSelectedProvisionAmount.equals(bb)) {
                throw new Exception("Error, selected transactions do not equal statement balance.");
            }
            if (this.provision == null) {
                throw new Exception("Error, provision is not set.");
            }
            String pi = this.provision.getProvisionIdentifier();
            if (pi == null || pi.isEmpty()) {
                throw new Exception("Error, provision identifier is not set.");
            }
            if (!this.totalSelectedProvisionAmount.equals(0.0)) {
                Transaction rect = this.applicationController.addTransaction();
                if (this.lastMaxDate == null) {
                    throw new Exception("Error, no date set. Select a date first.");
                }
                rect.setTransactionDate(this.lastMaxDate.format(DateTimeFormatter.ISO_LOCAL_DATE));
                rect.setTransactionType("general_journal");
                rect.setTransactionStatus("posted");
                String desc = this.statement_description.getGlenixElementValue();
                if (desc == null || desc.isEmpty()) {
                    desc = "Statement balance";
                }
                TransactionLine tl = rect.addBlankTransactionLine();
                tl.setAmount(-bb.doubleValue() * (double)this.multiplier);
                tl.setProvisionAmount(-bb.doubleValue() * (double)this.multiplier);
                tl.setLineComment("Closing: " + desc);
                tl.setProvisionIdentifier(pi);
                tl = rect.addBlankTransactionLine();
                tl.setAmount(bb * (double)this.multiplier);
                tl.setProvisionAmount(bb * (double)this.multiplier);
                tl.setLineComment(desc);
                tl.setProvisionIdentifier(pi);
                GlenixTrnXBRL gt = this.applicationController.saveTransactionGetXBRL(rect);
                Business sb = gt.getBusiness();
                if (sb == null) {
                    throw new Exception("Error, unable to save statement balance.");
                }
                Transaction saveT = sb.getTransaction(0);
                if (saveT == null) {
                    throw new Exception("Error, unable to save statement balance transaction.");
                }
                TransactionLine saveTl = saveT.getFirstTransactionLine();
                if (saveTl == null) {
                    throw new Exception("Error, unable to save statement balance transaction line.");
                }
                String stmrec = saveTl.getProvisionReconciliationNumber();
                if (stmrec == null || stmrec.isEmpty()) {
                    throw new Exception("Error, unable to get reconciliation reference for saved statement balance.");
                }
                rrsb.append(",");
                rrsb.append(stmrec);
            }
            if ((gr = this.applicationController.sendReconcile(rrsb.toString())) == null) {
                throw new Exception("Error, unable to read post reconciliation response");
            }
            String resultCode = gr.getResultCode();
            if (resultCode == null) {
                throw new Exception("Error, unable to read post reconciliation response code");
            }
            if (!resultCode.equals("OK")) {
                throw new Exception(gr.getResultDescription());
            }
            this.error_message.setText("Reconciliation saved");
            this.applicationController.setStatusBarMessage("Reconciliation saved");
            this.statement_balance.setText(null);
            this.statement_description.setText(null);
            this.clearSelection();
            this.updateFilterReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        String filterTextValue;
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPageLandscape();
        gpw.setColumns(10);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 266.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 266.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 44.0);
        gpw.setColumnLeftPosAndWidthMM(3, 64.0, 24.0);
        gpw.setColumnLeftPosAndWidthMM(4, 88.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(5, 128.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(6, 168.0, 26.0);
        gpw.setColumnLeftPosAndWidthMM(7, 194.0, 26.0);
        gpw.setColumnLeftPosAndWidthMM(8, 220.0, 26.0);
        gpw.setColumnLeftPosAndWidthMM(9, 246.0, 20.0);
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        gpw.setColumnFont(9, gpw.muliLightFont);
        Double fontSize = this.convertFontSize(this.page_heading.getFont().getSize());
        gpw.prepareString(0, this.page_heading.getText(), true, fontSize);
        gpw.drawStrings(10.0);
        fontSize = this.convertFontSize(new Double(this.applicationController.getCurrentFontSize()));
        if (this.filterText != null && (filterTextValue = this.filterText.getGlenixElementValue()) != null && !filterTextValue.isEmpty()) {
            gpw.prepareString(1, "Filter: " + filterTextValue, true, fontSize);
            gpw.drawStrings(10.0);
        }
        this.drawPDFColumnHeadings(gpw);
        gpw.setAddPageCallback(this);
        Double totalAmount = 0.0;
        Double totalNetAmount = 0.0;
        Double totalProvisionAmount = 0.0;
        for (Transaction.TransactionTransactionLine ttl : this.filteredItems) {
            String id;
            LocalDate d = ttl.getTransactionDateAsDate();
            if (d != null) {
                gpw.prepareString(2, this.displayDateFormatter.format(d), true, fontSize);
            }
            if ((id = ttl.getCounterpartyIdentifier()) != null && !id.isEmpty()) {
                try {
                    Transaction ct = this.applicationController.getCounterpartyTransaction(id);
                    if (ct != null) {
                        gpw.prepareString(3, ct.getCounterpartyLegalName(), true, fontSize);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            gpw.prepareString(4, ttl.getTransactionComment(), true, fontSize);
            Double amt = ttl.getProvisionAmount();
            if (amt != null) {
                totalProvisionAmount = totalProvisionAmount + amt;
                gpw.prepareString(6, this.amountFormat.format(amt), true, fontSize, "right");
            }
            if ((amt = ttl.getNetAmount()) != null) {
                totalNetAmount = totalNetAmount + amt;
                gpw.prepareString(7, this.amountFormat.format(amt), true, fontSize, "right");
            }
            if ((amt = ttl.getAmount()) != null) {
                totalAmount = totalAmount + amt;
                gpw.prepareString(8, this.amountFormat.format(amt), true, fontSize, "right");
            }
            if ((id = ttl.getAccountIdentifier()) != null && !id.isEmpty()) {
                try {
                    Transaction pt = this.applicationController.getAccountTransaction(id);
                    if (pt != null) {
                        gpw.prepareString(9, pt.getAccountName(), true, fontSize);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            gpw.drawStrings(2.0);
        }
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(6, gpw.muliBoldFont);
        gpw.setColumnFont(7, gpw.muliBoldFont);
        gpw.setColumnFont(8, gpw.muliBoldFont);
        gpw.prepareString(2, "Totals", true, fontSize);
        gpw.prepareString(6, this.amountFormat.format(totalProvisionAmount), true, fontSize, "right");
        gpw.prepareString(7, this.amountFormat.format(totalNetAmount), true, fontSize, "right");
        gpw.prepareString(8, this.amountFormat.format(totalAmount), true, fontSize, "right");
        gpw.drawStrings();
        gpw.addFooter();
        return gpw;
    }

    private void drawPDFColumnHeadings(GlenixPDFWrapper gpw) throws Exception {
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliBoldFont);
        gpw.setColumnFont(4, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        gpw.setColumnFont(6, gpw.muliBoldFont);
        gpw.setColumnFont(7, gpw.muliBoldFont);
        gpw.setColumnFont(8, gpw.muliBoldFont);
        gpw.setColumnFont(9, gpw.muliBoldFont);
        Double fontSize = this.convertFontSize(new Double(this.applicationController.getCurrentFontSize()));
        gpw.prepareString(2, this.dateColumn.getText(), true, fontSize);
        gpw.prepareString(3, this.dateColumn.getText(), true, fontSize);
        gpw.prepareString(4, this.counterpartyNameColumn.getText(), true, fontSize);
        gpw.prepareString(5, this.detailCommentColumn.getText(), true, fontSize);
        gpw.prepareString(6, this.provisionAmountColumn.getText(), true, fontSize, "right");
        gpw.prepareString(7, this.netAmountColumn.getText(), true, fontSize, "right");
        gpw.prepareString(8, this.amountColumn.getText(), true, fontSize, "right");
        gpw.prepareString(9, this.accountNameColumn.getText(), true, fontSize);
        gpw.drawStrings(2.0);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        gpw.setColumnFont(9, gpw.muliLightFont);
    }
}

