/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixLabelCounterpartyCombo;
import au.com.glenix.GlenixLabelProvisionCombo;
import au.com.glenix.IncomeAndExpenditureController;
import au.com.glenix.cloud.ProfitAndLossController;
import au.com.glenix.trn.Account;
import au.com.glenix.trn.Provision;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javafx.fxml.FXML;
import javafx.scene.control.TableRow;
import javafx.scene.input.MouseEvent;

public class BalanceSheetController
extends ProfitAndLossController {
    @FXML
    protected GlenixLabelCounterpartyCombo counterpartyIdentifier;
    @FXML
    protected GlenixLabelProvisionCombo provisionIdentifier;
    private HashMap<String, String> basgroups = new HashMap();

    public BalanceSheetController(ApplicationController applicationController) {
        super(applicationController);
        this.basgroups.put("NA", "GST not applicable");
        this.basgroups.put("GST_Taxable_Sales", "GST payable");
        this.basgroups.put("Export_Sales", "GST free sales tax code");
        this.basgroups.put("GST_Free_Sales", "GST free sales tax code");
        this.basgroups.put("Input_Taxed_Sales", "GST free sales tax code");
        this.basgroups.put("Sales_Adjustments", "GST payable");
        this.basgroups.put("Capital_Purchases", "GST receivable");
        this.basgroups.put("Non_Capital_Purchases", "GST receivable");
        this.basgroups.put("Purchases_for_Input_Taxed_Sales", "GST free purchases tax code");
        this.basgroups.put("Purchases_for_Input_Taxed_Sales_Capital", "GST free purchases tax code");
        this.basgroups.put("GST_Free_Purchases", "GST free purchases tax code");
        this.basgroups.put("GST_Free_Purchases_Capital", "GST free purchases tax code");
        this.basgroups.put("Purchase_Adjustments", "GST receivable");
        this.basgroups.put("Salaries_and_Wages", "Salaries and wages tax code");
        this.basgroups.put("PAYG_Withholding_Payable", "PAYG withholding payable");
        this.basgroups.put("No_ABN_Withholding", "PAYG withholding payable");
        this.basgroups.put("Other_PAYG_Withholding", "PAYG withholding payable");
        this.basgroups.put("GST_Paid_to_ATO", "GST payable");
        this.basgroups.put("GST_Received_from_ATO", "GST receivable");
        this.basgroups.put("PAYG_Withheld_Paid_to_ATO", "PAYG withholding payable");
        this.basgroups.put("PAYG_Instalment_Accrued", "PAYG instalment payable");
        this.basgroups.put("PAYG_Instalment_Paid_to_ATO", "PAYG instalment payable");
        this.basgroups.put("Wine_Equalisation_Tax_Claimable_Credits", "WET payable");
        this.basgroups.put("Wine_Equalisation_Tax_Liability", "WET payable");
        this.basgroups.put("Wine_Equalisation_Paid_to_ATO", "WET payable");
        this.basgroups.put("Luxury_Car_Tax_Claimable_Credits", "LCT payable");
        this.basgroups.put("Luxury_Car_Tax_Liability", "LCT payable");
        this.basgroups.put("Luxury_Car_Tax_Paid_to_ATO", "LCT payable");
        this.basgroups.put("Fuel_Tax_Claimable_Credits_Tax_Amount", "FTC receivable");
        this.basgroups.put("Fuel_Tax_Overclaimed_Credits_Tax_Amount", "FTC receivable");
        this.basgroups.put("Fuel_Tax_Claimable_Credits", "FTC receivable");
        this.basgroups.put("Fuel_Tax_Overclaimed_Credits", "FTC receivable");
        this.basgroups.put("Fuel_Tax_Credits_Refunded_from_ATO", "FTC receivable");
        this.basgroups.put("GST_Deferred_Liability_On_Import_Duty", "GST deferred liability on import duty");
        this.basgroups.put("NA", "Not applicable");
        this.basgroups.put("PAYG_Individual_Non_Business", "PAYG_Individual_Non_Business");
        this.basgroups.put("PAYG_Voluntary_Agreement", "PAYG_Voluntary_Agreement");
        this.basgroups.put("PAYG_Labour_Hire", "PAYG_Labour_Hire");
        this.basgroups.put("PAYG_Specified", "PAYG_Specified");
        this.basgroups.put("PAYG_JPDA", "PAYG_JPDA");
        this.basgroups.put("PAYG_JPDA_Foreign_Withholding", "PAYG_JPDA_Foreign_Withholding");
        this.basgroups.put("PAYG_Working_Holiday", "PAYG_Working_Holiday");
        this.basgroups.put("PAYG_Foreign_Resident", "PAYG_Foreign_Resident");
        this.basgroups.put("Foreign_Tax_Withheld", "Foreign_Tax_Withheld");
        this.basgroups.put("PAYG_ETP_B", "PAYG_ETP - type B");
        this.basgroups.put("PAYG_ETP_D", "PAYG_ETP - type D");
        this.basgroups.put("PAYG_ETP_N", "PAYG_ETP - type N");
        this.basgroups.put("PAYG_ETP_O", "PAYG_ETP - type O");
        this.basgroups.put("PAYG_ETP_P", "PAYG_ETP - type P");
        this.basgroups.put("PAYG_ETP_R", "PAYG_ETP - type R");
        this.basgroups.put("PAYG_ETP_S", "PAYG_ETP - type S");
        this.basgroups.put("PAYG_ETP_T", "PAYG_ETP - type T");
        this.basgroups.put("Fringe_Benefits_Reportable", "Fringe benefits - employer not tax exempt");
        this.basgroups.put("Fringe_Benefits_Reportable_Exempt", "Fringe benefits - employer is tax exempt");
        this.basgroups.put("Superannuation_SGC_Contributions", "Employer super compulsory contributions");
        this.basgroups.put("Superannuation_Additional_Employer_Contributions", "Employer super additional contributions");
        this.basgroups.put("Expense_Workplace_Giving", "Expense_Workplace_Giving");
        this.basgroups.put("Expense_Union_Or_Professional_Association_Fee", "Expense_Union_Or_Professional_Association_Fee");
        this.basgroups.put("Taxable_Payments_Annual_Report_GST", "Taxable_Payments_Annual_Report_GST");
        this.basgroups.put("Taxable_Payments_Annual_Report_Tax_Withheld_No_ABN", "Taxable_Payments_Annual_Report_Tax_Withheld_No_ABN");
    }

    @Override
    public void setupIncomeAndExpenditureTable() {
        this.incomeAndExpenditure.setRowFactory(tv -> {
            TableRow<IncomeAndExpenditureController.ReportLine> row = new TableRow<IncomeAndExpenditureController.ReportLine>(){

                protected final void updateItem(IncomeAndExpenditureController.ReportLine reportLine, boolean empty) {
                    super.updateItem((Object)reportLine, empty);
                    if (reportLine != null && reportLine.getClassification() != null && (reportLine.getClassification().equals("incomeheader") || reportLine.getClassification().equals("totalincome") || reportLine.getClassification().equals("expenseheader") || reportLine.getClassification().equals("totalexpense") || reportLine.getClassification().equals("netincome") || reportLine.getClassification().equals("totalasset") || reportLine.getClassification().equals("totalliability") || reportLine.getClassification().equals("netassets") || reportLine.getClassification().equals("totalequity") || reportLine.getClassification().equals("totalequityincrease") || reportLine.getClassification().equals("totaldistribution") || reportLine.getClassification().equals("assetheader") || reportLine.getClassification().equals("liabilityheader") || reportLine.getClassification().equals("equityheader") || reportLine.getClassification().equals("distributionheader"))) {
                        this.getStyleClass().add((Object)"totalRow");
                    }
                }
            };
            row.setOnMouseClicked(arg_0 -> this.lambda$null$0((TableRow)row, arg_0));
            return row;
        });
    }

    @Override
    @FXML
    protected void updateFilter() {
        LocalDate toDateValue = null;
        if (this.filterToDate != null) {
            toDateValue = this.filterToDate.getLocalDate();
        }
        try {
            List<Transaction> trns = this.applicationController.getAccountProvisionTotals(null, null, toDateValue, this.counterpartyIdentifier.getGlenixElementValue(), this.provisionIdentifier.getGlenixElementValue());
            if (trns == null) {
                throw new Exception("Error, unable to generate Balance sheet report");
            }
            this.lastMaxDate = toDateValue;
            this.setSummaryTransaction(trns);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public HashMap<String, IncomeAndExpenditureController.ReportLine> buildReportLineHashMap(List<Transaction> transactions) throws Exception {
        HashMap<String, IncomeAndExpenditureController.ReportLine> reportLineHashMap = new HashMap<String, IncomeAndExpenditureController.ReportLine>();
        for (Transaction transaction : transactions) {
            String tt = transaction.getTransactionType();
            if (tt != null && tt.equals("cash_received")) {
                IncomeAndExpenditureController.ReportLine rl = reportLineHashMap.get("cash");
                if (rl == null) {
                    rl = new IncomeAndExpenditureController.ReportLine(null);
                    reportLineHashMap.put("cash", rl);
                    rl.setAmount(transaction.getCreditTotalAmount());
                    rl.setClassification("asset");
                    rl.setSubClassification("cash");
                    rl.setName("Cash at bank");
                    rl.setHideQuantityGross(true);
                } else {
                    rl.addAmount(transaction.getCreditTotalAmount());
                }
            } else if (tt != null && (tt.equals("cash_payment") || tt.equals("pay_slip"))) {
                IncomeAndExpenditureController.ReportLine rl = reportLineHashMap.get("cash");
                if (rl == null) {
                    rl = new IncomeAndExpenditureController.ReportLine(null);
                    reportLineHashMap.put("cash", rl);
                    rl.setAmount(transaction.getCreditTotalAmount());
                    rl.setClassification("asset");
                    rl.setSubClassification("cash");
                    rl.setName("Cash at bank");
                    rl.setHideQuantityGross(true);
                } else {
                    rl.addAmount(transaction.getCreditTotalAmount());
                }
            } else if (tt != null && (tt.equals("sales_invoice") || tt.equals("sales_credit"))) {
                IncomeAndExpenditureController.ReportLine rl = reportLineHashMap.get("accountsreceivable");
                if (rl == null) {
                    rl = new IncomeAndExpenditureController.ReportLine(null);
                    reportLineHashMap.put("accountsreceivable", rl);
                    rl.setAmount(transaction.getCreditTotalAmount());
                    rl.setClassification("asset");
                    rl.setSubClassification("accountsreceivable");
                    rl.setName("Accounts receivable");
                    rl.setHideQuantityGross(true);
                } else {
                    rl.addAmount(transaction.getCreditTotalAmount());
                }
            } else if (tt != null && (tt.equals("purchase_invoice") || tt.equals("purchase_credit"))) {
                IncomeAndExpenditureController.ReportLine rl = reportLineHashMap.get("accountspayable");
                if (rl == null) {
                    rl = new IncomeAndExpenditureController.ReportLine(null);
                    reportLineHashMap.put("accountspayable", rl);
                    rl.setAmount(transaction.getCreditTotalAmount());
                    rl.setClassification("liability");
                    rl.setSubClassification("accountspayable");
                    rl.setName("Accounts payable");
                    rl.setHideQuantityGross(true);
                } else {
                    rl.addAmount(transaction.getCreditTotalAmount());
                }
            }
            for (int i = 0; i < transaction.getTransactionLineCount(); ++i) {
                IncomeAndExpenditureController.ReportLine rl;
                String pi;
                IncomeAndExpenditureController.ReportLine rl2;
                TransactionLine tl = transaction.getTransactionLine(i);
                Account a = tl.getAccount();
                String ai = null;
                if (a != null) {
                    ai = a.getAccountIdentifier();
                }
                if (ai != null && !ai.isEmpty()) {
                    IncomeAndExpenditureController.ReportLine prl;
                    String pi2;
                    rl2 = reportLineHashMap.get(ai);
                    if (rl2 == null) {
                        rl2 = new IncomeAndExpenditureController.ReportLine(a);
                        reportLineHashMap.put(ai, rl2);
                        rl2.setAmount(tl.getDebitAmount(tt));
                        rl2.setQuantity(tl.getDebitQuantity(tt));
                        String cref = a.getAccountClassificationReference();
                        if (cref != null && (cref.equals("income") || cref.equals("expense") || cref.equals("distribution"))) {
                            rl2.setClassification("expense");
                        } else {
                            rl2.setClassification(cref);
                        }
                    } else {
                        rl2.addAmount(tl.getDebitAmount(tt));
                        rl2.addQuantity(tl.getDebitQuantity(tt));
                    }
                    rl2.addTransactionLine(tt, tl);
                    Provision p = tl.getProvision();
                    if (p == null || (pi2 = p.getProvisionIdentifier()) == null || pi2.isEmpty()) continue;
                    String pgroup = "unknown";
                    Transaction pt = this.applicationController.getProvisionTransaction(pi2);
                    if (pt != null) {
                        String pclass = pt.getProvisionGrossBASClassification();
                        if (pclass == null || pclass.isEmpty() || pclass.equals("NA")) {
                            pclass = pt.getProvisionTaxPSClassification();
                        }
                        if (pclass != null && !pclass.isEmpty()) {
                            pgroup = this.basgroups.get(pclass);
                        }
                        if (pgroup == null || pgroup.isEmpty()) {
                            pgroup = "unknown";
                        }
                    }
                    if ((prl = reportLineHashMap.get("p_" + pgroup)) == null) {
                        prl = new IncomeAndExpenditureController.ReportLine(null, p);
                        reportLineHashMap.put("p_" + pgroup, prl);
                        prl.setAmount(tl.getDebitProvisionAmount(tt));
                        prl.setQuantity(tl.getDebitQuantity(tt));
                        prl.setClassification(p.getProvisionClassificationReference());
                        prl.setHideQuantityGross(true);
                        prl.setName(pgroup);
                    } else {
                        prl.addAmount(tl.getDebitProvisionAmount(tt));
                        prl.addQuantity(tl.getDebitQuantity(tt));
                    }
                    prl.addProvisionIdentifier(pi2);
                    continue;
                }
                if (tt != null && tt.equals("cash_received")) {
                    rl2 = reportLineHashMap.get("accountsreceivable");
                    if (rl2 == null) {
                        rl2 = new IncomeAndExpenditureController.ReportLine(null);
                        reportLineHashMap.put("accountsreceivable", rl2);
                        rl2.setAmount(tl.getDebitAmount("cash_received"));
                        rl2.setClassification("asset");
                        rl2.setSubClassification("accountsreceivable");
                        rl2.setHideQuantityGross(true);
                    } else {
                        rl2.addAmount(tl.getDebitAmount("cash_received"));
                    }
                } else if (tt != null && tt.equals("cash_payment")) {
                    rl2 = reportLineHashMap.get("accountspayable");
                    if (rl2 == null) {
                        rl2 = new IncomeAndExpenditureController.ReportLine(null);
                        reportLineHashMap.put("accountspayable", rl2);
                        rl2.setAmount(tl.getDebitAmount("cash_payment"));
                        rl2.setClassification("liability");
                        rl2.setSubClassification("accountspayable");
                        rl2.setHideQuantityGross(true);
                    } else {
                        rl2.addAmount(tl.getDebitAmount("cash_payment"));
                    }
                }
                Provision p = tl.getProvision();
                if (p == null || (pi = p.getProvisionIdentifier()) == null || pi.isEmpty()) continue;
                String pgroup = "unknown";
                Transaction pt = this.applicationController.getProvisionTransaction(pi);
                if (pt != null) {
                    String pclass = pt.getProvisionGrossBASClassification();
                    if (pgroup == null || pgroup.isEmpty() || pgroup.equals("NA")) {
                        pclass = pt.getProvisionTaxPSClassification();
                    }
                    if (pclass != null && !pclass.isEmpty()) {
                        pgroup = this.basgroups.get(pclass);
                    }
                    if (pgroup == null || pgroup.isEmpty()) {
                        pgroup = "unknown";
                    }
                }
                if ((rl = reportLineHashMap.get("p_" + pgroup)) == null) {
                    rl = new IncomeAndExpenditureController.ReportLine(null, p);
                    reportLineHashMap.put("p_" + pi, rl);
                    rl.setAmount(tl.getDebitProvisionAmount(tt));
                    rl.setQuantity(tl.getDebitQuantity(tt));
                    rl.setClassification(p.getProvisionClassificationReference());
                    rl.setHideQuantityGross(true);
                    rl.setName(pgroup);
                } else {
                    rl.addAmount(tl.getDebitProvisionAmount(tt));
                    rl.addQuantity(tl.getDebitQuantity(tt));
                }
                rl.addProvisionIdentifier(pi);
            }
        }
        return reportLineHashMap;
    }

    @Override
    public void addTotalLines(HashMap<String, IncomeAndExpenditureController.ReportLine> reportLineHashMap) throws Exception {
        HashSet<String> removeLines = new HashSet<String>();
        IncomeAndExpenditureController.ReportLine assetHeader = new IncomeAndExpenditureController.ReportLine(null);
        assetHeader.setClassification("assetheader");
        assetHeader.setName("Assets");
        IncomeAndExpenditureController.ReportLine totalAsset = new IncomeAndExpenditureController.ReportLine(null);
        totalAsset.setClassification("totalasset");
        totalAsset.setSubClassification("totalasset");
        totalAsset.setName("Total assets");
        totalAsset.setHideQuantityGross(true);
        IncomeAndExpenditureController.ReportLine liabilityHeader = new IncomeAndExpenditureController.ReportLine(null);
        liabilityHeader.setClassification("liabilityheader");
        liabilityHeader.setName("Liabilities");
        IncomeAndExpenditureController.ReportLine totalLiability = new IncomeAndExpenditureController.ReportLine(null);
        totalLiability.setClassification("totalliability");
        totalLiability.setSubClassification("totalliability");
        totalLiability.setName("Total liabilities");
        totalLiability.setHideQuantityGross(true);
        IncomeAndExpenditureController.ReportLine netAssets = new IncomeAndExpenditureController.ReportLine(null);
        netAssets.setClassification("netassets");
        netAssets.setSubClassification("netassets");
        netAssets.setName("Net assets");
        netAssets.setHideQuantityGross(true);
        IncomeAndExpenditureController.ReportLine equityHeader = new IncomeAndExpenditureController.ReportLine(null);
        equityHeader.setClassification("equityheader");
        equityHeader.setName("Equity");
        IncomeAndExpenditureController.ReportLine totalEquity = new IncomeAndExpenditureController.ReportLine(null);
        totalEquity.setClassification("totalequity");
        totalEquity.setSubClassification("totalequity");
        totalEquity.setName("Total equity");
        totalEquity.setHideQuantityGross(true);
        IncomeAndExpenditureController.ReportLine retainedEarnings = new IncomeAndExpenditureController.ReportLine(null);
        retainedEarnings.setClassification("retainedearnings");
        retainedEarnings.setSubClassification("retainedearnings");
        retainedEarnings.setName("Retained earnings");
        retainedEarnings.setHideQuantityGross(true);
        for (String key : reportLineHashMap.keySet()) {
            Double tmp;
            IncomeAndExpenditureController.ReportLine rl = reportLineHashMap.get(key);
            String classification = rl.getClassification();
            if (classification != null && (classification.equals("income") || classification.equals("expense") || classification.equals("distribution") || classification.equals("retainedearnings"))) {
                tmp = rl.getGrossAsDoubleCalc();
                if (tmp != null) {
                    retainedEarnings.addAmount(tmp);
                    totalEquity.addAmount(tmp);
                }
                if ((tmp = rl.getQuantityAsDoubleCalc()) != null) {
                    retainedEarnings.addQuantity(tmp);
                    totalEquity.addQuantity(tmp);
                }
                retainedEarnings.addTransactionLines("cash_payment", rl.getTransactionLines());
                totalEquity.addTransactionLines("cash_payment", rl.getTransactionLines());
                removeLines.add(key);
                continue;
            }
            if (classification != null && classification.equals("asset")) {
                tmp = rl.getGrossAsDoubleCalc();
                if (tmp != null) {
                    totalAsset.addAmount(tmp);
                    netAssets.addAmount(tmp);
                }
                if ((tmp = rl.getQuantityAsDoubleCalc()) != null) {
                    totalAsset.addQuantity(tmp);
                    netAssets.addQuantity(tmp);
                }
                if (rl.getAccountIdentifier() == null) continue;
                totalAsset.addTransactionLines("cash_payment", rl.getTransactionLines());
                netAssets.addTransactionLines("cash_payment", rl.getTransactionLines());
                continue;
            }
            if (classification != null && classification.equals("liability")) {
                tmp = rl.getGrossAsDoubleCalc();
                if (tmp != null) {
                    totalLiability.addAmount(-tmp.doubleValue());
                    netAssets.addAmount(-tmp.doubleValue());
                }
                if ((tmp = rl.getQuantityAsDoubleCalc()) != null) {
                    totalLiability.addQuantity(-tmp.doubleValue());
                    netAssets.addQuantity(-tmp.doubleValue());
                }
                if (rl.getAccountIdentifier() == null) continue;
                totalLiability.addTransactionLines("cash_payment", rl.getTransactionLines());
                netAssets.addTransactionLines("cash_payment", rl.getTransactionLines());
                continue;
            }
            if (classification == null || !classification.equals("equity")) continue;
            tmp = rl.getGrossAsDoubleCalc();
            if (tmp != null) {
                totalEquity.addAmount(-tmp.doubleValue());
            }
            if ((tmp = rl.getQuantityAsDoubleCalc()) != null) {
                totalEquity.addQuantity(-tmp.doubleValue());
            }
            if (rl.getAccountIdentifier() == null) continue;
            totalEquity.addTransactionLines("cash_payment", rl.getTransactionLines());
        }
        reportLineHashMap.put("assetheader", assetHeader);
        reportLineHashMap.put("totalasset", totalAsset);
        reportLineHashMap.put("liabilityheader", liabilityHeader);
        reportLineHashMap.put("totalliability", totalLiability);
        reportLineHashMap.put("netassets", netAssets);
        reportLineHashMap.put("equityheader", equityHeader);
        reportLineHashMap.put("retainedearnings", retainedEarnings);
        reportLineHashMap.put("totalequity", totalEquity);
        for (String key : removeLines) {
            reportLineHashMap.remove(key);
        }
    }

    @Override
    public void gotoIncomeAndExpenditureAccountDetail(String ai) {
        try {
            this.applicationController.gotoBalanceSheetAccountDetail(ai, this.filterToDate.getLocalDate(), this.counterpartyIdentifier.getGlenixElementValue(), this.provisionIdentifier.getGlenixElementValue());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @Override
    public void gotoIncomeAndExpenditureProvisionDetail(String pi) {
        try {
            this.applicationController.gotoBalanceSheetProvisionDetail(pi, this.filterToDate.getLocalDate(), this.counterpartyIdentifier.getGlenixElementValue(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    public void gotoIncomeAndExpenditureProvisionDetail(Set<String> pi) {
        try {
            this.applicationController.gotoBalanceSheetProvisionDetail(pi, this.filterToDate.getLocalDate(), this.counterpartyIdentifier.getGlenixElementValue(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    private /* synthetic */ void lambda$null$0(TableRow row, MouseEvent event) {
        IncomeAndExpenditureController.ReportLine reportItem;
        if (event.getClickCount() == 2 && !row.isEmpty() && (reportItem = (IncomeAndExpenditureController.ReportLine)row.getItem()) != null) {
            String ai = reportItem.getAccountIdentifier();
            if (ai != null && !ai.isEmpty()) {
                this.gotoIncomeAndExpenditureAccountDetail(ai);
            } else {
                Set<String> pis = reportItem.getProvisionIdentifiers();
                if (pis != null && pis.size() > 0) {
                    this.gotoIncomeAndExpenditureProvisionDetail(pis);
                } else {
                    String pi = reportItem.getProvisionIdentifier();
                    if (pi != null && !pi.isEmpty()) {
                        this.gotoIncomeAndExpenditureProvisionDetail(pi);
                    } else {
                        try {
                            String subc = reportItem.getSubClassification();
                            if (subc != null && subc.equals("cash")) {
                                this.applicationController.gotoBankReconciliationE(null, null, null, this.lastMaxDate, null);
                            } else if (subc != null && subc.equals("accountsreceivable")) {
                                this.applicationController.gotoReceiveMoneyE(null, null, null, this.lastMaxDate, null);
                            } else if (subc != null && subc.equals("accountspayable")) {
                                this.applicationController.gotoPayMoneyE(null, null, null, this.lastMaxDate, null);
                            }
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            this.error_message.setText(e.getMessage());
                            this.applicationController.setStatusBarMessage(e.getMessage());
                        }
                    }
                }
            }
        }
    }
}

