/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ApplicationController;
import au.com.glenix.cloud.ProfitAndLossAccountDetailController;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixLabelTwoDecimalNumber;
import java.net.URL;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ResourceBundle;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.util.Callback;

public class BalanceSheetAccountDetailController
extends ProfitAndLossAccountDetailController {
    @FXML
    protected TableColumn accountNameColumn;
    @FXML
    protected TableColumn reconciliationDetailsAndAmountColumn;
    @FXML
    protected GlenixLabelTwoDecimalNumber statement_balance;
    @FXML
    protected GlenixLabelText statement_description;

    public BalanceSheetAccountDetailController(ApplicationController applicationController) {
        super(applicationController);
    }

    @Override
    public void updateHeading() {
        if (this.account == null) {
            this.page_heading.setText("Account reconciliation");
            this.setGlenixElementDescription("Account reconciliation");
        } else {
            this.page_heading.setText(this.account.getAccountName() + " - reconciliation");
            this.setGlenixElementDescription(this.account.getAccountName() + " - reconciliation");
            String classification = this.account.getAccountClassificationReference();
            this.multiplier = 1;
            if (classification != null && (classification.equals("income") || classification.equals("netincome") || classification.equals("totalincome") || classification.equals("equity") || classification.equals("distribution") || classification.equals("liability") || classification.equals("totalliability") || classification.equals("totalequity"))) {
                this.multiplier = -1;
            }
        }
    }

    public void setupReconciliationDetailsColumn() {
        if (this.reconciliationDetailsAndAmountColumn != null) {
            this.reconciliationDetailsAndAmountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                Transaction.TransactionTransactionLine ttl;
                                boolean isset = false;
                                if (item != null && !item.isEmpty() && (ttl = (Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())) != null) {
                                    LocalDate recdate = ttl.getReconciliationMaxDateAsDate();
                                    Double amount = ttl.getReconciliationAmount();
                                    if (recdate != null && amount != null) {
                                        if (BalanceSheetAccountDetailController.this.multiplier < 0) {
                                            amount = -amount.doubleValue();
                                        }
                                        item = item + " (" + BalanceSheetAccountDetailController.this.outputDateFormatter.format(recdate) + ", " + BalanceSheetAccountDetailController.this.formatTwoDp.format(amount) + ")";
                                        this.setText(item);
                                        isset = true;
                                    }
                                }
                                if (!isset) {
                                    this.setText("null");
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        if (this.accountNameColumn != null) {
            this.accountNameColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                boolean isset = false;
                                if (item != null) {
                                    try {
                                        Transaction ct = BalanceSheetAccountDetailController.this.applicationController.getAccountTransaction(item);
                                        if (ct != null) {
                                            this.setText(ct.getAccountName());
                                            isset = true;
                                        }
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                    }
                                }
                                if (!isset) {
                                    this.setText("null");
                                }
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        this.setupReconciliationDetailsColumn();
        this.statement_balance.addTextChangeListener(new ChangeListener<String>(){

            public void changed(ObservableValue<? extends String> observable, String oldValue, String newValue) {
                BalanceSheetAccountDetailController.this.updateTotalLabelStyle();
            }
        });
    }

    @FXML
    protected void backToBalanceSheet() {
        try {
            this.applicationController.gotoBalanceSheet(this.filterToDate.getLocalDate(), this.filterCounterpartyIdentifier.getGlenixElementValue(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    protected LocalDate calcFromDate(LocalDate maxDate) {
        if (maxDate == null) {
            return null;
        }
        String dmStr = this.displayMonths.getGlenixElementValue();
        Integer dm = 0;
        if (dmStr != null && !dmStr.isEmpty()) {
            try {
                dm = Integer.parseInt(dmStr);
            }
            catch (Exception e) {
                e.printStackTrace();
                dm = 0;
            }
        }
        if (dm == null || dm == 0) {
            return maxDate.plusDays(1L);
        }
        LocalDate minDate = maxDate.withDayOfMonth(1);
        if (dm > 1) {
            return minDate.minusMonths(dm - 1);
        }
        return minDate;
    }

    @Override
    @FXML
    protected void updateFilterReload() {
        if (this.account == null) {
            this.error_message.setText("Error, account is not set.");
            this.applicationController.setStatusBarMessage("Error, account is not set.");
            return;
        }
        String ai = this.account.getAccountIdentifier();
        if (ai == null || ai.isEmpty()) {
            this.error_message.setText("Error, account identifier is not set.");
            this.applicationController.setStatusBarMessage("Error, account identifier is not set.");
            return;
        }
        String filterTextValue = null;
        if (this.filterText != null) {
            filterTextValue = this.filterText.getText();
        }
        LocalDate toDateValue = null;
        if (this.filterToDate != null) {
            this.lastMaxDate = toDateValue = this.filterToDate.getLocalDate();
        }
        LocalDate fromDateValue = this.calcFromDate(toDateValue);
        String ci = null;
        if (this.filterCounterpartyIdentifier != null) {
            ci = this.filterCounterpartyIdentifier.getGlenixElementValue();
        }
        String pi = null;
        if (this.filterProvisionIdentifier != null) {
            pi = this.filterProvisionIdentifier.getGlenixElementValue();
        }
        try {
            ArrayList<Transaction.TransactionTransactionLine> ttl = this.applicationController.getTransactionLineListByAccountReconciliation(ai, null, fromDateValue, toDateValue, ci, pi);
            this.transactionLineObservableList = FXCollections.observableList(ttl);
            this.setTransactionObservableList((ObservableList<Transaction.TransactionTransactionLine>)this.transactionLineObservableList);
            this.updateFilter(filterTextValue, null, toDateValue, ci, pi);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
            return;
        }
    }

    @Override
    protected void updateFilter(String newValue, LocalDate fromDate, LocalDate toDate, String ci, String pi) {
        this.filteredItems.setPredicate(ttl -> {
            String formattedDate;
            String pid;
            String ttlpi;
            String ttlci;
            LocalDate localDate = ttl.getTransactionDateAsDate();
            if (fromDate != null || toDate != null) {
                if (localDate == null) {
                    return false;
                }
                if (fromDate != null && localDate.isBefore(fromDate)) {
                    return false;
                }
                if (toDate != null && localDate.isAfter(toDate)) {
                    return false;
                }
            }
            if (!(ci == null || ci.isEmpty() || (ttlci = ttl.getCounterpartyIdentifier()) != null && ttlci.equals(ci))) {
                return false;
            }
            if (!(pi == null || pi.isEmpty() || (ttlpi = ttl.getProvisionIdentifier()) != null && ttlpi.equals(pi))) {
                return false;
            }
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String transactionComment = ttl.getTransactionCommentLineComment();
            if (transactionComment != null && transactionComment.toLowerCase().contains(newValue.toLowerCase())) {
                return true;
            }
            String cid = ttl.getCounterpartyIdentifier();
            if (cid != null && !cid.isEmpty()) {
                try {
                    String cname;
                    Transaction ct = this.applicationController.getCounterpartyTransaction(cid);
                    if (ct != null && (cname = ct.getCounterpartyLegalName()) != null && !cname.isEmpty() && cname.toLowerCase().contains(newValue.toLowerCase())) {
                        return true;
                    }
                }
                catch (Exception ct) {
                    // empty catch block
                }
            }
            if ((pid = ttl.getProvisionIdentifier()) != null && !pid.isEmpty()) {
                try {
                    String pname;
                    Transaction pt = this.applicationController.getProvisionTransaction(pid);
                    if (pt != null && (pname = pt.getProvisionName()) != null && !pname.isEmpty() && pname.toLowerCase().contains(newValue.toLowerCase())) {
                        return true;
                    }
                }
                catch (Exception pt) {
                    // empty catch block
                }
            }
            if (localDate != null && (formattedDate = this.displayDateFormatter.format(localDate)) != null && !formattedDate.isEmpty() && formattedDate.toLowerCase().contains(newValue.toLowerCase())) {
                return true;
            }
            String recDet = ttl.getReconciliationDetailsAndAmount();
            return recDet != null && !recDet.isEmpty() && recDet.toLowerCase().contains(newValue.toLowerCase());
        });
        this.updateTotalAmount();
    }

    @Override
    protected void updateTotalLabel() {
        if (this.total_label == null) {
            return;
        }
        super.updateTotalLabel();
        this.updateTotalLabelStyle();
    }

    protected void updateTotalLabelStyle() {
        if (this.totalSelectedCount == 0) {
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"success"});
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"error"});
            return;
        }
        Double bb = this.statement_balance.getDouble();
        if (bb == null) {
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"success"});
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"error"});
        } else if (bb.equals(this.totalSelectedAmount)) {
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"error"});
            this.total_label.getStyleClass().add((Object)"success");
        } else {
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"success"});
            this.total_label.getStyleClass().add((Object)"error");
        }
    }

    @FXML
    protected void splitSelectedTransactions() {
        try {
            boolean hasselected = false;
            StringBuilder trsb = new StringBuilder();
            for (Transaction.TransactionTransactionLine ttl : this.incomeAndExpenditure.getSelectionModel().getSelectedItems()) {
                String tn;
                if (hasselected) {
                    trsb.append(",");
                }
                if ((tn = ttl.getTransactionNumber()) == null || tn.isEmpty()) continue;
                String tln = ttl.getLineNumber();
                if (tln != null && !tln.isEmpty()) {
                    trsb.append(tn + "|" + tln);
                } else {
                    trsb.append(tn);
                }
                hasselected = true;
            }
            if (!hasselected) {
                throw new Exception("Error, no transactions selected.");
            }
            GlenixResult gr = this.applicationController.sendSplit(trsb.toString());
            if (gr == null) {
                throw new Exception("Error, unable to read post split response");
            }
            String resultCode = gr.getResultCode();
            if (resultCode == null) {
                throw new Exception("Error, unable to read post split response code");
            }
            if (!resultCode.equals("OK")) {
                throw new Exception(gr.getResultDescription());
            }
            this.error_message.setText("Split saved");
            this.applicationController.setStatusBarMessage("Split saved");
            this.clearSelection();
            this.updateFilterReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    protected void postReconcilation() {
        try {
            if (this.selectedRows == null || this.selectedRows.size() <= 0) {
                throw new Exception("Error, no transactions selected.");
            }
            StringBuilder rrsb = new StringBuilder();
            boolean hasselected = false;
            for (Transaction.TransactionTransactionLine rr : this.selectedRows) {
                if (hasselected) {
                    rrsb.append(",");
                }
                rrsb.append(rr.getReconciliationNumber());
                hasselected = true;
            }
            GlenixResult gr = this.applicationController.sendReconcile(rrsb.toString());
            if (gr == null) {
                throw new Exception("Error, unable to read post reconciliation response");
            }
            String resultCode = gr.getResultCode();
            if (resultCode == null) {
                throw new Exception("Error, unable to read post reconciliation response code");
            }
            if (!resultCode.equals("OK")) {
                throw new Exception(gr.getResultDescription());
            }
            this.error_message.setText("Reconciliation saved");
            this.applicationController.setStatusBarMessage("Reconciliation saved");
            this.statement_balance.setText(null);
            this.statement_description.setText(null);
            this.clearSelection();
            this.updateFilterReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    protected void postStatementReconcilation() {
        try {
            GlenixResult gr;
            if (this.selectedRows == null || this.selectedRows.size() <= 0) {
                throw new Exception("Error, no transactions selected.");
            }
            Double bb = this.statement_balance.getDouble();
            StringBuilder rrsb = new StringBuilder();
            boolean hasselected = false;
            HashSet<String> recnos = new HashSet<String>();
            for (Transaction.TransactionTransactionLine rr : this.selectedRows) {
                recnos.add(rr.getReconciliationNumber());
            }
            for (String recno : recnos) {
                if (hasselected) {
                    rrsb.append(",");
                }
                rrsb.append(recno);
                hasselected = true;
            }
            if (!hasselected) {
                throw new Exception("Error, no transactions selected.");
            }
            if (this.totalSelectedAmount == null || !this.totalSelectedAmount.equals(bb)) {
                throw new Exception("Error, selected transactions do not equal statement balance.");
            }
            if (this.account == null) {
                throw new Exception("Error, account is not set.");
            }
            String ai = this.account.getAccountIdentifier();
            if (ai == null || ai.isEmpty()) {
                throw new Exception("Error, account identifier is not set.");
            }
            if (!this.totalSelectedAmount.equals(0.0)) {
                Transaction rect = this.applicationController.addTransaction();
                if (this.lastMaxDate == null) {
                    throw new Exception("Error, no date set. Select a date first.");
                }
                rect.setTransactionDate(this.lastMaxDate.format(DateTimeFormatter.ISO_LOCAL_DATE));
                rect.setTransactionType("general_journal");
                rect.setTransactionStatus("posted");
                String desc = this.statement_description.getGlenixElementValue();
                if (desc == null || desc.isEmpty()) {
                    desc = "Statement balance";
                }
                TransactionLine tl = rect.addBlankTransactionLine();
                tl.setAmount(-bb.doubleValue() * (double)this.multiplier);
                tl.setLineComment("Closing: " + desc);
                tl.setAccountIdentifier(ai);
                tl = rect.addBlankTransactionLine();
                tl.setAmount(bb * (double)this.multiplier);
                tl.setLineComment(desc);
                tl.setAccountIdentifier(ai);
                GlenixTrnXBRL gt = this.applicationController.saveTransactionGetXBRL(rect);
                Business sb = gt.getBusiness();
                if (sb == null) {
                    throw new Exception("Error, unable to save statement balance.");
                }
                Transaction saveT = sb.getTransaction(0);
                if (saveT == null) {
                    throw new Exception("Error, unable to save statement balance transaction.");
                }
                TransactionLine saveTl = saveT.getFirstTransactionLine();
                if (saveTl == null) {
                    throw new Exception("Error, unable to save statement balance transaction line.");
                }
                String stmrec = saveTl.getReconciliationNumber();
                if (stmrec == null || stmrec.isEmpty()) {
                    throw new Exception("Error, unable to get reconciliation reference for saved statement balance.");
                }
                rrsb.append(",");
                rrsb.append(stmrec);
            }
            if ((gr = this.applicationController.sendReconcile(rrsb.toString())) == null) {
                throw new Exception("Error, unable to read post reconciliation response");
            }
            String resultCode = gr.getResultCode();
            if (resultCode == null) {
                throw new Exception("Error, unable to read post reconciliation response code");
            }
            if (!resultCode.equals("OK")) {
                throw new Exception(gr.getResultDescription());
            }
            this.error_message.setText("Reconciliation saved");
            this.applicationController.setStatusBarMessage("Reconciliation saved");
            this.statement_balance.setText(null);
            this.statement_description.setText(null);
            this.clearSelection();
            this.updateFilterReload();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }
}

