/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ActivityStatementListController;
import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixSBRResponse;
import au.com.glenix.trn.ASLStatement;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.ActivityStatementList;
import au.com.glenix.trn.ActivityStatementListIntermediary;
import au.com.glenix.trn.ActivityStatementListResponse;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.widget.GlenixLabelLabel;
import javafx.application.Platform;
import javafx.fxml.FXML;
import org.w3c.dom.Document;

public class ActivityStatementListCloudController
extends ActivityStatementListController {
    @FXML
    private GlenixLabelLabel ssid;

    public ActivityStatementListCloudController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    @Override
    public void setModel(GlenixTrnXBRL glenixTrnXBRL) throws Exception {
        String status;
        ActivityStatementList asl;
        super.setModel(glenixTrnXBRL);
        String ssidStr = this.xbrlFileController.getSignedSoftwareSubscriptionIdentifier();
        if (ssidStr != null && !ssidStr.isEmpty()) {
            ssidStr = ssidStr.substring(0, 10);
        }
        this.ssid.setGlenixElementValue(ssidStr);
        if (glenixTrnXBRL != null && (asl = glenixTrnXBRL.getActivityStatementList()) != null && (status = asl.getSBRDocumentStatus()) != null && status.equals("list_in_progress")) {
            this.error_message.setText("List is in progress this page will refresh in 20 seconds");
            final ActivityStatementList checkASL = this.activityStatementList;
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(20000L);
                        Platform.runLater((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                ActivityStatementListCloudController.this.reloadPage(checkASL);
                            }
                        });
                    }
                    catch (Exception e) {
                        ActivityStatementListCloudController.this.error_message.setText(e.getMessage());
                    }
                }
            }).start();
            return;
        }
        this.error_message.setText(null);
    }

    protected void reloadPage(ActivityStatementList checkASL) {
        if (this.xbrlFileController.activityStatementListIsVisible() && checkASL == this.activityStatementList) {
            this.xbrlFileController.bustCacheActivityStatementList();
            try {
                GlenixTrnXBRL asl = this.xbrlFileController.getActivityStatementList();
                this.setModel(asl);
                return;
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
            }
        }
        this.error_message.setText(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FXML
    protected void activityStatementListDownloadAndPrefill() {
        try {
            String subdate;
            String intTAN;
            this.error_message.setText(null);
            this.downloadAndPrefillButton.disableProperty().set(true);
            String passwordStr = this.password.getGlenixElementValue();
            if (passwordStr == null || passwordStr.isEmpty()) {
                throw new Exception("Error, you must enter your login password");
            }
            if (!this.xbrlFileController.reverifyPassword(passwordStr.toCharArray())) {
                throw new Exception("Error, password is not correct");
            }
            this.password.setText(null);
            ActivityStatementList asl = new ActivityStatementList();
            String abn = this.activityStatementListABN.getGlenixElementValue();
            asl.setActivityStatementListABN(abn);
            asl.setOrganisationDetails_OrganisationBranch_Code(this.OrganisationDetails_OrganisationBranch_Code.getGlenixElementValue());
            String tfn = this.activityStatementListTFN.getGlenixElementValue();
            asl.setActivityStatementListTFN(tfn);
            asl.setStartDate(this.startDate.getGlenixElementValue());
            asl.setEndDate(this.endDate.getGlenixElementValue());
            String intABN = this.activityStatementListIntermediaryABN.getGlenixElementValue();
            if (intABN != null && !intABN.isEmpty()) {
                ActivityStatementListIntermediary activityStatementListIntermediary = asl.getActivityStatementListIntermediary();
                activityStatementListIntermediary.setActivityStatementListIntermediaryABN(intABN);
            }
            if ((intTAN = this.Identifiers_TaxAgentNumber_Identifier.getGlenixElementValue()) != null && !intTAN.isEmpty()) {
                ActivityStatementListIntermediary activityStatementListIntermediary = asl.getActivityStatementListIntermediary();
                activityStatementListIntermediary.setIdentifiers_TaxAgentNumber_Identifier(intTAN);
            }
            if ((subdate = this.Report_Submission_Date.getGlenixElementValue()) != null && !subdate.isEmpty()) {
                ActivityStatementListIntermediary activityStatementListIntermediary = asl.getActivityStatementListIntermediary();
                activityStatementListIntermediary.setReport_Submission_Date(subdate);
            }
            this.error_message.setText(null);
            GlenixSBRResponse response = this.xbrlFileController.saveActivityStatementListDownload(asl);
            response.parseResponse();
            Document resdoc = response.getDocumentByHref("res.xml");
            if (resdoc == null) {
                throw new Exception("Error, unable to get activity statement list, cannot read response from server");
            }
            GlenixResult gr = new GlenixResult();
            gr.loadDocumentElement(resdoc, resdoc.getDocumentElement());
            String resultCode = gr.getResultCode();
            String resultDescription = gr.getResultDescription();
            if (resultCode == null || resultCode.isEmpty() || !resultCode.equals("OK")) {
                if (resultCode != null && !resultCode.isEmpty()) {
                    if (resultDescription != null && !resultDescription.isEmpty()) {
                        throw new Exception(resultCode + " - " + resultDescription);
                    }
                    throw new Exception("Error, activity statement list failed with result code: " + resultCode);
                }
                if (resultDescription != null && !resultDescription.isEmpty()) {
                    throw new Exception(resultDescription);
                }
                throw new Exception("Error, activity statement list failed with no result code");
            }
            this.error_message.setText("Activity statement list and prefill has been submitted. Please reload this page by clicking on Reports -> Activity statement, in about 20 seconds to check on the progress.");
            this.activityStatementList.setSBRDocumentStatus("list_in_progress");
            this.setModel(this.glenixTrnXBRL);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        finally {
            this.downloadAndPrefillButton.disableProperty().set(false);
        }
    }

    @Override
    @FXML
    protected void reviseSelectedActivityStatement() {
        ASLStatement aslStatement = (ASLStatement)this.aslStatementTable.getSelectionModel().getSelectedItem();
        if (aslStatement == null) {
            this.error_message.setText("No activity statement selected. Select an Activity Statement to revise.");
            this.xbrlFileController.setStatusBarMessage("No activity statement selected. Select an Activity Statement to revise.");
            return;
        }
        try {
            String asNumber = aslStatement.getActivityStatementNumber();
            ActivityStatementListResponse activityStatementListResponse = this.activityStatementList.getActivityStatementListResponse();
            if (activityStatementListResponse == null) {
                throw new Exception("No activity statements are listed yet.");
            }
            ASLStatement prevRevisedAS = activityStatementListResponse.getASLRByOriginalASNumber(asNumber);
            if (prevRevisedAS != null) {
                throw new Exception("Error, this Activity Statement has already been revised.");
            }
            GlenixTrnXBRL asXBRL = this.xbrlFileController.loadActivityStatementCheckCacheNoDefault(asNumber);
            if (asXBRL == null) {
                throw new Exception("Error, you cannot revise this activity statement as you have not lodged it yet.");
            }
            ActivityStatement as = asXBRL.getActivityStatement();
            if (as == null) {
                throw new Exception("Error, you cannot revise this activity statement as you have not lodged it yet.");
            }
            String status = as.getSBRDocumentStatus();
            if (status == null || !status.equals("lodge_complete")) {
                throw new Exception("Error, you cannot revise this activity statement as you have not lodged it yet.");
            }
            ASLStatement revisedASLStatement = activityStatementListResponse.reviseASLStatementByAsNumber(asNumber);
            String revisedASNumber = revisedASLStatement.getActivityStatementNumber();
            GlenixTrnXBRL buildASLStatementAndAS = new GlenixTrnXBRL();
            Document doc = asXBRL.buildDocument();
            buildASLStatementAndAS.loadDocumentElement(doc, doc.getDocumentElement());
            ActivityStatement revisedAS = buildASLStatementAndAS.getActivityStatement();
            if (revisedAS == null) {
                throw new Exception("Error, an error has occured in revising the activity statement");
            }
            revisedAS.setActivityStatementNumber(revisedASNumber);
            revisedAS.setOriginalActivityStatementNumber(asNumber);
            revisedAS.setSBRDocumentStatus("prefill_complete");
            revisedAS.removeEventMessages();
            revisedAS.setReportStatementRevisionIndicator("true");
            doc = revisedASLStatement.buildDocumentBusiness();
            Business b = buildASLStatementAndAS.getBusiness();
            b.loadDocumentElement(doc, doc.getDocumentElement());
            ActivityStatementList asl = b.getActivityStatementList();
            ActivityStatementListResponse aslr = asl.getActivityStatementListResponse();
            aslr.setActivityStatementListABN(activityStatementListResponse.getActivityStatementListABN());
            aslr.setActivityStatementListTFN(activityStatementListResponse.getActivityStatementListTFN());
            aslr.setOrganisationDetails_OrganisationBranch_Code(activityStatementListResponse.getOrganisationDetails_OrganisationBranch_Code());
            aslr.setStartDate(activityStatementListResponse.getStartDate());
            aslr.setEndDate(activityStatementListResponse.getEndDate());
            this.error_message.setText(null);
            GlenixSBRResponse response = this.xbrlFileController.saveFileEncryptGetResponse("activityStatement.xml", buildASLStatementAndAS.buildSignableDocument());
            response.parseResponse();
            Document resdoc = response.getDocumentByHref("echo.xml");
            if (resdoc == null) {
                throw new Exception("Error, unable to save revised activity statement, cannot read response from server");
            }
            this.reloadPage(this.activityStatementList);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }
}

