/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix.cloud;

import au.com.glenix.ActivityStatementController;
import au.com.glenix.ApplicationController;
import au.com.glenix.GlenixSBRResponse;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.widget.GlenixLabelLabel;
import javafx.fxml.FXML;
import org.w3c.dom.Document;

public class ActivityStatementCloudController
extends ActivityStatementController {
    @FXML
    private GlenixLabelLabel ssid;

    public ActivityStatementCloudController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    @Override
    public void setModel(GlenixTrnXBRL glenixTrnXBRL) throws Exception {
        super.setModel(glenixTrnXBRL);
        String ssidStr = this.xbrlFileController.getSignedSoftwareSubscriptionIdentifier();
        if (ssidStr != null && !ssidStr.isEmpty()) {
            ssidStr = ssidStr.substring(0, 10);
        }
        this.ssid.setGlenixElementValue(ssidStr);
        this.error_message.setText(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FXML
    public void activityStatementPrelodge() {
        if (this.activityStatement == null) {
            this.xbrlFileController.setStatusBarMessage("Error, activity statement is null, save first.");
            this.error_message.setText("Error, activity statement is null, save first.");
            return;
        }
        try {
            String passwordStr = this.password.getGlenixElementValue();
            if (passwordStr == null || passwordStr.isEmpty()) {
                throw new Exception("Error, you must enter your login password");
            }
            if (!this.xbrlFileController.reverifyPassword(passwordStr.toCharArray())) {
                throw new Exception("Error, password is not correct");
            }
            this.error_message.setText("Begin prelodge validation");
            this.xbrlFileController.setStatusBarMessage("Begin prelodge validation");
            this.saveButton.disableProperty().set(true);
            this.prelodgeButton.disableProperty().set(true);
            this.lodgeButton.disableProperty().set(true);
            this.activityStatementSaveEnteredData();
            this.activityStatement.setSBRDocumentStatus("prelodge_in_progress");
            GlenixSBRResponse response = this.xbrlFileController.saveAndPrelodgeActivityStatement(this.glenixTrnXBRL);
            response.parseResponse();
            Document resdoc = response.getDocumentByHref("res.xml");
            if (resdoc == null) {
                throw new Exception("Error, unable to read response from server");
            }
            GlenixResult gr = new GlenixResult();
            gr.loadDocumentElement(resdoc, resdoc.getDocumentElement());
            String resultCode = gr.getResultCode();
            String resultDescription = gr.getResultDescription();
            if (resultCode == null || resultCode.isEmpty() || !resultCode.equals("OK")) {
                if (resultCode != null && !resultCode.isEmpty()) {
                    if (resultDescription != null && !resultDescription.isEmpty()) {
                        throw new Exception(resultCode + " - " + resultDescription);
                    }
                    throw new Exception("Error, save failed with result code: " + resultCode);
                }
                if (resultDescription != null && !resultDescription.isEmpty()) {
                    throw new Exception(resultDescription);
                }
                throw new Exception("Error, save failed with no result code");
            }
            Document datadoc = response.getDocumentByHref("data.xml");
            if (datadoc == null) {
                throw new Exception("Error, unable to get activity statement, cannot read response from server");
            }
            GlenixTrnXBRL glenixTrnXBRLActivityStatement = new GlenixTrnXBRL();
            glenixTrnXBRLActivityStatement.loadDocumentElement(datadoc, datadoc.getDocumentElement());
            this.setModel(glenixTrnXBRLActivityStatement);
            ActivityStatement as = glenixTrnXBRLActivityStatement.getActivityStatement();
            if (as != null) {
                String status = as.getSBRDocumentStatus();
                if (status != null && status.equals("prelodge_complete")) {
                    this.error_message.setText("Prelodge validate complete");
                } else {
                    this.error_message.setText("Preodge failed, check messages");
                }
            }
            this.setProfileDetails(this.xbrlFileController.getProfileXBRL());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        finally {
            this.saveButton.disableProperty().set(false);
            this.prelodgeButton.disableProperty().set(false);
            this.lodgeButton.disableProperty().set(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @FXML
    public void activityStatementLodge() {
        if (this.activityStatement == null) {
            this.xbrlFileController.setStatusBarMessage("Error, activity statement is null, save first.");
            this.error_message.setText("Error, activity statement is null, save first.");
            return;
        }
        try {
            String passwordStr = this.password.getGlenixElementValue();
            if (passwordStr == null || passwordStr.isEmpty()) {
                throw new Exception("Error, you must enter your login password");
            }
            if (!this.xbrlFileController.reverifyPassword(passwordStr.toCharArray())) {
                throw new Exception("Error, password is not correct");
            }
            this.error_message.setText("Begin lodge");
            this.xbrlFileController.setStatusBarMessage("Begin lodge");
            this.saveButton.disableProperty().set(true);
            this.prelodgeButton.disableProperty().set(true);
            this.lodgeButton.disableProperty().set(true);
            this.activityStatementSaveEnteredData();
            this.activityStatement.setSBRDocumentStatus("lodge_in_progress");
            GlenixSBRResponse response = this.xbrlFileController.saveAndLodgeActivityStatement(this.glenixTrnXBRL);
            response.parseResponse();
            Document resdoc = response.getDocumentByHref("res.xml");
            if (resdoc == null) {
                throw new Exception("Error, unable to read response from server");
            }
            GlenixResult gr = new GlenixResult();
            gr.loadDocumentElement(resdoc, resdoc.getDocumentElement());
            String resultCode = gr.getResultCode();
            String resultDescription = gr.getResultDescription();
            if (resultCode == null || resultCode.isEmpty() || !resultCode.equals("OK")) {
                if (resultCode != null && !resultCode.isEmpty()) {
                    if (resultDescription != null && !resultDescription.isEmpty()) {
                        throw new Exception(resultCode + " - " + resultDescription);
                    }
                    throw new Exception("Error, save failed with result code: " + resultCode);
                }
                if (resultDescription != null && !resultDescription.isEmpty()) {
                    throw new Exception(resultDescription);
                }
                throw new Exception("Error, save failed with no result code");
            }
            Document datadoc = response.getDocumentByHref("data.xml");
            if (datadoc == null) {
                throw new Exception("Error, unable to get activity statement, cannot read response from server");
            }
            GlenixTrnXBRL glenixTrnXBRLActivityStatement = new GlenixTrnXBRL();
            glenixTrnXBRLActivityStatement.loadDocumentElement(datadoc, datadoc.getDocumentElement());
            this.setModel(glenixTrnXBRLActivityStatement);
            ActivityStatement as = glenixTrnXBRLActivityStatement.getActivityStatement();
            if (as != null) {
                String status = as.getSBRDocumentStatus();
                if (status != null && status.equals("lodge_complete")) {
                    this.error_message.setText("Lodge complete");
                } else {
                    this.error_message.setText("Lodge failed, check messages");
                }
            }
            this.setProfileDetails(this.xbrlFileController.getProfileXBRL());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        finally {
            this.saveButton.disableProperty().set(false);
            this.prelodgeButton.disableProperty().set(false);
            this.lodgeButton.disableProperty().set(false);
        }
    }
}

