/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.Glenix;
import au.com.glenix.GlenixAUSKey;
import au.com.glenix.GlenixFile;
import au.com.glenix.GlenixSBRAttachment;
import au.com.glenix.GlenixSBRResponse;
import au.com.glenix.trn.GlenixResult;
import au.com.glenix.trn.Profile;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelText;
import java.awt.Desktop;
import java.net.URI;
import java.net.URL;
import java.util.ResourceBundle;
import java.util.UUID;
import javafx.fxml.FXML;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javax.swing.SwingUtilities;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class VerifyFASIdentityController
extends GlenixBranchController {
    @FXML
    private Label error_message;
    @FXML
    private GlenixLabelText firstName;
    @FXML
    private GlenixLabelText otherGivenNames;
    @FXML
    private GlenixLabelText lastName;
    @FXML
    private Hyperlink identity_check_hyperlink;
    @FXML
    private TextField identity_check_text_field;
    private Profile profile = null;
    private DocumentBuilder dBuilder;
    private ApplicationController xbrlFileController = null;

    public VerifyFASIdentityController(ApplicationController xbrlFileController) {
        this.xbrlFileController = xbrlFileController;
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        try {
            DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();
            dbFactory.setNamespaceAware(true);
            this.dBuilder = dbFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    private void setUrl() throws Exception {
        this.identity_check_hyperlink.setText(null);
        this.identity_check_hyperlink.setOnAction(null);
        this.identity_check_text_field.setText(null);
        GlenixAUSKey gk = this.xbrlFileController.getGlenixKey();
        final String url = Glenix.fas_identity_check_url + gk.getPublicKeyIdentifier();
        this.identity_check_hyperlink.setText(url);
        this.identity_check_hyperlink.setOnAction(event -> SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    if (!Desktop.isDesktopSupported() || !Desktop.getDesktop().isSupported(Desktop.Action.BROWSE)) {
                        throw new Exception("Error, unable to open web browser, please manually copy and paste the below link into your web browser.");
                    }
                    Desktop.getDesktop().browse(new URI(url));
                }
                catch (Exception e) {
                    e.printStackTrace();
                    VerifyFASIdentityController.this.error_message.setText(e.getMessage());
                    VerifyFASIdentityController.this.xbrlFileController.setStatusBarMessage(e.getMessage());
                }
            }
        }));
        this.identity_check_text_field.setText(url);
    }

    public void setModel(GlenixFile profileFile, Profile profileXBRL) throws Exception {
        this.profile = profileXBRL;
        if (this.profile != null) {
            Document doc = this.profile.buildDocument();
            if (doc != null) {
                this.loadGlenixXBRL(doc, doc.getDocumentElement());
            }
        } else {
            this.identity_check_hyperlink.setText(null);
            this.identity_check_text_field.setText(null);
        }
    }

    @FXML
    public void saveProfile() {
        try {
            String firstNameString = this.firstName.getGlenixElementValue();
            String otherGivenNamesString = this.otherGivenNames.getGlenixElementValue();
            String lastNameString = this.lastName.getGlenixElementValue();
            if (!(firstNameString != null && !firstNameString.isEmpty() || otherGivenNamesString != null && !otherGivenNamesString.isEmpty() || lastNameString != null && !lastNameString.isEmpty())) {
                throw new Exception("Error, you need to enter your name");
            }
            Document resultDoc = this.dBuilder.newDocument();
            super.buildGlenixXBRL(resultDoc, null);
            if (this.profile != null) {
                String commonName;
                GlenixAUSKey gk = this.xbrlFileController.getGlenixKey();
                Object gkCommonName = null;
                String certString = this.profile.getPublicKey();
                String currentCommonName = this.xbrlFileController.getX509CertificateCommonName(certString);
                StringBuilder sb = new StringBuilder();
                String prefix = null;
                if (firstNameString != null && !firstNameString.isEmpty()) {
                    sb.append(firstNameString);
                    prefix = " ";
                }
                if (otherGivenNamesString != null && !otherGivenNamesString.isEmpty()) {
                    if (prefix != null) {
                        sb.append(prefix);
                    }
                    sb.append(otherGivenNamesString);
                    prefix = " ";
                }
                if (lastNameString != null && !lastNameString.isEmpty()) {
                    if (prefix != null) {
                        sb.append(prefix);
                    }
                    sb.append(lastNameString);
                    prefix = " ";
                }
                if (!(commonName = sb.toString()).equals(currentCommonName) || gkCommonName != null && !commonName.equals(gkCommonName)) {
                    gk.setCommonName(commonName);
                    String newXDer = gk.getBase64PublicKeyOneLine();
                    this.profile.setPublicKey(newXDer);
                }
                this.profile.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
                this.xbrlFileController.saveProfileFile();
                this.sendProfileToFAS(gk, commonName);
                this.setUrl();
                this.error_message.setText("Saved, you can now proceed to the identity verification.");
            } else {
                this.error_message.setText("Could not save no profile loaded.");
            }
        }
        catch (Exception e) {
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
            e.printStackTrace();
        }
    }

    protected String generateMessageIdentifier() {
        UUID uuid = UUID.randomUUID();
        return uuid.toString() + "@freeaccountingsoftware.com.au";
    }

    @Override
    public void buildGlenixXBRL(Document resultDoc, Element resultElement) throws Exception {
        Element el = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:glenix");
        el.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:gx", "http://www.glenix.com.au/");
        if (resultElement == null) {
            resultDoc.appendChild(el);
        } else {
            resultElement.appendChild(el);
        }
        Element profileEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:profile");
        el.appendChild(profileEl);
        try {
            String pkStr = this.xbrlFileController.getPublicKeyDer();
            Element pkiEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:publicKey");
            pkiEl.setTextContent(pkStr);
            Element keyPairEl = resultDoc.createElementNS("http://www.glenix.com.au/", "gx:keyPair");
            profileEl.appendChild(keyPairEl);
            keyPairEl.appendChild(pkiEl);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.buildGlenixXBRLSub(this.getPane(), resultDoc, profileEl);
    }

    public void sendProfileToFAS(GlenixAUSKey gk, String commonName) throws Exception {
        Document profiledoc = this.dBuilder.newDocument();
        this.buildGlenixXBRL(profiledoc, null);
        GlenixSBRAttachment gatt = new GlenixSBRAttachment(profiledoc, "profile", gk.calcDigest(profiledoc.getDocumentElement(), "SHA-1"));
        gatt.setMimeType("text/xml");
        gatt.setDocumentType("PROFILE");
        gatt.setDocumentName("profile.xml");
        String messageId = this.generateMessageIdentifier();
        GlenixSBRResponse glenixSBRResponse = this.xbrlFileController.sendRegisterProfile(gk, commonName, messageId, gatt);
        glenixSBRResponse.parseResponse();
        int count = glenixSBRResponse.getSignalMessageErrorSize();
        for (int i = 0; i < count; ++i) {
            System.out.println("GOT ERROR CODE " + glenixSBRResponse.getSignalMessageErrorCode(i));
        }
        Document doc = glenixSBRResponse.getDocumentByHref("res.xml");
        if (doc == null) {
            throw new Exception("Error, profile not saved");
        }
        GlenixResult gr = new GlenixResult();
        gr.loadDocumentElement(doc, doc.getDocumentElement());
        String rc = gr.getResultCode();
        if (rc == null || rc.isEmpty()) {
            throw new Exception("Error, profile not saved");
        }
        if (!rc.equals("OK")) {
            throw new Exception("Error, profile not saved, error code = " + rc + " - " + gr.getResultDescription());
        }
    }
}

