/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.TransactionsTableController;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.Batch;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.ResourceBundle;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.control.SelectionMode;

public class TrashTransactionTableController
extends TransactionsTableController {
    public TrashTransactionTableController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        this.page_heading.setText("Trash bin - Transactions");
        this.setGlenixElementDescription("Trash bin - Transactions");
        this.transactionTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
    }

    @Override
    protected boolean checkTransactionType(Transaction t) {
        if (t == null) {
            return false;
        }
        String ts = t.getTransactionStatus();
        return ts == null || ts.equals("cancelled");
    }

    @FXML
    protected void deleteSelectedTransactions() {
        this.transaction = null;
        if (this.business != null) {
            ObservableList selectedTransactions = this.transactionTable.getSelectionModel().getSelectedItems();
            if (selectedTransactions != null && selectedTransactions.size() > 0) {
                this.business.removeTransactionCollection((Collection<Transaction>)selectedTransactions);
                try {
                    this.xbrlFileController.saveTransactions((Collection<Transaction>)selectedTransactions);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.xbrlFileController.setStatusBarMessage(e.getMessage());
                    this.error_message.setText(e.getMessage());
                }
            } else {
                String message = "Error, there are no transactions to permanently delete.";
                this.xbrlFileController.setStatusBarMessage(message);
                this.error_message.setText(message);
            }
        }
        this.createFilteredItems();
    }

    @FXML
    protected void deleteAllTransactions() {
        this.transaction = null;
        if (this.business != null && this.filteredItems != null && this.filteredItems.size() > 0) {
            this.business.removeTransactionCollection((Collection<Transaction>)this.filteredItems);
            try {
                this.xbrlFileController.saveTransactions((Collection<Transaction>)this.filteredItems);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
                this.error_message.setText(e.getMessage());
            }
        } else {
            String message = "Error, there are no transactions to permanently delete.";
            this.xbrlFileController.setStatusBarMessage(message);
            this.error_message.setText(message);
        }
        this.createFilteredItems();
    }

    protected boolean lodgedActivityStatementIsChanged(Transaction transaction) {
        if (transaction == null) {
            return false;
        }
        HashSet ass = new HashSet();
        for (int i = 0; i < transaction.getTransactionLineCount(); ++i) {
            String status;
            ActivityStatement as;
            TransactionLine tl = transaction.getTransactionLine(i);
            String asNumber = tl.getActivityStatementNumber();
            if (asNumber == null || asNumber.isEmpty()) continue;
            GlenixTrnXBRL asTrn = null;
            try {
                asTrn = this.xbrlFileController.loadActivityStatement(asNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (asTrn == null || (as = asTrn.getActivityStatement()) == null || (status = as.getSBRDocumentStatus()) == null || status.equals("created") || status.equals("list_complete") || status.equals("list_in_progress") || status.equals("prefill_complete") || status.equals("prefill_in_progress") || status.equals("prelodge_complete") || status.equals("prelodge_in_progress")) continue;
            return true;
        }
        return false;
    }

    protected boolean transactionBatchIsLocked(Transaction transaction) {
        Batch b;
        String trBi = null;
        if (transaction != null && (b = transaction.getBatch()) != null && (trBi = b.getBatchIdentifier()) != null && !trBi.isEmpty()) {
            String status;
            Transaction bt = null;
            try {
                bt = this.xbrlFileController.getBatchTransaction(trBi);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bt != null && (status = bt.getBatchStatus()) != null && !status.equals("created")) {
                return true;
            }
        }
        return false;
    }

    @FXML
    protected void restoreSelectedTransactions() {
        this.transaction = null;
        if (this.business != null) {
            ObservableList selectedTransactions = this.transactionTable.getSelectionModel().getSelectedItems();
            if (selectedTransactions != null && selectedTransactions.size() > 0) {
                try {
                    for (Transaction t : selectedTransactions) {
                        if (this.lodgedActivityStatementIsChanged(t)) {
                            throw new Exception("Error, one of the lines is on a lodged Activity Statment.");
                        }
                        if (!this.transactionBatchIsLocked(t)) continue;
                        throw new Exception("Error, one of the lines is on an authorised or lodged Batch.");
                    }
                    for (Transaction t : selectedTransactions) {
                        t.setTransactionStatus("posted");
                    }
                    this.xbrlFileController.saveTransactions((Collection<Transaction>)selectedTransactions);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.xbrlFileController.setStatusBarMessage(e.getMessage());
                    this.error_message.setText(e.getMessage());
                    return;
                }
            } else {
                String message = "Error, there are no selected transactions to restore.";
                this.xbrlFileController.setStatusBarMessage(message);
                this.error_message.setText(message);
                return;
            }
        }
        this.updateFilter();
        this.refreshTable();
        this.updateTotalAmount();
    }

    @FXML
    protected void restoreAllTransactions() {
        this.transaction = null;
        if (this.business != null && this.filteredItems != null && this.filteredItems.size() > 0) {
            try {
                for (Transaction t : this.filteredItems) {
                    t.setTransactionStatus("posted");
                }
                this.xbrlFileController.saveTransactions((Collection<Transaction>)this.filteredItems);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.xbrlFileController.setStatusBarMessage(e.getMessage());
                this.error_message.setText(e.getMessage());
            }
        } else {
            String message = "Error, there are no transactions to restore.";
            this.xbrlFileController.setStatusBarMessage(message);
            this.error_message.setText(message);
        }
        this.updateFilter();
        this.refreshTable();
        this.updateTotalAmount();
    }
}

