/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.TransactionsTableController;
import au.com.glenix.trn.BusinessMasterFile;
import au.com.glenix.trn.Counterparty;
import au.com.glenix.trn.OutgoingMailServer;
import au.com.glenix.trn.Profile;
import au.com.glenix.trn.Transaction;
import au.com.glenix.widget.GlenixLabelText;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.UUID;
import javafx.fxml.FXML;
import javafx.scene.web.HTMLEditor;
import javafx.util.Pair;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class TransactionsTableSalesController
extends TransactionsTableController {
    @FXML
    protected HTMLEditor html_message;
    @FXML
    protected GlenixLabelText email_to;
    @FXML
    protected GlenixLabelText email_from;
    @FXML
    protected GlenixLabelText email_subject;

    public TransactionsTableSalesController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    @Override
    public void setTransactionDefaults() throws Exception {
        if (this.transaction == null) {
            return;
        }
        String tt = this.transaction.getTransactionType();
        if (tt == null) {
            this.transaction.setTransactionType("sales_invoice");
        }
    }

    protected void setupEmail(Transaction transaction) {
        this.html_message.setHtmlText("<html><head></head><body><p>Dear Customer,</p><p>Please find attached your invoice.</p></body></html>");
        this.email_subject.setGlenixElementValue("Tax Invoice");
        BusinessMasterFile bmf = this.xbrlFileController.getBusinessMasterFile();
        if (bmf != null) {
            String name = bmf.getBusinessTradingName();
            if (name == null || name.isEmpty()) {
                name = bmf.getBusinessLegalName();
            }
            this.email_subject.setGlenixElementValue(name + " - Tax Invoice");
        }
        this.email_to.setText(null);
        try {
            Counterparty c;
            Transaction ct;
            String ci;
            if (transaction != null && (ci = transaction.getCounterpartyIdentifier()) != null && (ct = this.xbrlFileController.getCounterpartyTransaction(ci)) != null && (c = ct.getCounterparty()) != null) {
                String email = c.getCounterpartyEmailAddress();
                this.email_to.setText(email);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        this.email_from.setGlenixElementValue(null);
        try {
            OutgoingMailServer oms;
            Profile p = this.xbrlFileController.getOutgoingMailServer();
            if (p != null && (oms = p.getOutgoingMailServer()) != null) {
                this.email_from.setGlenixElementValue(oms.getOutgoingMailFromEmailAddress());
                this.html_message.setHtmlText(oms.getOutgoingMailSignature());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
    }

    protected void setTransactionTypeOptions() {
        ArrayList<Pair<String, String>> options = new ArrayList<Pair<String, String>>();
        options.add(new Pair((Object)"sales_invoice", (Object)"Sales invoice"));
        options.add(new Pair((Object)"sales_credit", (Object)"Sales credit"));
        this.transactionEditFormVBox.setTransactionTypeVisibleOptions(options, true, "sales_invoice");
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        this.setupEmail(null);
        this.setTransactionTypeOptions();
    }

    @Override
    protected boolean checkTransactionType(Transaction t) {
        if (t == null) {
            return false;
        }
        String tt = t.getTransactionType();
        if (tt == null) {
            return false;
        }
        if (!(tt.equals("sales_invoice") || tt.equals("sales_credit") || tt.equals("cash_received"))) {
            return false;
        }
        String ts = t.getTransactionStatus();
        return ts != null && ts.equals("posted");
    }

    @FXML
    private void pdfTransaction() {
        if (this.transaction == null) {
            return;
        }
        this.xbrlFileController.pdfSalesInvoice(this.transaction);
    }

    @Override
    protected void loadTransaction(Transaction transaction) {
        super.loadTransaction(transaction);
        this.setupEmail(transaction);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @FXML
    private void sendEmail() {
        File file = null;
        try {
            if (this.transaction == null) {
                throw new Exception("Error, the transaction is not yet saved.");
            }
            Profile p = this.xbrlFileController.getOutgoingMailServer();
            if (p == null) {
                throw new Exception("Error, outgoing mail server is not set up");
            }
            OutgoingMailServer outgoingMailServer = p.getOutgoingMailServer();
            if (outgoingMailServer == null) {
                throw new Exception("Error, outgoing mail server is not set up");
            }
            String host = outgoingMailServer.getOutgoingMailServerName();
            if (host == null || host.isEmpty()) {
                throw new Exception("Error, outgoing mail server host is not set up");
            }
            String port = outgoingMailServer.getOutgoingMailServerPort();
            if (port == null || port.isEmpty()) {
                throw new Exception("Error, outgoing mail server host is not set up");
            }
            final String username = outgoingMailServer.getOutgoingMailUsername();
            final String password = outgoingMailServer.getOutgoingMailPassword();
            String to = this.email_to.getGlenixElementValue();
            if (to == null || to.isEmpty()) {
                throw new Exception("Error, to email address is not set");
            }
            String from = this.email_from.getGlenixElementValue();
            if (from == null || from.isEmpty()) {
                throw new Exception("Error, from email address is not set");
            }
            String subject = this.email_subject.getGlenixElementValue();
            if (subject == null || subject.isEmpty()) {
                throw new Exception("Error, subject is not set");
            }
            String message_html = this.html_message.getHtmlText();
            if (message_html == null || message_html.isEmpty()) {
                throw new Exception("Error, message is not set");
            }
            Properties properties = new Properties();
            properties.put("mail.smtp.allow8bitmime", "true");
            properties.put("mail.smtp.timeout", "60000");
            properties.put("mail.smtp.connectiontimeout", "60000");
            properties.put("mail.smtp.port", port);
            properties.put("mail.smtp.socketFactory.port", port);
            properties.put("mail.smtp.from", from);
            properties.put("mail.smtp.starttls.enable", "true");
            properties.put("mail.smtp.EnableSSL.enable", "true");
            properties.setProperty("mail.smtp.host", host);
            if (username != null && !username.isEmpty()) {
                properties.put("mail.smtp.auth", "true");
                properties.put("mail.smtp.socketFactory.class", "javax.net.ssl.SSLSocketFactory");
                properties.setProperty("mail.user", username);
            }
            if (password != null && !password.isEmpty()) {
                properties.setProperty("mail.password", password);
            }
            Session session = Session.getInstance(properties, new Authenticator(){

                @Override
                protected PasswordAuthentication getPasswordAuthentication() {
                    return new PasswordAuthentication(username, password);
                }
            });
            MimeMessage message = new MimeMessage(session);
            message.setFrom(new InternetAddress(from));
            message.addRecipient(Message.RecipientType.TO, new InternetAddress(to));
            message.setSubject(subject);
            MimeBodyPart messageBodyPart = new MimeBodyPart();
            messageBodyPart.setContent(message_html, "text/html");
            MimeMultipart multipart = new MimeMultipart();
            ((Multipart)multipart).addBodyPart(messageBodyPart);
            messageBodyPart = new MimeBodyPart();
            String tmpdir = System.getProperty("java.io.tmpdir");
            UUID uuid = UUID.randomUUID();
            String randomUUIDString = uuid.toString();
            file = tmpdir != null && !tmpdir.isEmpty() ? new File(tmpdir + "/Tax_Invoice_" + randomUUIDString + ".pdf") : new File("Tax_Invoice_" + randomUUIDString + ".pdf");
            this.xbrlFileController.buildPDFSalesInvoice(file, this.transaction);
            FileDataSource source = new FileDataSource(file);
            messageBodyPart.setDataHandler(new DataHandler((DataSource)source));
            messageBodyPart.setFileName("Tax_Invoice.pdf");
            ((Multipart)multipart).addBodyPart(messageBodyPart);
            message.setContent(multipart);
            Transport transport = session.getTransport();
            transport.connect();
            transport.sendMessage(message, message.getAllRecipients());
            transport.close();
            this.error_message.setText("Sales invoice has been emailed.");
            this.xbrlFileController.setStatusBarMessage("Sales invoice has been emailed.");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.xbrlFileController.setStatusBarMessage(e.getMessage());
        }
        finally {
            if (file != null) {
                file.delete();
            }
        }
    }
}

