/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.TransactionsTableController;
import au.com.glenix.trn.Transaction;
import java.net.URL;
import java.util.ResourceBundle;
import javafx.fxml.FXML;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.Region;

public class TransactionsTableOtherPurchasesController
extends TransactionsTableController {
    @FXML
    protected ScrollPane transaction_scroll_pane;
    @FXML
    protected Region otherpane;

    public TransactionsTableOtherPurchasesController(ApplicationController xbrlFileController) {
        super(xbrlFileController);
    }

    @Override
    public void setTransactionDefaults() throws Exception {
        if (this.transaction == null) {
            return;
        }
        String tt = this.transaction.getTransactionType();
        if (tt == null) {
            this.transaction.setTransactionType("purchase_invoice");
        }
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        this.page_heading.setText("Purchases worksheet");
        this.setGlenixElementDescription("Purchases worksheet");
    }

    @Override
    protected boolean checkTransactionType(Transaction t) {
        if (t == null) {
            return false;
        }
        String tt = t.getTransactionType();
        if (tt == null) {
            return false;
        }
        if (!(tt.equals("purchase_invoice") || tt.equals("purchase_credit") || tt.equals("cash_payment"))) {
            return false;
        }
        String ts = t.getTransactionStatus();
        return ts != null && ts.equals("posted");
    }

    @Override
    protected void loadTransaction(Transaction newTransaction) {
        if (newTransaction != null) {
            try {
                String homeOfficeIdentifier = newTransaction.getHomeOfficeIdentifier();
                if (homeOfficeIdentifier != null && !homeOfficeIdentifier.isEmpty()) {
                    this.error_message.setText("Error, the selected transaction is a home office expense. Double click to go to the home office expense edit.");
                    this.xbrlFileController.setStatusBarMessage("Error, the selected transaction is a home office expense. Double click to go to the home office expense edit.");
                    if (this.transactionEditFormVBox != null) {
                        this.transactionEditFormVBox.setTransactionElement(null);
                    }
                    return;
                }
                String fuelTaxCreditIdentifier = newTransaction.getFuelTaxCreditIdentifier();
                if (fuelTaxCreditIdentifier != null && !fuelTaxCreditIdentifier.isEmpty()) {
                    this.error_message.setText("Error, the selected transaction is a fuel tax credit. Double click to go to the fuel tax credit edit.");
                    this.xbrlFileController.setStatusBarMessage("Error, the selected transaction is a fuel tax credit. Double click to go to the fuel tax credit edit.");
                    if (this.transactionEditFormVBox != null) {
                        this.transactionEditFormVBox.setTransactionElement(null);
                    }
                    return;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText("Error, could not quick edit transaction.");
                this.xbrlFileController.setStatusBarMessage("Error, could not quick edit transaction.");
                return;
            }
        }
        super.loadTransaction(newTransaction);
    }
}

