/*
 * Decompiled with CFR 0.152.
 */
package au.com.glenix;

import au.com.glenix.ApplicationController;
import au.com.glenix.TransactionEditShortFormVBox;
import au.com.glenix.trn.ActivityStatement;
import au.com.glenix.trn.Batch;
import au.com.glenix.trn.Business;
import au.com.glenix.trn.GlenixTrnXBRL;
import au.com.glenix.trn.ImportData;
import au.com.glenix.trn.Transaction;
import au.com.glenix.trn.TransactionLine;
import au.com.glenix.widget.GlenixBranchController;
import au.com.glenix.widget.GlenixLabelDate;
import au.com.glenix.widget.GlenixLabelText;
import au.com.glenix.widget.GlenixPDFWrapper;
import au.com.glenix.widget.GlenixPDFWrapperNewPageCallback;
import java.math.RoundingMode;
import java.net.URL;
import java.text.DecimalFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.Property;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableRow;
import javafx.scene.control.TableView;
import javafx.util.Callback;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;

public class TransactionsTableImportDataController
extends GlenixBranchController
implements GlenixPDFWrapperNewPageCallback {
    @FXML
    protected Label error_message;
    @FXML
    protected Label page_heading;
    @FXML
    protected TransactionEditShortFormVBox transactionEditFormVBox;
    protected Transaction transaction;
    protected LocalDate lastLocalDate = null;
    private Transaction importDataTransaction = null;
    private ImportData importData = null;
    private List<Transaction> importDataTransactions = null;
    private DocumentBuilderFactory docFactory;
    private DocumentBuilder docBuilder;
    private boolean suspendSelectionChange = false;
    private HashSet<Transaction.TransactionTransactionLine> selectedTransactionTransactionLines = new HashSet();
    private HashSet<Transaction.TransactionTransactionLine> originalSelectedTransactionTransactionLines = new HashSet();
    @FXML
    protected Label total_label;
    @FXML
    protected TableView<Transaction.TransactionTransactionLine> importDataTransactionTransactionLineTable;
    @FXML
    protected TableColumn importDataTransactionDateColumn;
    @FXML
    protected TableColumn importDataTransactionCounterpartyColumn;
    @FXML
    protected TableColumn importDataTransactionCommentColumn;
    @FXML
    protected TableColumn importDataAmountColumn;
    @FXML
    protected TableColumn importDataAccountTextColumn;
    @FXML
    protected TableColumn importDataProvisionTextColumn;
    @FXML
    protected TableColumn importDataTaxAmountColumn;
    @FXML
    protected TableColumn importDataQuantityColumn;
    protected ObservableList<Transaction.TransactionTransactionLine> importDataTransactionTransactionLineObservableList = null;
    @FXML
    protected TableView<Transaction.TransactionTransactionLine> transactionTransactionLineTable;
    @FXML
    protected TableColumn transactionDateColumn;
    @FXML
    protected TableColumn counterpartyColumn;
    @FXML
    protected TableColumn commentColumn;
    @FXML
    protected TableColumn amountColumn;
    @FXML
    protected TableColumn accountColumn;
    @FXML
    protected TableColumn provisionColumn;
    @FXML
    protected TableColumn taxAmountColumn;
    @FXML
    protected TableColumn quantityColumn;
    @FXML
    protected GlenixLabelText filterText;
    @FXML
    protected GlenixLabelDate filterFromDate;
    @FXML
    protected GlenixLabelDate filterToDate;
    protected ApplicationController applicationController = null;
    protected ObservableList<Transaction.TransactionTransactionLine> transactionTransactionLineObservableList = null;
    protected FilteredList<Transaction.TransactionTransactionLine> filteredItems = null;
    protected Business business;
    protected String pattern = "dd MMM yyyy";
    protected DateTimeFormatter displayDateFormatter;
    protected DecimalFormat amountFormat;
    protected DecimalFormat quantityFormat;
    protected DecimalFormat wholeDollarFormat;
    private String subSection = "importData";

    public TransactionsTableImportDataController(ApplicationController applicationController) {
        this.applicationController = applicationController;
        this.amountFormat = new DecimalFormat("$#,##0.00");
        this.amountFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.quantityFormat = new DecimalFormat("#,##0.######");
        this.quantityFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.wholeDollarFormat = new DecimalFormat("$#,##0");
        this.wholeDollarFormat.setRoundingMode(RoundingMode.HALF_UP);
        this.displayDateFormatter = DateTimeFormatter.ofPattern(this.pattern);
    }

    @Override
    public void initialize(URL url, ResourceBundle rb) {
        super.initialize(url, rb);
        this.page_heading.setText("Import data worksheet");
        this.setGlenixElementDescription("Import data worksheet");
        this.docFactory = DocumentBuilderFactory.newInstance();
        this.docFactory.setNamespaceAware(true);
        try {
            this.docBuilder = this.docFactory.newDocumentBuilder();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
        }
        this.importDataTransactionTransactionLineTable.setRowFactory(tv -> {
            TableRow row = new TableRow();
            row.setOnMouseClicked(event -> {
                block9: {
                    if (event.getClickCount() == 2) {
                        if (!row.isEmpty()) {
                            Transaction.TransactionTransactionLine ttl = (Transaction.TransactionTransactionLine)row.getItem();
                            if (ttl != null) {
                                try {
                                    String batchIdentifier = ttl.getBatchIdentifier();
                                    if (batchIdentifier != null && !batchIdentifier.isEmpty()) {
                                        this.error_message.setText("Error, cannot edit batch transaction on import data page.");
                                        this.applicationController.setStatusBarMessage("Error, cannot edit batch transaction on import data page.");
                                        break block9;
                                    }
                                    ImportData importData = ttl.getImportData();
                                    if (importData != null) {
                                        this.error_message.setText(null);
                                        this.applicationController.setStatusBarMessage(null);
                                        this.applicationController.gotoImportDataEdit((List<Transaction.TransactionTransactionLine>)this.transactionTransactionLineObservableList, ttl, importData);
                                        break block9;
                                    }
                                    this.error_message.setText(null);
                                    this.applicationController.setStatusBarMessage(null);
                                    this.loadTransaction(ttl.getTransaction());
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                    this.error_message.setText("Error, could not go to transaction edit page.");
                                    this.applicationController.setStatusBarMessage("Error, could not go to transaction edit page.");
                                }
                            } else {
                                this.error_message.setText("Error, could not get transaction.");
                                this.applicationController.setStatusBarMessage("Error, could not get transaction.");
                            }
                        } else {
                            this.clearTransaction();
                        }
                    }
                }
            });
            return row;
        });
        if (this.importDataTransactionDateColumn != null) {
            this.importDataTransactionDateColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, LocalDate>, TableCell<Transaction.TransactionTransactionLine, LocalDate>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, LocalDate> param) {
                    TableCell<Transaction.TransactionTransactionLine, LocalDate> cell = new TableCell<Transaction.TransactionTransactionLine, LocalDate>(){

                        public void updateItem(LocalDate item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableImportDataController.this.getImportDataTransactionDateColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.importDataTransactionCounterpartyColumn != null) {
            this.importDataTransactionCounterpartyColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableImportDataController.this.getImportDataCounterpartyColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.importDataTransactionCommentColumn != null) {
            this.importDataTransactionCommentColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableImportDataController.this.getImportDataCommentColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.importDataAmountColumn != null) {
            this.importDataAmountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Double>, TableCell<Transaction.TransactionTransactionLine, Double>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Double> param) {
                    TableCell<Transaction.TransactionTransactionLine, Double> cell = new TableCell<Transaction.TransactionTransactionLine, Double>(){

                        public void updateItem(Double item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableImportDataController.this.getImportDataAmountColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.importDataAccountTextColumn != null) {
            this.importDataAccountTextColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableImportDataController.this.getImportDataAccountColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.importDataProvisionTextColumn != null) {
            this.importDataProvisionTextColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableImportDataController.this.getImportDataProvisionColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.importDataTaxAmountColumn != null) {
            this.importDataTaxAmountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Double>, TableCell<Transaction.TransactionTransactionLine, Double>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Double> param) {
                    TableCell<Transaction.TransactionTransactionLine, Double> cell = new TableCell<Transaction.TransactionTransactionLine, Double>(){

                        public void updateItem(Double item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableImportDataController.this.getImportDataProvisionAmountColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.importDataQuantityColumn != null) {
            this.importDataQuantityColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Double>, TableCell<Transaction.TransactionTransactionLine, Double>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Double> param) {
                    TableCell<Transaction.TransactionTransactionLine, Double> cell = new TableCell<Transaction.TransactionTransactionLine, Double>(){

                        public void updateItem(Double item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableImportDataController.this.getImportDataQuantityColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.transactionDateColumn != null) {
            this.transactionDateColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, LocalDate>, TableCell<Transaction.TransactionTransactionLine, LocalDate>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, LocalDate> param) {
                    TableCell<Transaction.TransactionTransactionLine, LocalDate> cell = new TableCell<Transaction.TransactionTransactionLine, LocalDate>(){

                        public void updateItem(LocalDate item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableImportDataController.this.getTransactionDateColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.counterpartyColumn != null) {
            this.counterpartyColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableImportDataController.this.getCounterpartyColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.amountColumn != null) {
            this.amountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Double>, TableCell<Transaction.TransactionTransactionLine, Double>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Double> param) {
                    TableCell<Transaction.TransactionTransactionLine, Double> cell = new TableCell<Transaction.TransactionTransactionLine, Double>(){

                        public void updateItem(Double item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableImportDataController.this.getAmountColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.accountColumn != null) {
            this.accountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableImportDataController.this.getAccountColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.provisionColumn != null) {
            this.provisionColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, String>, TableCell<Transaction.TransactionTransactionLine, String>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, String> param) {
                    TableCell<Transaction.TransactionTransactionLine, String> cell = new TableCell<Transaction.TransactionTransactionLine, String>(){

                        public void updateItem(String item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableImportDataController.this.getProvisionColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.taxAmountColumn != null) {
            this.taxAmountColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Double>, TableCell<Transaction.TransactionTransactionLine, Double>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Double> param) {
                    TableCell<Transaction.TransactionTransactionLine, Double> cell = new TableCell<Transaction.TransactionTransactionLine, Double>(){

                        public void updateItem(Double item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableImportDataController.this.getProvisionAmountColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        if (this.quantityColumn != null) {
            this.quantityColumn.setCellFactory((Callback)new Callback<TableColumn<Transaction.TransactionTransactionLine, Double>, TableCell<Transaction.TransactionTransactionLine, Double>>(){

                public TableCell call(TableColumn<Transaction.TransactionTransactionLine, Double> param) {
                    TableCell<Transaction.TransactionTransactionLine, Double> cell = new TableCell<Transaction.TransactionTransactionLine, Double>(){

                        public void updateItem(Double item, boolean empty) {
                            super.updateItem((Object)item, empty);
                            this.setGraphic(null);
                            if (empty) {
                                this.setText(null);
                            } else {
                                this.setText(TransactionsTableImportDataController.this.getQuantityColumnValue((Transaction.TransactionTransactionLine)this.getTableView().getItems().get(this.getIndex())));
                            }
                        }
                    };
                    return cell;
                }
            });
        }
        this.transactionTransactionLineTable.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.transactionTransactionLineTable.getSelectionModel().getSelectedItems().addListener(new ListChangeListener(){

            public void onChanged(ListChangeListener.Change change) {
                TransactionsTableImportDataController.this.updateSelectedTransactionLines();
                TransactionsTableImportDataController.this.updateTotalAmount();
            }
        });
        this.importDataTransactionTransactionLineTable.getSelectionModel().getSelectedItems().addListener(new ListChangeListener(){

            public void onChanged(ListChangeListener.Change change) {
                TransactionsTableImportDataController.this.updateSelectedTransactionLines();
                TransactionsTableImportDataController.this.updateTotalAmount();
            }
        });
        this.importDataTransactionDateColumn.prefWidthProperty().bindBidirectional((Property)this.transactionDateColumn.prefWidthProperty());
        this.importDataTransactionDateColumn.minWidthProperty().bindBidirectional((Property)this.transactionDateColumn.minWidthProperty());
        this.importDataTransactionDateColumn.maxWidthProperty().bindBidirectional((Property)this.transactionDateColumn.maxWidthProperty());
        this.importDataTransactionCounterpartyColumn.prefWidthProperty().bindBidirectional((Property)this.counterpartyColumn.prefWidthProperty());
        this.importDataTransactionCommentColumn.prefWidthProperty().bindBidirectional((Property)this.commentColumn.prefWidthProperty());
        this.importDataAmountColumn.prefWidthProperty().bindBidirectional((Property)this.amountColumn.prefWidthProperty());
        this.importDataAccountTextColumn.prefWidthProperty().bindBidirectional((Property)this.accountColumn.prefWidthProperty());
        this.importDataProvisionTextColumn.prefWidthProperty().bindBidirectional((Property)this.provisionColumn.prefWidthProperty());
        this.importDataTaxAmountColumn.prefWidthProperty().bindBidirectional((Property)this.taxAmountColumn.prefWidthProperty());
        this.importDataQuantityColumn.prefWidthProperty().bindBidirectional((Property)this.quantityColumn.prefWidthProperty());
    }

    public String getImportDataTransactionDateColumnValue(Transaction.TransactionTransactionLine ttl) {
        LocalDate ld = ttl.getTransactionDateAsDate();
        if (ld != null) {
            return this.displayDateFormatter.format(ld);
        }
        ld = ttl.getImportDataDateAsDate();
        if (ld != null) {
            return "(I) " + this.displayDateFormatter.format(ld);
        }
        return null;
    }

    public String getImportDataCounterpartyColumnValue(Transaction.TransactionTransactionLine ttl) {
        String importCounterparty;
        String counterpartyIdentifier = ttl.getCounterpartyIdentifier();
        if (counterpartyIdentifier != null && !counterpartyIdentifier.isEmpty()) {
            try {
                Transaction ct = this.applicationController.getCounterpartyTransaction(counterpartyIdentifier);
                if (ct != null) {
                    return ct.getCounterpartyLegalName();
                }
                return counterpartyIdentifier;
            }
            catch (Exception ct) {
                // empty catch block
            }
        }
        if ((importCounterparty = ttl.getImportDataCounterparty()) != null && !importCounterparty.isEmpty()) {
            return "(I) " + importCounterparty;
        }
        return null;
    }

    public String getImportDataCommentColumnValue(Transaction.TransactionTransactionLine ttl) {
        String comment = ttl.getTransactionComment();
        if (comment != null && !comment.isEmpty()) {
            return comment;
        }
        comment = ttl.getImportDataComment();
        if (comment != null && !comment.isEmpty()) {
            return "(I) " + comment;
        }
        return null;
    }

    public String getImportDataAmountColumnValue(Transaction.TransactionTransactionLine ttl) {
        Double amount = ttl.getCreditAmount();
        if (amount != null) {
            return this.amountFormat.format(amount);
        }
        amount = ttl.getCreditImportDataAmount();
        if (amount != null) {
            return "(I) " + this.amountFormat.format(amount);
        }
        return null;
    }

    public String getImportDataProvisionAmountColumnValue(Transaction.TransactionTransactionLine ttl) {
        Double amount = ttl.getCreditProvisionAmount();
        if (amount != null) {
            return this.amountFormat.format(amount);
        }
        amount = ttl.getCreditImportDataProvisionAmount();
        if (amount != null) {
            return "(I) " + this.amountFormat.format(amount);
        }
        return null;
    }

    public String getImportDataQuantityColumnValue(Transaction.TransactionTransactionLine ttl) {
        Double quantity = ttl.getCreditQuantity();
        if (quantity != null) {
            return this.quantityFormat.format(quantity);
        }
        quantity = ttl.getCreditImportDataQuantity();
        if (quantity != null) {
            return "(I) " + this.quantityFormat.format(quantity);
        }
        return null;
    }

    public String getImportDataAccountColumnValue(Transaction.TransactionTransactionLine ttl) {
        String accountIdentifier = ttl.getAccountIdentifier();
        if (accountIdentifier != null && !accountIdentifier.isEmpty()) {
            try {
                Transaction ct = this.applicationController.getAccountTransaction(accountIdentifier);
                if (ct != null) {
                    return ct.getAccountName();
                }
                return accountIdentifier;
            }
            catch (Exception ct) {
                return accountIdentifier;
            }
        }
        String accountStr = ttl.getImportDataAccount();
        if (accountStr != null && !accountStr.isEmpty()) {
            return "(I) " + accountStr;
        }
        return null;
    }

    public String getImportDataProvisionColumnValue(Transaction.TransactionTransactionLine ttl) {
        String provisionIdentifier = ttl.getProvisionIdentifier();
        if (provisionIdentifier != null && !provisionIdentifier.isEmpty()) {
            try {
                Transaction ct = this.applicationController.getProvisionTransaction(provisionIdentifier);
                if (ct != null) {
                    return ct.getProvisionName();
                }
                return provisionIdentifier;
            }
            catch (Exception ct) {
                return provisionIdentifier;
            }
        }
        String provisionStr = ttl.getImportDataProvision();
        if (provisionStr != null && !provisionStr.isEmpty()) {
            return "(I) " + provisionStr;
        }
        return null;
    }

    public String getTransactionDateColumnValue(Transaction.TransactionTransactionLine ttl) {
        LocalDate ld = ttl.getTransactionDateAsDate();
        if (ld != null) {
            return this.displayDateFormatter.format(ld);
        }
        return null;
    }

    public String getCounterpartyColumnValue(Transaction.TransactionTransactionLine ttl) {
        String counterpartyIdentifier = ttl.getCounterpartyIdentifier();
        if (counterpartyIdentifier != null && !counterpartyIdentifier.isEmpty()) {
            try {
                Transaction ct = this.applicationController.getCounterpartyTransaction(counterpartyIdentifier);
                if (ct != null) {
                    return ct.getCounterpartyLegalName();
                }
                return counterpartyIdentifier;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    public String getAmountColumnValue(Transaction.TransactionTransactionLine ttl) {
        Double amount = ttl.getCreditAmount();
        if (amount != null) {
            return this.amountFormat.format(amount);
        }
        return null;
    }

    public String getProvisionAmountColumnValue(Transaction.TransactionTransactionLine ttl) {
        Double amount = ttl.getCreditProvisionAmount();
        if (amount != null) {
            return this.amountFormat.format(amount);
        }
        return null;
    }

    public String getQuantityColumnValue(Transaction.TransactionTransactionLine ttl) {
        Double quantity = ttl.getCreditQuantity();
        if (quantity != null) {
            return this.quantityFormat.format(quantity);
        }
        return null;
    }

    public String getAccountColumnValue(Transaction.TransactionTransactionLine ttl) {
        String accountIdentifier = ttl.getAccountIdentifier();
        if (accountIdentifier != null && !accountIdentifier.isEmpty()) {
            try {
                Transaction ct = this.applicationController.getAccountTransaction(accountIdentifier);
                if (ct != null) {
                    return ct.getAccountName();
                }
                return accountIdentifier;
            }
            catch (Exception exception) {
                return accountIdentifier;
            }
        }
        return null;
    }

    public String getProvisionColumnValue(Transaction.TransactionTransactionLine ttl) {
        String provisionIdentifier = ttl.getProvisionIdentifier();
        if (provisionIdentifier != null && !provisionIdentifier.isEmpty()) {
            try {
                Transaction ct = this.applicationController.getProvisionTransaction(provisionIdentifier);
                if (ct != null) {
                    return ct.getProvisionName();
                }
                return provisionIdentifier;
            }
            catch (Exception exception) {
                return provisionIdentifier;
            }
        }
        return null;
    }

    public void setImportData(List<Transaction> importDataTransactions, Transaction importDataTransaction) {
        this.importDataTransaction = importDataTransaction;
        this.importDataTransactions = importDataTransactions;
        if (importDataTransaction != null) {
            ArrayList<Transaction.TransactionTransactionLine> importDataTransactionLines = importDataTransaction.getTransactionTransactionLineLineArrayList();
            this.originalSelectedTransactionTransactionLines.clear();
            this.selectedTransactionTransactionLines.clear();
            this.importDataTransactionTransactionLineObservableList = FXCollections.observableList(importDataTransactionLines);
            this.updateImportDataTransactionObservableList();
        }
    }

    protected void updateImportDataTransactionObservableList() {
        if (this.importDataTransactionTransactionLineObservableList == null || this.importDataTransactionTransactionLineObservableList.isEmpty()) {
            this.importDataTransactionTransactionLineTable.getItems().clear();
        } else {
            this.importDataTransactionTransactionLineTable.setItems(this.importDataTransactionTransactionLineObservableList);
        }
    }

    @FXML
    private void gotoImportDataEdit() {
        try {
            System.out.println("TODO TransactionsTableImportDataController");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    private void gotoImportDataList() {
        try {
            this.applicationController.gotoImportDataList();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    protected void updateTotalAmount() {
        Double totalAmount = 0.0;
        Double totalProvisionAmount = 0.0;
        Double totalQuantity = 0.0;
        boolean hasselected = false;
        boolean selection_visible = true;
        for (Transaction.TransactionTransactionLine ttl : this.selectedTransactionTransactionLines) {
            totalAmount = totalAmount + ttl.getCreditAmount();
            totalProvisionAmount = totalProvisionAmount + ttl.getCreditProvisionAmount();
            totalQuantity = totalQuantity + ttl.getCreditQuantity();
            hasselected = true;
            if (this.filteredItems.contains((Object)ttl)) continue;
            selection_visible = false;
        }
        if (hasselected) {
            Transaction.TransactionTransactionLine importDataLine = (Transaction.TransactionTransactionLine)this.importDataTransactionTransactionLineTable.getSelectionModel().getSelectedItem();
            if (importDataLine == null) {
                this.total_label.setText("Please select an import data in the topmost table");
            } else {
                String matchedStr = null;
                Double iAmt = importDataLine.getCreditAmount();
                if (iAmt != null && totalAmount.equals(iAmt)) {
                    this.total_label.getStyleClass().removeAll((Object[])new String[]{"error"});
                    this.total_label.getStyleClass().add((Object)"success");
                    matchedStr = " (matched)";
                } else {
                    this.total_label.getStyleClass().removeAll((Object[])new String[]{"success"});
                    this.total_label.getStyleClass().add((Object)"error");
                    matchedStr = totalAmount < iAmt ? " (need +" + (iAmt - totalAmount) + ")" : " (need -" + (totalAmount - iAmt) + ")";
                }
                if (selection_visible) {
                    this.total_label.setText("Total selected amount: " + this.amountFormat.format(totalAmount) + matchedStr + ", total tax: " + this.amountFormat.format(totalProvisionAmount) + ", total quantity: " + this.quantityFormat.format(totalQuantity));
                } else {
                    this.total_label.setText("Total selected amount: " + this.amountFormat.format(totalAmount) + matchedStr + ", total tax: " + this.amountFormat.format(totalProvisionAmount) + ", total quantity: " + this.quantityFormat.format(totalQuantity) + " (some selections are filtered out)");
                }
            }
        } else {
            this.total_label.setText("No transaction lines selected");
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"error"});
            this.total_label.getStyleClass().removeAll((Object[])new String[]{"success"});
        }
    }

    @FXML
    private void setImportDataOnSelectedTransactionLines() {
        try {
            Transaction.TransactionTransactionLine importDataLine = (Transaction.TransactionTransactionLine)this.importDataTransactionTransactionLineTable.getSelectionModel().getSelectedItem();
            if (importDataLine == null) {
                throw new Exception("Error. Please select an import data in the topmost table");
            }
            String ii = importDataLine.getImportDataIdentifier();
            if (ii == null || ii.isEmpty()) {
                throw new Exception("Error, import data identifier not set");
            }
            Double iAmt = importDataLine.getImportDataAmount();
            if (iAmt == null) {
                throw new Exception("Error, import amount not set");
            }
            Double totalAmount = 0.0;
            for (Transaction.TransactionTransactionLine ttl : this.selectedTransactionTransactionLines) {
                totalAmount = totalAmount + ttl.getCreditAmount();
            }
            if (!totalAmount.equals(iAmt)) {
                throw new Exception("Error, selected amount is not equal to imported data amount, cannot match");
            }
            boolean changed = false;
            HashMap<String, Transaction> changedTransactions = new HashMap<String, Transaction>();
            for (Transaction.TransactionTransactionLine ttl : this.originalSelectedTransactionTransactionLines) {
                if (this.selectedTransactionTransactionLines.contains(ttl)) continue;
                ttl.deleteImportData();
                changed = true;
                changedTransactions.put(ttl.getTransaction().getTransactionNumber(), ttl.getTransaction());
            }
            for (Transaction.TransactionTransactionLine ttl : this.selectedTransactionTransactionLines) {
                if (this.originalSelectedTransactionTransactionLines.contains(ttl)) continue;
                ttl.copyImportData(importDataLine.getImportData());
                changed = true;
                changedTransactions.put(ttl.getTransaction().getTransactionNumber(), ttl.getTransaction());
            }
            if (changed) {
                this.applicationController.saveTransactions(changedTransactions.values());
                this.applicationController.deleteSelectedImportData(ii);
                this.applicationController.saveImportDataTransactions(null);
                this.originalSelectedTransactionTransactionLines.clear();
                this.originalSelectedTransactionTransactionLines.addAll(this.selectedTransactionTransactionLines);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    private void updateSelectedTransactionLines() {
        if (this.suspendSelectionChange) {
            return;
        }
        ObservableList selectedItems = this.transactionTransactionLineTable.getSelectionModel().getSelectedItems();
        for (Transaction.TransactionTransactionLine ttl : this.transactionTransactionLineTable.getItems()) {
            if (selectedItems.contains((Object)ttl)) {
                if (this.selectedTransactionTransactionLines.contains(ttl)) continue;
                this.selectedTransactionTransactionLines.add(ttl);
                continue;
            }
            if (!this.selectedTransactionTransactionLines.contains(ttl)) continue;
            this.selectedTransactionTransactionLines.remove(ttl);
        }
    }

    @FXML
    private void selectMatchedTransactionLines() {
        try {
            Transaction.TransactionTransactionLine importDataLine = (Transaction.TransactionTransactionLine)this.importDataTransactionTransactionLineTable.getSelectionModel().getSelectedItem();
            if (importDataLine == null) {
                throw new Exception("Error. Please select an import data in the topmost table");
            }
            boolean hasselected = false;
            String ii = importDataLine.getImportDataIdentifier();
            if (ii == null || ii.isEmpty()) {
                throw new Exception("Error, import data identifier not set");
            }
            this.selectedTransactionTransactionLines = new HashSet();
            this.originalSelectedTransactionTransactionLines = new HashSet();
            this.transactionTransactionLineTable.getSelectionModel().clearSelection();
            for (Transaction.TransactionTransactionLine ttl : this.transactionTransactionLineObservableList) {
                String tidi = ttl.getImportDataIdentifier();
                if (tidi == null || !tidi.equals(ii)) continue;
                this.selectedTransactionTransactionLines.add(ttl);
                this.originalSelectedTransactionTransactionLines.add(ttl);
                this.transactionTransactionLineTable.getSelectionModel().select((Object)ttl);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    protected void updateFilter() {
        String filterTextValue = null;
        if (this.filterText != null) {
            filterTextValue = this.filterText.getText();
        }
        LocalDate fromDateValue = null;
        if (this.filterFromDate != null) {
            fromDateValue = this.filterFromDate.getLocalDate();
        }
        LocalDate toDateValue = null;
        if (this.filterToDate != null) {
            toDateValue = this.filterToDate.getLocalDate();
        }
        this.updateFilter(filterTextValue, fromDateValue, toDateValue);
    }

    protected void updateFilter(String newValue, LocalDate fromDate, LocalDate toDate) {
        this.suspendSelectionChange = true;
        this.filteredItems.setPredicate(ttl -> {
            String formattedDate;
            LocalDate localDate = ttl.getTransactionDateAsDate();
            if (fromDate != null || toDate != null) {
                if (localDate == null) {
                    return false;
                }
                if (fromDate != null && localDate.isBefore(fromDate)) {
                    return false;
                }
                if (toDate != null && localDate.isAfter(toDate)) {
                    return false;
                }
            }
            if (newValue == null || newValue.isEmpty()) {
                return true;
            }
            String transactionComment = ttl.getTransactionComment();
            if (transactionComment != null && transactionComment.toLowerCase().contains(newValue.toLowerCase())) {
                return true;
            }
            String cid = ttl.getCounterpartyIdentifier();
            if (cid != null && !cid.isEmpty()) {
                try {
                    String cname;
                    Transaction ct = this.applicationController.getCounterpartyTransaction(cid);
                    if (ct != null && (cname = ct.getCounterpartyLegalName()) != null && !cname.isEmpty() && cname.toLowerCase().contains(newValue.toLowerCase())) {
                        return true;
                    }
                }
                catch (Exception ct) {
                    // empty catch block
                }
            }
            return localDate != null && (formattedDate = this.displayDateFormatter.format(localDate)) != null && !formattedDate.isEmpty() && formattedDate.toLowerCase().contains(newValue.toLowerCase());
        });
        for (int row = 0; row < this.transactionTransactionLineTable.getItems().size(); ++row) {
            Transaction.TransactionTransactionLine ttl2 = (Transaction.TransactionTransactionLine)this.transactionTransactionLineTable.getItems().get(row);
            if (!this.selectedTransactionTransactionLines.contains(ttl2)) continue;
            this.transactionTransactionLineTable.getSelectionModel().select(row);
        }
        this.suspendSelectionChange = false;
        this.updateTotalAmount();
    }

    protected void loadTransaction(Transaction newTransaction) {
        block15: {
            if (newTransaction != null) {
                try {
                    String batchIdentifier = newTransaction.getBatchIdentifier();
                    if (batchIdentifier != null && !batchIdentifier.isEmpty()) {
                        this.error_message.setText("Error, the selected transaction is on a batch. Double click to go to edit.");
                        this.applicationController.setStatusBarMessage("Error, the selected transaction is on a batch. Double click to go to edit.");
                        if (this.transactionEditFormVBox != null) {
                            this.transactionEditFormVBox.setTransactionElement(null);
                        }
                        this.transaction = null;
                        break block15;
                    }
                    String type = newTransaction.getTransactionType();
                    if (type != null && type.equals("pay_slip")) {
                        this.error_message.setText("Error, cannot edit pay slip on this page. Double click to go to the pay slip edit page.");
                        if (this.transactionEditFormVBox != null) {
                            this.transactionEditFormVBox.setTransactionElement(null);
                        }
                        this.transaction = null;
                    } else {
                        if (this.transactionEditFormVBox != null) {
                            this.transactionEditFormVBox.setTransactionElement(newTransaction);
                        }
                        this.transaction = newTransaction;
                    }
                    this.error_message.setText(null);
                    this.applicationController.setStatusBarMessage(null);
                }
                catch (Exception e) {
                    this.transaction = null;
                    e.printStackTrace();
                    this.error_message.setText("Error, could not quick edit transaction.");
                    this.applicationController.setStatusBarMessage("Error, could not quick edit transaction.");
                    try {
                        this.transactionEditFormVBox.setTransactionElement(null);
                    }
                    catch (Exception exception) {}
                }
            } else {
                this.transaction = null;
                this.error_message.setText(null);
                this.applicationController.setStatusBarMessage(null);
                if (this.transactionEditFormVBox != null) {
                    try {
                        this.transactionEditFormVBox.setTransactionElement(null);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        this.error_message.setText(e.getMessage());
                        this.applicationController.setStatusBarMessage(e.getMessage());
                    }
                }
            }
        }
    }

    public void setTransaction(Transaction transaction) {
        this.loadTransaction(transaction);
    }

    public void setTransactionDefaults() throws Exception {
        if (this.transaction == null) {
            return;
        }
        String tt = this.transaction.getTransactionType();
        if (tt == null) {
            this.transaction.setTransactionType("cash_payment");
        }
    }

    private boolean lodgedActivityStatementIsChanged(boolean statusChange) {
        if (this.transaction == null) {
            return false;
        }
        HashSet<String> ass = new HashSet<String>();
        boolean hasas = false;
        for (int i = 0; i < this.transaction.getTransactionLineCount(); ++i) {
            String status;
            ActivityStatement as;
            TransactionLine tl = this.transaction.getTransactionLine(i);
            String asNumber = tl.getActivityStatementNumber();
            if (asNumber == null || asNumber.isEmpty()) continue;
            hasas = true;
            GlenixTrnXBRL asTrn = null;
            try {
                asTrn = this.applicationController.loadActivityStatement(asNumber);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (asTrn == null || (as = asTrn.getActivityStatement()) == null || (status = as.getSBRDocumentStatus()) == null || status.equals("created") || status.equals("list_complete") || status.equals("list_in_progress") || status.equals("prefill_complete") || status.equals("prefill_in_progress") || status.equals("prelodge_complete") || status.equals("prelodge_in_progress")) continue;
            if (statusChange) {
                return true;
            }
            ass.add(asNumber);
        }
        if (this.transactionEditFormVBox == null) {
            return hasas;
        }
        return this.transactionEditFormVBox.basChanged(ass);
    }

    private boolean transactionBatchIsLocked() {
        String bi;
        Transaction bt;
        Batch b;
        String trBi = null;
        if (this.transaction != null && (b = this.transaction.getBatch()) != null && (trBi = b.getBatchIdentifier()) != null && !trBi.isEmpty()) {
            String status;
            bt = null;
            try {
                bt = this.applicationController.getBatchTransaction(trBi);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (bt != null && (status = bt.getBatchStatus()) != null && !status.equals("created")) {
                return true;
            }
        }
        if (this.transactionEditFormVBox != null && (bi = this.transactionEditFormVBox.getTransactionBatchIdentifier()) != null && !bi.isEmpty() && !bi.equals(trBi)) {
            bt = null;
            try {
                bt = this.applicationController.getBatchTransaction(bi);
            }
            catch (Exception status) {
                // empty catch block
            }
            if (bt != null && (status = bt.getBatchStatus()) != null && !status.equals("created")) {
                return true;
            }
        }
        return false;
    }

    private void saveTransaction() throws Exception {
        Document resultDoc = this.docBuilder.newDocument();
        this.transactionEditFormVBox.buildGlenixXBRLTransactionPart(resultDoc, null);
        this.transaction.loadDocumentElementOverwrite(resultDoc, resultDoc.getDocumentElement());
        this.setTransactionDefaults();
        this.applicationController.saveTransaction(this.transaction);
    }

    protected void validateTransaction() throws Exception {
        String status;
        if (this.transactionEditFormVBox == null) {
            throw new Exception("Error, no transaction edit form found");
        }
        boolean statusChange = false;
        if (this.transaction != null && !(status = this.transaction.getTransactionStatus()).equals("posted")) {
            statusChange = true;
        }
        if (this.lodgedActivityStatementIsChanged(statusChange)) {
            this.transactionEditFormVBox.setTransactionElement(this.transaction);
            throw new Exception("Error, one of the modified lines is on a lodged Activity Statment.");
        }
        if (this.transactionBatchIsLocked()) {
            this.transactionEditFormVBox.setTransactionElement(this.transaction);
            throw new Exception("Error, you cannot modify the transaction as it is on an authorised or lodged Batch.");
        }
        LocalDate ld = this.transactionEditFormVBox.getTransactionLocalDate();
        if (ld == null) {
            throw new Exception("Error, a transaction date is blank or incorrect");
        }
        String counterpartyIdentifier = this.transactionEditFormVBox.getCounterpartyIdentifier();
        if (counterpartyIdentifier == null || counterpartyIdentifier.isEmpty()) {
            throw new Exception("Error, the transaction does not have a counterparty, select a counterparty");
        }
        if (!this.transactionEditFormVBox.allLinesHaveAccount()) {
            throw new Exception("Error, a transaction line is missing an account");
        }
    }

    @FXML
    private void postTransactionE() throws Exception {
        this.validateTransaction();
        if (this.transaction == null) {
            this.transaction = this.applicationController.addTransaction();
        }
        if (this.transaction == null) {
            throw new Exception("Error, transaction is null");
        }
        this.transaction.setTransactionStatus("posted");
        this.saveTransaction();
        this.error_message.setText("Saved");
        this.lastLocalDate = this.transactionEditFormVBox.getTransactionLocalDate();
    }

    @FXML
    private void postTransaction() {
        try {
            this.postTransactionE();
            this.updateFilter();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void clearTransaction() {
        if (this.transactionEditFormVBox != null) {
            try {
                this.transactionEditFormVBox.setTransactionElement(null);
                this.transaction = null;
                if (this.lastLocalDate != null) {
                    this.transactionEditFormVBox.setTransactionLocalDate(this.lastLocalDate);
                }
                this.transactionEditFormVBox.requestFocus();
                this.error_message.setText("New transaction");
                this.applicationController.setStatusBarMessage(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.applicationController.setStatusBarMessage(e.getMessage());
            }
        }
    }

    @FXML
    public void postAndClearTransaction() {
        try {
            this.postTransactionE();
            this.clearTransaction();
            this.updateFilter();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void copyToNewTransaction() {
        try {
            this.transaction = null;
            this.transactionEditFormVBox.setActivityStatmentNumber(null);
            this.transactionEditFormVBox.setBatchTransactionElement(null);
            this.transactionEditFormVBox.requestFocus();
            this.error_message.setText("New transaction");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    public void cancelTransaction() {
        try {
            String status;
            boolean statusChange = false;
            if (this.transaction != null && !(status = this.transaction.getTransactionStatus()).equals("cancelled")) {
                statusChange = true;
            }
            if (this.lodgedActivityStatementIsChanged(statusChange)) {
                this.transactionEditFormVBox.setTransactionElement(this.transaction);
                this.error_message.setText("Error, one of the modified lines is on a lodged Activity Statment.");
                this.applicationController.setStatusBarMessage("Error, one of the modified lines is on a lodged Activity Statment.");
                return;
            }
            if (this.transactionBatchIsLocked()) {
                this.transactionEditFormVBox.setTransactionElement(this.transaction);
                this.error_message.setText("Error, you cannot modify the transaction as it is on an authorised or lodged Batch.");
                this.applicationController.setStatusBarMessage("Error, you cannot modify the transaction as it is on an authorised or lodged Batch.");
                return;
            }
            if (this.transaction == null) {
                throw new Exception("Error, transaction is null, no transaction to cancel");
            }
            this.transaction.setTransactionStatus("cancelled");
            this.saveTransaction();
            this.error_message.setText("Cancelled");
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
        this.updateFilter();
    }

    @FXML
    protected void addTransactionLine() {
        try {
            this.transactionEditFormVBox.addTransactionLine(null);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error_message.setText(e.getMessage());
            this.applicationController.setStatusBarMessage(e.getMessage());
        }
    }

    @FXML
    protected void deleteSelectedTransactionLines() {
        block8: {
            try {
                if (this.transaction != null) {
                    HashSet<String> ass = new HashSet<String>();
                    for (int i = 0; i < this.transaction.getTransactionLineCount(); ++i) {
                        String status;
                        ActivityStatement as;
                        TransactionLine tl = this.transaction.getTransactionLine(i);
                        String asNumber = tl.getActivityStatementNumber();
                        if (asNumber == null || asNumber.isEmpty()) continue;
                        GlenixTrnXBRL asTrn = null;
                        try {
                            asTrn = this.applicationController.loadActivityStatement(asNumber);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        if (asTrn == null || (as = asTrn.getActivityStatement()) == null || (status = as.getSBRDocumentStatus()) == null || status.equals("created") || status.equals("list_complete") || status.equals("list_in_progress") || status.equals("prefill_complete") || status.equals("prefill_in_progress") || status.equals("prelodge_complete") || status.equals("prelodge_in_progress")) continue;
                        ass.add(asNumber);
                    }
                    if (ass.size() == 0) {
                        this.transactionEditFormVBox.deleteSelectedTransactionLines(null);
                    } else {
                        this.transactionEditFormVBox.deleteSelectedTransactionLines(ass);
                    }
                    break block8;
                }
                this.transactionEditFormVBox.deleteSelectedTransactionLines(null);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.error_message.setText(e.getMessage());
                this.applicationController.setStatusBarMessage(e.getMessage());
            }
        }
    }

    public void setCounterpartyTransactionList(ObservableList<Transaction> counterpartyObservableList) {
        if (this.transactionEditFormVBox != null) {
            this.transactionEditFormVBox.setCounterpartyTransactionList(counterpartyObservableList);
        }
    }

    public void setProvisionList(ObservableList<Transaction> provisionObservableList) {
        if (this.transactionEditFormVBox != null) {
            this.transactionEditFormVBox.setProvisionList(provisionObservableList);
        }
    }

    public void setAccountList(ObservableList<Transaction> accountObservableList) {
        if (this.transactionEditFormVBox != null) {
            this.transactionEditFormVBox.setAccountList(accountObservableList);
        }
    }

    public void setBusinessTransactions(Business business) {
        this.business = business;
        if (business != null) {
            ArrayList<Transaction> tal = business.getTransactionArrayList();
            ObservableList tol = FXCollections.observableList(tal);
            this.setTransactionObservableList((ObservableList<Transaction>)tol);
        }
    }

    protected void createFilteredItems() {
        this.filteredItems = new FilteredList(this.transactionTransactionLineObservableList, ttl -> true);
        this.transactionTransactionLineTable.setItems(this.filteredItems);
        if (this.filterText != null) {
            this.filterText.addTextChangeListener((ChangeListener<String>)((ChangeListener)(obs, oldValue, newValue) -> this.updateFilter()));
        }
        if (this.filterFromDate != null) {
            this.filterFromDate.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(obs, oldValue, newValue) -> this.updateFilter()));
        }
        if (this.filterToDate != null) {
            this.filterToDate.setSingleChangeListener((ChangeListener<String>)((ChangeListener)(obs, oldValue, newValue) -> this.updateFilter()));
        }
    }

    protected void setTransactionObservableList(ObservableList<Transaction> transactionObservableList) {
        this.transactionTransactionLineObservableList = FXCollections.observableArrayList();
        for (Transaction t : transactionObservableList) {
            this.transactionTransactionLineObservableList.addAll(t.getTransactionTransactionLineLineArrayList());
        }
        this.createFilteredItems();
    }

    private void buildPDFSubSection(String subSection, GlenixPDFWrapper gpw) throws Exception {
        this.subSection = subSection;
        Double fontSize = this.convertFontSize(new Double(this.applicationController.getCurrentFontSize()));
        this.drawPDFColumnHeadings(gpw);
        for (Transaction.TransactionTransactionLine ttl : this.filteredItems) {
            if (subSection.equals("importData")) {
                gpw.prepareString(2, this.getImportDataTransactionDateColumnValue(ttl), true, fontSize);
                gpw.prepareString(3, this.getImportDataCounterpartyColumnValue(ttl), true, fontSize);
                gpw.prepareString(4, this.getImportDataCommentColumnValue(ttl), true, fontSize);
                gpw.prepareString(5, this.getImportDataAmountColumnValue(ttl), true, fontSize, "right");
                gpw.prepareString(6, this.getImportDataAccountColumnValue(ttl), true, fontSize);
                gpw.prepareString(7, this.getImportDataProvisionColumnValue(ttl), true, fontSize);
                gpw.prepareString(8, this.getImportDataProvisionAmountColumnValue(ttl), true, fontSize, "right");
                gpw.prepareString(9, this.getImportDataQuantityColumnValue(ttl), true, fontSize, "right");
            } else {
                gpw.prepareString(2, this.getTransactionDateColumnValue(ttl), true, fontSize);
                gpw.prepareString(3, this.getCounterpartyColumnValue(ttl), true, fontSize);
                gpw.prepareString(4, ttl.getTransactionComment(), true, fontSize);
                gpw.prepareString(5, this.getAmountColumnValue(ttl), true, fontSize, "right");
                gpw.prepareString(6, this.getAccountColumnValue(ttl), true, fontSize);
                gpw.prepareString(7, this.getProvisionColumnValue(ttl), true, fontSize);
                gpw.prepareString(8, this.getProvisionAmountColumnValue(ttl), true, fontSize, "right");
                gpw.prepareString(9, this.getQuantityColumnValue(ttl), true, fontSize, "right");
            }
            gpw.drawStrings(5.0);
        }
        gpw.drawStrings(10.0);
    }

    @Override
    public GlenixPDFWrapper buildPDF(boolean includeBlanks) throws Exception {
        LocalDate ld;
        String filterTextValue;
        GlenixPDFWrapper gpw = new GlenixPDFWrapper();
        gpw.addPDPageLandscape();
        gpw.setColumns(10);
        gpw.setColumnLeftPosAndWidthMM(0, 20.0, 266.0);
        gpw.setColumnLeftPosAndWidthMM(1, 20.0, 266.0);
        gpw.setColumnLeftPosAndWidthMM(2, 20.0, 24.0);
        gpw.setColumnLeftPosAndWidthMM(3, 44.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(4, 84.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(5, 124.0, 28.0);
        gpw.setColumnLeftPosAndWidthMM(6, 156.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(7, 196.0, 40.0);
        gpw.setColumnLeftPosAndWidthMM(8, 236.0, 26.0);
        gpw.setColumnLeftPosAndWidthMM(9, 262.0, 24.0);
        gpw.setColumnFont(0, gpw.muliBoldFont);
        gpw.setColumnFont(1, gpw.muliLightFont);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        gpw.setColumnFont(9, gpw.muliLightFont);
        Double fontSize = this.convertFontSize(this.page_heading.getFont().getSize());
        gpw.prepareString(0, this.page_heading.getText(), true, fontSize);
        gpw.drawStrings(10.0);
        fontSize = this.convertFontSize(new Double(this.applicationController.getCurrentFontSize()));
        gpw.setAddPageCallback(this);
        gpw.prepareString(0, "Import data transaction", true, fontSize);
        gpw.drawStrings(5.0);
        this.buildPDFSubSection("importData", gpw);
        gpw.prepareString(0, "Transaction lines (unmatched lines and lines that are matched to this import data)", true, fontSize);
        gpw.drawStrings(5.0);
        StringBuilder filterBuilder = new StringBuilder();
        String prefix = "";
        if (this.filterText != null && (filterTextValue = this.filterText.getGlenixElementValue()) != null && !filterTextValue.isEmpty()) {
            filterBuilder.append("Filter text: ");
            filterBuilder.append(filterTextValue);
            prefix = ", ";
        }
        if (this.filterFromDate != null && (ld = this.filterFromDate.getLocalDate()) != null) {
            filterBuilder.append(prefix);
            filterBuilder.append("From date: ");
            filterBuilder.append(this.displayDateFormatter.format(ld));
            prefix = ", ";
        }
        if (this.filterToDate != null && (ld = this.filterToDate.getLocalDate()) != null) {
            filterBuilder.append(prefix);
            filterBuilder.append("To date: ");
            filterBuilder.append(this.displayDateFormatter.format(ld));
            prefix = ", ";
        }
        if (filterBuilder.length() > 0) {
            gpw.prepareString(1, filterBuilder.toString(), true, fontSize);
            gpw.drawStrings(10.0);
        }
        this.buildPDFSubSection("transactionLine", gpw);
        gpw.addFooter();
        return gpw;
    }

    private void drawPDFColumnHeadings(GlenixPDFWrapper gpw) throws Exception {
        gpw.setColumnFont(2, gpw.muliBoldFont);
        gpw.setColumnFont(3, gpw.muliBoldFont);
        gpw.setColumnFont(4, gpw.muliBoldFont);
        gpw.setColumnFont(5, gpw.muliBoldFont);
        gpw.setColumnFont(6, gpw.muliBoldFont);
        gpw.setColumnFont(7, gpw.muliBoldFont);
        gpw.setColumnFont(8, gpw.muliBoldFont);
        gpw.setColumnFont(9, gpw.muliBoldFont);
        Double fontSize = this.convertFontSize(new Double(this.applicationController.getCurrentFontSize()));
        if (this.subSection != null || this.subSection.equals("importData")) {
            gpw.prepareString(2, this.importDataTransactionDateColumn.getText(), true, fontSize);
            gpw.prepareString(3, this.importDataTransactionCounterpartyColumn.getText(), true, fontSize);
            gpw.prepareString(4, this.importDataTransactionCommentColumn.getText(), true, fontSize);
            gpw.prepareString(5, this.importDataAmountColumn.getText(), true, fontSize, "right");
            gpw.prepareString(6, this.importDataAccountTextColumn.getText(), true, fontSize);
            gpw.prepareString(7, this.importDataProvisionTextColumn.getText(), true, fontSize);
            gpw.prepareString(8, this.importDataTaxAmountColumn.getText(), true, fontSize, "right");
            gpw.prepareString(9, this.importDataQuantityColumn.getText(), true, fontSize, "right");
        } else {
            gpw.prepareString(2, this.transactionDateColumn.getText(), true, fontSize);
            gpw.prepareString(3, this.counterpartyColumn.getText(), true, fontSize);
            gpw.prepareString(4, this.commentColumn.getText(), true, fontSize);
            gpw.prepareString(5, this.amountColumn.getText(), true, fontSize, "right");
            gpw.prepareString(6, this.accountColumn.getText(), true, fontSize);
            gpw.prepareString(7, this.provisionColumn.getText(), true, fontSize);
            gpw.prepareString(8, this.taxAmountColumn.getText(), true, fontSize, "right");
            gpw.prepareString(9, this.quantityColumn.getText(), true, fontSize, "right");
        }
        gpw.drawStrings(5.0);
        gpw.setColumnFont(2, gpw.muliLightFont);
        gpw.setColumnFont(3, gpw.muliLightFont);
        gpw.setColumnFont(4, gpw.muliLightFont);
        gpw.setColumnFont(5, gpw.muliLightFont);
        gpw.setColumnFont(6, gpw.muliLightFont);
        gpw.setColumnFont(7, gpw.muliLightFont);
        gpw.setColumnFont(8, gpw.muliLightFont);
        gpw.setColumnFont(9, gpw.muliLightFont);
    }

    @Override
    public void newPDFPageAdded(GlenixPDFWrapper gpw) throws Exception {
        this.drawPDFColumnHeadings(gpw);
    }
}

